/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.mulimport.resolve.model.MulImportCollectModel;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportTypeEnum;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class MulImportDataMappingRule
implements Serializable {
    private static final long serialVersionUID = -5783212813146732570L;
    private MulImportTypeEnum importType;
    private String dataReplaceRuleField;
    private int parentDataSheetIndex;
    private String parentDataSheetName;
    int dataSheetIndex;
    private String dataSheetName;
    private int startRow;
    private int startCol;
    private boolean isFirstImport;
    private List<MulImportCollectModel> needCollectColIndexList;
    private Integer parentContactFieldCol;
    private Integer contactFieldCol;
    private List<MulImportDataMappingRule> contactRules;
    private final BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap = new DualHashBidiMap();
    private MulImportResolveTypeEnum mulImportResolveTypeEnum;
    private String parentEntityNumber;
    private String mainEntityNumber;
    private String currentEntityNumber;
    private String currentUniqueEntityKey;
    private String parentUniqueEntityKey;

    public MulImportDataMappingRule() {
    }

    private MulImportDataMappingRule(String MainEntityName, String currentEntityName, int parentDataSheetIndex, String parentDataSheetName, int dataSheetIndex, String dataSheetName, int startRow, int startCol, List<MulImportCollectModel> needCollectColIndexList, Integer parentContactFieldCol, Integer contactFieldCol, List<MulImportDataMappingRule> contactRules, BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap, MulImportTypeEnum importType, String dataReplaceRuleField) {
        if (StringUtils.isEmpty((CharSequence)dataSheetName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6761\u4ef6\u6784\u9020\u5931\u8d25", (String)"MulImportResolve_3", (String)"bos-import", (Object[])new Object[0]));
        }
        this.setMulImportResolveTypeEnum(MainEntityName, currentEntityName);
        this.parentDataSheetIndex = parentDataSheetIndex;
        this.parentDataSheetName = parentDataSheetName;
        this.dataSheetIndex = dataSheetIndex;
        this.dataSheetName = dataSheetName;
        this.startRow = startRow;
        this.startCol = startCol;
        this.needCollectColIndexList = needCollectColIndexList;
        this.parentContactFieldCol = parentContactFieldCol;
        this.contactFieldCol = contactFieldCol;
        this.contactRules = contactRules;
        this.excelCol2PropInfoMap.putAll(excelCol2PropInfoMap);
        this.importType = importType;
        this.dataReplaceRuleField = dataReplaceRuleField;
    }

    public static MulImportDataMappingRule createMulImportDataMappingRule(String MainEntityName, String currentEntityName, int parentDataSheetIndex, String parentDataSheetName, int dataSheetIndex, String dataSheetName, int startRow, int startCol, List<MulImportCollectModel> needCollectColIndexList, Integer parentContactFieldCol, Integer contactFieldCol, List<MulImportDataMappingRule> contactSheets, BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap, MulImportTypeEnum importType, String dataReplaceRuleField) {
        return new MulImportDataMappingRule(MainEntityName, currentEntityName, parentDataSheetIndex, parentDataSheetName, dataSheetIndex, dataSheetName, startRow, startCol, needCollectColIndexList, parentContactFieldCol, contactFieldCol, contactSheets, excelCol2PropInfoMap, importType, dataReplaceRuleField);
    }

    private void setMulImportResolveTypeEnum(String mainEntityNumber, String currentEntityNumber) {
        if (StringUtils.isEmpty((CharSequence)mainEntityNumber) || StringUtils.isEmpty((CharSequence)currentEntityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6761\u4ef6\u6784\u9020\u5931\u8d25", (String)"MulImportResolve_3", (String)"bos-import", (Object[])new Object[0]));
        }
        this.currentEntityNumber = currentEntityNumber;
        this.mainEntityNumber = mainEntityNumber;
        if (StringUtils.equals((CharSequence)currentEntityNumber, (CharSequence)mainEntityNumber)) {
            this.mulImportResolveTypeEnum = MulImportResolveTypeEnum.HEAD;
            this.currentUniqueEntityKey = mainEntityNumber;
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        if (dataEntityType == null || dataEntityType.getAllEntities().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6761\u4ef6\u6784\u9020\u5931\u8d25", (String)"MulImportResolve_3", (String)"bos-import", (Object[])new Object[0]));
        }
        Map allEntities = dataEntityType.getAllEntities();
        if (allEntities.get(currentEntityNumber) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6761\u4ef6\u6784\u9020\u5931\u8d25", (String)"MulImportResolve_3", (String)"bos-import", (Object[])new Object[0]));
        }
        if (allEntities.get(currentEntityNumber) instanceof SubEntryType) {
            this.mulImportResolveTypeEnum = MulImportResolveTypeEnum.SUB_ENTRY;
            this.parentEntityNumber = ((EntityType)allEntities.get(currentEntityNumber)).getParent().getName();
            this.currentUniqueEntityKey = mainEntityNumber + "." + this.parentEntityNumber + "." + currentEntityNumber;
            this.parentUniqueEntityKey = mainEntityNumber + "." + this.parentEntityNumber;
            return;
        }
        if (allEntities.get(currentEntityNumber) instanceof EntryType) {
            this.mulImportResolveTypeEnum = MulImportResolveTypeEnum.ENTRY;
            this.parentEntityNumber = ((EntityType)allEntities.get(currentEntityNumber)).getParent().getName();
            this.currentUniqueEntityKey = mainEntityNumber + "." + currentEntityNumber;
            this.parentUniqueEntityKey = mainEntityNumber;
        }
    }

    public MulImportResolveTypeEnum getMulImportResolveTypeEnum() {
        return this.mulImportResolveTypeEnum;
    }

    public String getCurrentEntityNumber() {
        return this.currentEntityNumber;
    }

    public String getParentEntityNumber() {
        return this.parentEntityNumber;
    }

    public int getParentDataSheetIndex() {
        return this.parentDataSheetIndex;
    }

    public String getParentDataSheetName() {
        return this.parentDataSheetName;
    }

    public String getMainEntityNumber() {
        return this.mainEntityNumber;
    }

    public int getDataSheetIndex() {
        return this.dataSheetIndex;
    }

    public String getDataSheetName() {
        return this.dataSheetName;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public List<MulImportCollectModel> getNeedCollectColIndexList() {
        return this.needCollectColIndexList;
    }

    public Integer getParentContactFieldCol() {
        return this.parentContactFieldCol;
    }

    public Integer getContactFieldCol() {
        return this.contactFieldCol;
    }

    public List<MulImportDataMappingRule> getContactRules() {
        return this.contactRules;
    }

    public BidiMap<Integer, MulImportPropColMapping> getExcelCol2PropInfoMap() {
        return this.excelCol2PropInfoMap;
    }

    public MulImportTypeEnum getImportType() {
        return this.importType;
    }

    public void setImportType(MulImportTypeEnum importType) {
        this.importType = importType;
    }

    public String getDataReplaceRuleField() {
        return this.dataReplaceRuleField;
    }

    public EntityType getEntityType() {
        return (EntityType)EntityMetadataCache.getDataEntityType((String)this.mainEntityNumber).getAllEntities().get(this.currentEntityNumber);
    }

    public String getCurrentUniqueEntityKey() {
        return this.currentUniqueEntityKey;
    }

    public String getParentUniqueEntityKey() {
        return this.parentUniqueEntityKey;
    }

    public void setFirstImport(boolean firstImport) {
        this.isFirstImport = firstImport;
    }

    public boolean getFirstImport() {
        return this.isFirstImport;
    }
}

