/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.listerer.LimitExcelReadListener;
import kd.bos.mulimport.resolve.listerer.ThreeParamFunction;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportFile;
import kd.bos.mulimport.resolve.service.IMulImportResolveService;
import kd.bos.mulimport.resolve.service.MulImportExcelReader;
import kd.bos.mulimport.resolve.utils.MulImportConvertUtils;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.SecurityUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractImportResolveService
implements IMulImportResolveService {
    protected MulImportContext mulImportContext;
    private static final Log log = LogFactory.getLog(AbstractImportResolveService.class);

    public AbstractImportResolveService(MulImportContext mulImportContext) {
        this.mulImportContext = mulImportContext;
        if (StringUtils.isEmpty((CharSequence)mulImportContext.getExcelPath())) {
            String fileUrl = mulImportContext.getFileUrl();
            File file = new File(IWatermarkHandler.TEMP_DIR, FilenameUtils.getName((String)("mulExcel" + UUID.randomUUID().toString().replace("-", ""))));
            String excelPath = file.getPath();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                FileServiceFactory.getAttachmentFileService().download(fileUrl, (OutputStream)fileOutputStream, null);
                this.mulImportContext.setExcelPath(excelPath);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u6d41", (String)"BOS_IMPORT_16", (String)"bos-import", (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    FileSecurityUtil.safeClose(fileOutputStream);
                    throw throwable;
                }
            }
            FileSecurityUtil.safeClose((Closeable)fileOutputStream);
        }
    }

    protected void readExcelFile(ExcelTypeEnum excelTypeEnum, final ThreeParamFunction<Map<Integer, String>, MulImportDataMappingRule, Integer> handleDataFunction) {
        List<MulImportDataMappingRule> mulImportDataMappingRuleList = this.mulImportContext.getMulImportDataMappingRuleList();
        ArrayList<ReadSheet> readSheetList = new ArrayList<ReadSheet>(mulImportDataMappingRuleList.size());
        for (final MulImportDataMappingRule mulImportDataMappingRule : mulImportDataMappingRuleList) {
            int dataSheetIndex = mulImportDataMappingRule.getDataSheetIndex();
            String dataSheetName = mulImportDataMappingRule.getDataSheetName();
            int headRowNumber = mulImportDataMappingRule.getStartRow();
            ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)dataSheetIndex, (String)dataSheetName).registerReadListener((ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invoke(Map<Integer, String> map, AnalysisContext analysisContext) {
                    Integer curRowIndex = analysisContext.readRowHolder().getRowIndex();
                    MulImportConvertUtils.getEntityImportResult(AbstractImportResolveService.this.mulImportContext, mulImportDataMappingRule.getCurrentUniqueEntityKey()).getTotalRowsIndex().add(curRowIndex);
                    handleDataFunction.accept(map, mulImportDataMappingRule, curRowIndex);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            })).headRowNumber(Integer.valueOf(headRowNumber))).build();
            readSheetList.add(readSheet);
        }
        try (MulImportFile file = new MulImportFile(this.mulImportContext.getExcelPath(), false);){
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(excelTypeEnum).build();
            excelReader.read(readSheetList);
            excelReader.finish();
        }
        catch (Exception e) {
            log.error("[MulImport\uff1aread file failed]" + e);
            throw new RuntimeException(e);
        }
    }

    protected List<Map<Integer, String>> readExcelSheetFromStart2End(ExcelTypeEnum excelTypeEnum, int sheetNo, int startRow, int startCol, int endRow) {
        if (endRow <= startRow) {
            return new ArrayList<Map<Integer, String>>(1);
        }
        LimitExcelReadListener limitExcelReadListener = new LimitExcelReadListener(startRow, startCol, endRow, Integer.MAX_VALUE, false);
        ReadSheet readSheet = ((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)sheetNo).registerReadListener((ReadListener)limitExcelReadListener)).build();
        try (MulImportFile file = new MulImportFile(this.mulImportContext.getExcelPath(), false);){
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(excelTypeEnum).autoCloseStream(Boolean.valueOf(true)).build();
            excelReader.analysisContext().readWorkbookHolder().setIgnoreEmptyRow(Boolean.valueOf(false));
            excelReader.read(new ReadSheet[]{readSheet});
            excelReader.finish();
        }
        catch (ExcelAnalysisException e) {
            return this.mergeData(limitExcelReadListener.getHeadList(), limitExcelReadListener.getDataList());
        }
        catch (Exception ex) {
            log.error("[\u591a\u5b9e\u4f53\u591a\u9875\u7b7e\u5bfc\u5165\uff1a\u8bfb\u53d6\u8d77\u59cb\u7ed3\u675f\u884c\u9519\u8bef]" + ex);
        }
        return this.mergeData(limitExcelReadListener.getHeadList(), limitExcelReadListener.getDataList());
    }

    private List<Map<Integer, String>> mergeData(List<Map<Integer, String>> headList, List<Map<Integer, String>> dataList) {
        ArrayList<Map<Integer, String>> totalRow = new ArrayList<Map<Integer, String>>();
        totalRow.addAll(headList);
        totalRow.addAll(dataList);
        return totalRow;
    }

    public List<Map<Integer, String>> readExcelSheetGetHead(ExcelTypeEnum excelTypeEnum, int sheetNo, int startRow, int startCol) {
        LimitExcelReadListener limitExcelReadListener = new LimitExcelReadListener(startRow, startCol, 1, Integer.MAX_VALUE);
        ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)sheetNo).registerReadListener((ReadListener)limitExcelReadListener)).headRowNumber(Integer.valueOf(startRow))).build();
        try (MulImportFile file = new MulImportFile(this.mulImportContext.getExcelPath(), false);){
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(excelTypeEnum).autoCloseStream(Boolean.valueOf(true)).build();
            excelReader.read(new ReadSheet[]{readSheet});
            excelReader.finish();
        }
        catch (ExcelAnalysisException e) {
            return limitExcelReadListener.getHeadList();
        }
        catch (Exception ex) {
            log.error("[MulImport\uff1aread start or end line failed]" + ex);
        }
        return limitExcelReadListener.getHeadList();
    }

    public List<ReadSheet> listSheets() {
        ExcelReader excelReader = null;
        try (MulImportFile file = new MulImportFile(this.mulImportContext.getExcelPath(), true);){
            excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
        }
        catch (Exception e) {
            log.error("[MulImport\uff1aread sheets failed]" + e);
        }
        if (excelReader == null) {
            return null;
        }
        return excelReader.excelExecutor().sheetList();
    }

    @Override
    public MulImportContext getMulImportContext() {
        return this.mulImportContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileIsEmpty(List<ReadSheet> readSheetList) {
        if (CollectionUtils.isEmpty(readSheetList)) {
            return true;
        }
        AnalysisEventListener<Object> readListener = new AnalysisEventListener<Object>(){

            public void invoke(Object data, AnalysisContext context) {
                throw new ExcelAnalysisException("not empty");
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }
        };
        ExcelReader excelReader = null;
        try (MulImportFile file = new MulImportFile(this.mulImportContext.getExcelPath(), true);){
            excelReader = ((ExcelReaderBuilder)EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.valueOf(true)).registerReadListener((ReadListener)readListener)).build();
            excelReader.read(readSheetList);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Map<Integer, String>> getBatchSheetHead(Map<Integer, Integer> sheetInfos) {
        final HashMap<Integer, Map<Integer, String>> sheetHeadMap = new HashMap<Integer, Map<Integer, String>>(sheetInfos.size());
        OPCPackage pkg = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            pkg = OPCPackage.open((String)this.mulImportContext.getExcelPath());
            XSSFReader r = new XSSFReader(pkg);
            r.setUseReadOnlySharedStringsTable(false);
            SharedStringsTable sharedStringsTable = (SharedStringsTable)r.getSharedStringsTable();
            StylesTable stylesTable = r.getStylesTable();
            XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            HashSet<String> sheetNames = new HashSet<String>(16);
            while (sheets.hasNext()) {
                sheets.next();
                if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName())) continue;
                sheetNames.add(sheets.getSheetName());
            }
            sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            for (final Map.Entry<Integer, Integer> sheetInfo : sheetInfos.entrySet()) {
                SheetHandler sheetHandler = new SheetHandler(){

                    @Override
                    public void handleRow(SheetHandler.ParsedRow row) {
                        Map currentSheetHead = AbstractImportResolveService.this.handleDataRow(row, (Integer)sheetInfo.getValue());
                        if (null != currentSheetHead) {
                            sheetHeadMap.put(sheetInfo.getKey(), currentSheetHead);
                            throw new RuntimeException();
                        }
                    }
                };
                sheetHandler.setSheetNames(sheetNames);
                sheetHandler.setSharedStringsTable(sharedStringsTable);
                sheetHandler.setStylesTable(stylesTable);
                parser.setContentHandler(sheetHandler);
                String sheetName = MulImportStepPluginUtil.getSheetNameByValue(this.getMulImportContext().getView(), sheetInfo.getKey());
                new MulImportExcelReader().read(parser, sheetName, sheets);
            }
        }
        catch (Exception e) {
            log.error("getBatchSheetHead parse failed:", (Throwable)e);
        }
        finally {
            this.deleteExcel();
            if (pkg != null) {
                pkg.revert();
            }
        }
        return sheetHeadMap;
    }

    private Map<Integer, String> handleDataRow(SheetHandler.ParsedRow row, int startRow) {
        if (row.getRowNum() == startRow - 1) {
            Map<Integer, String> data = row.getData();
            HashMap<Integer, String> returnDta = new HashMap<Integer, String>();
            int maxKey = 0;
            for (Map.Entry<Integer, String> entry : data.entrySet()) {
                maxKey = Math.max(maxKey, entry.getKey());
            }
            if (maxKey == data.size() - 1) {
                return data;
            }
            for (int i = 0; i <= maxKey; ++i) {
                if (StringUtils.isBlank((CharSequence)data.get(i))) {
                    returnDta.put(i, null);
                    continue;
                }
                returnDta.put(i, data.get(i));
            }
            return returnDta;
        }
        return null;
    }

    public void deleteExcel() {
        FileSecurityUtil.safeDeleteFile((File)new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)this.mulImportContext.getExcelPath())), FilenameUtils.getName((String)SecurityUtils.normalize((String)this.mulImportContext.getExcelPath()))));
    }
}

