/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.service.AbstractImportResolveService;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import kd.bos.mulimport.stepplugin.util.MulCellStyleUtils;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class MulErrorFileCreateService
extends AbstractImportResolveService {
    private static final Log log = LogFactory.getLog(MulErrorFileCreateService.class);
    private final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String BOS_IMPORT = "bos-import";
    private final Map<String, MulEntityImportResult> entityImportResult;

    public MulErrorFileCreateService(MulImportContext mulImportContext, Map<String, MulEntityImportResult> entityImportResult) {
        super(mulImportContext);
        this.entityImportResult = entityImportResult;
    }

    public void creatErrorFile() {
        File errorFile = null;
        try {
            errorFile = new File(this.TEMP_DIR, FilenameUtils.getName((String)("errorFile" + UUID.randomUUID().toString().replace("-", "") + ".xlsx")));
            this.write(errorFile, this.mulImportContext.getMulImportDataMappingRuleList());
            this.uploadToFileService(errorFile);
        }
        catch (Throwable throwable) {
            FileSecurityUtil.safeDeleteFile(errorFile);
            throw throwable;
        }
        FileSecurityUtil.safeDeleteFile((File)errorFile);
    }

    private void write(File errorFile, List<MulImportDataMappingRule> dataMappingRuleList) {
        try (FileOutputStream fos = new FileOutputStream(errorFile);
             ExcelWriter excelWriter = EasyExcel.write((OutputStream)fos).build();){
            for (MulImportDataMappingRule rule : dataMappingRuleList) {
                this.writeSheet(excelWriter, rule.getDataSheetIndex(), rule.getDataSheetName(), rule);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void uploadToFileService(File errorFile) {
        try (FileInputStream in = new FileInputStream(errorFile);){
            String fileName = this.mulImportContext.getFileName();
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMdd");
            String formattedDate = currentDate.format(formatter);
            String prefix = fileName.substring(0, fileName.lastIndexOf(46));
            String suffix = fileName.substring(fileName.lastIndexOf(46));
            String errorFileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25-%1$s-%2$s%3$s", (String)"MulImportStepPlugin_32", (String)BOS_IMPORT, (Object[])new Object[0]), prefix, formattedDate, suffix);
            FileItem fileItem = this.createFileItem(errorFileName, this.generatePath(errorFileName), in, FileSource.EXCEL_MUL_IMPORT);
            String errorFileUrl = FileServiceFactory.getAttachmentFileService().upload(fileItem);
            this.mulImportContext.setErrorFileUrl(errorFileUrl);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void writeSheet(ExcelWriter excelWriter, int sheetIndex, String sheetName, MulImportDataMappingRule rule) {
        final int startRow = rule.getStartRow();
        final int startCol = rule.getStartCol();
        List<List<String>> dataRow = this.getDataRow(sheetIndex, startRow, startCol, this.entityImportResult.get(rule.getCurrentUniqueEntityKey()));
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetIndex, (String)sheetName).registerWriteHandler((WriteHandler)new CellWriteHandler(){

            public void afterCellDispose(CellWriteHandlerContext context) {
                MulErrorFileCreateService.this.cellStyleSetting(context, startRow, startCol);
            }
        })).build();
        excelWriter.write(dataRow, writeSheet);
    }

    private void cellStyleSetting(CellWriteHandlerContext context, int startRow, int startCol) {
        int msgColIndex = startCol - 1;
        Integer curColIndex = context.getColumnIndex();
        Integer curRowIndex = context.getRowIndex();
        WriteCellData cellData = context.getFirstCellData();
        WriteCellStyle style = cellData.getOrCreateStyle();
        MulCellStyleUtils.setCommonStyle(style);
        if (curColIndex > msgColIndex) {
            if (curRowIndex == startRow - 1) {
                style.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
                return;
            }
            return;
        }
        if (curRowIndex == startRow - 1) {
            style.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
            style.setHorizontalAlignment(HorizontalAlignment.LEFT);
        }
        if (curRowIndex > startRow - 1) {
            MulCellStyleUtils.setErrorColStyle(style, context, curColIndex);
        }
    }

    private List<List<String>> getDataRow(int sheetIndex, int startRow, int startCol, MulEntityImportResult importResult) {
        Map<Integer, List<String>> rowErrorInfos = importResult.getRowErrorInfos();
        Set<Integer> totalRowIndexs = importResult.getTotalRowsIndex();
        List<Integer> covertRowIndexs = importResult.getCovertRowsIndex();
        List ignoreRowsIndex = totalRowIndexs.stream().filter(totalRowIndex -> !covertRowIndexs.contains(totalRowIndex)).collect(Collectors.toList());
        List<Map<Integer, String>> totalRow = this.readExcelSheetFromStart2End(ExcelTypeEnum.XLSX, sheetIndex, 0, 0, 5000);
        ArrayList<List<String>> dataRows = new ArrayList<List<String>>(totalRow.size());
        int curIndex = 0;
        for (Map<Integer, String> row : totalRow) {
            ArrayList<String> rowData = new ArrayList<String>(row.values());
            String msgInfo = "";
            if (curIndex + 1 == startRow) {
                msgInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u7684\u89e3\u51b3\u529e\u6cd5\u8bf7\u53c2\u8003\u94fe\u63a5\uff1ahttps://vip.kingdee.com/knowledge/specialDetail/228886918686445824?category=228887079747323136&id=348494125253422848&productLineId=29", (String)"MulErrorFileCreateService_0", (String)BOS_IMPORT, (Object[])new Object[0]);
            }
            if (rowErrorInfos.containsKey(curIndex)) {
                List<String> importLogs = rowErrorInfos.get(curIndex);
                StringBuilder sb = new StringBuilder();
                for (String importLog : importLogs) {
                    sb.append(importLog).append("\r\n");
                }
                msgInfo = sb.toString();
            }
            if (ignoreRowsIndex.contains(curIndex)) {
                msgInfo = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7cfb\u7edf\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u540c\u4e00\u5f20\u5355\u7684\u5355\u636e\u5934\u3001\u5355\u636e\u4f53\u548c\u5b50\u5355\u636e\u4f53\u6570\u636e\u5173\u8054\u5b57\u6bb5\u503c\u662f\u5426\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MulImportConvertService_7", (String)BOS_IMPORT, (Object[])new Object[0]);
            }
            if (msgInfo.length() >= Short.MAX_VALUE) {
                log.debug("kd.bos.mulimport.resolve.service.MulErrorFileCreateService.getDataRow -- msgInfo ===" + msgInfo);
                msgInfo = msgInfo.substring(0, 32764) + "...";
            }
            if (CollectionUtils.isNotEmpty(rowData) && rowData.size() > startCol - 1) {
                rowData.add(startCol - 1, msgInfo);
            }
            dataRows.add(rowData);
            ++curIndex;
        }
        return dataRows;
    }

    private String generatePath(String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)"mulimport", (String)(uuid + "/" + AttachmentServiceHelper.replaceSpeSymbol((String)fileName)));
    }

    private FileItem createFileItem(String fileName, String path, InputStream in, FileSource fileSource) {
        FileItemExt fileItem = new FileItemExt(fileName, path, in);
        fileItem.setSource(fileSource);
        fileItem.setCreateNewFileWhenExists(true);
        return fileItem;
    }
}

