/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.cache.selector.ReadCacheSelector;
import com.alibaba.excel.cache.selector.SimpleReadCacheSelector;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.impt.service.MulImportSaveService;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;
import kd.bos.mulimport.resolve.convert.MulImportPropConvertFactory;
import kd.bos.mulimport.resolve.model.MulImportConvertData;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportFile;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportTypeEnum;
import kd.bos.mulimport.resolve.service.AbstractImportResolveService;
import kd.bos.mulimport.resolve.utils.MulImportConvertUtils;
import kd.bos.mulimport.result.model.MulCovertRow;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;

public class MulImportConvertService
extends AbstractImportResolveService {
    private static final Log log = LogFactory.getLog(MulImportConvertService.class);
    private Map<String, DynamicObject> blankDataEntity = new HashMap<String, DynamicObject>();
    private MulImportSaveService saveService = new MulImportSaveService();
    private static final String BOS_IMPORT = "bos-import";
    private final int batchSize = 5000;

    public MulImportConvertService(MulImportContext context, boolean isInit) {
        super(context);
        if (isInit) {
            this.initEntityResultInfo();
        }
    }

    private void resolveXlsxForCovert(MulImportDataMappingRule rule, Map<String, Integer> childAndSubRuleStartRowMap) {
        int startRow = rule.getStartRow();
        int currentBatch = startRow + 5000;
        MainEntityType entityType = (MainEntityType)rule.getEntityType();
        try (EntityTraceSpan entityTraceSpan = EntityTracer.create((String)this.getClass().getSimpleName(), (String)"resolveXlsxForCovert");){
            this.batchReadHead(entityType, rule, new Ref(currentBatch), childAndSubRuleStartRowMap);
        }
        catch (ExcelAnalysisException excelAnalysisException) {
            // empty catch block
        }
    }

    private void batchReadHead(final MainEntityType entityType, final MulImportDataMappingRule rule, final Ref refBatchIndex, final Map<String, Integer> childAndSubRuleStartRowMap) {
        HashMap contactMap;
        ArrayList<MulImportConvertData> convertDatas;
        block14: {
            final ArrayList headContractVals = new ArrayList(5000);
            final Integer contractIndex = rule.getContactFieldCol();
            final Ref refIsFinish = new Ref(Boolean.FALSE);
            final List<MulImportDataMappingRule> contactSheets = rule.getContactRules();
            final String mainEntityNumber = rule.getMainEntityNumber();
            String currentUniqueEntityKey = rule.getCurrentUniqueEntityKey();
            final int startRow = refBatchIndex.getValue() - 5000;
            convertDatas = new ArrayList<MulImportConvertData>();
            contactMap = new HashMap();
            contactMap.putIfAbsent(currentUniqueEntityKey, new HashMap());
            ReadSheet headSheet = ((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)rule.getDataSheetIndex(), (String)rule.getDataSheetName()).registerReadListener((ReadListener)new AnalysisEventListener<Map<Integer, String>>(){
                Queue<MulImportConvertData> entityData;
                {
                    this.entityData = MulImportConvertService.this.mulImportContext.getEntityData(mainEntityNumber);
                }

                public void invoke(Map<Integer, String> row, AnalysisContext analysisContext) {
                    ReadRowHolder curRowHolder = analysisContext.readRowHolder();
                    Integer curRowIndex = curRowHolder.getRowIndex();
                    if (curRowIndex >= refBatchIndex.getValue()) {
                        throw new ExcelAnalysisException("current head batch end");
                    }
                    if (curRowIndex >= startRow) {
                        if (row.get(contractIndex) != null) {
                            headContractVals.add(row.get(contractIndex));
                        }
                        MulImportConvertService.this.convertHeadData(entityType, rule, curRowHolder, convertDatas, contactMap);
                    }
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                    MulImportConvertService.this.resolveChildSheet(contactSheets, headContractVals, contactMap, childAndSubRuleStartRowMap);
                    List collect = convertDatas.stream().filter(MulImportConvertData::isSuccess).collect(Collectors.toList());
                    this.entityData.addAll(collect);
                    MulImportConvertService.this.saveService.manageData(MulImportConvertService.this.mulImportContext, startRow);
                    refIsFinish.setFlag(true);
                }

                public void onException(Exception exception, AnalysisContext context) throws Exception {
                    if (exception instanceof ExcelAnalysisException && StringUtils.equals((CharSequence)exception.getMessage(), (CharSequence)"current head batch end")) {
                        MulImportConvertService.this.resolveChildSheet(contactSheets, headContractVals, contactMap, childAndSubRuleStartRowMap);
                        List collect = convertDatas.stream().filter(MulImportConvertData::isSuccess).collect(Collectors.toList());
                        this.entityData.addAll(collect);
                        MulImportConvertService.this.saveService.manageData(MulImportConvertService.this.mulImportContext, startRow);
                        refBatchIndex.setValue(refBatchIndex.getValue() + 5000);
                        MulImportConvertService.this.batchReadHead(entityType, rule, refBatchIndex, childAndSubRuleStartRowMap);
                        throw exception;
                    }
                }
            })).build();
            SimpleReadCacheSelector simpleReadCacheSelector = new SimpleReadCacheSelector();
            simpleReadCacheSelector.setMaxUseMapCacheSize(Long.valueOf(5L));
            simpleReadCacheSelector.setMaxCacheActivateBatchCount(Integer.valueOf(20));
            try (MulImportFile file = new MulImportFile(this.getMulImportContext().getExcelPath(), false);){
                ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(ExcelTypeEnum.XLSX).readCacheSelector((ReadCacheSelector)simpleReadCacheSelector).autoCloseStream(Boolean.valueOf(true)).build();
                excelReader.read(new ReadSheet[]{headSheet});
                this.recodeSubEntryFail(contactSheets, convertDatas);
                this.recodeParentEntryFail(rule);
                excelReader.finish();
                Thread.sleep(0L);
            }
            catch (Exception e) {
                if (e instanceof ExcelAnalysisException && StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)"current head batch end")) break block14;
                log.error("[MulImport:Convert error]" + e);
            }
        }
        convertDatas.clear();
        contactMap.clear();
    }

    private void resolveChildSheet(List<MulImportDataMappingRule> readSheetList, final List<String> headContractVals, final Map<String, Map<String, MulImportConvertData>> contactMap, final Map<String, Integer> childAndSubRuleStartRowMap) {
        final HashMap subContractValMap = new HashMap();
        for (final MulImportDataMappingRule childRule : readSheetList) {
            ArrayList<ReadSheet> readSheets = new ArrayList<ReadSheet>(childRule.getContactRules().size() + 1);
            int dataSheetIndex = childRule.getDataSheetIndex();
            int startRow = childRule.getStartRow();
            final Integer pCol = childRule.getParentContactFieldCol();
            final Integer subCol = childRule.getContactFieldCol();
            final String childSheetUniqueEntityKey = childRule.getCurrentUniqueEntityKey();
            ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)dataSheetIndex, (String)childRule.getDataSheetName()).registerReadListener((ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invoke(Map<Integer, String> row, AnalysisContext analysisContext) {
                    Integer curRowIndex = analysisContext.readRowHolder().getRowIndex();
                    Integer hasResolvedIndex = (Integer)childAndSubRuleStartRowMap.get(childSheetUniqueEntityKey);
                    if (curRowIndex <= hasResolvedIndex) {
                        return;
                    }
                    String parentContactValue = row.get(pCol);
                    if (StringUtils.isBlank((CharSequence)parentContactValue)) {
                        return;
                    }
                    if (!headContractVals.contains(parentContactValue)) {
                        return;
                    }
                    MulImportConvertService.this.convertEntryData(row, childRule, analysisContext.readRowHolder(), contactMap);
                    String subContactValue = row.get(subCol);
                    if (subContactValue != null) {
                        subContractValMap.computeIfAbsent(childSheetUniqueEntityKey, i -> new HashSet()).add(subContactValue);
                    }
                    childAndSubRuleStartRowMap.put(childSheetUniqueEntityKey, curRowIndex);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            })).headRowNumber(Integer.valueOf(startRow))).build();
            readSheets.add(readSheet);
            List<MulImportDataMappingRule> subSheets = childRule.getContactRules();
            for (final MulImportDataMappingRule subSheet : subSheets) {
                final Integer parentContactCol = subSheet.getParentContactFieldCol();
                final String subSheetUniqueEntityKey = subSheet.getCurrentUniqueEntityKey();
                final String parentUniqueEntityKey = subSheet.getParentUniqueEntityKey();
                ReadSheet readSubSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)subSheet.getDataSheetIndex(), (String)subSheet.getDataSheetName()).registerReadListener((ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                    public void invoke(Map<Integer, String> row, AnalysisContext analysisContext) {
                        Set contractValSet = (Set)subContractValMap.get(parentUniqueEntityKey);
                        Integer curRowIndex = analysisContext.readRowHolder().getRowIndex();
                        Integer hasResolvedIndex = (Integer)childAndSubRuleStartRowMap.get(subSheetUniqueEntityKey);
                        if (curRowIndex <= hasResolvedIndex) {
                            return;
                        }
                        String parentContactValue = row.get(parentContactCol);
                        if (StringUtils.isBlank((CharSequence)parentContactValue)) {
                            return;
                        }
                        if (!contractValSet.contains(parentContactValue)) {
                            return;
                        }
                        MulImportConvertService.this.convertEntryData(row, subSheet, analysisContext.readRowHolder(), contactMap);
                        childAndSubRuleStartRowMap.put(subSheetUniqueEntityKey, curRowIndex);
                    }

                    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                    }
                })).headRowNumber(Integer.valueOf(subSheet.getStartRow()))).build();
                readSheets.add(readSubSheet);
            }
            SimpleReadCacheSelector simpleReadCacheSelector = new SimpleReadCacheSelector();
            simpleReadCacheSelector.setMaxUseMapCacheSize(Long.valueOf(5L));
            simpleReadCacheSelector.setMaxCacheActivateBatchCount(Integer.valueOf(20));
            try {
                MulImportFile file = new MulImportFile(this.getMulImportContext().getExcelPath(), false);
                Throwable throwable = null;
                try {
                    ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(ExcelTypeEnum.XLSX).readCacheSelector((ReadCacheSelector)simpleReadCacheSelector).autoCloseStream(Boolean.valueOf(true)).build();
                    excelReader.read(readSheets);
                    excelReader.finish();
                    Thread.sleep(0L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (file == null) continue;
                    if (throwable != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    file.close();
                }
            }
            catch (Exception e) {
                log.error("[MulImport failed]" + e);
            }
        }
    }

    @Override
    public void convert() {
        List<MulImportDataMappingRule> rules = this.mulImportContext.getMulImportDataMappingRuleList();
        Map<String, Integer> childRuleStartRowMap = rules.stream().filter(item -> item.getMulImportResolveTypeEnum() != MulImportResolveTypeEnum.HEAD).collect(Collectors.toMap(MulImportDataMappingRule::getCurrentUniqueEntityKey, v -> 0));
        for (MulImportDataMappingRule rule : rules) {
            if (rule.getMulImportResolveTypeEnum() != MulImportResolveTypeEnum.HEAD) continue;
            this.mulImportContext.getEntityNumberSet().add(rule.getMainEntityNumber());
            this.resolveXlsxForCovert(rule, childRuleStartRowMap);
            this.mulImportContext.getFinishEntity().add(rule.getMainEntityNumber());
            this.mulImportContext.feedbackProgress(this.mulImportContext.getFinishEntity());
        }
    }

    private void recodeSubEntryFail(List<MulImportDataMappingRule> contactRules, List<MulImportConvertData> convertDataList) {
        for (MulImportConvertData billData : convertDataList) {
            List<MulCovertRow> covertRows;
            String contactValue;
            if (billData.isSuccess()) continue;
            String entityNumber = billData.getEntityNumber();
            MulEntityImportResult mainEntityImportResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, entityNumber);
            List<MulCovertRow> failedRows = mainEntityImportResult.getFailedRowsByContactVal(contactValue = billData.getContactValue());
            if (CollectionUtils.isEmpty(failedRows) && CollectionUtils.isNotEmpty(covertRows = mainEntityImportResult.getCovertRowsByContactVal(contactValue))) {
                MulCovertRow covertRow = covertRows.get(0);
                covertRow.setSuccess(false);
                mainEntityImportResult.recodeErrorInfo(covertRow.getRowIndex(), ResManager.loadKDString((String)"\u56e0\u540c\u4e00\u5f20\u5355\u636e\u7684\u5176\u4ed6\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u81f4\u8be5\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u5176\u4ed6\u9875\u7b7e\u68c0\u67e5\u5e76\u4fee\u6539\u6570\u636e\u3002", (String)"MulImportConvertService_4", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            this.recordSubEntityFailed(contactValue, contactRules);
        }
    }

    private void recodeParentEntryFail(MulImportDataMappingRule rule) {
        List<MulImportDataMappingRule> contactRules = rule.getContactRules();
        for (MulImportDataMappingRule contactRule : contactRules) {
            for (MulImportDataMappingRule subEntryRule : contactRule.getContactRules()) {
                this.recodeParentFail(subEntryRule);
            }
            this.recodeParentFail(contactRule);
        }
    }

    private void recodeParentFail(MulImportDataMappingRule childRule) {
        MulEntityImportResult childImportResult = MulImportConvertUtils.getEntityImportResult(this.getMulImportContext(), childRule.getCurrentUniqueEntityKey());
        MulEntityImportResult parentImportResult = MulImportConvertUtils.getEntityImportResult(this.getMulImportContext(), childRule.getParentUniqueEntityKey());
        List<MulCovertRow> childFailedRows = childImportResult.getFailedRows();
        for (MulCovertRow childFailedRow : childFailedRows) {
            String parentContactVal = childFailedRow.getParentContactVal();
            List<MulCovertRow> entityCovertRows = parentImportResult.getCovertRowsByContactVal(parentContactVal);
            for (MulCovertRow entityCovertRow : entityCovertRows) {
                if (entityCovertRow.isSuccess()) {
                    parentImportResult.recodeErrorInfo(entityCovertRow.getRowIndex(), ResManager.loadKDString((String)"\u56e0\u540c\u4e00\u5f20\u5355\u636e\u7684\u5176\u4ed6\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u81f4\u8be5\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u5176\u4ed6\u9875\u7b7e\u68c0\u67e5\u5e76\u4fee\u6539\u6570\u636e\u3002", (String)"MulImportConvertService_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                entityCovertRow.setSuccess(false);
            }
        }
    }

    private void convertHeadData(MainEntityType dataEntityType, MulImportDataMappingRule rule, ReadRowHolder curRowHolder, List<MulImportConvertData> convertDatas, Map<String, Map<String, MulImportConvertData>> contactMap) {
        block8: {
            Integer rowIndex = curRowHolder.getRowIndex();
            String entityNumber = rule.getCurrentEntityNumber();
            Integer contactFieldCol = rule.getContactFieldCol();
            Map row = (Map)curRowHolder.getCurrentRowAnalysisResult();
            boolean hasContactField = contactFieldCol != null && contactFieldCol >= 0;
            String nextContactVal = (String)row.get(contactFieldCol);
            String uniqueResultKey = rule.getCurrentUniqueEntityKey();
            Map<String, MulImportConvertData> convertDataMap = contactMap.get(uniqueResultKey);
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).getCovertRows().add(new MulCovertRow(rowIndex, nextContactVal, null, true));
            MulImportConvertData mainConvertData = null;
            try {
                boolean success;
                DynamicObject mainDataEntity = this.genMainDataEntity(rowIndex, row, (EntityType)dataEntityType, rule);
                if (mainDataEntity == null) {
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                    if (!hasContactField) {
                        return;
                    }
                    mainConvertData = new MulImportConvertData(entityNumber, nextContactVal, null, rowIndex);
                    mainConvertData.setSuccess(false);
                    convertDatas.add(mainConvertData);
                    convertDataMap.putIfAbsent(mainConvertData.getContactValue(), mainConvertData);
                    return;
                }
                if (hasContactField) {
                    mainConvertData = new MulImportConvertData(entityNumber, nextContactVal, mainDataEntity, rowIndex);
                }
                if (!(success = this.setValue(curRowHolder, row, rule, mainDataEntity, mainConvertData))) {
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                    if (!hasContactField) {
                        return;
                    }
                    mainConvertData.setSuccess(false);
                }
                if (hasContactField) {
                    convertDatas.add(mainConvertData);
                    convertDataMap.putIfAbsent(mainConvertData.getContactValue(), mainConvertData);
                    return;
                }
                this.mulImportContext.getEntityData(entityNumber).offer(new MulImportConvertData(entityNumber, null, mainDataEntity, rowIndex));
            }
            catch (Exception e) {
                log.error("kd.bos.mulimport.resolve.service.MulImportConvertService.convertHeadData", (Throwable)e);
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, e.getMessage());
                if (mainConvertData == null) break block8;
                mainConvertData.setSuccess(false);
            }
        }
    }

    private void convertEntryData(Map<Integer, String> row, MulImportDataMappingRule childRule, ReadRowHolder curRowHolder, Map<String, Map<String, MulImportConvertData>> contactMap) {
        block7: {
            Integer rowIndex = curRowHolder.getRowIndex();
            EntityType entityType = childRule.getEntityType();
            Integer parentContactFieldCol = childRule.getParentContactFieldCol();
            String parentContactValue = row.get(parentContactFieldCol);
            Integer contactFieldCol = childRule.getContactFieldCol();
            String nextContactVal = row.get(contactFieldCol);
            String uniqueResultKey = childRule.getCurrentUniqueEntityKey();
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).getCovertRows().add(new MulCovertRow(rowIndex, nextContactVal, parentContactValue, true));
            MulImportConvertData mainConvertData = null;
            try {
                if (this.isParentFail(childRule, parentContactValue)) {
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u56e0\u540c\u4e00\u5f20\u5355\u636e\u7684\u5176\u4ed6\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u81f4\u8be5\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u5176\u4ed6\u9875\u7b7e\u68c0\u67e5\u5e76\u4fee\u6539\u6570\u636e\u3002", (String)"MulImportConvertService_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                    return;
                }
                mainConvertData = this.getMainConvertData(childRule, entityType, parentContactValue, contactMap, nextContactVal);
                if (mainConvertData == null) {
                    return;
                }
                DynamicObjectCollection entryCollection = mainConvertData.getEntryCollection(entityType, parentContactValue);
                DynamicObject entryRowData = this.addOrUpdateEntryCollection(rowIndex, row, entryCollection, childRule);
                if (entryRowData == null) {
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                    mainConvertData.setSuccess(false);
                    return;
                }
                boolean success = this.setValue(curRowHolder, row, childRule, entryRowData, mainConvertData);
                if (!success) {
                    MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                    mainConvertData.setSuccess(false);
                    return;
                }
                if (this.isContactSubEntry(entityType, contactFieldCol)) {
                    mainConvertData.addEntryData(new MulImportConvertData(entityType.getName(), row.get(contactFieldCol), entryRowData, rowIndex));
                }
            }
            catch (Exception e) {
                log.error("kd.bos.mulimport.resolve.service.MulImportConvertService.convertEntryData", (Throwable)e);
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).setFailedRow(rowIndex);
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, e.getMessage());
                if (mainConvertData == null) break block7;
                mainConvertData.setSuccess(false);
            }
        }
    }

    private void recordSubEntityFailed(String parentContactValue, List<MulImportDataMappingRule> contactRules) {
        for (MulImportDataMappingRule contactRule : contactRules) {
            MulEntityImportResult contactResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, contactRule.getCurrentUniqueEntityKey());
            List<MulCovertRow> contactRows = contactResult.getCovertRowsByParentContactVal(parentContactValue);
            List<Integer> failedRowIndex = contactResult.getFailedRowsIndex();
            for (MulCovertRow contactRow : contactRows) {
                contactRow.setSuccess(false);
                if (failedRowIndex.contains(contactRow.getRowIndex())) continue;
                contactResult.recodeErrorInfo(contactRow.getRowIndex(), ResManager.loadKDString((String)"\u56e0\u540c\u4e00\u5f20\u5355\u636e\u7684\u5176\u4ed6\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u81f4\u8be5\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u5176\u4ed6\u9875\u7b7e\u68c0\u67e5\u5e76\u4fee\u6539\u6570\u636e\u3002", (String)"MulImportConvertService_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                if (contactRow.getNextContactVal() == null) continue;
                List<MulImportDataMappingRule> subRules = contactRule.getContactRules();
                this.recordSubEntityFailed(contactRow.getNextContactVal(), subRules);
            }
        }
    }

    private boolean isParentFail(MulImportDataMappingRule rule, String parentContactValue) {
        String parentUniqueResultKey = rule.getParentUniqueEntityKey();
        List<MulCovertRow> parentFailedRows = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, parentUniqueResultKey).getFailedRowsByContactVal(parentContactValue);
        return CollectionUtils.isNotEmpty(parentFailedRows);
    }

    private boolean isContactSubEntry(EntityType entityType, Integer contactFieldCol) {
        return !(entityType instanceof SubEntryType) && contactFieldCol != null && contactFieldCol >= 0;
    }

    private DynamicObject genMainDataEntity(Integer rowIndex, Map<Integer, String> row, EntityType dataEntityType, MulImportDataMappingRule rule) {
        MulEntityImportResult importResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, rule.getCurrentUniqueEntityKey());
        MulImportTypeEnum importType = rule.getImportType();
        DynamicObject entityRowData = null;
        if (importType == MulImportTypeEnum.NEW_IMPORT) {
            entityRowData = this.getNewDataEntity(dataEntityType.getName());
        }
        if (importType == MulImportTypeEnum.UPDATE_IMPORT) {
            if (this.isUpdateImportFail(rowIndex, importResult)) {
                return null;
            }
            entityRowData = this.findSourceData(rowIndex, row, rule, importType);
        }
        if (importType == MulImportTypeEnum.NEW_UPDATE_IMPORT) {
            if (this.isUpdateImportFail(rowIndex, importResult)) {
                return null;
            }
            entityRowData = this.findSourceData(rowIndex, row, rule, importType);
        }
        return entityRowData;
    }

    private boolean isUpdateImportFail(Integer rowIndex, MulEntityImportResult importResult) {
        Map<Integer, String> updateImportFailRow = importResult.getUpdateImportFailRow();
        if (updateImportFailRow.containsKey(rowIndex)) {
            importResult.recodeErrorInfo(rowIndex, updateImportFailRow.get(rowIndex));
            return true;
        }
        return false;
    }

    private DynamicObject getNewDataEntity(String entityNumber) {
        DynamicObject newDataEntity = this.blankDataEntity.get(entityNumber);
        if (newDataEntity == null) {
            newDataEntity = BusinessDataServiceHelper.newDynamicObject((String)entityNumber, (boolean)true, (OperateOption)OperateOption.create());
            this.blankDataEntity.put(entityNumber, newDataEntity);
        }
        for (IDataEntityProperty property : newDataEntity.getDataEntityType().getProperties()) {
            if (!(property instanceof CreateDateProp)) continue;
            property.setValue((Object)newDataEntity, (Object)new Date());
            break;
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)newDataEntity, (boolean)false, (boolean)true);
    }

    private DynamicObject addOrUpdateEntryCollection(Integer rowIndex, Map<Integer, String> row, DynamicObjectCollection entryCollection, MulImportDataMappingRule childRule) {
        MulEntityImportResult importResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, childRule.getCurrentUniqueEntityKey());
        String uniqueResultKey = childRule.getCurrentUniqueEntityKey();
        if (childRule.getImportType() == MulImportTypeEnum.NEW_IMPORT) {
            DynamicObject entryRowData = new DynamicObject(entryCollection.getDynamicObjectType());
            entryRowData.set("seq", (Object)(entryCollection.size() + 1));
            entryCollection.add((Object)entryRowData);
            return entryRowData;
        }
        if (childRule.getImportType() == MulImportTypeEnum.UPDATE_IMPORT) {
            if (this.isUpdateImportFail(rowIndex, importResult)) {
                return null;
            }
            List<DynamicObject> dymList = this.getUpdateEntryRowData(rowIndex, row, entryCollection, childRule);
            if (dymList == null) {
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u8bf7\u5728excel\u4e2d\u586b\u5199\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u201d\u3002", (String)"MulImportConvertService_10", (String)BOS_IMPORT, (Object[])new Object[0]));
                return null;
            }
            if (dymList.size() == 0) {
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e\u3002", (String)"MulImportConvertService_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                return null;
            }
            if (dymList.size() > 1) {
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u5339\u914d\u5230\u4e86\u591a\u6761\u6570\u636e\u3002", (String)"MulImportConvertService_6", (String)BOS_IMPORT, (Object[])new Object[0]));
                return null;
            }
            return dymList.get(0);
        }
        if (this.isUpdateImportFail(rowIndex, importResult)) {
            return null;
        }
        List<DynamicObject> dymList = this.getUpdateEntryRowData(rowIndex, row, entryCollection, childRule);
        if (dymList == null) {
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u8bf7\u5728excel\u4e2d\u586b\u5199\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u201d\u3002", (String)"MulImportConvertService_10", (String)BOS_IMPORT, (Object[])new Object[0]));
            return null;
        }
        if (dymList.size() > 1) {
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u5339\u914d\u5230\u4e86\u591a\u6761\u6570\u636e\u3002", (String)"MulImportConvertService_6", (String)BOS_IMPORT, (Object[])new Object[0]));
            return null;
        }
        if (dymList.size() == 0) {
            DynamicObject entryRowData = new DynamicObject(entryCollection.getDynamicObjectType());
            entryCollection.add((Object)entryRowData);
            return entryRowData;
        }
        return dymList.get(0);
    }

    private List<DynamicObject> getUpdateEntryRowData(Integer rowIndex, Map<Integer, String> row, DynamicObjectCollection entryCollection, MulImportDataMappingRule rule) {
        MulEntityImportResult importResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, rule.getCurrentUniqueEntityKey());
        String queryKey = MulImportConvertUtils.getQueryKey(rule);
        ArrayList<DynamicObject> dymList = new ArrayList<DynamicObject>();
        for (DynamicObject entryDym : entryCollection) {
            Object sourceValue = entryDym.get(queryKey);
            if (ObjectUtils.isEmpty((Object)sourceValue)) continue;
            String sourceValueCovert = MulImportConvertUtils.covertSourceValue(sourceValue);
            String excelValueCovert = MulImportConvertUtils.covertCellToSearchKey(importResult, rowIndex, row, rule);
            if (excelValueCovert == null) {
                return null;
            }
            if (!StringUtils.equals((CharSequence)excelValueCovert, (CharSequence)sourceValueCovert)) continue;
            dymList.add(entryDym);
        }
        return dymList;
    }

    private boolean setValue(ReadRowHolder curRowHolder, Map<Integer, String> row, MulImportDataMappingRule rule, DynamicObject entityRowData, MulImportConvertData curConvertData) {
        Integer rowIndex = curRowHolder.getRowIndex();
        BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap = rule.getExcelCol2PropInfoMap();
        EntityType entityType = rule.getEntityType();
        String uniqueResultKey = rule.getCurrentUniqueEntityKey();
        Map cellMap = curRowHolder.getCellMap();
        ArrayList<MulImportPropColMapping> propColMappings = new ArrayList<MulImportPropColMapping>(excelCol2PropInfoMap.values());
        propColMappings.sort(Comparator.comparingInt(o -> o.getConvertSeq().getSeq()));
        for (MulImportPropColMapping propColMapping : propColMappings) {
            Integer convertCol;
            IDataEntityProperty property;
            Integer cellIndex = propColMapping.getExcelColIndex();
            String cellData = row.get(cellIndex);
            if (StringUtils.isBlank((CharSequence)cellData) || (property = entityType.findProperty(propColMapping.getPropNumber())) == null || (property instanceof BasedataProp || property instanceof MulBasedataProp) && (convertCol = MulImportConvertUtils.getBaseDataPropConvertIndex(rule, property, row, true)) != null && !convertCol.equals(cellIndex)) continue;
            MulImportPropConvert propConvert = MulImportPropConvertFactory.newInstance(property, this.mulImportContext);
            propConvert.init(curRowHolder, rule, curConvertData, propColMapping, (ReadCellData<Object>)((ReadCellData)cellMap.get(cellIndex)));
            try {
                propConvert.setValue(entityRowData, cellData);
            }
            catch (Exception e) {
                log.error("kd.bos.mulimport.resolve.service.MulImportConvertService.setValue", (Throwable)e);
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5\uff0c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff1a%2$s", (String)"MulImportStepPlugin_31", (String)BOS_IMPORT, (Object[])new Object[0]), property.getDisplayName().getLocaleValue(), e.getMessage()));
            }
        }
        Map<Integer, List<String>> rowErrorInfo = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).getRowErrorInfos();
        return CollectionUtils.isEmpty((Collection)rowErrorInfo.get(rowIndex));
    }

    private MulImportConvertData getMainConvertData(MulImportDataMappingRule childRule, EntityType entityType, String parentContactValue, Map<String, Map<String, MulImportConvertData>> contactMap, String nextContactVal) {
        String currentUniqueEntityKey = childRule.getCurrentUniqueEntityKey();
        String parentUniqueEntityKey = childRule.getParentUniqueEntityKey();
        Map<String, MulImportConvertData> convertDataMap = contactMap.get(parentUniqueEntityKey);
        if (entityType instanceof SubEntryType) {
            MulImportConvertData mulImportConvertData = convertDataMap.get(parentContactValue);
            if (mulImportConvertData == null) {
                return null;
            }
            return mulImportConvertData;
        }
        if (entityType instanceof EntryType) {
            MulImportConvertData mulImportConvertData = convertDataMap.get(parentContactValue);
            if (mulImportConvertData == null) {
                return null;
            }
            contactMap.putIfAbsent(currentUniqueEntityKey, new HashMap());
            Map<String, MulImportConvertData> entryConvertDataMap = contactMap.get(currentUniqueEntityKey);
            entryConvertDataMap.put(nextContactVal, mulImportConvertData);
            return mulImportConvertData;
        }
        return null;
    }

    private DynamicObject findSourceData(Integer rowIndex, Map<Integer, String> row, MulImportDataMappingRule rule, MulImportTypeEnum importType) {
        MulEntityImportResult importResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, rule.getCurrentUniqueEntityKey());
        String uniqueResultKey = rule.getCurrentUniqueEntityKey();
        String currentUniqueEntityKey = rule.getCurrentUniqueEntityKey();
        String excelValueCovert = MulImportConvertUtils.covertCellToSearchKey(importResult, rowIndex, row, rule);
        if (excelValueCovert == null) {
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, currentUniqueEntityKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u8bf7\u5728excel\u4e2d\u586b\u5199\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u201d\u3002", (String)"MulImportConvertService_10", (String)BOS_IMPORT, (Object[])new Object[0]));
            return null;
        }
        Map<String, List<DynamicObject>> collectedUpdateData = this.mulImportContext.getCollectedUpdateData().get(uniqueResultKey);
        if (collectedUpdateData == null) {
            if (importType == MulImportTypeEnum.UPDATE_IMPORT) {
                log.debug("find collectedUpdateData fail." + this.mulImportContext.getCollectedUpdateData().toString());
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e\u3002", (String)"MulImportConvertService_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                return null;
            }
            return this.getNewDataEntity(rule.getEntityType().getName());
        }
        List<DynamicObject> updateData = collectedUpdateData.get(excelValueCovert);
        if (CollectionUtils.isEmpty(updateData)) {
            if (importType == MulImportTypeEnum.UPDATE_IMPORT) {
                MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e\u3002", (String)"MulImportConvertService_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                return null;
            }
            return this.getNewDataEntity(rule.getEntityType().getName());
        }
        if (updateData.size() > 1) {
            MulImportConvertUtils.getEntityImportResult(this.mulImportContext, uniqueResultKey).recodeErrorInfo(rowIndex, ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u5339\u914d\u5230\u4e86\u591a\u6761\u6570\u636e\u3002", (String)"MulImportConvertService_6", (String)BOS_IMPORT, (Object[])new Object[0]));
            return null;
        }
        return updateData.get(0);
    }

    private void initEntityResultInfo() {
        List<MulImportDataMappingRule> dataMappingRuleList = this.mulImportContext.getMulImportDataMappingRuleList();
        for (MulImportDataMappingRule rule : dataMappingRuleList) {
            String dataSheetName = rule.getDataSheetName();
            String entityName = rule.getEntityType().getDisplayName().getLocaleValue();
            MulEntityImportResult entityResultInfo = this.mulImportContext.getEntityImportResult().computeIfAbsent(rule.getCurrentUniqueEntityKey(), c -> new MulEntityImportResult());
            entityResultInfo.setEntityName(entityName);
            entityResultInfo.setDataSheetName(dataSheetName);
            entityResultInfo.setEntityType(rule.getEntityType());
        }
    }

    static class Ref {
        Integer intVal;
        Boolean flag;

        public Ref(Integer value) {
            this.intVal = value;
        }

        public Ref(Boolean flag) {
            this.flag = flag;
        }

        public Integer getValue() {
            return this.intVal;
        }

        public void setValue(Integer value) {
            this.intVal = value;
        }

        public Boolean getFlag() {
            return this.flag;
        }

        public void setFlag(Boolean flag) {
            this.flag = flag;
        }
    }
}

