/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.context.MulImportPreviewContext;
import kd.bos.mulimport.resolve.listerer.FiveParamFunction;
import kd.bos.mulimport.resolve.model.MulImportFile;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulPreviewRowData;
import kd.bos.mulimport.resolve.model.PreviewResolveParam;
import kd.bos.mulimport.resolve.service.AbstractImportResolveService;
import org.apache.commons.collections4.MapUtils;

public class MulImportPreviewResolveService
extends AbstractImportResolveService {
    public static final String CACHE_KEY_SHOW_DATA = "cache_key_show_data";
    private MulImportPreviewContext previewContext;
    private static Log log = LogFactory.getLog(MulImportPreviewResolveService.class);

    public MulImportPreviewResolveService(MulImportContext context, MulImportPreviewContext previewContext) {
        super(context);
        this.previewContext = previewContext;
    }

    public void cacheShowData(List<PreviewResolveParam> previewResolveParams) {
        try {
            this.resolveXlsxForPreview(this::handleRowData, previewResolveParams);
        }
        catch (ExcelAnalysisException e) {
            log.debug("MulImportPreviewResolveService resolve end");
        }
        IPageCache pageCache = this.mulImportContext.getView().getPageCache();
        pageCache.put(CACHE_KEY_SHOW_DATA, SerializationUtils.toJsonString((Object)this.previewContext.getBillShowData()));
    }

    public void resolveXlsxForPreview(final FiveParamFunction<ReadRowHolder, Integer, List<Integer>, Integer, Integer> handleFunction, List<PreviewResolveParam> previewResolveParams) {
        ArrayList<ReadSheet> readSheetList = new ArrayList<ReadSheet>(previewResolveParams.size());
        for (PreviewResolveParam previewResolveParam : previewResolveParams) {
            String dataSheetName = previewResolveParam.getDataSheetName();
            int dataSheetIndex = previewResolveParam.getDataSheetIndex();
            final List<Integer> colIndexs = previewResolveParam.getColIndexs();
            final int startRow = previewResolveParam.getStartRow();
            final int nodeType = previewResolveParam.getNodeType();
            final int parentContactFieldCol = previewResolveParam.getParentContactFieldCol();
            final int subContactFieldCol = previewResolveParam.getSubContactFieldCol();
            ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)dataSheetIndex, (String)dataSheetName).registerReadListener((ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invoke(Map<Integer, String> row, AnalysisContext analysisContext) {
                    MulPreviewRowData billShowData;
                    ReadRowHolder readRowHolder = analysisContext.readRowHolder();
                    if (nodeType == MulImportResolveTypeEnum.HEAD.getType() && readRowHolder.getRowIndex() == startRow) {
                        handleFunction.accept(readRowHolder, nodeType, colIndexs, parentContactFieldCol, subContactFieldCol);
                    }
                    if (nodeType == MulImportResolveTypeEnum.ENTRY.getType() && (billShowData = MulImportPreviewResolveService.this.previewContext.getBillShowData()).getContactShowData().size() <= 10) {
                        handleFunction.accept(readRowHolder, nodeType, colIndexs, parentContactFieldCol, subContactFieldCol);
                    }
                    if (nodeType == MulImportResolveTypeEnum.SUB_ENTRY.getType()) {
                        handleFunction.accept(readRowHolder, nodeType, colIndexs, parentContactFieldCol, subContactFieldCol);
                    }
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            })).headRowNumber(Integer.valueOf(startRow))).build();
            readSheetList.add(readSheet);
        }
        try (MulImportFile file = new MulImportFile(this.getMulImportContext().getExcelPath(), true);){
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.valueOf(true)).build();
            excelReader.read(readSheetList);
            excelReader.finish();
        }
        catch (Exception e) {
            log.error("[MulImport Failed:]" + e);
        }
    }

    private void handleRowData(ReadRowHolder readRowHolder, int nodeType, List<Integer> colIndexs, int parentContactFieldCol, int subContactFieldCol) {
        Map row = (Map)readRowHolder.getCurrentRowAnalysisResult();
        if (MapUtils.isEmpty((Map)row)) {
            return;
        }
        if (nodeType == MulImportResolveTypeEnum.HEAD.getType()) {
            this.convertHeadData(row, colIndexs, subContactFieldCol);
            return;
        }
        if (nodeType == MulImportResolveTypeEnum.ENTRY.getType()) {
            this.convertEntryData(row, colIndexs, parentContactFieldCol, subContactFieldCol);
            return;
        }
        if (nodeType == MulImportResolveTypeEnum.SUB_ENTRY.getType()) {
            this.convertSubEntryData(row, colIndexs, parentContactFieldCol);
        }
    }

    private void convertHeadData(Map<Integer, String> row, List<Integer> colIndexs, int subContactFieldCol) {
        boolean hasContactField;
        List<String> showDatas = this.genRowVal(row, colIndexs);
        MulPreviewRowData rowDataModel = this.previewContext.getBillShowData();
        rowDataModel.getShowData().addAll(showDatas);
        boolean bl = hasContactField = subContactFieldCol >= 0;
        if (hasContactField) {
            String contactVal = row.get(subContactFieldCol);
            this.previewContext.setHeadContactVal(contactVal);
        }
    }

    private void convertEntryData(Map<Integer, String> row, List<Integer> colIndexs, int parentContactFieldCol, int subContactFieldCol) {
        if (parentContactFieldCol < 0) {
            return;
        }
        String contactValue = row.get(parentContactFieldCol);
        String headContactVal = this.previewContext.getHeadContactVal();
        if (!StringUtils.equals((CharSequence)headContactVal, (CharSequence)contactValue)) {
            return;
        }
        List<String> colDatas = this.genRowVal(row, colIndexs);
        if (colDatas.size() == 0) {
            return;
        }
        MulPreviewRowData previewRowData = this.previewContext.getBillShowData();
        List<MulPreviewRowData> contactShowData = previewRowData.getContactShowData();
        contactShowData.add(new MulPreviewRowData(colDatas, row.get(subContactFieldCol)));
        if (subContactFieldCol >= 0) {
            String contactFieldCol = row.get(subContactFieldCol);
            this.previewContext.getEntryContactVal().add(contactFieldCol);
        }
    }

    private void convertSubEntryData(Map<Integer, String> row, List<Integer> colIndexs, int parentContactFieldCol) {
        if (parentContactFieldCol < 0) {
            return;
        }
        String contactValue = row.get(parentContactFieldCol);
        Set<String> entryContactVal = this.previewContext.getEntryContactVal();
        if (!entryContactVal.contains(contactValue)) {
            return;
        }
        List<String> colDatas = this.genRowVal(row, colIndexs);
        if (colDatas.size() == 0) {
            return;
        }
        MulPreviewRowData billShowData = this.previewContext.getBillShowData();
        for (MulPreviewRowData contactShowData : billShowData.getContactShowData()) {
            if (contactShowData.getContactShowData().size() > 5) {
                return;
            }
            if (!StringUtils.equals((CharSequence)contactShowData.getContactVal(), (CharSequence)contactValue)) continue;
            contactShowData.getContactShowData().add(new MulPreviewRowData(colDatas));
        }
    }

    private List<String> genRowVal(Map<Integer, String> row, List<Integer> colIndexs) {
        ArrayList<String> showDatas = new ArrayList<String>(colIndexs.size());
        for (Integer colIndex : colIndexs) {
            String showData = row.get(colIndex);
            showDatas.add(showData);
        }
        return showDatas;
    }
}

