/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import org.apache.commons.collections4.BidiMap;

public class MulImportConvertUtils {
    private static final String BOS_IMPORT = "bos-import";
    private static final Log log = LogFactory.getLog(MulImportConvertUtils.class);

    public static MulImportPropColMapping findMappingProp(MulImportDataMappingRule dataMappingRule, String selectStr, BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap, Map<Integer, String> row, boolean isCheckCellNull) {
        EntityType entityType = dataMappingRule.getEntityType();
        for (MulImportPropColMapping propMapping : excelCol2PropInfoMap.values()) {
            String propNumber;
            String matchProp;
            String curVal;
            IDataEntityProperty property = entityType.findProperty(propMapping.getPropNumber());
            if (property == null) continue;
            if (property instanceof BasedataProp) {
                Integer convertCol = MulImportConvertUtils.getBaseDataPropConvertIndex(dataMappingRule, property, row, isCheckCellNull);
                Integer cellIndex = propMapping.getExcelColIndex();
                if (convertCol != null && !convertCol.equals(cellIndex)) continue;
            }
            if (property instanceof MuliLangTextProp && !StringUtils.equals((CharSequence)(curVal = Lang.get().toString()), (CharSequence)(matchProp = propMapping.getMatchProp())) || !StringUtils.equals((CharSequence)selectStr, (CharSequence)(propNumber = propMapping.getPropNumber()))) continue;
            return propMapping;
        }
        return null;
    }

    public static Integer getBaseDataPropConvertIndex(MulImportDataMappingRule dataMappingRule, IDataEntityProperty property, Map<Integer, String> row, boolean isCheckCellNull) {
        BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap = dataMappingRule.getExcelCol2PropInfoMap();
        IBasedataField baseDataProp = (IBasedataField)property;
        BasedataEntityType entityType = (BasedataEntityType)baseDataProp.getComplexType();
        Integer idIndex = null;
        String numberProperty = entityType.getNumberProperty();
        Integer numberIndex = null;
        String nameProperty = entityType.getNameProperty();
        Integer nameIndex = null;
        for (Map.Entry mappingEntry : excelCol2PropInfoMap.entrySet()) {
            MulImportPropColMapping propColMapping = (MulImportPropColMapping)mappingEntry.getValue();
            if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propColMapping.getPropNumber())) continue;
            if (StringUtils.equals((CharSequence)"id", (CharSequence)propColMapping.getMatchProp())) {
                idIndex = (Integer)mappingEntry.getKey();
                continue;
            }
            if (StringUtils.equals((CharSequence)numberProperty, (CharSequence)propColMapping.getMatchProp())) {
                numberIndex = (Integer)mappingEntry.getKey();
                continue;
            }
            if (!StringUtils.equals((CharSequence)nameProperty, (CharSequence)propColMapping.getMatchProp())) continue;
            nameIndex = (Integer)mappingEntry.getKey();
        }
        if (idIndex != null && isCheckCellNull && StringUtils.isNotBlank((CharSequence)row.get(idIndex))) {
            return idIndex;
        }
        if (numberIndex != null && isCheckCellNull && StringUtils.isNotBlank((CharSequence)row.get(numberIndex))) {
            return numberIndex;
        }
        if (nameIndex != null && isCheckCellNull && StringUtils.isNotBlank((CharSequence)row.get(nameIndex))) {
            return nameIndex;
        }
        return null;
    }

    public static String covertCellToSearchKey(MulEntityImportResult importResult, Integer rowIndex, Map<Integer, String> row, MulImportDataMappingRule rule) {
        Object queryVal = MulImportConvertUtils.covert4Query(row, rule, importResult, rowIndex);
        if (queryVal == null) {
            return null;
        }
        if (queryVal instanceof String) {
            return (String)queryVal;
        }
        return JSON.toJSONString((Object)queryVal);
    }

    public static Object covert4Query(Map<Integer, String> row, MulImportDataMappingRule rule, MulEntityImportResult importResult, Integer excelRow) {
        String dataReplaceRuleField = rule.getDataReplaceRuleField();
        MulImportPropColMapping propMapping = MulImportConvertUtils.findMappingProp(rule, dataReplaceRuleField, rule.getExcelCol2PropInfoMap(), row, true);
        if (propMapping == null) {
            return null;
        }
        Integer colIndex = propMapping.getExcelColIndex();
        String cellVal = row.get(colIndex);
        if (cellVal == null) {
            return null;
        }
        IDataEntityProperty property = rule.getEntityType().findProperty(dataReplaceRuleField);
        boolean isIdCell = "id".equals(propMapping.getMatchProp());
        return MulImportConvertUtils.covertCellValue(property, cellVal, dataReplaceRuleField, importResult, excelRow, isIdCell);
    }

    private static Object covertCellValue(IDataEntityProperty property, String cellVal, String fieldName, MulEntityImportResult importResult, Integer excelRow, boolean isIdCell) {
        Map<Integer, String> updateImportFailRow = importResult.getUpdateImportFailRow();
        if (property instanceof DateTimeProp) {
            try {
                DateFormat dateFormat = ((DateTimeProp)property).getDateFormat(cellVal);
                return dateFormat.parse(cellVal);
            }
            catch (ParseException e) {
                updateImportFailRow.put(excelRow, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiDateTimePropConverter_0", (String)BOS_IMPORT, (Object[])new Object[0]), property.getDisplayName(), cellVal));
                return null;
            }
        }
        if (property instanceof TimeProp) {
            try {
                return TimeProp.timeToSecond((Object)cellVal, (String)fieldName);
            }
            catch (KDException e) {
                updateImportFailRow.put(excelRow, e.getMessage());
                return null;
            }
        }
        if (property instanceof DecimalProp) {
            try {
                return new BigDecimal(new BigDecimal(cellVal).stripTrailingZeros().toPlainString());
            }
            catch (NumberFormatException e) {
                updateImportFailRow.put(excelRow, String.format(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5\u201c%1$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s", (String)"DecimalProp_1", (String)BOS_IMPORT, (Object[])new Object[0]), property.getDisplayName(), cellVal));
                return null;
            }
        }
        if (isIdCell && property instanceof IFieldHandle) {
            int dbType = ((IFieldHandle)property).getDbType();
            return MulImportConvertUtils.safeConvert(dbType, cellVal);
        }
        return cellVal;
    }

    public static String covertSourceValue(Object sourceValue) {
        if (sourceValue instanceof OrmLocaleValue) {
            sourceValue = ((OrmLocaleValue)sourceValue).getLocaleValue();
        }
        if (sourceValue instanceof String) {
            return (String)sourceValue;
        }
        if (sourceValue instanceof BigDecimal) {
            sourceValue = new BigDecimal(((BigDecimal)sourceValue).stripTrailingZeros().toPlainString());
        }
        return JSON.toJSONString((Object)sourceValue);
    }

    public static String getQueryKey(MulImportDataMappingRule rule) {
        String dataReplaceRuleField = rule.getDataReplaceRuleField();
        MulImportPropColMapping propMapping = MulImportConvertUtils.findMappingProp(rule, dataReplaceRuleField, rule.getExcelCol2PropInfoMap(), null, false);
        IDataEntityProperty entityProperty = rule.getEntityType().findProperty(dataReplaceRuleField);
        if (!(entityProperty instanceof DynamicProperty)) {
            throw new KDException(new ErrorCode("buildQFilter fail", ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\u3002", (String)"BOS_IMPORT_14", (String)BOS_IMPORT, (Object[])new Object[0])), new Object[0]);
        }
        DynamicProperty property = (DynamicProperty)entityProperty;
        return MulImportConvertUtils.rebuildFieldKey(property, propMapping, dataReplaceRuleField);
    }

    private static String rebuildFieldKey(DynamicProperty property, MulImportPropColMapping propMapping, String fieldName) {
        if (propMapping == null) {
            return fieldName;
        }
        if (property instanceof BasedataProp) {
            String dataType = propMapping.getMatchProp();
            fieldName = fieldName + "." + dataType;
        }
        return fieldName;
    }

    public static Object safeConvert(int dbType, Object value) {
        if (null == value) {
            return null;
        }
        if (12 == dbType || -9 == dbType || 1 == dbType) {
            return value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public static MulEntityImportResult getEntityImportResult(MulImportContext mulImportContext, String entityNumber) {
        return mulImportContext.getEntityImportResult().get(entityNumber);
    }
}

