/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.result.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.mulimport.result.model.MulCovertRow;
import kd.bos.util.CollectionUtils;

public class MulEntityImportResult {
    private String entityName;
    private EntityType entityType;
    private List<MulCovertRow> covertRows = new ArrayList<MulCovertRow>();
    private Set<Integer> totalRowsIndex = new HashSet<Integer>();
    private Map<Integer, String> updateImportFailRow = new HashMap<Integer, String>();
    private Map<Integer, List<String>> rowErrorInfos = new HashMap<Integer, List<String>>(10000);
    private String dataSheetName;
    private static final int LIMIT_FOR_ERROR_MESSAGE = 5000;
    private static final int LIMIT_FIELD_NUM = 50;
    private static final long LIMIT_CHAR_SIZE = 5000000L;
    private static final int LIMIT_CHAR_ROW_SIZE = Short.MAX_VALUE;
    private boolean rowLimitFlag = false;
    private long charSize;
    private boolean charSizeLimitFlag = false;
    private Map<Integer, Long> charSizeByRow = new HashMap<Integer, Long>(8);

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Map<Integer, List<String>> getRowErrorInfos() {
        return this.rowErrorInfos;
    }

    public Set<Integer> getTotalRowsIndex() {
        return this.totalRowsIndex;
    }

    public String getDataSheetName() {
        return this.dataSheetName;
    }

    public void setDataSheetName(String dataSheetName) {
        this.dataSheetName = dataSheetName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void recodeErrorInfo(Integer row, String errorInfo) {
        long curInfoLength;
        long rowCellSize;
        List<String> curRowErrorInfo = this.rowErrorInfos.get(row);
        if (this.charSize >= 5000000L) {
            if (!this.charSizeLimitFlag) {
                this.charSizeLimitFlag = true;
                ArrayList<String> tooLargeError = new ArrayList<String>();
                tooLargeError.add(this.getToLargeMessage());
                this.rowErrorInfos.put(row, tooLargeError);
            }
            return;
        }
        if (curRowErrorInfo == null && this.rowErrorInfos.size() >= 5000) {
            if (!this.rowLimitFlag) {
                this.rowLimitFlag = true;
                ArrayList<String> tooLargeError = new ArrayList<String>();
                tooLargeError.add(this.getToLargeMessage());
                this.rowErrorInfos.put(row, tooLargeError);
            }
            return;
        }
        if (curRowErrorInfo != null) {
            if (curRowErrorInfo.size() == 50) {
                ArrayList<String> tooLargeError = new ArrayList<String>();
                tooLargeError.add(ResManager.loadKDString((String)"\u5f53\u524d\u5806\u6808\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u8d85\u957f\uff0c\u5df2\u505a\u622a\u65ad\u5904\u7406\uff0c\u5982\u9700\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u67e5\u770bmonitor\u3002", (String)"ImportLogger_2", (String)"bos-entity-core", (Object[])new Object[0]));
                this.rowErrorInfos.put(row, tooLargeError);
                return;
            }
            if (curRowErrorInfo.size() > 50) {
                return;
            }
        }
        if ((rowCellSize = this.charSizeByRow.computeIfAbsent(row, charSize -> 0L).longValue()) >= 32767L) {
            return;
        }
        if (curRowErrorInfo == null) {
            curRowErrorInfo = new ArrayList<String>(1);
            this.rowErrorInfos.put(row, curRowErrorInfo);
        }
        if ((curInfoLength = (long)errorInfo.length()) > 32767L) {
            errorInfo = errorInfo.substring(0, 32764) + "...";
            curInfoLength = 32767L;
        }
        curRowErrorInfo.add(errorInfo);
        this.charSizeByRow.put(row, this.charSizeByRow.get(row) + curInfoLength);
        this.charSize += curInfoLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20000);
        boolean isFirst = true;
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(this.rowErrorInfos.keySet());
        rowIndexes.sort(Comparator.naturalOrder());
        for (Integer i : rowIndexes) {
            List<String> logs;
            if (!isFirst) {
                sb.append("\r\n");
            } else {
                isFirst = false;
            }
            if ((logs = this.rowErrorInfos.get(i)) == null || logs.isEmpty()) continue;
            if (i >= 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u7b2c%1$s\u884c", (String)"ImportLogger_0", (String)"bos-entity-core", (Object[])new Object[0]), i));
                sb.append(" ");
            }
            int logsCount = 0;
            for (String log : logs) {
                sb.append(logsCount++ == 0 ? "" : "\r\n\t").append(log);
            }
        }
        if (sb.length() == 0) {
            return sb.toString();
        }
        return sb.append("\r\n").toString();
    }

    public List<MulCovertRow> getCovertRows() {
        return this.covertRows;
    }

    public MulCovertRow getCovertRowsByRowIndex(int rowIndex) {
        List collect = this.getCovertRows().stream().filter(covertRow -> covertRow.getRowIndex() == rowIndex).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            return (MulCovertRow)collect.get(0);
        }
        return null;
    }

    public List<MulCovertRow> getCovertRowsByContactVal(String contactValue) {
        return this.getCovertRows().stream().filter(row -> StringUtils.equals((CharSequence)row.getNextContactVal(), (CharSequence)contactValue)).collect(Collectors.toList());
    }

    public List<MulCovertRow> getFailedRows() {
        return this.getCovertRows().stream().filter(covertRow -> !covertRow.isSuccess()).collect(Collectors.toList());
    }

    public List<MulCovertRow> getFailedRowsByContactVal(String contactValue) {
        return this.getFailedRows().stream().filter(row -> StringUtils.equals((CharSequence)row.getNextContactVal(), (CharSequence)contactValue)).collect(Collectors.toList());
    }

    public List<MulCovertRow> getSuccessRows() {
        return this.getCovertRows().stream().filter(MulCovertRow::isSuccess).collect(Collectors.toList());
    }

    public void setFailedRow(int excelRowIndex) {
        MulCovertRow covertRow = this.getCovertRowsByRowIndex(excelRowIndex);
        if (covertRow != null) {
            covertRow.setSuccess(false);
        }
    }

    public int getFailed() {
        return this.getFailedRows().size();
    }

    public List<Integer> getFailedRowsIndex() {
        return this.getFailedRows().stream().map(MulCovertRow::getRowIndex).collect(Collectors.toList());
    }

    public List<Integer> getCovertRowsIndex() {
        return this.getCovertRows().stream().map(MulCovertRow::getRowIndex).collect(Collectors.toList());
    }

    private String getToLargeMessage() {
        return ResManager.loadKDString((String)"\u7531\u4e8e\u9519\u8bef\u4fe1\u606f\u8fc7\u5927\uff0c\u5df2\u505c\u6b62\u52a0\u8f7d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u6570\u636e\u5e93\u6216monitor\u3002", (String)"ImportLogger_1", (String)"bos-entity-core", (Object[])new Object[0]);
    }

    public List<MulCovertRow> getCovertRowsByParentContactVal(String parentContactVal) {
        ArrayList<MulCovertRow> rows = new ArrayList<MulCovertRow>();
        for (MulCovertRow row : this.getCovertRows()) {
            if (!StringUtils.equals((CharSequence)parentContactVal, (CharSequence)row.getParentContactVal())) continue;
            rows.add(row);
        }
        return rows;
    }

    public Map<Integer, String> getUpdateImportFailRow() {
        return this.updateImportFailRow;
    }
}

