/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.result.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.model.MulEntityImportingInfo;
import kd.bos.svc.util.ImportLogDeleteFileUtil;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;

public class MulImportEndPlugin
extends ImportPermissionPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(MulImportEndPlugin.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String BTNOK = "btnok";
    private static final String DOWNLOAD_ERROR_FILE = "downloaderrorfile";
    private static final String DOWNLOAD_IGNORE_FILE = "downloadignorefile";
    private static final String IMPORT_FAILED_RESULT = "importfailedresult";
    private static final String IMPORT_IGNORE_RESULT = "importignoreresult";
    private static final String RESULT_CARD_ENTRY = "result_card_entry";
    private static final String ENTITY_NAME = "entity_name";
    private static final String SUCCESS_ROWS = "success_rows";
    private static final String FAIL_ROWS = "fail_rows";
    private static final String BOS_MULTI_IMPORT_RESULT = "bos_multi_import_result";
    private static final String FORM_ID = "bos_multi_import_end";
    private static final String IMPORTFAILFLEX = "importfailflex";
    private static final String IMPORTIGNOREFLEX = "importignoreflex";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, IMPORT_FAILED_RESULT, IMPORT_IGNORE_RESULT, DOWNLOAD_ERROR_FILE, DOWNLOAD_IGNORE_FILE});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String importStatusModelsStr = String.valueOf(view.getFormShowParameter().getCustomParams().get("importStatusModels"));
        List importStatusModels = SerializationUtils.fromJsonStringToList((String)importStatusModelsStr, MulEntityImportingInfo.class);
        this.fillImportResult(importStatusModels);
    }

    private void fillImportResult(List<MulEntityImportingInfo> mainEntityImportResult) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{IMPORTFAILFLEX, IMPORTIGNOREFLEX});
        if (CollectionUtils.isEmpty(mainEntityImportResult)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(RESULT_CARD_ENTRY, mainEntityImportResult.size());
        CardEntry cardEntry = (CardEntry)this.getControl(RESULT_CARD_ENTRY);
        boolean isShowFailImportTips = false;
        for (MulEntityImportingInfo importStatusModel : mainEntityImportResult) {
            int index = importStatusModel.getRowIndex();
            String entityName = importStatusModel.getEntityName();
            int total = importStatusModel.getTotal();
            int fail = importStatusModel.getFail();
            this.getModel().setValue(ENTITY_NAME, (Object)entityName, index);
            this.getModel().setValue(SUCCESS_ROWS, (Object)(total - fail), index);
            this.getModel().setValue(FAIL_ROWS, (Object)fail, index);
            if (index > 0 && (index + 1) % 2 == 0) {
                cardEntry.setCustomProperties(RESULT_CARD_ENTRY, index, MulImportEndPlugin.getBackColorStyle());
            }
            if (isShowFailImportTips) continue;
            isShowFailImportTips = fail > 0;
        }
        if (isShowFailImportTips) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMPORTFAILFLEX});
            return;
        }
        String hasIgnoreSheetNameStr = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("hasIgnoreSheetName"));
        if (StringUtils.isBlank((CharSequence)hasIgnoreSheetNameStr)) {
            return;
        }
        List hasIgnoreSheetNames = SerializationUtils.fromJsonStringToList((String)hasIgnoreSheetNameStr, String.class);
        if (CollectionUtils.isEmpty((Collection)hasIgnoreSheetNames)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String hasIgnoreSheetName : hasIgnoreSheetNames) {
            sb.append(hasIgnoreSheetName).append("\u3001");
        }
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        ((Label)this.getControl("ignoremessage")).setText(String.format(ResManager.loadKDString((String)"Excel\u7684\u201c%s\u201d\u5b58\u5728\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7cfb\u7edf\u5355\u636e\u7684\u6570\u636e\u3002\r\n\u8bf7\u68c0\u67e5\u540c\u4e00\u5f20\u5355\u7684\u5355\u636e\u5934\u3001\u5355\u636e\u4f53\u548c\u5b50\u5355\u636e\u4f53\u6570\u636e\u5173\u8054\u5b57\u6bb5\u503c\u662f\u5426\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MulImportEndPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]), sb));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{IMPORTIGNOREFLEX});
    }

    private static Map<String, Object> getBackColorStyle() {
        HashMap<String, Object> rowStyle = new HashMap<String, Object>(1);
        HashMap<String, String> labelStyle = new HashMap<String, String>(1);
        labelStyle.put("bc", "#F5F5F5");
        rowStyle.put("row_panelap", labelStyle);
        return rowStyle;
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(controlKey)) {
            IFormView parentView = this.getView().getParentView();
            Tab tab = (Tab)parentView.getControl("guidecontent");
            tab.activeTab("tabpageap");
            this.getView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (DOWNLOAD_ERROR_FILE.equals(controlKey) || DOWNLOAD_IGNORE_FILE.equals(controlKey)) {
            String url = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("errorFileUrl"));
            url = UrlService.getAttachmentFullUrl((String)url);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("download", (Object)url);
        }
        if (IMPORT_FAILED_RESULT.equals(controlKey) || IMPORT_IGNORE_RESULT.equals(controlKey)) {
            this.showImportResult();
        }
    }

    private void showImportResult() {
        IFormView view = this.getView();
        String pkId = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("importResultPk"));
        String parentPageId = view.getFormShowParameter().getParentPageId();
        IFormView parentView = view.getView(parentPageId);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(BOS_MULTI_IMPORT_RESULT);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        parameter.setPkId((Object)pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        parentView.showForm((FormShowParameter)parameter);
        view.sendFormAction(parentView);
        view.close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String url = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("errorFileUrl"));
        FileServiceFactory.getAttachmentFileService().delete(url);
        String bizAppId = ImportLogDeleteFileUtil.getBizAppId((String)this.getView().getFormShowParameter().getAppId(), (String)FORM_ID);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u6587\u4ef6", "MulImportEndPlugin_0", BOS_IMPORT);
        MultiLangEnumBridge logOpDesc = new MultiLangEnumBridge("\u5220\u9664\u6587\u4ef6\u6210\u529f\u3002", "MulImportEndPlugin_1", BOS_IMPORT);
        ImportLogDeleteFileUtil.createAppLog((String)FORM_ID, (String)bizAppId, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)logOpDesc, (String[])new String[0]);
    }
}

