/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.tongtech.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.service.MulImportConvertService;
import kd.bos.mulimport.schemeplugin.model.SchemeOpenTypeEnum;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.query.UserPermissionNewListDataRpt;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.service.admingroup.AdmGrpFunpermService;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class MulImportStepBasePlugin
extends AbstractFormPlugin
implements UploadListener,
TabSelectListener,
ICloseCallBack,
BeforeF7SelectListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog(MulImportStepBasePlugin.class);
    protected static final String BOS_IMPORT = "bos-import";
    MulImportConvertService convertService;
    protected MulImportContext mulImportContext;
    protected static final String SUCCESS_VECTORAP = "success_vectorap";
    protected static final String PERCENTFLEX = "percentflex";
    protected static final String PROGRESSFLEX = "progressflex";
    protected static final String COLOR_GREEN = "#1BA854";
    protected static final String COLOR_BLUED = "#5582F3";
    protected static final String PERCENT_LABEL = "percentlabel";
    protected static final String BOS_USER = "bos_user";
    protected static final String PERM_PERMITEM = "perm_permitem";

    public void registerListener(EventObject e) {
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("mulbasedatafield");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"opentips", "closetips", "downloadschemefile", "schemeoldfile"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter modelTypeFilter = new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"});
        listShowParameter.getListFilterParameter().setFilter(modelTypeFilter);
        QFilter permFilter = this.genPermFilter();
        if (permFilter != null) {
            listShowParameter.getListFilterParameter().setFilter(permFilter);
        }
        listShowParameter.getListFilterParameter().setFilter(new QFilter("number", "not in", MulImportStepPluginUtil.queryHideEntity()));
    }

    public void upload(UploadEvent evt) {
        try {
            DynamicObject schemeInfo;
            if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_from_scheme")) && null != (schemeInfo = this.getSchemeInfo())) {
                String path = schemeInfo.getString("filepath");
                String fileName = schemeInfo.getString("filename");
                this.buildContext(path);
                List<ReadSheet> sheets = this.convertService.listSheets();
                this.cacheSheetInfo(path, fileName, sheets);
                return;
            }
            this.finishImporting(null);
            Object[] fileInfo = evt.getUrls();
            if (null != fileInfo && fileInfo.length > 0 && fileInfo[0] instanceof Map) {
                Map excelFile = (Map)fileInfo[0];
                if (ObjectUtils.isEmpty(excelFile.get("url"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6url\u4e3a\u7a7a", (String)"BOS_IMPORT_12", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                String fileName = String.valueOf(excelFile.get("name"));
                String tempUrl = String.valueOf(excelFile.get("url"));
                String appId = this.getView().getFormShowParameter().getAppId();
                String formId = this.getView().getEntityId();
                String pkId = String.valueOf(ID.genLongId());
                Object pathObj = excelFile.get("path");
                String path = StringUtils.isNotBlank(pathObj) ? pathObj.toString() : AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)appId, (String)formId, (Object)pkId, (String)fileName, (boolean)true, (boolean)true);
                excelFile.put("url", UrlService.getAttachmentDownloadUrl((String)path));
                excelFile.put("previewurl", UrlService.getAttachmentPreviewUrl((String)path));
                this.buildContext(path);
                List<ReadSheet> sheets = this.convertService.listSheets();
                boolean empty = this.convertService.fileIsEmpty(sheets);
                if (empty) {
                    this.deleteFile();
                    evt.setCancel(true);
                    evt.setCancelMsg(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"MulImportStepPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                    return;
                }
                this.cacheSheetInfo(path, fileName, sheets);
                if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_choose_scheme_id"))) {
                    if (this.checkExcelFailed(sheets)) {
                        this.deleteFile();
                        evt.setCancel(true);
                        evt.setCancelMsg(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u4e0e\u9009\u62e9\u65b9\u6848\u6587\u4ef6\u7684\u9875\u7b7e\u987a\u5e8f\u3001\u9875\u7b7e\u540d\u79f0\u3001\u5b57\u6bb5\u4e2a\u6570\u6216\u5b57\u6bb5\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"MulImportSchemePlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                    }
                } else if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_scheme_reupload"))) {
                    int schemeType = (Integer)this.getView().getFormShowParameter().getCustomParam("schemeOpenType");
                    if (schemeType == SchemeOpenTypeEnum.IMPORT.getType()) {
                        if (this.checkExcelFailed(sheets)) {
                            this.deleteFile();
                            evt.setCancel(true);
                            evt.setCancelMsg(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u4e0e\u9009\u62e9\u65b9\u6848\u6587\u4ef6\u7684\u9875\u7b7e\u987a\u5e8f\u3001\u9875\u7b7e\u540d\u79f0\u3001\u5b57\u6bb5\u4e2a\u6570\u6216\u5b57\u6bb5\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"MulImportSchemePlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                        }
                    } else if ((schemeType == SchemeOpenTypeEnum.COPY.getType() || schemeType == SchemeOpenTypeEnum.OPEN.getType()) && this.checkExcelFailed(sheets)) {
                        this.getView().getPageCache().put("mul_import_scheme_reset", "1");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("resolve excel failed:", (Throwable)e);
            this.deleteFile();
            throw e;
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public MulImportContext getMulImportContext() {
        return this.mulImportContext;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", this.getView().getPageCache().get("mul_import_file_path"));
        params.put("isOpenScheme", this.getView().getPageCache().get("mul_import_scheme_save"));
        this.getView().returnDataToParent(params);
    }

    public void setMulImportContext(MulImportContext mulImportContext) {
        this.mulImportContext = mulImportContext;
    }

    protected void buildContext(String path) {
        this.mulImportContext = new MulImportContext(path, ExcelTypeEnum.XLSX, this.getView(), null);
        this.mulImportContext.setExcelTypeEnum(ExcelTypeEnum.XLSX);
        this.mulImportContext.setFileUrl(path);
        this.mulImportContext.setFileName(this.getView().getPageCache().get("filename"));
        this.convertService = new MulImportConvertService(this.mulImportContext, false);
    }

    protected void cacheSheetInfo(String path, String fileName, List<ReadSheet> sheets) {
        if (CollectionUtils.isNotEmpty(sheets)) {
            ArrayList<String> sheetNames = new ArrayList<String>(sheets.size());
            for (ReadSheet sheet : sheets) {
                sheetNames.add(sheet.getSheetName());
            }
            this.getView().getPageCache().put("mul_import_sheet_name", SerializationUtils.toJsonString(sheetNames));
        }
        this.getView().getPageCache().put("mul_import_file_path", path);
        this.getView().getPageCache().put("filename", fileName);
    }

    protected void deleteFile() {
        String path = this.getView().getPageCache().get("mul_import_file_path");
        String saveAsScheme = this.getView().getPageCache().get("mul_import_scheme_save");
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)saveAsScheme)) {
            FileServiceFactory.getAttachmentFileService().delete(path);
        }
    }

    protected void clearPageCache(String clearKey) {
        Map pageCaches = this.getView().getPageCache().getAll();
        ArrayList keys = new ArrayList();
        if (null != pageCaches) {
            for (Map.Entry entry : pageCaches.entrySet()) {
                if (!((String)entry.getKey()).startsWith(clearKey)) continue;
                keys.add(entry.getKey());
            }
        }
        for (String string : keys) {
            if ("mul_import_choose_scheme".equals(string) || "mul_import_scheme_new_create_id".equals(string)) continue;
            this.getView().getPageCache().remove(string);
        }
    }

    protected List<String> getHeadCells(List<Map<Integer, String>> headInfo) {
        ArrayList<String> cells = new ArrayList<String>();
        for (Map<Integer, String> cell : headInfo) {
            for (Map.Entry<Integer, String> entry : cell.entrySet()) {
                cells.add(entry.getValue());
            }
        }
        return cells;
    }

    protected DynamicObject getSchemeInfo() {
        if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_scheme_reset"))) {
            return null;
        }
        Map schemeParam = (Map)this.getView().getFormShowParameter().getCustomParam("schemeParam");
        if (MapUtils.isNotEmpty((Map)schemeParam)) {
            Object id = schemeParam.get("id");
            if (StringUtils.isBlank(id)) {
                return null;
            }
            return BusinessDataServiceHelper.loadSingleFromCache(id, (String)"bos_multi_import_scheme");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_choose_scheme_id"))) {
            String id = this.getView().getPageCache().get("mul_import_choose_scheme_id");
            return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id), (String)"bos_multi_import_scheme");
        }
        return null;
    }

    protected void previous() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }

    protected void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            break;
        }
    }

    protected String getCurrentTab() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        return tab.getCurrentTab();
    }

    protected void setProgressColor(String color) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("fc", color);
        this.getView().updateControlMetadata("progressbarap", meta);
    }

    protected void finishImporting(ProgressEvent evt) {
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        if (evt == null) {
            progress.setPercent(100);
        } else {
            evt.setProgress(100);
        }
        progress.stop();
        this.setProgressColor(COLOR_GREEN);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SUCCESS_VECTORAP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PERCENTFLEX});
    }

    protected void continueImporting(ProgressEvent evt) {
        evt.setProgress(99);
        ((Label)this.getControl(PERCENT_LABEL)).setText("99");
    }

    private QFilter genPermFilter() {
        try {
            Set<String> hasPermEntity = this.getHasImportPermEntity();
            if (null == hasPermEntity) {
                return null;
            }
            return new QFilter("number", "in", (Object)hasPermEntity.toArray());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private DynamicObjectCollection filterInfoParamGenerate(String entityName, Object pkValue) {
        DynamicObjectCollection userCollection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Object[] pkArr = new Object[]{pkValue};
        Object[] dymArr = BusinessDataReader.load((Object[])pkArr, (DynamicObjectType)entityType, (Boolean)Boolean.TRUE);
        userCollection.addAll((Collection)Arrays.asList((Object[])dymArr));
        return userCollection;
    }

    private boolean checkExcelFailed(List<ReadSheet> sheets) {
        HashMap<Integer, Integer> sheetHeadInfo;
        DynamicObject schemeInfo = this.getSchemeInfo();
        if (this.checkSheetNotMatch(schemeInfo, sheets, sheetHeadInfo = new HashMap<Integer, Integer>())) {
            return true;
        }
        return this.checkCellNotMatch(schemeInfo, sheetHeadInfo);
    }

    private boolean checkSheetNotMatch(DynamicObject schemeInfo, List<ReadSheet> sheets, Map<Integer, Integer> sheetHeadInfo) {
        DynamicObjectCollection schemeSetInfos = schemeInfo.getDynamicObjectCollection("setentryentity");
        for (DynamicObject schemeSetInfo : schemeSetInfos) {
            int sheetNo = schemeSetInfo.getInt("detailsheet");
            int startRow = schemeSetInfo.getInt("startrow");
            sheetHeadInfo.put(sheetNo, startRow);
            String sheetName = schemeSetInfo.getString("sheetname");
            ReadSheet readSheet = sheets.stream().filter(sheet -> sheet.getSheetNo() == sheetNo).findFirst().orElse(null);
            if (null != readSheet && StringUtils.equals((CharSequence)readSheet.getSheetName(), (CharSequence)sheetName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCellNotMatch(DynamicObject schemeInfo, Map<Integer, Integer> sheetHeadInfo) {
        this.buildContext(this.getView().getPageCache().get("mul_import_file_path"));
        Map<Integer, Map<Integer, String>> currentFileSheetHead = this.convertService.getBatchSheetHead(sheetHeadInfo);
        DynamicObjectCollection schemeSetInfos = schemeInfo.getDynamicObjectCollection("setentryentity");
        for (DynamicObject schemeSetInfo : schemeSetInfos) {
            int sheetNo = schemeSetInfo.getInt("detailsheet");
            Map<Integer, String> cellsMap = currentFileSheetHead.get(sheetNo);
            DynamicObjectCollection schemeMapInfos = schemeSetInfo.getDynamicObjectCollection("subentryentity");
            if (!MapUtils.isNotEmpty(cellsMap) || schemeMapInfos.isEmpty()) continue;
            for (DynamicObject schemeMapInfo : schemeMapInfos) {
                int excelFieldSeq = schemeMapInfo.getInt("excelfield");
                if (excelFieldSeq == -1) continue;
                String excelFieldName = schemeMapInfo.getString("excelfieldname");
                String cellName = cellsMap.get(excelFieldSeq);
                if (!StringUtils.isBlank((CharSequence)cellName) && StringUtils.equals((CharSequence)excelFieldName, (CharSequence)cellName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean needAutoMatch() {
        String autoMatchParam = this.getView().getPageCache().get("all_mul_import_auto_match");
        if (StringUtils.equals((CharSequence)autoMatchParam, (CharSequence)"0")) {
            String chooseScheme = this.getView().getPageCache().get("mul_import_choose_scheme");
            if (StringUtils.equals((CharSequence)chooseScheme, (CharSequence)String.valueOf(SchemeOpenTypeEnum.NOT_CHOOSE.getType()))) {
                int schemeType = (Integer)this.getView().getFormShowParameter().getCustomParam("schemeOpenType");
                return schemeType == SchemeOpenTypeEnum.NEW.getType();
            }
        } else {
            return true;
        }
        return true;
    }

    protected Set<String> getHasImportPermEntity() {
        HashSet<Object> hasPermEntityFromReport = new HashSet<Object>();
        long currUserId = RequestContext.get().getCurrUserId();
        try {
            AdmGrpHasPermResp adminQueryResult;
            Set permissionSet;
            if (PermissionServiceHelper.isSuperUser((long)currUserId)) {
                return null;
            }
            if (PermissionServiceHelper.isAdminUser((long)currUserId) && CollectionUtils.isNotEmpty((Collection)(permissionSet = (adminQueryResult = AdmGrpFunpermService.getAdmGrpHasPermByUserId((Long)currUserId)).getFunpermSet()))) {
                Set collect = permissionSet.stream().filter(perm -> StringUtils.equals((CharSequence)"4730fc9f000003ae", (CharSequence)perm.getPermItemId())).map(AdmGrpFunperm::getEntNum).collect(Collectors.toSet());
                hasPermEntityFromReport.addAll(collect);
            }
            ReportQueryParam reportQueryParam = new ReportQueryParam();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.addFilterItem("users", (Object)this.filterInfoParamGenerate(BOS_USER, currUserId));
            filterInfo.addFilterItem("permfilter", (Object)this.filterInfoParamGenerate(PERM_PERMITEM, "4730fc9f000003ae"));
            filterInfo.addFilterItem("selectdimtype", (Object)"bos_org", "105");
            reportQueryParam.setFilter(filterInfo);
            try (DataSet permResult = new UserPermissionNewListDataRpt().query(reportQueryParam, null);){
                while (permResult.hasNext()) {
                    Row row = permResult.next();
                    String permStatus = row.getString("permstatustag");
                    String entityName = row.getString("entity");
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)permStatus)) continue;
                    hasPermEntityFromReport.add(entityName);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        Set<String> bindImportPermEntitySet = this.getBindImportPermEntitySet();
        bindImportPermEntitySet.removeAll(hasPermEntityFromReport);
        Set<String> allEntitySet = this.getAllEntitySet();
        allEntitySet.removeAll(bindImportPermEntitySet);
        return allEntitySet;
    }

    private Set<String> getBindImportPermEntitySet() {
        HashSet<String> bindImportPermEntitySet = new HashSet<String>();
        String sql = "select fentitytypeid from t_perm_functionperm where fpermitemid = '4730fc9f000003ae'";
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query_t_perm_functionperm";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String entityNumber = row.getString("fentitytypeid");
                bindImportPermEntitySet.add(entityNumber);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return bindImportPermEntitySet;
    }

    private Set<String> getAllEntitySet() {
        QFilter[] filter = new QFilter[]{new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"})};
        Map allEntityDynamicObject = BusinessDataReader.loadFromCache((String)"bos_formmeta", (QFilter[])filter);
        return allEntityDynamicObject.values().stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
    }
}

