/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.model.MulDynamicColElement;
import kd.bos.mulimport.resolve.model.MulDynamicColEntryElement;
import kd.bos.mulimport.resolve.model.MulFieldInfo;
import kd.bos.mulimport.resolve.model.MulFieldMappingCacheVo;
import kd.bos.mulimport.resolve.model.MulFieldTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportCollectModel;
import kd.bos.mulimport.resolve.model.MulImportCollectTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportTypeEnum;
import kd.bos.mulimport.resolve.model.MulNodeDetailVo;
import kd.bos.mulimport.resolve.model.MulOneFieldMappingVo;
import kd.bos.mulimport.resolve.model.MulPreviewRowData;
import kd.bos.mulimport.schemeplugin.model.SchemeOpenTypeEnum;
import kd.bos.mulimport.stepplugin.MulImportStepThreePlugin;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class MulImportStepFourPlugin
extends MulImportStepThreePlugin {
    private static final Log log = LogFactory.getLog(MulImportStepFourPlugin.class);
    private static final String FILENAME = "filename";
    private static final String FORMNAMES = "formnames";
    private static final String FORMNAMESLABEL = "formnameslabel";
    private static final String TOTALNUMBER = "totalnumber";
    private static final String IMPORT_MULTI_PROGRESS = "bos_multi_import_progress";
    public static final String CACHE_KEY_SHOW_DATA = "cache_key_show_data";
    private String ENTRY_ID = "import_result_entry";

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        super.tabSelected(tabSelectEvent);
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap3".equals(tabKey)) {
            this.buttonVisibleSetting();
            try {
                this.buildShowData();
            }
            catch (Exception e) {
                log.info("kd.bos.mulimport.resolve.stepplugin.MulImportStepFourPlugin.tabSelected", (Object)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efa\u9884\u89c8\u6570\u636e\u5f02\u5e38\u3002", (String)"MulImportStepPlugin_33", (String)"bos-import", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String tabKey;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bariteimport".equals(key)) {
            MulImportStepPluginUtil.executeImport(this.buildMappingRule(), this.getView());
        }
        if (StringUtils.equals((CharSequence)"tabpageap3", (CharSequence)(tabKey = this.getCurrentTab()))) {
            if ("bariteprev".equals(key)) {
                this.previous();
            }
            String schemeSaveId = this.getView().getPageCache().get("mul_import_scheme_new_create_id");
            boolean isFromScheme = this.getView().getFormShowParameter().getCustomParam("schemeOpenType") instanceof Integer;
            boolean hasCreate = StringUtils.isNotBlank((CharSequence)schemeSaveId);
            if (isFromScheme) {
                this.dealFromScheme(key, hasCreate);
            } else {
                this.dealFromImport(key, hasCreate);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"show_scheme_save", (CharSequence)actionId) && StringUtils.isNotBlank((Object)returnData) && returnData instanceof Map && ((Map)returnData).get("executeImport") instanceof Boolean && ((Boolean)((Map)returnData).get("executeImport")).booleanValue()) {
            MulImportStepPluginUtil.executeImport(this.buildMappingRule(), this.getView());
        }
        super.closedCallBack(closedCallBackEvent);
    }

    private void buildShowData() {
        this.clearEntryData();
        this.buildHead();
        int totalNumber = this.buildShowEntry();
        this.settingPage(totalNumber);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MulDynamicColEntryElement entryElement;
        List<MulDynamicColElement> elementList;
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("cloneFailed", ex.getMessage()), new Object[0]);
        }
        String elements = this.getPageCache().get("entry_element");
        if (StringUtils.isNotBlank((CharSequence)elements) && CollectionUtils.isNotEmpty(elementList = (entryElement = (MulDynamicColEntryElement)SerializationUtils.deSerializeFromBase64((String)elements)).getItems())) {
            this.cacheEntryElement(elementList, this.getView());
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(this.ENTRY_ID);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    private void buildHead() {
        this.getEntryElement().build(this.getView());
        this.getModel().setDataChanged(false);
    }

    private void clearEntryData() {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(this.ENTRY_ID);
        model.endInit();
    }

    private MulDynamicColEntryElement getEntryElement() {
        String elements = this.getPageCache().get("entry_element");
        if (elements == null) {
            ArrayList<MulDynamicColElement> elementList = new ArrayList<MulDynamicColElement>();
            MulDynamicColEntryElement entryElement = new MulDynamicColEntryElement(this.ENTRY_ID);
            entryElement.setItems(elementList);
            return entryElement;
        }
        return (MulDynamicColEntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private MulPreviewRowData getRowDataModel() {
        String rowDataStr = this.getPageCache().get(CACHE_KEY_SHOW_DATA);
        if (rowDataStr == null) {
            return new MulPreviewRowData();
        }
        return (MulPreviewRowData)SerializationUtils.fromJsonString((String)rowDataStr, MulPreviewRowData.class);
    }

    private void buttonVisibleSetting() {
        boolean isFromScheme = this.getView().getFormShowParameter().getCustomParam("schemeOpenType") instanceof Integer;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritenext"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritecancel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bariteprev"});
        if (isFromScheme) {
            int schemeType = (Integer)this.getView().getFormShowParameter().getCustomParam("schemeOpenType");
            if (schemeType == SchemeOpenTypeEnum.NEW.getType() || schemeType == SchemeOpenTypeEnum.COPY.getType()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bariteimport", "savescheme1"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"savescheme2"});
            } else if (schemeType == SchemeOpenTypeEnum.OPEN.getType()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme2", "bariteimport"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"savescheme1"});
            } else if (schemeType == SchemeOpenTypeEnum.IMPORT.getType()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bariteimport"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme1", "savescheme2"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bariteimport"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme1", "savescheme2"});
        }
    }

    private void settingPage(int totalNumber) {
        String fileName = this.getView().getPageCache().get(FILENAME);
        ArrayList<String> bills = new ArrayList<String>(8);
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        Map nodeMap = mulTreeNodeVos.stream().collect(Collectors.groupingBy(MulNodeDetailVo::getMainTypeName, LinkedHashMap::new, Collectors.toList()));
        for (String billNumber : nodeMap.keySet()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
            bills.add(mainType.getDisplayName().toString());
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = bills.iterator();
        while (iterator.hasNext()) {
            String bill = (String)iterator.next();
            sb.append(bill);
            if (!iterator.hasNext()) continue;
            sb.append("\u3001");
        }
        String billName = (String)bills.get(0);
        Label billNameLabel = (Label)this.getControl(FORMNAMESLABEL);
        Label totalNumberLabel = (Label)this.getControl(TOTALNUMBER);
        Label fileNameLabel = (Label)this.getControl(FILENAME);
        Label formNamesLabel = (Label)this.getControl(FORMNAMES);
        billNameLabel.setText(billName);
        totalNumberLabel.setText(String.valueOf(totalNumber));
        fileNameLabel.setText(fileName);
        formNamesLabel.setText(sb.toString());
    }

    private int buildShowEntry() {
        MulPreviewRowData rowDataModel = this.getRowDataModel();
        DynamicObjectCollection showEntryCollection = this.getModel().getDataEntity().getDynamicObjectCollection(this.ENTRY_ID);
        DynamicObject showDataDym = new DynamicObject(showEntryCollection.getDynamicObjectType());
        List<String> headCellDatas = rowDataModel.getShowData();
        int headSize = headCellDatas.size();
        if (headSize == 0) {
            return 0;
        }
        int curIndex = 2;
        for (String headCellData : headCellDatas) {
            showDataDym.set(curIndex++, (Object)headCellData);
        }
        List<MulPreviewRowData> entryRows = rowDataModel.getContactShowData();
        for (MulPreviewRowData entryRow : entryRows) {
            List<String> entryCellDatas = entryRow.getShowData();
            curIndex = 2 + headSize;
            for (String entryCellData : entryCellDatas) {
                showDataDym.set(curIndex++, (Object)entryCellData);
            }
            List<MulPreviewRowData> subEntryRows = entryRow.getContactShowData();
            for (MulPreviewRowData subEntryRow : subEntryRows) {
                List<String> showDatas = subEntryRow.getShowData();
                curIndex = 2 + headSize + entryCellDatas.size();
                for (String showData : showDatas) {
                    showDataDym.set(curIndex++, (Object)showData);
                }
                showEntryCollection.add((Object)showDataDym);
                showDataDym = new DynamicObject(showEntryCollection.getDynamicObjectType());
            }
            if (subEntryRows.size() == 0) {
                showEntryCollection.add((Object)showDataDym);
            }
            showDataDym = new DynamicObject(showEntryCollection.getDynamicObjectType());
        }
        if (entryRows.size() == 0) {
            showEntryCollection.add((Object)showDataDym);
        }
        this.getView().updateView(this.ENTRY_ID);
        return showEntryCollection.size();
    }

    private List<MulImportDataMappingRule> buildMappingRule() {
        IFormView view = this.getView();
        ArrayList<MulImportDataMappingRule> mulImportDataMappingRuleList = new ArrayList<MulImportDataMappingRule>();
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(view.getPageCache());
        IDataModel model = view.getModel();
        Map<String, List<MulNodeDetailVo>> nodeMap = this.getOrderNodeMap(model, mulTreeNodeVos);
        for (Map.Entry<String, List<MulNodeDetailVo>> entryNodeVoEntry : nodeMap.entrySet()) {
            for (MulNodeDetailVo entryNode : entryNodeVoEntry.getValue()) {
                MulFieldMappingCacheVo parentMappingCacheVo;
                DualHashBidiMap excelCol2PropInfoMap = new DualHashBidiMap();
                int currentNodeSeq = entryNode.getRowId();
                MulFieldMappingCacheVo mulFieldMappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(view, String.valueOf(currentNodeSeq));
                ArrayList<MulImportCollectModel> importCollectModels = new ArrayList<MulImportCollectModel>();
                if (null == mulFieldMappingCacheVo || StringUtils.isEmpty((CharSequence)mulFieldMappingCacheVo.getCurDataSheetIndex())) continue;
                int currentSheetIndex = Integer.parseInt(mulFieldMappingCacheVo.getCurDataSheetIndex());
                String currentSheetName = MulImportStepPluginUtil.getSheetNameByValue(view, currentSheetIndex);
                int lowerRelationField = mulFieldMappingCacheVo.getLowerRelationField();
                int superRelationField = mulFieldMappingCacheVo.getSuperRelationField();
                List<MulOneFieldMappingVo> fields = mulFieldMappingCacheVo.getOneFieldMappingVos();
                List<String> headColumn = MulImportStepPluginUtil.getHeadColumn(view, String.valueOf(currentNodeSeq));
                if (CollectionUtils.isNotEmpty(fields) && CollectionUtils.isNotEmpty(headColumn)) {
                    for (MulOneFieldMappingVo field : fields) {
                        if (StringUtils.isBlank((CharSequence)field.getExcelField())) continue;
                        int excelCol = Integer.parseInt(field.getExcelField());
                        MulFieldInfo fieldInfo = field.getFieldInfo();
                        MulImportPropColMapping mulImportPropColMapping = new MulImportPropColMapping(fieldInfo.getNumber(), excelCol, headColumn.get(excelCol), fieldInfo.getPropSeq());
                        if (MulFieldTypeEnum.BASE_DATA == fieldInfo.getFieldType()) {
                            MulImportCollectModel collectModel = new MulImportCollectModel(MulImportCollectTypeEnum.getValue(fieldInfo.getType()), excelCol);
                            importCollectModels.add(collectModel);
                        }
                        if (MulFieldTypeEnum.BASE_DATA == fieldInfo.getFieldType() || MulFieldTypeEnum.MUL_LANG_TEXT == fieldInfo.getFieldType()) {
                            String[] splitNumber = StringUtils.split((String)fieldInfo.getNumber(), (String)".");
                            mulImportPropColMapping.setPropNumber(splitNumber[0]);
                            mulImportPropColMapping.setMatchProp(splitNumber[1]);
                        }
                        excelCol2PropInfoMap.put((Object)excelCol, (Object)mulImportPropColMapping);
                    }
                }
                int parentSheetIndex = -1;
                String parentDataSheetName = "";
                if ((entryNode.getNodeType() == MulImportResolveTypeEnum.ENTRY.getType() || entryNode.getNodeType() == MulImportResolveTypeEnum.SUB_ENTRY.getType()) && null != (parentMappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(view, String.valueOf(entryNode.getParentRowId())))) {
                    parentSheetIndex = Integer.parseInt(parentMappingCacheVo.getCurDataSheetIndex());
                    parentDataSheetName = parentMappingCacheVo.getCurDataSheetName();
                }
                int startRow = -1;
                int startCol = -1;
                int importType = -1;
                String dataReplaceValue = "";
                Object startRowObj = model.getValue("startrow", currentNodeSeq);
                Object startColObj = model.getValue("startcolumn", currentNodeSeq);
                Object importTypeObj = model.getValue("importtypechoose", currentNodeSeq);
                Object dataReplaceValueObj = model.getValue("datareplacevalue", currentNodeSeq);
                if (!ObjectUtils.isEmpty((Object)startRowObj)) {
                    startRow = Integer.parseInt(startRowObj.toString());
                }
                if (!ObjectUtils.isEmpty((Object)startColObj)) {
                    startCol = Integer.parseInt(startColObj.toString());
                }
                if (!ObjectUtils.isEmpty((Object)importTypeObj)) {
                    importType = Integer.parseInt(importTypeObj.toString());
                }
                if (!ObjectUtils.isEmpty((Object)dataReplaceValueObj)) {
                    dataReplaceValue = dataReplaceValueObj.toString();
                }
                MulImportDataMappingRule rule = MulImportDataMappingRule.createMulImportDataMappingRule(entryNodeVoEntry.getKey(), entryNode.getNodeNumber(), parentSheetIndex, parentDataSheetName, currentSheetIndex, currentSheetName, startRow, startCol, importCollectModels, superRelationField, lowerRelationField, new ArrayList<MulImportDataMappingRule>(), (BidiMap<Integer, MulImportPropColMapping>)excelCol2PropInfoMap, MulImportTypeEnum.getValue(importType), dataReplaceValue);
                if (entryNode.getNodeType() == MulImportResolveTypeEnum.ENTRY.getType() || entryNode.getNodeType() == MulImportResolveTypeEnum.SUB_ENTRY.getType()) {
                    for (MulImportDataMappingRule ruleTmp : mulImportDataMappingRuleList) {
                        if (!StringUtils.equals((CharSequence)ruleTmp.getDataSheetName(), (CharSequence)rule.getParentDataSheetName())) continue;
                        ruleTmp.getContactRules().add(rule);
                    }
                }
                mulImportDataMappingRuleList.add(rule);
            }
        }
        Object firstImportFormObj = model.getValue("firstimportsheetcombo");
        if (firstImportFormObj != null) {
            MulImportDataMappingRule rule = (MulImportDataMappingRule)mulImportDataMappingRuleList.get(0);
            rule.setFirstImport(true);
        }
        return mulImportDataMappingRuleList;
    }

    private void dealFromScheme(String key, boolean hasCreate) {
        int schemeType = (Integer)this.getView().getFormShowParameter().getCustomParam("schemeOpenType");
        if (schemeType == SchemeOpenTypeEnum.NEW.getType()) {
            if ("savescheme2".equals(key)) {
                if (hasCreate) {
                    this.saveMulImportScheme(null, null, true);
                } else {
                    this.showSaveSchemeForm(false);
                }
            } else if ("importandsave2".equals(key)) {
                if (hasCreate) {
                    this.updateSchemeAndExecuteImport();
                } else {
                    this.showSaveSchemeForm(true);
                }
            }
        } else if (schemeType == SchemeOpenTypeEnum.COPY.getType()) {
            if ("savescheme2".equals(key)) {
                this.showSaveSchemeForm(false);
            } else if ("importandsave2".equals(key)) {
                if (hasCreate) {
                    this.updateSchemeAndExecuteImport();
                } else {
                    this.showSaveSchemeForm(true);
                }
            }
        } else if (schemeType == SchemeOpenTypeEnum.OPEN.getType()) {
            if ("savescheme1".equals(key)) {
                this.saveMulImportScheme(null, null, true);
            } else if ("savenewscheme1".equals(key)) {
                this.showSaveSchemeForm(false);
            } else if ("importandsave1".equals(key)) {
                this.updateSchemeAndExecuteImport();
            }
        } else if (schemeType == SchemeOpenTypeEnum.IMPORT.getType()) {
            if ("savescheme".equals(key)) {
                this.saveMulImportScheme(null, null, true);
            } else if ("savenewscheme".equals(key)) {
                this.showSaveSchemeForm(false);
            } else if ("importandsave".equals(key)) {
                this.updateSchemeAndExecuteImport();
            }
        }
    }

    private void dealFromImport(String key, boolean hasCreate) {
        String importType = this.getView().getPageCache().get("mul_import_choose_scheme");
        if (StringUtils.isNotBlank((CharSequence)importType)) {
            if (SchemeOpenTypeEnum.CHOOSE.getType() == Integer.parseInt(importType)) {
                if ("savescheme".equals(key)) {
                    this.saveMulImportScheme(null, null, true);
                } else if ("savenewscheme".equals(key)) {
                    this.showSaveSchemeForm(false);
                } else if ("importandsave".equals(key)) {
                    this.updateSchemeAndExecuteImport();
                }
            } else if (SchemeOpenTypeEnum.NOT_CHOOSE.getType() == Integer.parseInt(importType)) {
                if ("savescheme".equals(key)) {
                    if (hasCreate) {
                        this.saveMulImportScheme(null, null, true);
                    } else {
                        this.showSaveSchemeForm(false);
                    }
                } else if ("savenewscheme".equals(key)) {
                    this.showSaveSchemeForm(false);
                } else if ("importandsave".equals(key)) {
                    if (hasCreate) {
                        this.updateSchemeAndExecuteImport();
                    } else {
                        this.showSaveSchemeForm(true);
                    }
                }
            }
        }
    }

    private void updateSchemeAndExecuteImport() {
        this.saveMulImportScheme(null, null, true);
        MulImportStepPluginUtil.executeImport(this.buildMappingRule(), this.getView());
    }

    private Map<String, List<MulNodeDetailVo>> getOrderNodeMap(IDataModel model, List<MulNodeDetailVo> mulTreeNodeVos) {
        Map nodeMap = mulTreeNodeVos.stream().collect(Collectors.groupingBy(MulNodeDetailVo::getMainTypeName, LinkedHashMap::new, Collectors.toList()));
        Object firstImportFormObj = model.getValue("firstimportsheetcombo");
        LinkedHashMap<String, List<MulNodeDetailVo>> nodeMapOrder = new LinkedHashMap<String, List<MulNodeDetailVo>>(nodeMap.size());
        if (StringUtils.isNotBlank((Object)firstImportFormObj)) {
            String firstImportForm = firstImportFormObj.toString();
            List firstImportList = (List)nodeMap.get(firstImportForm);
            if (CollectionUtils.isNotEmpty((Collection)firstImportList)) {
                nodeMapOrder.put(firstImportForm, firstImportList);
            }
            for (Map.Entry entry : nodeMap.entrySet()) {
                if (((String)entry.getKey()).equals(firstImportForm)) continue;
                nodeMapOrder.put((String)entry.getKey(), (List<MulNodeDetailVo>)entry.getValue());
            }
            return nodeMapOrder;
        }
        return nodeMap;
    }
}

