/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.model.MulEntityImportingInfo;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class MulImportingPlugin
extends ImportPermissionPlugin
implements ProgresssListener {
    public static final String COLOR_BLUE = "#276FF5";
    public static final String COLOR_GREEN = "#1BA854";
    private final Log log = LogFactory.getLog(MulImportingPlugin.class);
    private final String PROGRESSBARAP = "progressbarap";
    private final String IMPORT_DETAIL = "import_detail";
    private final String ENTITY_NAME = "entityname";
    private final String GOBACKGROUNDBTN = "gobackgroundbtn";
    private final String PROGRESS_IMPORT_STATUS = "progressimportstatus";
    private final String BOS_IMPORT = "bos-import";
    private final String CACHE_KEY_PROGRESS = "Cache_Multi_Import_Progress";
    private final String BOS_MULTI_IMPORT_END = "bos_multi_import_end";
    private final String CACHE_KEY_IMPORT_RESULT_PK = "import_result_pk";
    private final String CACHE_KEY_IMPORTSTATUS = "cache_key_importStatus";
    private final String CACHE_KEY_HASIGNORESHEETNAME = "cache_key_hasIgnoreSheetName";
    private final String CACHE_KEY_ErrorFile_Url = "cache_key_errorfile_url";
    private final String CACHE_KEY_STATUS = "Cache_Multi_Import_Status";
    private final String CACHE_KEY_CHOOSE_FIRST_IMPORT = "chooseFirstImport";
    public static final String CACHEKEY_MUL_TASKID = "mul_import_taskid";
    public static final String CACHEKEY_MUL_JOBFORMINFO = "import_mul_jobforminfo";
    private final String CONFIRMED_TOBACKGROUND = "CLOSE_CONFIRMED_TOBACKGROUND";
    private final String BOS_MULTI_IMPORT_RESULT = "bos_multi_import_result";
    private final String START_KEY = "CHECK_MUL_IMPORT_START_KEY";
    private final String FINISHED_KEY = "CHECK_MUL_IMPORT_FINISHED_KEY";
    private final String FAIL_KEY = "CHECK_MUL_IMPORT_FAIL_KEY";
    private boolean isFromBackGround = false;
    private static final String CACHE_KEY_MULTI_IMPORT_ENTITY_STATUS = "CACHE_MULTI_IMPORT_ENTITY_STATUS";
    private static final String MUL_IMPORT_CALLBACK_ID = "mul_import_callback_id";

    public void registerListener(EventObject e) {
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"gobackgroundbtn"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initImportEntryDetail();
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
        try {
            progress.start();
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportingPlugin_0", (String)"bos-import", (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportingPlugin_1", (String)"bos-import", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void onProgress(ProgressEvent evt) {
        IFormView parentView = this.getView().getParentView();
        String taskId = this.getTaskId();
        if (!MulImportStepPluginUtil.isStart(parentView) && StringUtils.isBlank((CharSequence)taskId)) {
            this.markStart(parentView);
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.log.info("---taskId is null---");
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"gobackgroundbtn"});
        if (StringUtils.equals((CharSequence)"error", (CharSequence)this.getParentView().getPageCache().get("Cache_Multi_Import_Status"))) {
            this.markFail(parentView);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540e\u53f0\u4e8b\u52a1\u5f02\u5e38\uff0c\u8bf7\u67e5\u540e\u53f0\u65e5\u5fd7\u5904\u7406\u3002", (String)"MulImportStepPlugin_34", (String)"bos-import", (Object[])new Object[0]));
            this.stopBar();
            TaskClientProxy.delTask((JobFormInfo)this.getJobFormInfo(), (String)taskId, null);
            return;
        }
        this.updateProgress(evt);
        if (StringUtils.equals((CharSequence)"finish", (CharSequence)this.getParentView().getPageCache().get("Cache_Multi_Import_Status"))) {
            this.log.info("---mulImport---finish---");
            this.finishImport(evt);
        }
    }

    private void updateProgress(ProgressEvent evt) {
        String progressInfoStr = this.getParentView().getPageCache().get("Cache_Multi_Import_Progress");
        if (StringUtils.isBlank((CharSequence)progressInfoStr)) {
            this.log.info("---progressInfo is null---");
            return;
        }
        Map progressInfos = (Map)SerializationUtils.deSerializeFromBase64((String)progressInfoStr);
        boolean isFirstImport = Boolean.parseBoolean(String.valueOf(progressInfos.get("isFirstImport")));
        int wholeCovertDataSize = 0;
        List entityProgressInfos = (List)progressInfos.get("entityProgressInfos");
        for (MulEntityImportingInfo entityProgressInfo : entityProgressInfos) {
            int covertDataSize;
            int entryIndex = entityProgressInfo.getRowIndex();
            String entityNumber = entityProgressInfo.getEntityNumber();
            String finishEntityStr = this.getParentView().getPageCache().get(CACHE_KEY_MULTI_IMPORT_ENTITY_STATUS);
            if (StringUtils.isBlank((CharSequence)finishEntityStr)) {
                int covertDataSize2 = this.showImportingProgress(entityProgressInfo, entryIndex);
                wholeCovertDataSize += covertDataSize2;
                continue;
            }
            Set finishEntity = (Set)SerializationUtils.fromJsonString((String)finishEntityStr, Set.class);
            if (finishEntity.contains(entityNumber)) {
                covertDataSize = this.showEntityFinishProgress(entityProgressInfo, entryIndex);
                wholeCovertDataSize += covertDataSize;
                continue;
            }
            covertDataSize = this.showImportingProgress(entityProgressInfo, entryIndex);
            wholeCovertDataSize += covertDataSize;
        }
        int wholeDataNum = (Integer)progressInfos.get("wholeDataNum");
        this.updateProgressRate(evt, wholeCovertDataSize, wholeDataNum, isFirstImport);
    }

    private void updateProgressRate(ProgressEvent evt, int wholeCovertDataSize, int wholeDataNum, boolean isFirstImport) {
        double rate = (double)wholeCovertDataSize / (double)wholeDataNum * 100.0;
        rate = MulImportStepPluginUtil.resetRate(rate);
        boolean chooseFirstImport = Boolean.parseBoolean(this.getParentView().getPageCache().get("chooseFirstImport"));
        if (chooseFirstImport) {
            rate = MulImportStepPluginUtil.reCalculateRate(isFirstImport, rate);
        }
        if (evt == null) {
            ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
            progress.setPercent((int)rate);
            return;
        }
        evt.setProgress((int)rate);
    }

    private int showEntityFinishProgress(MulEntityImportingInfo entityProgressInfo, int entryIndex) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("import_detail");
        String showMsg = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ImportingEntryPlugin_1", (String)"bos-import", (Object[])new Object[0]);
        cardEntry.setCustomProperties("import_detail", entryIndex, this.getStyles(COLOR_GREEN));
        this.getModel().setValue("entityname", (Object)entityProgressInfo.getEntityName(), entryIndex);
        this.getModel().setValue("progressimportstatus", (Object)showMsg, entryIndex);
        return entityProgressInfo.getCovertDataSize();
    }

    private int showImportingProgress(MulEntityImportingInfo entityProgressInfo, int entryIndex) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("import_detail");
        int total = entityProgressInfo.getTotal();
        int covertDataSize = entityProgressInfo.getCovertDataSize();
        String showMsg = String.format(ResManager.loadKDString((String)"%1$s/%2$s\u5f20", (String)"BOS_IMPORT_23", (String)"bos-import", (Object[])new Object[0]), covertDataSize, total);
        cardEntry.setCustomProperties("import_detail", entryIndex, this.getStyles(COLOR_BLUE));
        String importingEntityMsg = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165%s", (String)"ImportingEntryPlugin_5", (String)"bos-import", (Object[])new Object[0]), entityProgressInfo.getEntityName());
        this.getModel().setValue("entityname", (Object)importingEntityMsg, entryIndex);
        this.getModel().setValue("progressimportstatus", (Object)showMsg, entryIndex);
        return covertDataSize;
    }

    private void finishImport(ProgressEvent evt) {
        IFormView parentView = this.getView().getParentView();
        if (!this.isFinished(parentView)) {
            evt.setProgress(99);
            this.markFinished(parentView);
            return;
        }
        evt.setProgress(100);
        this.showEndForm();
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Button)) {
            return;
        }
        Button btn = (Button)evt.getSource();
        if ("gobackgroundbtn".equals(btn.getKey())) {
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (this.isFromBackGround || !MulImportStepPluginUtil.isStart(parentView) || this.isFinished(parentView) || this.isFail(parentView)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u5165\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"ImportingPlugin_13", (String)"bos-import", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("CLOSE_CONFIRMED_TOBACKGROUND", (IFormPlugin)this));
        this.stopBar();
        e.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"CLOSE_CONFIRMED_TOBACKGROUND")) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                this.toBackground();
            }
            if (messageboxclosedevent.getResult() == MessageBoxResult.Cancel) {
                this.startBar();
            }
        }
    }

    private Map<String, Object> getStyles(String color) {
        HashMap<String, Object> rowStyle = new HashMap<String, Object>(4);
        HashMap<String, String> nameStyle = new HashMap<String, String>(1);
        nameStyle.put("fc", color);
        rowStyle.put("entityname", nameStyle);
        rowStyle.put("progressimportstatus", nameStyle);
        return rowStyle;
    }

    private void initImportEntryDetail() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"gobackgroundbtn"});
        IFormView parentView = this.getView().getParentView();
        if (MulImportStepPluginUtil.isStart(parentView)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"gobackgroundbtn"});
        }
        String mainEntityNames = (String)this.getView().getFormShowParameter().getCustomParam("importNames");
        Set entityNames = (Set)SerializationUtils.fromJsonString((String)mainEntityNames, LinkedHashSet.class);
        this.getModel().batchCreateNewEntryRow("import_detail", entityNames.size());
        int rowIndex = 0;
        for (String entityName : entityNames) {
            this.getModel().setValue("entityname", (Object)entityName, rowIndex);
            this.getModel().setValue("progressimportstatus", (Object)ResManager.loadKDString((String)"\u5f85\u5bfc\u5165", (String)"MulImportingPlugin_0", (String)"bos-import", (Object[])new Object[0]), rowIndex);
            ++rowIndex;
        }
        this.updateProgress(null);
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_multi_import_result");
        DynamicObject dyn = (DynamicObject)entityType.createInstance();
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String importResultBillNo = coderule.getNumber("bos_multi_import_result", dyn, null);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"MulImportStepPlugin_35", (String)"bos-import", (Object[])new Object[0]), importResultBillNo));
        LocaleString tmpLocalString = ResManager.getLocaleString((String)"\u5bfc\u5165 - %s", (String)"MulImportStepPlugin_35", (String)"bos-import");
        for (Map.Entry entry : tmpLocalString.entrySet()) {
            tmpLocalString.setItem((String)entry.getKey(), (Object)String.format((String)entry.getValue(), importResultBillNo));
        }
        jobInfo.setlName(tmpLocalString);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String routeAppId = formShowParameter.getServiceAppId();
        this.log.debug("buildJobFormInfo ---- routeAppId : " + routeAppId);
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.mulimport.resolve.service.MulImportService");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("MulImportDataMappingRulesStr", formShowParameter.getCustomParam("MulImportDataMappingRulesStr"));
        params.put("importStartPageId", formShowParameter.getCustomParam("importStartPageId"));
        params.put("mul_import_file_path", this.getView().getParentView().getPageCache().get("mul_import_file_path"));
        params.put("importResultBillNo", importResultBillNo);
        params.put("schemeNumber", formShowParameter.getCustomParam("schemeNumber"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(formShowParameter.getParentPageId());
        jobFormInfo.setRootPageId(formShowParameter.getRootPageId());
        jobFormInfo.getParams().putAll(formShowParameter.getCustomParams());
        jobFormInfo.setClickClassName("kd.bos.mulimport.background.MulImportTaskClick");
        return jobFormInfo;
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void showEndForm() {
        IPageCache pageCache = this.getParentView().getPageCache();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_multi_import_end");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        showParameter.setParentPageId(this.getParentView().getPageId());
        showParameter.setCustomParam("importStatusModels", (Object)pageCache.get("cache_key_importStatus"));
        showParameter.setCustomParam("hasIgnoreSheetName", (Object)pageCache.get("cache_key_hasIgnoreSheetName"));
        showParameter.setCustomParam("errorFileUrl", (Object)pageCache.get("cache_key_errorfile_url"));
        showParameter.setCustomParam("importResultPk", (Object)pageCache.get("import_result_pk"));
        this.getView().getParentView().showForm(showParameter);
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        return this.getView().getViewNoPlugin(parentPageId);
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (TaskClientProxy.isExistTask((String)taskId)) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
    }

    private void closeForm() {
        this.isFromBackGround = true;
        this.getView().close();
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_MUL_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_MUL_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_MUL_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_MUL_JOBFORMINFO);
            return;
        }
        String str = SerializationUtils.toJsonString((Object)jobFormInfo);
        this.getPageCache().put(CACHEKEY_MUL_JOBFORMINFO, str);
    }

    private void markStart(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("CHECK_MUL_IMPORT_START_KEY", "true");
    }

    private void markFinished(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("CHECK_MUL_IMPORT_FINISHED_KEY", "true");
    }

    private boolean isFinished(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        return StringUtils.isNotBlank((CharSequence)pageCache.get("CHECK_MUL_IMPORT_FINISHED_KEY"));
    }

    private void markFail(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("CHECK_MUL_IMPORT_FAIL_KEY", "true");
    }

    private boolean isFail(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        return StringUtils.isNotBlank((CharSequence)pageCache.get("CHECK_MUL_IMPORT_FAIL_KEY"));
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_MUL_TASKID, taskId);
        this.getParentView().getPageCache().put(CACHEKEY_MUL_TASKID, taskId);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_MUL_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_MUL_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_MUL_TASKID);
    }
}

