/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.IImportServicePlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mvc.export.ImportEntityDataReader;
import kd.bos.mvc.export.ImportFailedSheetHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;

@Deprecated
public class ImportDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ImportDataTask.class);
    private static final String BOS_IMPORT = "bos-import";
    private int LIMIT_FOR_ERROR_MESSAGE = 5000;
    private String opSave;
    private final JSONObject option = new JSONObject();
    private String appId;
    private String billFormId;
    private LocaleString billFormName;
    private final Map<String, ImportLogger> urlLoggers = new HashMap<String, ImportLogger>();
    private ImportEntityDataReader reader;
    private AbstractOperateWebApi saveWebApi = null;
    private final List<IImportPlugin> importPlugins = new ArrayList<IImportPlugin>();

    private AbstractOperateWebApi getSaveWebApi() {
        if (StringUtils.isBlank((CharSequence)this.opSave)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"ImportDataTask_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        }
        if (this.saveWebApi == null) {
            this.saveWebApi = FormMetadataCache.getFormOperationApi((String)FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId(), (String)this.opSave);
        }
        return this.saveWebApi;
    }

    public void init(Map<String, Object> importParams) {
        this.appId = (String)importParams.get("ServiceAppId");
        this.billFormId = (String)importParams.get("BillFormId");
        this.option.put("importtype", importParams.get("Type"));
        this.option.put("ExtendData", importParams.get("ExtendData"));
        this.option.put("importmode", (Object)true);
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object importMaxErrCount = systemParamService.loadPublicParameterFromCache("import_max_errcount");
        if (importMaxErrCount != null && StringUtils.isNumeric((CharSequence)importMaxErrCount.toString()) && Integer.parseInt(importMaxErrCount.toString()) > 0) {
            this.LIMIT_FOR_ERROR_MESSAGE = Integer.parseInt(importMaxErrCount.toString());
        }
        for (String url : (List)importParams.get("Urls")) {
            ImportLogger importLogger = new ImportLogger(url);
            importLogger.setLimitForErrorMessage(this.LIMIT_FOR_ERROR_MESSAGE);
            this.urlLoggers.put(url, importLogger);
        }
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId());
        this.opSave = ops.getSave();
        List plugins = (List)importParams.remove("Plugins");
        MainEntityType entityType = null;
        if (plugins != null) {
            for (String className : plugins) {
                try {
                    IImportPlugin p = (IImportPlugin)Class.forName(className).newInstance();
                    p.init(importParams);
                    if (entityType == null) {
                        entityType = p.getImportMainEntityType(this.billFormId);
                    }
                    this.importPlugins.add(p);
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0cAPPID\uff1a%2$s\uff0c%3$s", (String)"ImportDataTask_10", (String)BOS_IMPORT, (Object[])new Object[0]), className, this.appId, e.getMessage());
                    this.feedbackProgress(-1, null, errMsg);
                    throw new KDBizException((Throwable)e, new ErrorCode("", errMsg), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0cAPPID\uff1a%2$s", (String)"ImportDataTask_11", (String)BOS_IMPORT, (Object[])new Object[0]), className, this.appId);
                    this.feedbackProgress(-1, null, errMsg);
                    throw new KDBizException((Throwable)e, new ErrorCode("", errMsg), new Object[0]);
                }
            }
        }
        if (entityType == null) {
            entityType = EntityMetadataCache.getDataEntityType((String)this.billFormId);
        }
        this.billFormName = entityType.getDisplayName();
        this.reader = ImportEntityDataReader.create(entityType);
    }

    public void execute(RequestContext ctx, Map<String, Object> importParams) {
        String errMsg = "";
        try {
            this.init(importParams);
            log.debug("----import-task-init----finish");
            boolean complete = this.fireResolveEvent();
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", true);
            if (!complete) {
                log.debug("----import-task--default-resolve-start----");
                this.resolve(this.urlLoggers, null);
            }
            for (Map.Entry<String, ImportLogger> url : this.urlLoggers.entrySet()) {
                ImportLogger importLogger = url.getValue();
                if (importLogger.getFailed() <= 0) continue;
                log.debug("----import-task--finish-and-start-outputFailedData----");
                this.outputFailedData(importLogger.getDelRows(), url);
            }
            retdata.put("info", this.urlLoggers);
            this.feedbackCustomdata(retdata);
            log.debug("----import-task--complete----");
        }
        catch (Throwable e) {
            errMsg = e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_0", (String)BOS_IMPORT, (Object[])new Object[0]);
            throw e;
        }
        finally {
            log.debug("----import-task--complete-feedbackProgress----");
            this.feedbackProgress(100, null, errMsg);
        }
    }

    public List<Object> importData(JSONObject data, JSONObject option, List<ImportLogger.ImportLog> logs) {
        JSONObject dataPack = new JSONObject();
        dataPack.put("data", (Object)data);
        dataPack.put("option", (Object)option);
        AbstractOperateWebApi webApi = this.getSaveWebApi();
        webApi.initialize(this.billFormId, (Map)dataPack);
        try {
            ApiResult result = webApi.execute();
            if (result == null) {
                logs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38", (String)"ImportDataTask_3", (String)"bos-form-mvc", (Object[])new Object[0])));
            } else {
                OperationResult errData;
                if (result.getSuccess()) {
                    OperationResult opResult = (OperationResult)result.getData();
                    return opResult.getSuccessPkIds();
                }
                String msg = result.getMessage();
                if (StringUtils.isBlank((CharSequence)msg) && !(errData = (OperationResult)result.getData()).isSuccess()) {
                    List errList = errData.getAllErrorOrValidateInfo();
                    StringBuilder stb = new StringBuilder();
                    for (IOperateInfo errinfo : errList) {
                        stb.append(errinfo.getMessage());
                    }
                    msg = stb.toString();
                }
                logs.add(new ImportLogger.ImportLog(msg));
            }
        }
        catch (KDException bize) {
            log.error((Throwable)bize);
            String msg = "";
            switch (option.getString("importtype")) {
                case "new": {
                    msg = ResManager.loadKDString((String)" \u65e0\u6cd5\u65b0\u589e\u5bfc\u5165\u3002", (String)"ImportDataTask_4", (String)"bos-form-mvc", (Object[])new Object[0]);
                    break;
                }
                case "override": {
                    msg = ResManager.loadKDString((String)" \u65e0\u6cd5\u8986\u76d6\u5bfc\u5165\u3002", (String)"ImportDataTask_5", (String)"bos-form-mvc", (Object[])new Object[0]);
                    break;
                }
                default: {
                    msg = ResManager.loadKDString((String)" \u65e0\u6cd5\u65b0\u589e\u8986\u76d6\u5bfc\u5165\u3002", (String)"ImportDataTask_6", (String)"bos-form-mvc", (Object[])new Object[0]);
                }
            }
            logs.add(new ImportLogger.ImportLog(bize.getMessage() + msg));
        }
        catch (Throwable e) {
            log.error(e);
            logs.add(new ImportLogger.ImportLog(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_6", (String)BOS_IMPORT, (Object[])new Object[0])));
        }
        return new ArrayList<Object>();
    }

    private void outputFailedData(List<int[]> delRows, Map.Entry<String, ImportLogger> urlLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream is = service.getInputStream(urlLogger.getKey());){
            ImportFailedSheetHandler handler = new ImportFailedSheetHandler(this.appId, this.billFormId, this.billFormName.toString(), urlLogger.getValue(), service);
            new ExcelReader().read(is, handler);
        }
        catch (Throwable e) {
            log.error(e);
            urlLogger.getValue().log(Integer.valueOf(0), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u751f\u6210\u9519\u8bef\u6570\u636e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    public void resolve(Map<String, ImportLogger> urls, BiFunction<JSONObject, JSONObject, List<ImportLogger.ImportLog>> dataHandler) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        int batchProgress = 0;
        int tempProgress = 0;
        for (Map.Entry<String, ImportLogger> url : urls.entrySet()) {
            String path = url.getKey();
            final JSONArray jsonSheet = new JSONArray();
            ImportLogger logger = url.getValue();
            try (InputStream in = service.getInputStream(path);){
                new ExcelReader().read(in, new SheetHandler(){

                    @Override
                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.isEmpty()) {
                            return;
                        }
                        JSONArray rowData = new JSONArray();
                        for (Map.Entry<Integer, String> entry : row.getData().entrySet()) {
                            Integer index = entry.getKey();
                            for (int i = index - rowData.size() + 1; i > 0; --i) {
                                rowData.add(null);
                            }
                            rowData.set(index.intValue(), (Object)entry.getValue());
                        }
                        jsonSheet.add((Object)rowData);
                    }
                });
                this.reader.init(jsonSheet, true);
                logger.setLastRowIndex(jsonSheet.size());
            }
            catch (KDException e) {
                url.getValue().log(Integer.valueOf(0), e.getMessage());
                log.error((Throwable)e);
                continue;
            }
            catch (Exception e) {
                url.getValue().log(Integer.valueOf(0), ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataTask_13", (String)BOS_IMPORT, (Object[])new Object[0]));
                log.error((Throwable)e);
                continue;
            }
            this.feedbackProgress(2);
            ArrayList<int[]> delRows = new ArrayList<int[]>();
            LinkedHashMap<String, JSONObject> cachedata = new LinkedHashMap<String, JSONObject>();
            int lastRow = jsonSheet.size() - 1;
            int batchSize = Math.max(500, lastRow / 30);
            batchSize = Math.min(3000, batchSize);
            int j = 3;
            while (j <= lastRow) {
                int endNext = this.reader.getNextBeginRow(jsonSheet, j, lastRow);
                try {
                    JSONObject subRow = new JSONObject();
                    int offset = this.reader.read(jsonSheet, j, endNext, subRow);
                    if (offset > 0) {
                        cachedata.put(j + "#" + endNext, subRow);
                        url.getValue().tick();
                    } else if (offset < 0) {
                        url.getValue().log(Integer.valueOf(j + 1), ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\u3002", (String)"ImportDataTask_15", (String)BOS_IMPORT, (Object[])new Object[0]));
                        url.getValue().fail().tick();
                    }
                }
                catch (KDException bize) {
                    url.getValue().log(Integer.valueOf(j + 1), bize.getMessage()).fail().tick();
                    log.error((Throwable)bize);
                }
                catch (Throwable e) {
                    url.getValue().log(Integer.valueOf(j + 1), ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_8", (String)BOS_IMPORT, (Object[])new Object[0])).fail().tick();
                    log.error(e);
                }
                j = endNext;
                if (cachedata.size() == batchSize || j >= lastRow) {
                    if (dataHandler != null) {
                        this.batchHandleForEach(dataHandler, cachedata, url, delRows);
                    } else {
                        this.batchHandleAll(cachedata, url, delRows);
                    }
                    log.error("-----------------------\u5f53\u524d\u5bfc\u51fa\u884c\uff1aj=" + j);
                    cachedata.clear();
                }
                logger.setRowIndex(j);
                tempProgress = (j - 2) * 100 / (lastRow - 2);
                int progress = Math.max(2, (batchProgress + tempProgress) / urls.size());
                progress = Math.min(99, progress);
                logger.setDelRows(delRows);
                this.feedbackProgress(progress, logger, null);
            }
            batchProgress += tempProgress;
        }
    }

    private void batchHandleForEach(BiFunction<JSONObject, JSONObject, List<ImportLogger.ImportLog>> dataHandler, Map<String, JSONObject> cachedata, Map.Entry<String, ImportLogger> url, List<int[]> delRows) {
        int currSeq = 0;
        for (Map.Entry<String, JSONObject> row : cachedata.entrySet()) {
            try {
                String[] index = row.getKey().split("#");
                currSeq = Integer.parseInt(index[0]);
                List<ImportLogger.ImportLog> errorInfo = dataHandler.apply(row.getValue(), this.option);
                if (errorInfo != null && !errorInfo.isEmpty()) {
                    url.getValue().logAll(Integer.valueOf(currSeq + 1), errorInfo).fail();
                    continue;
                }
                delRows.add(new int[]{currSeq, Integer.parseInt(index[1])});
            }
            catch (KDException bize) {
                url.getValue().log(Integer.valueOf(currSeq + 1), bize.getMessage()).fail();
                log.error((Throwable)bize);
            }
            catch (Throwable e) {
                url.getValue().log(Integer.valueOf(currSeq + 1), ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_9", (String)BOS_IMPORT, (Object[])new Object[0])).fail();
                log.error(e);
            }
        }
    }

    private void batchHandleAll(Map<String, JSONObject> cachedata, Map.Entry<String, ImportLogger> url, List<int[]> delRows) {
        HashMap<Integer, Tuple> dIndexMap = new HashMap<Integer, Tuple>();
        ArrayList<JSONObject> bills = new ArrayList<JSONObject>();
        int firstRow = 0;
        for (Map.Entry<String, JSONObject> bill : cachedata.entrySet()) {
            String[] index = bill.getKey().split("#");
            int beginSeq = Integer.parseInt(index[0]);
            int endSeq = Integer.parseInt(index[1]);
            if (firstRow == 0) {
                firstRow = beginSeq;
            }
            ArrayList<ImportLogger.ImportLog> logs = new ArrayList<ImportLogger.ImportLog>();
            boolean completeImport = false;
            boolean pluginBreak = false;
            pluginBreak = this.fireBeforeImportEvent(bill.getValue(), logs);
            if (!pluginBreak) {
                completeImport = this.fireImportEvent(bill.getValue(), logs);
            }
            if (!pluginBreak && !completeImport) {
                bills.add(bill.getValue());
                dIndexMap.put(bills.size() - 1, new Tuple((Object)beginSeq, (Object)endSeq));
                continue;
            }
            if (!logs.isEmpty()) {
                url.getValue().logAll(Integer.valueOf(beginSeq + 1), logs).fail();
                continue;
            }
            if (!completeImport) continue;
            delRows.add(new int[]{beginSeq, endSeq});
        }
        if (!bills.isEmpty()) {
            int beginSeq;
            String[] index;
            JSONObject dataPack = new JSONObject();
            dataPack.put("datas", bills);
            dataPack.put("option", (Object)this.option);
            ApiResult apiResult = null;
            try {
                AbstractOperateWebApi webApi = this.getSaveWebApi();
                webApi.initialize(this.billFormId, (Map)dataPack);
                apiResult = webApi.execute();
            }
            catch (KDException kdexp) {
                for (String range : cachedata.keySet()) {
                    index = range.split("#");
                    beginSeq = Integer.parseInt(index[0]);
                    url.getValue().log(Integer.valueOf(beginSeq + 1), kdexp.getMessage());
                }
                url.getValue().setFailed(url.getValue().getFailed() + bills.size());
                log.error((Throwable)kdexp);
            }
            catch (Throwable exp) {
                for (String range : cachedata.keySet()) {
                    index = range.split("#");
                    beginSeq = Integer.parseInt(index[0]);
                    url.getValue().log(Integer.valueOf(beginSeq + 1), ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_9", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                url.getValue().setFailed(url.getValue().getFailed() + bills.size());
                log.error(exp);
            }
            if (apiResult == null) {
                return;
            }
            List billResults = (List)apiResult.getData();
            for (int i = 0; i < billResults.size(); ++i) {
                Map billResult = (Map)billResults.get(i);
                if (((Boolean)billResult.get("success")).booleanValue()) {
                    ArrayList<Object> successIds = new ArrayList<Object>();
                    successIds.add(billResult.get("id"));
                    ArrayList<ImportLogger.ImportLog> logs = new ArrayList<ImportLogger.ImportLog>();
                    this.fireAfterImportEvent(successIds, logs);
                    if (logs.isEmpty()) {
                        delRows.add(new int[]{(Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item1, (Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item2});
                        continue;
                    }
                    url.getValue().logAll(Integer.valueOf((Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item1 + 1), logs).fail();
                    continue;
                }
                String msg = (String)billResult.get("message");
                if (StringUtils.isBlank((CharSequence)msg)) {
                    Object errData;
                    Object objData = billResult.get("data");
                    if (objData instanceof Map) {
                        List errList;
                        errData = (Map)objData;
                        if (errData != null && ((Boolean)errData.get("success")).booleanValue() && (errList = (List)errData.get("AllErrorOrValidateInfo")) != null && !errList.isEmpty()) {
                            StringBuilder stb = new StringBuilder();
                            for (Map errinfo : errList) {
                                stb.append(errinfo.get("message")).append("\r\n");
                            }
                            msg = stb.toString();
                        }
                    } else if (objData instanceof List) {
                        errData = (List)objData;
                        if (!errData.isEmpty()) {
                            StringBuilder stb = new StringBuilder();
                            Iterator iterator = errData.iterator();
                            while (iterator.hasNext()) {
                                OperateErrorInfo errinfo = (OperateErrorInfo)iterator.next();
                                stb.append(errinfo.getMessage()).append("\r\n");
                            }
                            msg = stb.toString();
                        }
                    } else {
                        msg = ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ImportDataTask_14", (String)BOS_IMPORT, (Object[])new Object[0]);
                    }
                }
                Integer dindex = (Integer)billResult.get("dindex");
                url.getValue().log(Integer.valueOf((Integer)((Tuple)dIndexMap.get((Object)dindex)).item1 + 1), msg).fail();
            }
        }
    }

    private void feedbackProgress(int progress, ImportLogger logger, String errMsg) {
        if (progress >= 100) {
            super.feedbackProgress(progress);
        }
        String cacheKey = "import-" + this.taskId;
        Map<String, Integer> map = new HashMap<String, Integer>();
        if (logger == null && (map = (Map)AppCache.get((String)"bos").get(cacheKey, Map.class)) == null) {
            map = new HashMap();
        }
        map.put("progress", progress);
        if (logger != null) {
            map.put("rowindex", logger.getRowIndex());
            map.put("lastrowindex", logger.getLastRowIndex());
            map.put("total", logger.getTotal());
            map.put("succeed", logger.getDelRows().size());
            map.put("failed", logger.getFailed());
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            map.put("err", (Integer)((Object)errMsg));
        }
        AppCache.get((String)"bos").put(cacheKey, map);
    }

    private boolean fireResolveEvent() {
        IImportServicePlugin oldPlugin;
        IImportPlugin p;
        boolean complete = false;
        Iterator<IImportPlugin> iterator = this.importPlugins.iterator();
        while (iterator.hasNext() && !(complete = (p = iterator.next()) instanceof IImportServicePlugin ? (oldPlugin = (IImportServicePlugin)p).resolve(new ArrayList<String>(this.urlLoggers.keySet()), (data, option) -> {
            String errorMsg = oldPlugin.beforeImportData(data, option);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                errorMsg = oldPlugin.importData(data, option);
            }
            return errorMsg;
        }) == null : p.resolve(this.urlLoggers, (data, option) -> {
            List pkIds;
            ArrayList logs = new ArrayList();
            if (p.beforeImportData(data, option, logs) && !(pkIds = p.importData(data, option, logs)).isEmpty()) {
                p.afterImportData(pkIds, logs);
            }
            return logs;
        }))) {
        }
        return complete;
    }

    private boolean fireBeforeImportEvent(JSONObject data, List<ImportLogger.ImportLog> logs) {
        boolean pluginBreak = false;
        for (IImportPlugin p : this.importPlugins) {
            if (p instanceof IImportServicePlugin) {
                IImportServicePlugin oldPlugin = (IImportServicePlugin)p;
                pluginBreak = StringUtils.isNotBlank((CharSequence)oldPlugin.beforeImportData((Map)data, (Map)this.option));
            } else {
                boolean bl = pluginBreak = !p.beforeImportData((Map)data, (Map)this.option, logs);
            }
            if (!pluginBreak) continue;
            if (!logs.isEmpty()) break;
            logs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%s\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"ImportDataTask_12", (String)BOS_IMPORT, (Object[])new Object[0]), p.getClass().getName())));
            break;
        }
        return pluginBreak;
    }

    private boolean fireImportEvent(JSONObject data, List<ImportLogger.ImportLog> logs) {
        boolean completeImport = false;
        for (IImportPlugin p : this.importPlugins) {
            if (p instanceof IImportServicePlugin) {
                IImportServicePlugin oldPlugin = (IImportServicePlugin)p;
                completeImport = oldPlugin.importData((Map)data, (Map)this.option) != null;
                continue;
            }
            List pkIds = p.importData((Map)data, (Map)this.option, logs);
            completeImport = !pkIds.isEmpty();
            if (!completeImport) continue;
            p.afterImportData(pkIds, logs);
        }
        return completeImport;
    }

    private void fireAfterImportEvent(List<Object> successIds, List<ImportLogger.ImportLog> logs) {
        for (IImportPlugin p : this.importPlugins) {
            p.afterImportData(successIds, logs);
        }
    }
}

