/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.NumberToTextConverter;

class ImportEntityDataReader {
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private final String entityName;
    private final EntityType entityType;
    private int beginCol = -1;
    private int nextBeginCol = -1;
    private final List<ImportEntityDataReader> next = new ArrayList<ImportEntityDataReader>();
    private final Map<String, Object> adminDivision = new HashMap<String, Object>();

    public ImportEntityDataReader(EntityType entityType) {
        this.entityName = entityType.getName();
        this.entityType = entityType;
    }

    public static ImportEntityDataReader create(MainEntityType mainEntityType) {
        HashMap importTree = new HashMap(16);
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            importTree.put(entry.getKey(), new ImportEntityDataReader((EntityType)entry.getValue()));
        }
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            ImportEntityDataReader wr;
            IDataEntityType parentType = ((EntityType)entry.getValue()).getParent();
            if (parentType == null || (wr = (ImportEntityDataReader)importTree.get(parentType.getName())) == null) continue;
            wr.next.add((ImportEntityDataReader)importTree.get(entry.getKey()));
        }
        return (ImportEntityDataReader)importTree.get(mainEntityType.getName());
    }

    public void init(JSONArray jsonSheet, boolean isFirst) {
        JSONArray entityRow = (JSONArray)jsonSheet.get(0);
        for (int i = 0; i < entityRow.size(); ++i) {
            String strValue;
            Object cellValue = entityRow.get(i);
            String string = strValue = cellValue instanceof String ? (String)cellValue : null;
            if (StringUtils.isNotBlank((CharSequence)strValue) && this.entityName != null && this.entityName.equalsIgnoreCase(strValue.split(" # ")[1])) {
                this.beginCol = i;
                break;
            }
            if (!isFirst) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataReader_0", (String)"bos-import", (Object[])new Object[0]));
        }
        JSONArray nameRow = (JSONArray)jsonSheet.get(2);
        this.nextBeginCol = this.getLastCellNum(jsonSheet, this.beginCol + 1, nameRow.size());
        this.next.forEach(r -> r.init(jsonSheet, false));
    }

    public int getNextBeginRow(JSONArray jsonSheet, int rowStart, int rowEnd) {
        JSONArray row;
        JSONArray nameRow = (JSONArray)jsonSheet.get(2);
        if (this.isRowEmpty(jsonSheet, nameRow, row = (JSONArray)jsonSheet.get(rowStart))) {
            return rowStart + 1;
        }
        for (int i = rowStart + 1; i <= rowEnd; ++i) {
            if (i >= jsonSheet.size()) {
                return i;
            }
            row = (JSONArray)jsonSheet.get(i);
            if (this.isRowEmpty(jsonSheet, nameRow, row)) continue;
            return i;
        }
        return jsonSheet.size();
    }

    private boolean isRowEmpty(JSONArray jsonSheet, JSONArray nameRow, JSONArray row) {
        if (row == null) {
            return true;
        }
        boolean isEmpty = true;
        for (int j = this.beginCol; j < this.nextBeginCol; ++j) {
            if (!StringUtils.isNotBlank((Object)this.getValue(row, j, true))) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public int read(JSONArray jsonSheet, int rowStart, int rowEnd, JSONObject parent) {
        String tempName;
        boolean valid = true;
        JSONArray entityRow = (JSONArray)jsonSheet.get(0);
        if (!this.next.isEmpty()) {
            for (ImportEntityDataReader r : this.next) {
                if (r.beginCol < 0) continue;
                JSONArray arr = new JSONArray();
                int i = rowStart;
                while (i < rowEnd) {
                    JSONObject subRow = new JSONObject();
                    int endNext = r.getNextBeginRow(jsonSheet, i, rowEnd);
                    int offset = r.read(jsonSheet, i, endNext, subRow);
                    Object value = this.getValue(entityRow, r.beginCol, true);
                    boolean bl = valid = valid && (offset > 0 || offset == 0 && (StringUtils.isBlank((Object)value) || !((String)value).startsWith("*")));
                    if (offset == 0) break;
                    arr.add((Object)subRow);
                    i = endNext;
                }
                if (arr.isEmpty()) continue;
                parent.put(r.entityName, (Object)arr);
            }
        }
        JSONArray nameRow = (JSONArray)jsonSheet.get(2);
        int rowColCount = 0;
        JSONArray row = (JSONArray)jsonSheet.get(rowStart);
        HashSet<String> flexColumn = new HashSet<String>();
        for (int i = this.beginCol; i < this.nextBeginCol && row != null && !StringUtils.isBlank((CharSequence)(tempName = (String)this.getValue(nameRow, i, false))); ++i) {
            if (flexColumn.contains(tempName.split(" # ")[1].split("\\.")[0])) continue;
            Object value = this.getValue(nameRow, row, i, this.nextBeginCol, flexColumn);
            if (StringUtils.isBlank((Object)value)) {
                if (!valid || !tempName.startsWith("*")) continue;
                valid = false;
                continue;
            }
            parent.put(tempName.split(" # ")[1].split("\\.")[0], value);
            ++rowColCount;
        }
        return !valid && rowColCount > 0 ? -rowColCount : rowColCount;
    }

    private int getLastCellNum(JSONArray jsonSheet, int col, int last) {
        while (col < last) {
            if (StringUtils.isNotBlank((Object)this.getValue((JSONArray)jsonSheet.get(0), col, true))) {
                return col;
            }
            ++col;
        }
        return last;
    }

    private Object getValue(JSONArray row, int column, boolean trim) {
        return this.getValue(row, column, null, trim);
    }

    private Object getValue(JSONArray row, int column, DynamicProperty prop, boolean trim) {
        Object cellValue;
        Object object = cellValue = column >= row.size() ? null : row.get(column);
        if (cellValue == null) {
            return null;
        }
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (cellValue instanceof String) {
            Pattern pattern;
            String val = (String)cellValue;
            if (val != null && trim) {
                val = val.trim();
            }
            cellValue = prop instanceof BooleanProp ? Boolean.valueOf(ResManager.loadKDString((String)"\u662f", (String)"ImportEntityDataReader_1", (String)BOS_FORM_MVC, (Object[])new Object[0]).equals(val) || !ResManager.loadKDString((String)"\u5426", (String)"ImportEntityDataReader_2", (String)BOS_FORM_MVC, (Object[])new Object[0]).equals(val) && Boolean.parseBoolean(val)) : (prop instanceof ComboProp && val != null && val.indexOf(" # ") != -1 ? val.split(" # ", -1)[1] : ((prop instanceof DateProp || prop instanceof DateTimeProp) && StringUtils.isNotBlank((Object)cellValue) ? ((pattern = Pattern.compile("^[-\\+]?[.\\d]*$")).matcher(String.valueOf(cellValue)).matches() ? sFormat.format(DateUtil.getJavaDate((double)Double.parseDouble(val))) : val) : val));
        } else if (cellValue instanceof Double) {
            if (prop instanceof DateProp || prop instanceof DateTimeProp) {
                Date dt = DateUtil.getJavaDate((double)((Double)cellValue));
                cellValue = sFormat.format(dt);
            } else if (!(prop instanceof DecimalProp)) {
                cellValue = this.trimZero(NumberToTextConverter.toText((double)((Double)cellValue)));
            }
        }
        return cellValue;
    }

    private String trimZero(String valStr) {
        if (StringUtils.isNotBlank((CharSequence)valStr)) {
            StringBuilder sb = new StringBuilder(valStr);
            int i = sb.indexOf(".");
            if (i >= 0) {
                for (int j = sb.length() - 1; j > i; --j) {
                    if (sb.charAt(j) == '0') continue;
                    sb.setLength(j + 1);
                    return sb.toString();
                }
                valStr = sb.substring(0, i);
            }
        }
        return valStr;
    }

    private Object getValue(JSONArray nameRow, JSONArray row, int column, int lastColumn, Set<String> flexColumn) {
        Object cellValue = null;
        String fullName = (String)this.getValue(nameRow, column, false);
        if (StringUtils.isNotBlank((CharSequence)fullName) && fullName.contains(" # ")) {
            String propertyName = fullName.split(" # ")[1];
            String[] propertyNameSplit = propertyName.split("\\.");
            DynamicProperty prop = this.entityType.getProperty(propertyNameSplit[0]);
            if (prop instanceof FlexProp && !flexColumn.contains(propertyNameSplit[0])) {
                cellValue = this.getFlexValue(nameRow, row, column, lastColumn, flexColumn, prop, propertyNameSplit);
            } else {
                cellValue = this.getValue(row, column, prop, true);
                if (StringUtils.isNotBlank((Object)cellValue)) {
                    if (prop instanceof AdminDivisionProp) {
                        cellValue = this.getAdminDivisionValue(cellValue.toString());
                    } else {
                        List items;
                        if (prop instanceof BasedataProp) {
                            JSONObject jsonData = new JSONObject();
                            jsonData.put(propertyNameSplit.length > 1 && "name".equalsIgnoreCase(propertyNameSplit[1]) ? "name" : "number", cellValue);
                            return jsonData;
                        }
                        if (prop instanceof ComboProp && (items = ((ComboProp)prop).getComboItems()) != null && !items.isEmpty()) {
                            List<String> cellValueSplit = Arrays.asList(cellValue.toString().split(","));
                            ArrayList<String> values = new ArrayList<String>();
                            for (ValueMapItem item : items) {
                                if (!(prop instanceof MulComboProp ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(cellValue))) continue;
                                values.add(item.getValue());
                            }
                            cellValue = String.join((CharSequence)",", values);
                        }
                    }
                }
            }
        }
        return cellValue;
    }

    private Object getFlexValue(JSONArray nameRow, JSONArray row, int column, int lastColumn, Set<String> flexColumn, DynamicProperty prop, String[] propertyNameSplit) {
        String tempName;
        flexColumn.add(propertyNameSplit[0]);
        HashMap flexVal = new HashMap();
        for (int i = column; i < lastColumn && !StringUtils.isBlank((CharSequence)(tempName = (String)this.getValue(nameRow, i, false))); ++i) {
            String[] tempPropertyNameSplit = tempName.split(" # ")[1].split("\\.");
            if (!propertyNameSplit[0].equals(tempPropertyNameSplit[0])) continue;
            String propertyCaption = tempName.split(" # ")[0];
            Object v = this.getValue(row, i, true);
            if (!StringUtils.isNotBlank((Object)v)) continue;
            HashMap<String, String> flexItem = new HashMap<String, String>();
            flexItem.put(tempPropertyNameSplit[1], v.toString());
            flexVal.put(propertyCaption.split("\\.")[1], flexItem);
        }
        if (flexVal.isEmpty()) {
            return null;
        }
        return flexVal;
    }

    private Object getAdminDivisionValue(String cellValue) {
        if (this.adminDivision.containsKey(cellValue)) {
            return this.adminDivision.get(cellValue);
        }
        Object adminId = ORMUtil.getAdminDivisionByName((String)cellValue.replace('/', '_'));
        if (StringUtils.isNotBlank((Object)adminId)) {
            this.adminDivision.put(cellValue, adminId);
            return adminId;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u201c%s\u201d\u4e0d\u5b58\u5728", (String)"ImportEntityDataReader_3", (String)"bos-import", (Object[])new Object[0]), cellValue));
    }
}

