/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment.extend.importdata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileImportEncodeTestPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(FileImportEncodeTestPlugin.class);
    private static final int SECRETKEY = 611;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar encodefile = (Toolbar)this.getControl("toolbarap");
        encodefile.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        String url = (String)urls[0];
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream sourceIn = tempFileCache.getInputStream(url);
        InputStream targeIn = null;
        try {
            targeIn = FileImportEncodeTestPlugin.XORCode(sourceIn);
        }
        catch (Exception e) {
            log.error("decode error is " + e);
            this.getView().showErrorNotification("decode error is " + e);
            return;
        }
        String tempFileUrl = tempFileCache.saveAsFullUrl("encodeFile.xlsx", targeIn, 7200);
        this.getView().download(tempFileUrl);
        this.getView().showSuccessNotification("success");
    }

    private static InputStream XORCode(InputStream in) throws Exception {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read()) != -1) {
            out.write(len ^ 0x263);
        }
        ByteArrayInputStream resultIn = new ByteArrayInputStream(out.toByteArray());
        in.close();
        out.close();
        return resultIn;
    }
}

