/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment.extend.importdata;

import java.io.InputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.IFileImportExtension;
import kd.bos.session.SystemPropertyUtils;

public class FileImportExtensionFactory {
    private static final Log logger = LogFactory.getLog(FileImportExtensionFactory.class);
    private static final String CLASSNAME_KEY = "file.import.ext.impl.classname";

    public static IFileImportExtension getFileImportExtension() {
        String className = SystemPropertyUtils.getProptyByTenant((String)CLASSNAME_KEY, (String)RequestContext.get().getTenantId());
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                return (IFileImportExtension)Class.forName(className).newInstance();
            }
            catch (Exception var2) {
                logger.error("init class " + className + " error:", (Throwable)var2);
            }
        }
        return FileImportExtensionFactory.getDefaultFileImportExtension();
    }

    public static IFileImportExtension getDefaultFileImportExtension() {
        return new DefaultFileImportExtension();
    }

    static class DefaultFileImportExtension
    implements IFileImportExtension {
        DefaultFileImportExtension() {
        }

        @Override
        public InputStream decode(String path, InputStream sourceIn) {
            return sourceIn;
        }
    }
}

