/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment.extend.importdata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.IFileImportExtension;
import org.apache.commons.io.FileUtils;

public class FileImportExtensionImpl
implements IFileImportExtension {
    private static final Log log = LogFactory.getLog(FileImportExtensionImpl.class);
    private static final int SECRETKEY = 611;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream decode(String path, InputStream sourceIn) {
        File tempFile = null;
        try {
            tempFile = this.writeToTempFile(sourceIn);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            InputStream inputStream = FileImportExtensionImpl.XORCode(fileInputStream);
            return inputStream;
        }
        catch (Exception e) {
            log.error("decode error is \uff1a " + e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return sourceIn;
    }

    private File writeToTempFile(InputStream sourceInputStream) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            FileUtils.copyInputStreamToFile((InputStream)sourceInputStream, (File)tempFile);
        }
        catch (IOException e) {
            log.error("excelSecurityVerification writeToTempFile error is " + e);
        }
        return tempFile;
    }

    private static InputStream XORCode(InputStream in) throws Exception {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read()) != -1) {
            out.write(len ^ 0x263);
        }
        ByteArrayInputStream resultIn = new ByteArrayInputStream(out.toByteArray());
        in.close();
        out.close();
        return resultIn;
    }
}

