/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.export.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.attachment.FileTypeEnum;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.export.po.ExportFileInfo;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.io.FilenameUtils;

public class ExportZipMaker {
    private static final String BOS_EXPORT = "bos-export";
    private static Log log = LogFactory.getLog(ExportZipMaker.class);

    public static String createZipForMainEntityType(ExcelWriter exporter, MainEntityType mainEntityType, List<ExportFileInfo> fileList, String fileName) {
        String urlResult;
        BatchDownloadRequest attachReq = new BatchDownloadRequest(fileName + ".zip");
        BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            ExportFileInfo exportFileInfo = fileList.get(i);
            files[i] = new BatchDownloadRequest.File(fileName + "_" + (i + 1) + ".xlsx", exportFileInfo.getUrl());
        }
        attachReq.setFiles(files);
        OutputStream fos = null;
        InputStream fin = null;
        File temp = null;
        try {
            temp = File.createTempFile("exportTempFile" + System.currentTimeMillis(), ".zip");
            fos = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
            FileService service = FileServiceFactory.getAttachmentFileService();
            service.batchDownload(attachReq, fos, null);
            fin = Files.newInputStream(temp.toPath(), new OpenOption[0]);
            urlResult = exporter.upload(mainEntityType, fileName + ".zip", fin);
        }
        catch (IOException e) {
            try {
                throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u751f\u6210\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"ExportDataTask_7", (String)BOS_EXPORT, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fos);
                FileSecurityUtil.safeClose(fin);
                FileSecurityUtil.safeDeleteFile(temp);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)fos);
        FileSecurityUtil.safeClose((Closeable)fin);
        FileSecurityUtil.safeDeleteFile((File)temp);
        return urlResult;
    }

    @Deprecated
    public static String createZip(ExcelWriter exporter, BillEntityType mainEntityType, List<ExportFileInfo> fileList, String fileName) {
        return ExportZipMaker.createZipForMainEntityType(exporter, (MainEntityType)mainEntityType, fileList, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String batchDownloadPictureOrAtt(FileTypeEnum fileTypeEnum, BidiMap<String, String> exportMessageMap, String entityName, File saveDir, String zipFileName) {
        FileService service;
        if (fileTypeEnum == FileTypeEnum.IMAGE) {
            service = FileServiceFactory.getImageFileService();
            zipFileName = ExportZipMaker.genPictureZipFileName(entityName);
        } else {
            service = FileServiceFactory.getAttachmentFileService();
        }
        BatchDownloadRequest request = new BatchDownloadRequest(zipFileName);
        Set urls = exportMessageMap.keySet();
        String[] urlsArr = urls.toArray(new String[0]);
        Set names = exportMessageMap.values();
        String[] namesArr = names.toArray(new String[0]);
        BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[urlsArr.length];
        for (int i = 0; i < urlsArr.length; ++i) {
            String url = urlsArr[i];
            String fileName = namesArr[i];
            files[i] = new BatchDownloadRequest.File(fileName, url);
        }
        request.setFiles(files);
        OutputStream fos = null;
        Path file = Paths.get(saveDir.getAbsolutePath() + File.separator, FilenameUtils.getName((String)(saveDir.getAbsolutePath() + File.separator + zipFileName)));
        try {
            Files.createFile(file, new FileAttribute[0]);
            fos = Files.newOutputStream(file, new OpenOption[0]);
            service.batchDownload(request, fos, null);
        }
        catch (IOException e) {
            try {
                log.error("[\u5bfc\u51fa\u56fe\u7247/\u9644\u4ef6]\uff1a\u751f\u6210\u672c\u5730\u538b\u7f29\u5305\u9519\u8bef" + e);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fos);
                throw throwable;
            }
            FileSecurityUtil.safeClose((Closeable)fos);
        }
        FileSecurityUtil.safeClose((Closeable)fos);
        return file.toAbsolutePath().toString();
    }

    private static String genPictureZipFileName(String entityName) {
        String dateStr = new SimpleDateFormat("MMddHHmmss").format(new Date());
        return String.format(ResManager.loadKDString((String)"%1$s_\u5bfc\u51fa\u56fe\u7247_%2$s.zip", (String)"ExportPicture_1", (String)BOS_EXPORT, (Object[])new Object[0]), entityName, dateStr);
    }

    public static String genAttZipFileName(String entityName) {
        String dateStr = new SimpleDateFormat("MMddHHmmss").format(new Date());
        return String.format(ResManager.loadKDString((String)"%1$s_\u5bfc\u51fa\u9644\u4ef6_%2$s.zip", (String)"ExportAtt_1", (String)BOS_EXPORT, (Object[])new Object[0]), entityName, dateStr);
    }
}

