/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.export.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.util.SecurityUtils;
import kd.bos.util.resource.Resources;
import org.apache.commons.io.FilenameUtils;

public class ImpExpAttachmentUtil {
    private static Log log = LogFactory.getLog(ImpExpAttachmentUtil.class);
    private static final String BOS_EXPORT = "bos-export";
    private static String ATTACHMENT_FORMAT = "/%s/%s/%s/api/attachment/%s/%s";
    private static String DEFAULT_TENANTID = "tenantapi";
    private static String DEFAULT_ACCOUNTID = "accountapi";

    public static List<AttachmentPanelAp> getAttachmentPanelAps(String formId) {
        ArrayList<AttachmentPanelAp> attachmentPanelAps = new ArrayList<AttachmentPanelAp>();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        aps.forEach(controlAp -> {
            if (controlAp instanceof AttachmentPanelAp) {
                attachmentPanelAps.add((AttachmentPanelAp)controlAp);
            }
        });
        return attachmentPanelAps;
    }

    public static void unzip(File zipFile, String unzipFilePath, boolean includeZipFileName, Charset charset) throws IOException {
        if (zipFile == null || StringUtils.isEmpty((CharSequence)unzipFilePath)) {
            throw new IllegalArgumentException(Resources.getString((String)"\u4e0d\u6b63\u786e\u7684\u538b\u7f29\u8def\u5f84\u53c2\u6570", (String)"ZipUtils_2", (String)BOS_EXPORT, (Object[])new Object[0]));
        }
        ZipFile zip = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File unzipFileDir;
            if (includeZipFileName) {
                String fileName = zipFile.getName();
                if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                }
                unzipFilePath = unzipFilePath + File.separator + fileName;
            }
            if (!(unzipFileDir = new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)unzipFilePath)), FilenameUtils.getName((String)SecurityUtils.normalize((String)unzipFilePath)))).exists() || !unzipFileDir.isDirectory()) {
                unzipFileDir.mkdirs();
            }
            ZipEntry entry = null;
            String entryFilePath = null;
            String entryDirPath = null;
            File entryFile = null;
            File entryDir = null;
            int index = 0;
            int count = 0;
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            zip = charset != null ? new ZipFile(zipFile, charset) : new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                SecurityManager securityManager;
                entry = entries.nextElement();
                entryFilePath = unzipFilePath + File.separator + entry.getName();
                index = entryFilePath.lastIndexOf(File.separator);
                entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
                entryDir = new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)entryDirPath)), FilenameUtils.getName((String)SecurityUtils.normalize((String)entryDirPath)));
                if (!entryDir.exists() || !entryDir.isDirectory()) {
                    entryDir.mkdirs();
                }
                entryFile = new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)entryFilePath)), FilenameUtils.getName((String)SecurityUtils.normalize((String)entryFilePath)));
                if (entry.isDirectory()) {
                    securityManager = new SecurityManager();
                    entryFile.delete();
                    entryFile.mkdir();
                    continue;
                }
                if (entryFile.exists()) {
                    securityManager = new SecurityManager();
                    entryFile.delete();
                }
                bos = new BufferedOutputStream(new FileOutputStream(entryFile));
                bis = new BufferedInputStream(zip.getInputStream(entry));
                while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    public static String getAttachmentRandomUrl(String fileName) {
        String tenantId = null;
        String accountId = null;
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            tenantId = rc.getTenantId();
            accountId = rc.getAccountId();
        }
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = DEFAULT_TENANTID;
        }
        if (StringUtils.isEmpty(accountId)) {
            accountId = DEFAULT_ACCOUNTID;
        }
        String monthStr = ImpExpAttachmentUtil.getMonthStr();
        return String.format(ATTACHMENT_FORMAT, tenantId, accountId, monthStr, ImpExpAttachmentUtil.createRandomId(), fileName);
    }

    private static String getMonthStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        String monthStr = sf.format(cale.getTime());
        return monthStr;
    }

    private static String createRandomId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

