/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mservice;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.form.dto.ExportPermissionParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ExportPermissionService {
    private static final Log log = LogFactory.getLog(ExportPermissionService.class);

    public boolean checkPermission(ExportPermissionParam exportPermissionParam) {
        String entityNum = exportPermissionParam.getEntityNum();
        String permItem = exportPermissionParam.getPermissionItem();
        Long curUserId = exportPermissionParam.getCurUserId();
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        Boolean checkExportPerm = securityParam.size() == 0 ? Boolean.parseBoolean(System.getProperty("check.export.permission", "false")) : Boolean.parseBoolean(String.valueOf(securityParam.get("exportpermission")));
        if (!checkExportPerm.booleanValue()) {
            return true;
        }
        log.info("curUserId : " + curUserId + " ; formId : " + entityNum + " ; permItem : " + permItem);
        if (curUserId == -1L) {
            return true;
        }
        Boolean hasPermission = Boolean.FALSE;
        Set<String> permissionCheckSet = ExportPermissionService.convertPermItem(permItem);
        Map permMap = PermissionServiceHelper.checkMultiPermItemInfos((long)curUserId, (String)entityNum, permissionCheckSet);
        log.info("checkFunctionPermission : permMap = " + permMap);
        if (((Boolean)permMap.get(permItem)).booleanValue()) {
            hasPermission = Boolean.TRUE;
        }
        log.info("hasPermission : " + hasPermission + " ; curUserId : " + curUserId);
        return hasPermission;
    }

    private static Set<String> convertPermItem(String permItem) {
        HashSet<String> permSet = new HashSet<String>();
        permSet.add(permItem);
        return permSet;
    }
}

