/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.export.po.ExportFileInfo;
import kd.bos.export.util.ExportZipMaker;
import kd.bos.form.BindingContext;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.BeforeExportEntryEvent;
import kd.bos.form.plugin.IExportEntryPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.util.ExportEntryUtil;
import kd.bos.form.util.ExportLogUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mvc.export.ListExporter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.PermissionParam;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.MapUtils;

public class ExportEntryConfigPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String LOG_ID = "logId";
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final String PROGRESS_BAR = "progressbarap";
    protected List<UploadListener> uploadListeners = new ArrayList<UploadListener>();
    private static final String PARAM_ENTRYKEY = "entrykey";
    private static final String PARAM_PAGEID = "pageid";
    private static final String PARAM_SETTING = "settingkey";
    private static final String FLEX_PROGRESS = "exportpanel";
    private static final String FLEX_OPERATEPANEL = "operatepanel";
    private static final String LABEL_ROWCOUNT = "rowcount";
    private static final String LABEL_PROGRESS_TOTAL = "total";
    private static final String LABEL_PROGRESS_EXPORTED = "complete";
    private static final String CACHE_TOTAL = "total";
    private static final String CACHE_EXPORTED = "exported";
    private static final String CACHE_URL = "url";
    private static final String ERRMSG = "errmsg";
    private static final String DATA_ROWS = "rows";
    private static final String DATA_INDEX = "dataindex";
    private static final String COMFIRMED = "Comfirmed";
    private static final String CLOSE_CONFIRM = "CLOSE_CONFIRM";
    private static final String BOS_EXPORT = "bos-export";
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ExportEntryThreadPool", (int)3);
    public static final String PLUGINS = "plugins";
    private DynamicObject exportLogObj;
    private NumberFormatProvider numberFormatProvider = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView currView = this.getView();
        FormShowParameter showParameter = currView.getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam(PARAM_ENTRYKEY);
        String pageid = (String)showParameter.getCustomParam(PARAM_PAGEID);
        String password = (String)showParameter.getCustomParam("password");
        if (StringUtils.isEmpty((CharSequence)entryKey) || StringUtils.isEmpty((CharSequence)pageid)) {
            return;
        }
        IFormView view = currView.getView(pageid);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.start();
        this.setTotal(view, entryKey);
        this.startExport(currView, password);
    }

    private IExportEntryPlugin getPlugin(String pluginsStr) {
        List plugins = JSONObject.parseArray((String)pluginsStr, Plugin.class);
        IExportEntryPlugin exportEntryPlugin = null;
        if (plugins == null) {
            return null;
        }
        String curPlugin = "";
        try {
            for (Plugin plugin : plugins) {
                if (!plugin.isEnabled()) continue;
                curPlugin = plugin.getClassName();
                exportEntryPlugin = (IExportEntryPlugin)TypesContainer.createInstance((String)plugin.getClassName());
                break;
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5bfc\u51fa\u63d2\u4ef6%s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u3002", (String)"ExportEntry_2", (String)BOS_EXPORT, (Object[])new Object[0]), curPlugin));
        }
        return exportEntryPlugin;
    }

    private void setTotal(IFormView view, String entryKey) {
        String total = String.valueOf(this.getTotal(view, entryKey));
        Label progressTotal = (Label)this.getControl("total");
        progressTotal.setText(total);
        this.getPageCache().put("total", total);
        this.getPageCache().put(CACHE_EXPORTED, "0");
        this.getPageCache().saveChanges();
    }

    private int getTotal(IFormView view, String entryKey) {
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        int row = view.getModel().getEntryRowCount(entryKey);
        if (grid.getEntryState().getSelectedRows().length > 0) {
            row = grid.getEntryState().getSelectedRows().length;
        }
        return row;
    }

    public void onProgress(ProgressEvent evt) {
        String errMsg = this.getPageCache().get(ERRMSG);
        if (errMsg != null) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExportDataProgressFormPlugin_14", (String)BOS_EXPORT, (Object[])new Object[0]);
            ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
            progressbar.stop();
            evt.setProgress(100);
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            IFormView parentView = this.getView().getParentView();
            parentView.showErrorNotification(msg);
            this.getView().sendFormAction(parentView);
            this.getView().close();
            return;
        }
        int total = Integer.parseInt(this.getPageCache().get("total"));
        int exported = Integer.parseInt(this.getPageCache().get(CACHE_EXPORTED));
        Label totalexport = (Label)this.getControl(LABEL_PROGRESS_EXPORTED);
        totalexport.setText(String.valueOf(exported));
        evt.setProgress((int)Math.min(99.0, (double)exported / (double)total * 100.0));
        String url = this.getPageCache().get(CACHE_URL);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            this.getView().download(url);
            this.getView().sendFormAction(this.getView());
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!COMFIRMED.equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, "Comfirming");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5bfc\u51fa\u6570\u636e\uff0c\u5173\u95ed\u5c06\u7ec8\u6b62\u5bfc\u51fa\u6570\u636e\uff0c\u60a8\u786e\u8ba4\u5173\u95ed\u5417\uff1f", (String)"ExportEntryConfigPlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.close();
        }
    }

    private void close() {
        if (!"Comfirming".equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ExportDataProgressFormPlugin_9", (String)BOS_EXPORT, (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    private void startExport(IFormView currView, final String password) {
        FormShowParameter showParameter = currView.getFormShowParameter();
        final String entryKey = (String)showParameter.getCustomParam(PARAM_ENTRYKEY);
        String pageid = (String)showParameter.getCustomParam(PARAM_PAGEID);
        String settingkey = (String)showParameter.getCustomParam(PARAM_SETTING);
        final String permId = (String)showParameter.getCustomParam("PermissionItemId_entry");
        try {
            final IFormView view = currView.getView(pageid);
            String pluginsStr = view.getPageCache().get(PLUGINS);
            final IExportEntryPlugin exportEntryPlugin = this.getPlugin(pluginsStr);
            String json = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)settingkey);
            JSONObject settings = JSON.parseObject((String)json).getJSONObject(entryKey);
            JSONArray visibleFields = settings.getJSONArray("cs");
            final List fieldNames = visibleFields.toJavaList(String.class);
            fieldNames.remove("seq");
            JSONArray cwgJsonArray = settings.getJSONArray("cwg");
            fieldNames.removeIf(field -> this.isOperationColumn(view, (String)field));
            MainEntityType dataEntityType = view.getModel().getDataEntityType();
            Map allEntities = dataEntityType.getAllEntities();
            EntityType entityType = (EntityType)allEntities.get(entryKey);
            final List<KeyValue> captions = this.prepareCaptions(cwgJsonArray, fieldNames, entityType == null ? null : entityType.getFields());
            final EntryGrid grid = (EntryGrid)view.getControl(entryKey);
            final int[] selectRows = grid.getSelectRows();
            final int total = this.getTotal(view, entryKey);
            if (total > 10000000) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u884c\u6570\u9650\u5236\uff1a%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_8", (String)BOS_EXPORT, (Object[])new Object[0]), 10000000));
            }
            String caption = view.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            final String entityNumber = view.getFormShowParameter().getFormConfig().getEntityTypeId();
            this.exportLogObj = ExportLogUtil.buildExportLogObj(caption, "4", entityNumber);
            this.getPageCache().put(LOG_ID, this.exportLogObj.getPkValue().toString());
            this.exportLogObj.set("total", (Object)total);
            final RequestContext requestContext = RequestContext.get();
            threadPool.submit(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() {
                    RequestContext.copyAndSet((RequestContext)requestContext);
                    ListExporter exporter = null;
                    try {
                        String attachId;
                        String url;
                        int pageRows;
                        exporter = new ListExporter(ExportEntryConfigPlugin.this.getEntryName(entryKey, view.getModel()), captions, true);
                        boolean isSplitEntry = ExportEntryConfigPlugin.this.isSplit(view, entryKey);
                        int n = pageRows = ExportFileInfo.maxFileRowSize >= 50000 ? 50000 : ExportFileInfo.maxFileRowSize;
                        if (isSplitEntry) {
                            pageRows = grid.getModel().getEntryPageSize();
                        }
                        int[] excelRowIndexs = new int[]{exporter.getRowCount() + 1};
                        int[] progress = new int[]{0, total};
                        int fileCount = ExportFileInfo.getFileCount(total);
                        ArrayList<ExportFileInfo> fileList = new ArrayList<ExportFileInfo>(fileCount);
                        for (int i = 0; i < fileCount; ++i) {
                            int batchSize = i == fileCount - 1 ? total - i * ExportFileInfo.maxFileRowSize : ExportFileInfo.maxFileRowSize;
                            fileList.add(ExportEntryConfigPlugin.this.createExportFileInfo(batchSize));
                        }
                        int startIndex = 0;
                        if (grid.getSelectRows().length > 0) {
                            startIndex = (grid.getEntryState().getCurrentPageIndex() - 1) * grid.getPageRow();
                        }
                        int curPage = 1;
                        int selectRowsStartIndex = 0;
                        int selectRowsEndIndex = 0;
                        for (ExportFileInfo fileInfo : fileList) {
                            int pages = fileInfo.getBatchSize() / pageRows + (fileInfo.getBatchSize() % pageRows == 0 ? 0 : 1);
                            for (int i = 1; i <= pages; ++i) {
                                EntryData entrydata;
                                int endIndex;
                                if (i == pages) {
                                    if (selectRows.length > 0) {
                                        selectRowsEndIndex = selectRowsStartIndex + (fileInfo.getBatchSize() - (i - 1) * pageRows);
                                        endIndex = selectRows[selectRowsEndIndex - 1] + 1;
                                    } else {
                                        endIndex = startIndex + (fileInfo.getBatchSize() - (i - 1) * pageRows);
                                    }
                                } else if (selectRows.length > 0) {
                                    selectRowsEndIndex = selectRowsStartIndex + pageRows;
                                    endIndex = selectRows[selectRowsEndIndex - 1];
                                } else {
                                    endIndex = startIndex + pageRows;
                                }
                                if (ExportEntryConfigPlugin.this.isSplit(view, entryKey)) {
                                    DynamicObjectCollection coll = view.getModel().getEntryEntity(entryKey);
                                    coll.fetchEntryRows(startIndex, view.getModel().getEntryPageSize());
                                    ArrayList<List> rows = new ArrayList<List>(10);
                                    for (int j = 0; j < coll.size(); ++j) {
                                        BindingContext bindCtx = new BindingContext((IDataEntityType)coll.getDynamicObjectType(), (DynamicObject)coll.get(j), startIndex + i, null);
                                        List rowBindValue = grid.getRowBindValue(bindCtx);
                                        rows.add(rowBindValue);
                                    }
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    data.put(ExportEntryConfigPlugin.DATA_ROWS, rows);
                                    data.put("pagerows", pageRows);
                                    data.put(ExportEntryConfigPlugin.DATA_INDEX, grid.getDataIndex());
                                    Map fmtInfo = ExportEntryConfigPlugin.this.getFmtInfo((DynamicObject[])coll.toArray((Object[])new DynamicObject[0]), startIndex, view, grid, entryKey);
                                    entrydata = new EntryData(entryKey, startIndex, endIndex, pageRows, (DynamicObject[])coll.toArray((Object[])new DynamicObject[0]), data, fmtInfo);
                                } else {
                                    entrydata = grid.getEntryData(fileInfo.getBatchSize(), startIndex, endIndex, curPage, pageRows, i, Boolean.TRUE);
                                }
                                int[] subSelectRows = this.splitSelectRows(selectRows, selectRowsStartIndex, selectRowsEndIndex);
                                ExportEntryConfigPlugin.this.exportEntry(view, grid, exporter, entrydata, fieldNames, excelRowIndexs, progress, subSelectRows, exportEntryPlugin);
                                startIndex = endIndex;
                                selectRowsStartIndex = selectRowsEndIndex;
                                ++curPage;
                            }
                            LocalDate now = LocalDate.now();
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMdd");
                            String formattedStr = now.format(formatter);
                            String entryName = ExportEntryConfigPlugin.this.getEntryName(entryKey, view.getModel());
                            String url2 = StringUtils.isBlank((CharSequence)entryName) ? exporter.flush(view.getModel().getDataEntityType(), String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5206\u5f55\u6570\u636e_%s", (String)"ExportEntryConfigPlugin_1", (String)ExportEntryConfigPlugin.BOS_EXPORT, (Object[])new Object[0]), formattedStr), exportEntryPlugin) : exporter.flush(view.getModel().getDataEntityType(), entryName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth()), exportEntryPlugin);
                            fileInfo.setUrl(url2);
                            exporter = new ListExporter(ExportEntryConfigPlugin.this.getEntryName(entryKey, view.getModel()), captions, true);
                        }
                        if (fileList.isEmpty()) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportList_0", (String)"bos-form-business", (Object[])new Object[0]));
                            Iterator iterator = null;
                            return iterator;
                        }
                        if (fileList.size() > 1) {
                            LocalDate now = LocalDate.now();
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMdd");
                            String formattedStr = now.format(formatter);
                            String fielName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5206\u5f55\u6570\u636e_%s", (String)"ExportEntryConfigPlugin_1", (String)ExportEntryConfigPlugin.BOS_EXPORT, (Object[])new Object[0]), formattedStr);
                            url = ExportZipMaker.createZipForMainEntityType(exporter, ExportEntryConfigPlugin.this.getView().getParentView().getModel().getDataEntityType(), fileList, fielName);
                        } else {
                            url = ((ExportFileInfo)fileList.get(0)).getUrl();
                        }
                        boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
                        String logPkId = ExportEntryConfigPlugin.this.getPageCache().get(ExportEntryConfigPlugin.LOG_ID);
                        String appId = view.getFormShowParameter().getAppId();
                        if (checkFilePermission) {
                            String logEntityNum = "bos_exportlog";
                            String fileType = "";
                            attachId = PermissionParam.genAttacId((String)appId, (String)entityNumber, (String)logEntityNum, (Object)logPkId, (String)fileType, (String)permId);
                        } else {
                            attachId = logPkId + "@bos_exportlog";
                            attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
                        }
                        url = UrlService.getAttachmentFullUrl((String)url);
                        String downloadUrl = UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=";
                        downloadUrl = downloadUrl + attachId + "&fId=" + entityNumber + "&appId=" + appId;
                        if (StringUtils.isNotEmpty((CharSequence)password)) {
                            downloadUrl = downloadUrl + "&password=" + password;
                        }
                        if (view.getModel().getDataEntityType() instanceof BillEntityType) {
                            BillEntityType dataEntityType = (BillEntityType)view.getModel().getDataEntityType();
                            DynamicObject dataEntity = view.getModel().getDataEntity();
                            if (dataEntity.containsProperty(dataEntityType.getBillNo())) {
                                downloadUrl = downloadUrl + "&billNo=" + dataEntity.get(dataEntityType.getBillNo());
                            }
                        }
                        ExportEntryConfigPlugin.this.exportLogObj.set("downloadurl", (Object)url);
                        ExportLogUtil.saveExportLog(ExportEntryConfigPlugin.this.exportLogObj);
                        ExportEntryConfigPlugin.this.getPageCache().put(ExportEntryConfigPlugin.CACHE_URL, downloadUrl);
                        ExportEntryConfigPlugin.this.getPageCache().saveChanges();
                        Object var19_26 = null;
                        return var19_26;
                    }
                    catch (Exception e) {
                        ExportEntryConfigPlugin.this.log.error((Throwable)e);
                        ExportEntryConfigPlugin.this.getPageCache().put(ExportEntryConfigPlugin.ERRMSG, e.toString());
                        ExportEntryConfigPlugin.this.getPageCache().saveChanges();
                    }
                    finally {
                        if (exporter != null) {
                            exporter.dispose();
                        }
                    }
                    return null;
                }

                private int[] splitSelectRows(int[] selectRows2, int startIndex, int endIndex) {
                    if (selectRows2.length == 0) {
                        return selectRows2;
                    }
                    int[] subSelectRows = new int[endIndex - startIndex];
                    int index = 0;
                    for (int i = 0; i < selectRows2.length; ++i) {
                        if (i < startIndex || i >= endIndex) continue;
                        subSelectRows[index] = selectRows2[i];
                        ++index;
                    }
                    return subSelectRows;
                }
            });
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            String errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ExportEntryConfigPlugin_2", (String)BOS_EXPORT, (Object[])new Object[0]);
            this.exportLogObj.set("logs", (Object)errMsg);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                throw new RuntimeException(e);
            }
            throw new KDBizException(errMsg);
        }
    }

    private ExportFileInfo createExportFileInfo(int batchSize) {
        ExportFileInfo fileInfo = new ExportFileInfo();
        fileInfo.setBatchSize(batchSize);
        return fileInfo;
    }

    private String getEntryName(String entryKey, IDataModel dataModel) {
        LocaleString caption = dataModel.getProperty(entryKey).getDisplayName();
        if (caption != null) {
            return StringUtils.isEmpty((CharSequence)caption.toString()) ? entryKey : caption.getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u65e0\u5355\u636e\u4f53\u540d\u79f0\u3002", (String)"ExcortEntry_1", (String)BOS_EXPORT, (Object[])new Object[0]);
    }

    private void exportEntry(IFormView view, EntryGrid grid, ListExporter exporter, EntryData entrydata, List<String> fields, int[] excelRowIndexs, int[] progress, int[] selectRows, IExportEntryPlugin exportEntryPlugin) {
        ArrayList<Object> rowdata = new ArrayList<Object>();
        List rows = (List)entrydata.getData().get(DATA_ROWS);
        boolean hasSelectRows = selectRows.length > 0;
        int startIndex = entrydata.getStartIndex();
        int endIndex = entrydata.getEndIndex();
        if (hasSelectRows && (endIndex < selectRows[0] || startIndex > selectRows[selectRows.length - 1])) {
            return;
        }
        Map dataindex = (Map)entrydata.getData().get(DATA_INDEX);
        Map fmtinfo = entrydata.getFmtInfo();
        for (int i = startIndex; i < endIndex; ++i) {
            int temp = i;
            if (hasSelectRows && IntStream.of(selectRows).noneMatch(value -> value == temp)) continue;
            int realIndex = i - startIndex;
            List row = (List)rows.get(realIndex);
            for (String fieldname : fields) {
                Integer index = (Integer)dataindex.get(fieldname);
                if (index == null) {
                    if (!fieldname.startsWith("$$")) continue;
                    boolean exist = false;
                    block2: for (Object val : row) {
                        if (!(val instanceof List)) continue;
                        List flexExpandList = (List)val;
                        for (Object tmpVal : flexExpandList) {
                            if (!(tmpVal instanceof Map) || !(((Map)tmpVal).get("k") instanceof String) || !StringUtils.equals((CharSequence)((Map)tmpVal).get("k").toString(), (CharSequence)fieldname) || !(((Map)tmpVal).get("alias") instanceof String)) continue;
                            String alias = ((Map)tmpVal).get("alias").toString();
                            String valStr = alias.substring(alias.indexOf(":") + 1);
                            rowdata.add(valStr);
                            exist = true;
                            continue block2;
                        }
                    }
                    if (exist) continue;
                    rowdata.add("");
                    continue;
                }
                Object val = row.get(index);
                val = ExportEntryUtil.getExportValue(view, grid, entrydata, dataindex, fmtinfo, realIndex, row, fieldname, val);
                rowdata.add(val);
            }
            if (exportEntryPlugin != null) {
                exportEntryPlugin.beforeExportEntry(new BeforeExportEntryEvent(view, rowdata));
            }
            exporter.writeLine(rowdata);
            excelRowIndexs[0] = excelRowIndexs[0] + 1;
            rowdata.clear();
            progress[0] = progress[0] + 1;
            if (i % 1000 != 0) continue;
            this.getPageCache().put(CACHE_EXPORTED, String.valueOf(progress[0]));
            this.getPageCache().saveChanges();
        }
        this.exportLogObj.set(LABEL_PROGRESS_EXPORTED, (Object)progress[0]);
        this.getPageCache().put(CACHE_EXPORTED, String.valueOf(progress[0]));
        this.getPageCache().saveChanges();
    }

    private boolean isOperationColumn(IFormView view, String fieldName) {
        Control control = view.getControl(fieldName);
        return control instanceof OperationColumn;
    }

    private List<KeyValue> prepareCaptions(JSONArray cwgNames, List fieldNames, Map<String, IDataEntityProperty> properties) {
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>();
        ReferenceInteger referenceInteger = new ReferenceInteger(0);
        this.createCaptions(captions, cwgNames, referenceInteger, fieldNames, properties);
        return captions;
    }

    private void createCaptions(List<KeyValue> captions, JSONArray cwgNames, ReferenceInteger index, List<String> fieldNames, Map<String, IDataEntityProperty> properties) {
        for (Object cwgName : cwgNames) {
            JSONObject cwgNameJsonObject = (JSONObject)cwgName;
            String colId = cwgNameJsonObject.getString("colId");
            String name = cwgNameJsonObject.getString("name");
            if (cwgNameJsonObject.get((Object)"children") == null && StringUtils.isNotEmpty((CharSequence)colId) && fieldNames.contains(colId)) {
                int fieldType = this.getTypeField(colId, properties);
                captions.add(new KeyValue(colId, name, new Object[]{fieldType, 0, "default"}, index.getValue()));
                index.increase();
            }
            if (cwgNameJsonObject.get((Object)"children") == null) continue;
            captions.add(new KeyValue(colId, (Object)new KeyValue(name, new ArrayList(), index.getValue()), index.getValue()));
            this.createCaptions((List)((KeyValue)captions.get((int)index.getValue().intValue()).value).value, cwgNameJsonObject.getJSONArray("children"), new ReferenceInteger(0), fieldNames, properties);
            index.increase();
        }
    }

    private int getTypeField(String colId, Map<String, IDataEntityProperty> properties) {
        if (MapUtils.isEmpty(properties)) {
            return 0;
        }
        if (properties.get(colId) == null) {
            return 0;
        }
        IDataEntityProperty iDataEntityProperty = properties.get(colId);
        if (iDataEntityProperty instanceof DecimalProp) {
            return 2;
        }
        if (iDataEntityProperty instanceof DateProp) {
            return 3;
        }
        if (iDataEntityProperty instanceof DateTimeProp) {
            return 4;
        }
        return 0;
    }

    private boolean isSplit(IFormView view, String entryKey) {
        int count = view.getModel().getEntryRowCount(entryKey);
        if (count <= 0 || count > this.getModel().getEntryPageSize() && view.getModel().getDataEntity().getDataEntityState().isSplitPage()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private NumberFormatProvider getNumberFormatProvider(DynamicObject[] dataEntitys, int rowStartIndex, boolean reuse, IFormView view, EntryGrid entryGrid, String entryKey) {
        if (this.numberFormatProvider != null && reuse) {
            return this.numberFormatProvider;
        }
        IDataModel model = view.getModel();
        IDataEntityType entryType = ((ICollectionProperty)model.getProperty(entryKey)).getItemType();
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        for (FieldEdit ctl : entryGrid.getFieldEdits()) {
            FmtField fmtField;
            IDataEntityProperty prop;
            if (ctl.isFlatField()) continue;
            if (ctl instanceof DecimalEdit) {
                prop = (IDataEntityProperty)entryType.getProperties().get((Object)ctl.getFieldKey());
                String propName = ((DecimalEdit)ctl).getControlPropName();
                FmtField fmtField2 = new FmtField(prop, ctl.getKey(), propName);
                fmtFields.add(fmtField2);
                continue;
            }
            if (ctl instanceof DateTimeEdit) {
                prop = (IDataEntityProperty)entryType.getProperties().get((Object)ctl.getFieldKey());
                fmtField = new FmtField(prop, ctl.getKey(), ctl instanceof DateEdit ? null : ((DateTimeProp)prop).getRelateOrg());
                fmtFields.add(fmtField);
                continue;
            }
            if (!(ctl instanceof DateRangeEdit)) continue;
            prop = (IDataEntityProperty)entryType.getProperties().get((Object)((DateRangeEdit)ctl).getStartDateFieldKey());
            fmtField = new FmtField(prop, ctl.getKey(), null);
            fmtFields.add(fmtField);
        }
        DynamicCollectionProperty entryProp = (DynamicCollectionProperty)view.getModel().getProperty(entryKey);
        List<DynamicObject> dynamicObjects = Arrays.asList(dataEntitys);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(entryProp.getDynamicCollectionItemPropertyType(), (Object)entryProp.getParent(), dynamicObjects);
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, dynamicObjectCollection, view.getModel().getDataEntity(), rowStartIndex);
        if (reuse) {
            this.numberFormatProvider = numberFormatProvider;
        }
        return numberFormatProvider;
    }

    private Map<String, Object> getFmtInfo(DynamicObject[] dataEntitys, int rowStartIndex, IFormView view, EntryGrid entryGrid, String entryKey) {
        NumberFormatProvider numberFormatProvider = this.getNumberFormatProvider(dataEntitys, rowStartIndex, false, view, entryGrid, entryKey);
        HashMap<String, Object> numFmtInfo = new HashMap<String, Object>();
        numFmtInfo.put("colfmt", numberFormatProvider.getColfmt());
        numFmtInfo.put("currencyfmt", numberFormatProvider.getCurrencyfmt());
        numFmtInfo.put("unitfmt", numberFormatProvider.getUnitfmt());
        numFmtInfo.put("timezonefmt", numberFormatProvider.getTimeZoneFmt());
        return numFmtInfo;
    }

    static class ReferenceInteger {
        Integer value;

        public ReferenceInteger(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public Integer increase() {
            Integer n = this.value;
            Integer n2 = this.value = Integer.valueOf(this.value + 1);
            return this.value;
        }
    }
}

