/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.util.TemplateUtil;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;

public class SelectExportTemplatePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String NEWTEMPLATE = "newtemplate";
    private static final String BILLLISTAP = "billlistap";
    private static final String BINDENTITYID = "bindEntityId";
    private static final String BOS_EXPORT = "bos-export";
    private static final String BOS_IMPORT_TEMPLATE = "bos_importtemplate";
    private ImportPermissionService importPermissionService = new ImportPermissionService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", NEWTEMPLATE});
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String billFormId;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parent = this.getView().getViewNoPlugin(parentPageId);
        if (this.isListViewOrBillView(parent) && !StringUtils.isBlank((CharSequence)(billFormId = parent instanceof IListView ? ((IListView)parent).getListModel().getDataEntityType().getName() : parent.getModel().getDataEntityType().getName()))) {
            String addFilter;
            DynamicObject billType;
            this.getPageCache().put(BINDENTITYID, billFormId);
            BillList list = (BillList)this.getControl(BILLLISTAP);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            FilterParameter filterParameter = new FilterParameter();
            String templateType = (String)showParameter.getCustomParam("TemplateType");
            QFilter filter = new QFilter("bizobject.number", "=", (Object)billFormId).and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("enable", "=", (Object)"1"));
            Object billTypeId = showParameter.getCustomParam("BillTypeId");
            if (billTypeId != null && !billTypeId.equals(0L) && (billType = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)"bos_billtype")) != null) {
                DynamicObjectCollection coll = billType.getDynamicObjectCollection("exporttpl");
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject obj : coll) {
                    ids.add((Long)obj.get("fbasedataid_id"));
                }
                if (!ids.isEmpty()) {
                    filter = filter.and(new QFilter("id", "in", ids));
                }
            }
            Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
            QFilter validScope = new QFilter("applyscope", "=", (Object)"0").or("creator", "=", (Object)userId).or(new QFilter("applyscope", "=", (Object)"1").and("users.fbasedataid.id", "in", (Object)userId));
            filter.and(validScope);
            String formAppId = this.getModel().getDataEntityType().getAppId();
            QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.get().getCurrUserId(), (String)formAppId, (String)BOS_IMPORT_TEMPLATE);
            if (dataRule != null) {
                filter.and(dataRule);
            }
            if (StringUtils.isNotBlank((CharSequence)(addFilter = (String)this.getView().getFormShowParameter().getCustomParam("TemplateListAddFilter")))) {
                filter.and(QFilter.fromSerializedString((String)addFilter));
            }
            filterParameter.setFilter(filter);
            list.setQueryFilterParameter(filterParameter);
        }
    }

    public void click(EventObject evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
                    this.importPermissionService.doFailCheckRight(this.getView(), result);
                    return;
                }
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView parent = this.getView().getViewNoPlugin(parentPageId);
                if (!this.isListViewOrBillView(parent)) break;
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
                if (templates == null || templates.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"SelectExportTemplatePlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]));
                    return;
                }
                long userId = RequestContext.get().getCurrUserId();
                for (Object template : templates) {
                    if (TemplateUtil.validateTemplatePermission(template, userId)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u4f7f\u7528\u8be5\u6a21\u677f\u3002", (String)"SelectExportTemplatePlugin_1", (String)BOS_EXPORT, (Object[])new Object[0]));
                    return;
                }
                this.getView().returnDataToParent((Object)templates);
                this.getView().close();
                break;
            }
            case "newtemplate": {
                if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
                    this.importPermissionService.doFailCheckRight(this.getView(), result);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(BOS_IMPORT_TEMPLATE);
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam(BINDENTITYID, (Object)this.getPageCache().get(BINDENTITYID));
                parameter.setCustomParam("templatetype", this.getView().getFormShowParameter().getCustomParam("TemplateType"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.refreshData();
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("name".equals(e.getFieldName())) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(billList.getEntityId());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId(billList.getFocusRowPkId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewtemplate"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private boolean isListViewOrBillView(IFormView view) {
        return view instanceof IListView || view instanceof IBillView;
    }
}

