/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AfterExportEntryEvent;
import kd.bos.form.plugin.BeforeExportEntryEvent;
import kd.bos.form.plugin.IExportEntryPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TestExportentryPlugin
implements IExportEntryPlugin {
    private static Log log = LogFactory.getLog(TestExportentryPlugin.class);
    private static final String BOS_IMPORT = "bos-import";

    @Override
    public void beforeExportEntry(BeforeExportEntryEvent beforeExportEntryEvent) {
        List<Object> rowData = beforeExportEntryEvent.getRowData();
        if (!rowData.isEmpty()) {
            for (int i = 0; i < rowData.size(); ++i) {
                if (!(rowData.get(i) instanceof String)) continue;
                rowData.set(i, ResManager.loadKDString((String)"\u63d2\u4ef6\u8d4b\u503c\u7684\u5b57\u7b26\u4e32", (String)"TestExportentryPlugin_0", (String)"bos-export", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterExportEntry(AfterExportEntryEvent afterExportEntryEvent) {
        File file = afterExportEntryEvent.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                for (int i = 0; i < 3; ++i) {
                    CellStyle cs = wb.createCellStyle();
                    cs.setFillForegroundColor(IndexedColors.RED.getIndex());
                    cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    sheet.getRow(i).getCell(1).setCellStyle(cs);
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
        afterExportEntryEvent.setFileName(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6587\u4ef6\u540d", (String)"BOS_IMPORT_7", (String)BOS_IMPORT, (Object[])new Object[0]));
    }
}

