/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.util.LogPath;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.ImportLogDeleteFileUtil;
import kd.bos.web.actions.utils.FilePathUtil;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class DeleteImpExtFileUtil {
    private static final Log log = LogFactory.getLog(DeleteImpExtFileUtil.class);
    private static final String IS_DELETED = "isdeleted";
    private static final String DOWNLOADURL = "downloadurl";
    private static final String PATH = "path=";
    private static final String BILLNO = "billno";
    private static final String BOS_EXPORT = "bos-export";

    public static void deleteFile(DynamicObject[] logObjS, boolean isImport) {
        if (logObjS.length == 0) {
            return;
        }
        ArrayList<DynamicObject> needUpdateLogDynS = new ArrayList<DynamicObject>(16);
        List<LogPath> logPaths = DeleteImpExtFileUtil.collectPathsAndNeedUpdateLogS(logObjS, needUpdateLogDynS, isImport);
        if (!CollectionUtils.isEmpty(logPaths)) {
            Set<Object> failDeletePkIds = DeleteImpExtFileUtil.deleteFileInFileServer(logPaths, false, null, null, null, null);
            DeleteImpExtFileUtil.updateDeletedLogS(needUpdateLogDynS, failDeletePkIds);
        }
    }

    public static List<LogPath> collectPathsAndNeedUpdateLogS(DynamicObject[] logObjS, List<DynamicObject> needUpdateLogDynS, boolean isImport) {
        ArrayList<LogPath> logPaths = new ArrayList<LogPath>(16);
        for (DynamicObject logObj : logObjS) {
            LogPath logPath;
            Optional<LogPath> optional;
            String isDeleted = logObj.getString(IS_DELETED);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)isDeleted) || !(optional = DeleteImpExtFileUtil.resolve(logObj, isImport)).isPresent() || !(logPath = optional.get()).isExistErrFile() && "2".equals(logObj.get(IS_DELETED))) continue;
            logPaths.add(logPath);
            if (logPath.isExistErrFile() || !isImport) {
                logObj.set(IS_DELETED, (Object)"1");
            } else {
                logObj.set(IS_DELETED, (Object)"2");
            }
            needUpdateLogDynS.add(logObj);
        }
        return logPaths;
    }

    private static Optional<LogPath> resolve(DynamicObject logDynamicObject, boolean isImport) {
        if (isImport) {
            return DeleteImpExtFileUtil.resolveImportSourceAndErrFileUrl(logDynamicObject);
        }
        return DeleteImpExtFileUtil.resolveExportFileUrl(logDynamicObject);
    }

    public static void updateDeletedLogS(List<DynamicObject> needUpdateLogDynS, Set<Object> failDeletePkIds) {
        if (failDeletePkIds == null) {
            return;
        }
        List<DynamicObject> collect = needUpdateLogDynS.stream().filter(updateDynamicObject -> !failDeletePkIds.contains(updateDynamicObject.getPkValue())).collect(Collectors.toList());
        OperateOption option = OperateOption.create();
        option.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.update((DynamicObject[])collect.toArray(new DynamicObject[0]), (OperateOption)option);
    }

    public static Set<Object> deleteFileInFileServer(List<LogPath> logPaths, boolean writeLog, String opName, String opDesc, String formId, String bizAppId) {
        if (logPaths == null) {
            return null;
        }
        HashSet<Object> failDeletePkIds = new HashSet<Object>(16);
        List splitLogPaths = Lists.partition(logPaths, (int)1000);
        for (List splitLogPath : splitLogPaths) {
            for (LogPath logPath : splitLogPath) {
                boolean deleted = true;
                Set<String> pathSet = logPath.getPathSet();
                for (String path : pathSet) {
                    if (path.contains("tempfile/download.do?configKey")) continue;
                    try {
                        ImportLogDeleteFileUtil.getFileService().delete(path);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        failDeletePkIds.add(logPath.getPkId());
                        deleted = false;
                    }
                    if (!deleted || !writeLog) continue;
                    ImportLogDeleteFileUtil.createAppLog((String)formId, (String)bizAppId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u6587\u4ef6", "ExportLogDeleteFileListPlugin_15", BOS_EXPORT), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5220\u9664\u6587\u4ef6\u6210\u529f\u3002", "ExportLogDeleteFileListPlugin_16", BOS_EXPORT), (String[])new String[]{logPath.getBillNo()});
                }
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("[\u5bfc\u5165\u5bfc\u51fa\u6587\u4ef6\u6e05\u7406\u5206\u6279\u5931\u8d25] \uff1a" + e);
            }
        }
        log.warn("[\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u6587\u4ef6]" + logPaths.size() + "\u4e2a");
        return failDeletePkIds;
    }

    private static Optional<LogPath> resolveImportSourceAndErrFileUrl(DynamicObject dynamicObject) {
        JSONObject data;
        String jsonData = dynamicObject.getString("data");
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return Optional.empty();
        }
        try {
            data = JSON.parseObject((String)jsonData);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        JSONObject info = data.getJSONObject("info");
        Set pathSet = info.keySet();
        Set set = pathSet.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(set)) {
            return Optional.empty();
        }
        HashSet<String> deletePathSet = new HashSet<String>(16);
        boolean isExistErrFile = false;
        for (String key : set) {
            String[] split;
            String errFileUrl;
            JSONObject jsonObject = info.getJSONObject(key);
            String isOnlyDeletedSrcFile = dynamicObject.getString(IS_DELETED);
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)isOnlyDeletedSrcFile)) {
                String srcFileUrl = jsonObject.getString("srcFile");
                deletePathSet.add(srcFileUrl);
            }
            if (StringUtils.isBlank((CharSequence)(errFileUrl = jsonObject.getString("errFile"))) || !errFileUrl.contains(PATH) || (split = errFileUrl.split(PATH)).length != 2) continue;
            String path = split[1];
            deletePathSet.add(path);
            isExistErrFile = true;
        }
        return Optional.of(new LogPath(dynamicObject.getPkValue(), dynamicObject.getString(BILLNO), deletePathSet, isExistErrFile));
    }

    private static Optional<LogPath> resolveExportFileUrl(DynamicObject dynamicObject) {
        String downloadUrl = dynamicObject.getString(DOWNLOADURL);
        if (StringUtils.isBlank((CharSequence)downloadUrl)) {
            return Optional.empty();
        }
        String[] urlTemp = downloadUrl.split(PATH);
        if (urlTemp.length != 2) {
            return Optional.empty();
        }
        String id = urlTemp[1];
        String path = FilePathUtil.dealPath((String)id, (String)"attach");
        return Optional.of(new LogPath(dynamicObject.getPkValue(), dynamicObject.getString(BILLNO), Collections.singleton(path)));
    }
}

