/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextBasedataEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

public class ExportEntryUtil {
    private static final String FLEX_PROP_GROUPS = "flexpropgroups";
    private static final String BOS_EXPORT = "bos-export";

    public static Object getExportValue(IFormView view, EntryGrid grid, EntryData entrydata, Map<String, Integer> dataindex, Map<String, Object> fmtinfo, int realIndex, List<Object> row, String fieldname, Object val) {
        IDataEntityProperty prop = view.getModel().getProperty(fieldname);
        if (prop instanceof AttachmentProp || prop instanceof PictureProp || prop instanceof IFieldHandle && !((IFieldHandle)prop).isExportable()) {
            return null;
        }
        boolean isDesensitizeField = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)prop, (String)ResManager.getLanguage(), (String)"EXPORT", null);
        if (null == val) {
            return null;
        }
        if (isDesensitizeField) {
            return ExportEntryUtil.getDesensitizeValue(grid, val, prop, isDesensitizeField);
        }
        if (prop instanceof BooleanProp) {
            return ExportEntryUtil.getExportBooleanValue(val);
        }
        if (prop instanceof ComboProp) {
            return ExportEntryUtil.getExportComboValue((ComboProp)prop, val);
        }
        if (prop instanceof MulBasedataProp) {
            return ExportEntryUtil.getDisplayNameFromBasedata(grid, prop, val);
        }
        if (prop instanceof FlexProp) {
            return ExportEntryUtil.getExportFlexValue(val);
        }
        if (prop instanceof BasedataProp) {
            return ExportEntryUtil.getDisplayNameFromBasedata(grid, prop, val);
        }
        if (prop instanceof DecimalProp) {
            return ExportEntryUtil.getExportDecimalValue(entrydata, dataindex, fmtinfo, realIndex, row, prop, val);
        }
        if (prop instanceof AdminDivisionProp) {
            return ExportEntryUtil.getExportAdminDivisionlValue(val);
        }
        if (val.getClass().isArray() && ((Object[])val).length >= 2) {
            return ((Object[])val)[1];
        }
        if (prop instanceof TimeProp) {
            return ExportEntryUtil.formatTimeStr((Integer)val);
        }
        if (prop == null) {
            return ExportEntryUtil.getExportTimeOrDateRangeValue(view, fieldname, val);
        }
        return val;
    }

    private static Object getExportAdminDivisionlValue(Object val) {
        if (val.getClass().isArray() && ((Object[])val).length >= 1) {
            String id = String.valueOf(((Object[])val)[0]);
            Object fullName = ORMUtil.getAdminDivisionFullName((String)id);
            String formatValue = StringUtils.isNotBlank((Object)fullName) ? fullName.toString().replace('_', '/') : null;
            return formatValue;
        }
        return val;
    }

    private static Object getDesensitizeValue(EntryGrid grid, Object val, IDataEntityProperty prop, boolean isDesensitizeField) {
        if (prop instanceof BooleanProp && isDesensitizeField) {
            return val;
        }
        if (prop instanceof ComboProp && isDesensitizeField) {
            return val;
        }
        if (prop instanceof MulBasedataProp) {
            return ExportEntryUtil.getDisplayNameFromBasedata(grid, prop, val);
        }
        if (prop instanceof FlexProp) {
            return ExportEntryUtil.getExportFlexValue(val);
        }
        if (prop instanceof BasedataProp) {
            return ExportEntryUtil.getDisplayNameFromBasedata(grid, prop, val);
        }
        if (prop instanceof DecimalProp && isDesensitizeField) {
            if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                return ((Object[])val)[0];
            }
            return val;
        }
        if (val.getClass().isArray() && ((Object[])val).length >= 2) {
            return ((Object[])val)[1];
        }
        if (prop instanceof TimeProp && isDesensitizeField) {
            return val;
        }
        if (prop == null) {
            return val;
        }
        return val;
    }

    private static Object getExportBooleanValue(Object val) {
        val = Boolean.TRUE.equals(val) ? ResManager.loadKDString((String)"\u662f", (String)"ExportEntryConfigPlugin_3", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExportEntryConfigPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]);
        return val;
    }

    private static Object getExportTimeOrDateRangeValue(IFormView view, String fieldname, Object val) {
        Control c = view.getControl(fieldname);
        String valStr = val.toString().trim();
        if (c instanceof TimeRangeEdit) {
            if (valStr.equals(",")) {
                return null;
            }
            String[] strs = valStr.replaceAll("\\s*", "").split(",");
            int start = Integer.parseInt(strs[0].trim());
            int end = Integer.parseInt(strs[1].trim());
            if (start < 0 && end < 0) {
                val = null;
                return val;
            }
            val = kd.bos.util.StringUtils.isEmpty((String)strs[0]) ? "" : ExportEntryUtil.formatTimeStr(start);
            val = val + "~" + (kd.bos.util.StringUtils.isEmpty((String)strs[1]) ? "" : ExportEntryUtil.formatTimeStr(end));
            return val;
        }
        if (c instanceof DateRangeEdit) {
            if (valStr.equals(",")) {
                return null;
            }
            val = valStr.replace(",", " ~");
            return val;
        }
        return val;
    }

    private static Object getExportDecimalValue(EntryData entrydata, Map<String, Integer> dataindex, Map<String, Object> fmtinfo, int realIndex, List<Object> row, IDataEntityProperty prop, Object val) {
        if (prop instanceof AmountProp) {
            if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                val = ((Object[])val)[0];
            }
            val = ExportEntryUtil.formatAmount(prop, row, dataindex, fmtinfo, entrydata.getDataEntitys()[realIndex], val);
        } else if (prop instanceof QtyProp) {
            if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                val = ((Object[])val)[0];
            }
            Integer cppropIndex = dataindex.get("cprop");
            Map cpprop = (Map)row.get(cppropIndex);
            Map materialFmtinfo = (Map)cpprop.get("fmtinfo");
            val = ExportEntryUtil.formatQty(prop, row, dataindex, materialFmtinfo, fmtinfo, entrydata.getDataEntitys()[realIndex], val);
        } else {
            if ("".equals(val.toString().trim())) {
                val = "0";
            }
            if (val != null) {
                val = new BigDecimal(val.toString()).setScale(((DecimalProp)prop).getScale(), 4).toPlainString();
            }
        }
        if (val == null || kd.bos.util.StringUtils.isEmpty((String)val.toString()) || !((DecimalProp)prop).isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(val.toString().replace(",", ""))) == 0) {
            val = null;
        }
        return val;
    }

    private static Object getExportComboValue(ComboProp prop, Object val) {
        List<String> values = Arrays.asList(val.toString().split(","));
        List items = prop.getComboItems();
        if (items == null || items.isEmpty()) {
            return val;
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (ValueMapItem item : items) {
            if (!values.contains(item.getValue())) continue;
            vals.add(null == item.getName() ? "" : item.getName().toString());
        }
        val = String.join((CharSequence)" ", vals);
        return val;
    }

    private static Object getExportFlexValue(Object val) {
        ArrayList<String> valStrs = new ArrayList<String>();
        for (Object obj : (List)val) {
            String alias = (String)((Map)obj).get("alias");
            if (kd.bos.util.StringUtils.isEmpty((String)alias)) continue;
            valStrs.add(alias);
        }
        val = String.join((CharSequence)";", valStrs);
        return val;
    }

    private static Object getDisplayNameFromBasedata(EntryGrid grid, IDataEntityProperty prop, Object val) {
        Object[] result = new Object[]{val};
        ExportEntryUtil.replaceValAtBasedataProp(grid.getItems(), prop, val, result);
        val = result[0];
        return val;
    }

    private static void replaceValAtBasedataProp(List<Control> items, IDataEntityProperty prop, Object valObj, Object[] result) {
        Pattern replaceNumber = Pattern.compile("number");
        Pattern replaceName = Pattern.compile("name");
        for (Control item : items) {
            String displayProp;
            if (item instanceof Container) {
                ExportEntryUtil.replaceValAtBasedataProp(((Container)item).getItems(), prop, valObj, result);
            }
            if (item instanceof TextBasedataEdit) continue;
            if (item instanceof MulBasedataEdit && prop.getName().equals(((BasedataEdit)item).getFieldKey())) {
                displayProp = ((BasedataEdit)item).getDisplayProp();
                if (displayProp == null || "".equals(displayProp)) {
                    result[0] = ((Object[])valObj)[1];
                    continue;
                }
                if (!(valObj instanceof List)) continue;
                ArrayList<String> valStrs = new ArrayList<String>();
                for (Object val : (List)valObj) {
                    if (!(val instanceof Object[]) || !val.getClass().isArray() || ((Object[])val).length < 2) continue;
                    String resultTmp = displayProp;
                    String replaceNumberReplacement = Matcher.quoteReplacement(((Object[])val)[0].toString());
                    resultTmp = replaceNumber.matcher(resultTmp).replaceAll(replaceNumberReplacement);
                    String replaceNameReplacement = Matcher.quoteReplacement(((Object[])val)[1].toString());
                    resultTmp = replaceName.matcher(resultTmp).replaceAll(replaceNameReplacement);
                    valStrs.add(resultTmp);
                }
                result[0] = String.join((CharSequence)";", valStrs);
                continue;
            }
            if (!(item instanceof BasedataEdit) || !prop.getName().equals(((BasedataEdit)item).getFieldKey())) continue;
            displayProp = ((BasedataEdit)item).getDisplayProp();
            if (displayProp == null || "".equals(displayProp)) {
                result[0] = ((Object[])valObj)[1];
                continue;
            }
            if (!(valObj instanceof Object[]) || !valObj.getClass().isArray() || ((Object[])valObj).length < 2) continue;
            String resultTmp = displayProp;
            String replaceNumberReplacement = Matcher.quoteReplacement(((Object[])valObj)[0].toString());
            resultTmp = replaceNumber.matcher(resultTmp).replaceAll(replaceNumberReplacement);
            String replaceNameReplacement = Matcher.quoteReplacement(((Object[])valObj)[1].toString());
            resultTmp = replaceName.matcher(resultTmp).replaceAll(replaceNameReplacement);
            result[0] = resultTmp;
        }
    }

    public static String formatAmount(IDataEntityProperty prop, List<Object> row, Map<String, Integer> dataindex, Map<String, Object> fmtinfo, DynamicObject dyn, Object val) {
        String ctrlKey = ((DecimalProp)prop).getControlPropName();
        Map colfmt = (Map)fmtinfo.get("colfmt");
        Map fmt = (Map)colfmt.get(ctrlKey);
        if (fmt == null) {
            Integer index = dataindex.get(ctrlKey);
            Object ctrlVal = null;
            if (index == null) {
                DynamicObject ctrl;
                if (((DynamicObjectType)dyn.getDataEntityType()).getProperty(ctrlKey) != null && (ctrl = (DynamicObject)dyn.get(ctrlKey)) != null) {
                    ctrlVal = ctrl.get(((BasedataProp)ctrl.getDataEntityType()).getNumberProp());
                }
            } else {
                ctrlVal = row.get(index);
                if (ctrlVal != null && ctrlVal.getClass().isArray() && ((Object[])ctrlVal).length >= 2) {
                    ctrlVal = ((Object[])ctrlVal)[0];
                }
            }
            if (ctrlVal != null) {
                Map currencyfmt = (Map)fmtinfo.get("currencyfmt");
                fmt = (Map)currencyfmt.get(ctrlVal);
            }
        }
        if (fmt == null) {
            fmt = (Map)colfmt.get("_MainCurrency_");
        }
        if (fmt != null && val != null && kd.bos.util.StringUtils.isNotEmpty((String)val.toString())) {
            val = new BigDecimal(val.toString()).setScale((int)((Integer)fmt.get(prop instanceof PriceProp ? "pp" : "ap")), 4).toPlainString();
        }
        return (String)val;
    }

    public static Object formatQty(IDataEntityProperty prop, List<Object> row, Map<String, Integer> dataindex, Map<String, Object> materialFmtinfo, Map<String, Object> fmtinfo, DynamicObject dyn, Object val) {
        Map colfmt;
        Map unitfmt;
        String ctrlKey = ((DecimalProp)prop).getControlPropName();
        Map fmt = null;
        if (materialFmtinfo != null && !materialFmtinfo.isEmpty() && (unitfmt = (Map)materialFmtinfo.get("unitfmt")) != null) {
            fmt = (Map)unitfmt.get(ctrlKey);
        }
        if (fmt == null && (fmt = (Map)(colfmt = (Map)fmtinfo.get("colfmt")).get(ctrlKey)) == null) {
            Integer index = dataindex.get(ctrlKey);
            Object ctrlVal = null;
            if (index == null) {
                DynamicObject ctrl;
                if (((DynamicObjectType)dyn.getDataEntityType()).getProperty(ctrlKey) != null && (ctrl = (DynamicObject)dyn.get(ctrlKey)) != null) {
                    ctrlVal = ctrl.getDataEntityType() instanceof RefEntityType ? ctrl.get("number") : ctrl.get(((BasedataProp)ctrl.getDataEntityType()).getNumberProp());
                }
            } else {
                ctrlVal = row.get(index);
                if (ctrlVal != null && ctrlVal.getClass().isArray() && ((Object[])ctrlVal).length >= 2) {
                    ctrlVal = ((Object[])ctrlVal)[0];
                }
            }
            if (ctrlVal != null) {
                Map unitfmt2 = (Map)fmtinfo.get("unitfmt");
                fmt = (Map)unitfmt2.get(ctrlVal);
            }
        }
        if (fmt != null && val != null && kd.bos.util.StringUtils.isNotEmpty((String)val.toString())) {
            val = new BigDecimal(val.toString()).setScale((int)((Integer)fmt.get(prop instanceof QtyProp ? "ps" : "pa")), 4).toPlainString();
        }
        return val;
    }

    public static String formatTimeStr(Integer timeObj) {
        if (timeObj == null || timeObj < 0) {
            return null;
        }
        int time = timeObj;
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static int getFlexPropGroups(String formId) {
        int groups = 16;
        DynamicObject billParameter = ParameterReader.getBillParameter((String)formId);
        if (null != billParameter && ((groups = billParameter.getInt(FLEX_PROP_GROUPS)) < 1 || groups > 50)) {
            return 16;
        }
        return groups;
    }
}

