/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TemplateUtil {
    private static final String APPLYSCOPE = "applyscope";
    private static final String BOS_IMPORTTEMPLATE = "bos_importtemplate";
    private static final String FBASEDATAID = "fbasedataid";

    public static boolean validateTemplatePermission(Object templateId, long userId) {
        DynamicObject templateDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)BOS_IMPORTTEMPLATE);
        boolean applyScope = templateDynamicObject.getBoolean(APPLYSCOPE);
        if (applyScope) {
            DynamicObjectCollection users = templateDynamicObject.getDynamicObjectCollection("users");
            return TemplateUtil.userTemplatePermission(userId, users);
        }
        return true;
    }

    private static boolean userTemplatePermission(long userId, DynamicObjectCollection users) {
        for (DynamicObject user : users) {
            Object userPk = user.getDynamicObject(FBASEDATAID).getPkValue();
            if (!(userPk instanceof Long) || userId != (Long)userPk) continue;
            return true;
        }
        return false;
    }
}

