/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportAdminDivisionProp
extends ExportPropConvert {
    private Map<Object, Object> adminDivisionNames = new HashMap<Object, Object>(2);

    public ExportAdminDivisionProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        if (StringUtils.isBlank((Object)value)) {
            return value;
        }
        Object fullname = this.adminDivisionNames.get(value);
        if (fullname != null) {
            return fullname;
        }
        fullname = ORMUtil.getAdminDivisionFullName((String)value.toString());
        String formatValue = StringUtils.isNotBlank((Object)fullname) ? fullname.toString().replace('_', '/') : null;
        this.adminDivisionNames.put(value, formatValue);
        return formatValue;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        Object writeValue = this.formatValue(activeRow, value, ExportFileType.JSArray);
        if (writeValue != null) {
            super.exportSubPropValue(activeRow, writeValue);
        }
    }
}

