/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.export.util.ConvertUtil;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;
import org.apache.commons.collections4.BidiMap;

class ExportAttachProp
extends ExportPropConvert {
    private static final String REGEXATTACHMENT = "\n";

    public ExportAttachProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (!(value instanceof MulBasedataDynamicObjectCollection) || ((MulBasedataDynamicObjectCollection)value).isEmpty() || !this.getContext().getExportAttPropAndPanel().booleanValue()) {
            return;
        }
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            DesensitiveResult result = this.deSensitive(this.getProp().getName(), value, activeRow);
            this.collectAtt(this.getProp().getName(), result);
            this.writeValue(col, result.getValue().toString(), cellPropertys);
        }
    }

    private void collectAtt(String field, DesensitiveResult result) {
        if (!this.getContext().getExportAttPropAndPanel().booleanValue()) {
            return;
        }
        if (!(result.getValue() instanceof MulBasedataDynamicObjectCollection) || ((MulBasedataDynamicObjectCollection)result.getValue()).isEmpty()) {
            return;
        }
        if (this.getContext().getSensitiveArgs() != null && this.getContext().getSensitiveArgs().contain(field)) {
            return;
        }
        BidiMap<String, String> exportAttMessageMap = this.getContext().getExportAttMessageMap();
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)result.getValue();
        HashSet<String> attNameSet = new HashSet<String>();
        String prefix = "";
        if (this.getContext().getExportAttType() == 1 && StringUtils.isNotEmpty((CharSequence)this.getContext().getBillNo())) {
            prefix = this.getContext().getBillNo();
        }
        for (DynamicObject mulBaseDataDynamicObject : mulBasedataDynamicObjectCollection) {
            String attUrl;
            String finalName;
            DynamicObject attObj = mulBaseDataDynamicObject.getDynamicObject("fbasedataid");
            if (attObj == null || !StringUtils.isNotEmpty((CharSequence)(finalName = ConvertUtil.collectSingleUrl(exportAttMessageMap, attUrl = attObj.getString("url"), prefix)))) continue;
            attNameSet.add(finalName);
        }
        if (!attNameSet.isEmpty()) {
            result.setValue(String.join((CharSequence)REGEXATTACHMENT, attNameSet));
        }
    }
}

