/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.lang.Lang;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportMuliLangTextProp
extends ExportPropConvert {
    public ExportMuliLangTextProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        if (value instanceof ILocaleString) {
            if (exportFileType == ExportFileType.JSArray) {
                return this.toJSONObject((ILocaleString)value);
            }
            return value;
        }
        return value;
    }

    private Object toJSONObject(ILocaleString value) {
        if (value.isEmpty()) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        for (Map.Entry item : value.entrySet()) {
            jsonObj.put((String)item.getKey(), item.getValue());
        }
        return jsonObj;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (!(value instanceof ILocaleString)) {
            super.exportSubPropValue(activeRow, value);
            return;
        }
        for (Map.Entry<Integer, Map<String, Object>> exportCol : this.getExportCols().entrySet()) {
            this.exportSubPropValue(activeRow, (ILocaleString)value, exportCol.getKey(), exportCol.getValue());
        }
    }

    private void exportSubPropValue(DynamicObject activeRow, ILocaleString localeString, int col, Map<String, Object> colPropertys) {
        Object dataKey = colPropertys.get("DataKey");
        String localeId = "";
        localeId = dataKey instanceof String ? (String)dataKey : Lang.get().getLocale().toString();
        Object value = localeString.get((Object)localeId);
        String fieldName = this.getProp().getName() + "." + localeId;
        DesensitiveResult result = this.getSensitiveValue(this.getProp(), value, activeRow, localeId, fieldName);
        this.writeValue(col, result.getValue(), colPropertys);
    }

    @Override
    protected String getCurrentFieldName(Map<String, Object> cellProperties) {
        Object dataKey = cellProperties.get("DataKey");
        String localeId = "";
        localeId = dataKey instanceof String ? (String)dataKey : Lang.get().getLocale().toString();
        return this.getProp().getName() + "." + localeId;
    }
}

