/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.export.util.ConvertUtil;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;
import org.apache.commons.collections4.BidiMap;

class ExportPictureProp
extends ExportPropConvert {
    public ExportPictureProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (value == null) {
            return;
        }
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            DesensitiveResult result = this.deSensitive(this.getProp().getName(), value, activeRow);
            this.collectPicture(this.getProp().getName(), result);
            this.writeValue(col, result.getValue().toString(), cellPropertys);
        }
    }

    private void collectPicture(String field, DesensitiveResult result) {
        String finalName;
        if (!this.getContext().getExportPictureProp().booleanValue()) {
            return;
        }
        if (result.getValue() == null) {
            return;
        }
        if (this.getContext().getSensitiveArgs() != null && this.getContext().getSensitiveArgs().contain(field)) {
            return;
        }
        BidiMap<String, String> exportPictureMessageMap = this.getContext().getExportPictureMessageMap();
        String pictureUrl = result.getValue().toString();
        String prefix = "";
        if (this.getContext().getExportPictureType() == 1 && StringUtils.isNotEmpty((CharSequence)this.getContext().getBillNo())) {
            prefix = this.getContext().getBillNo();
        }
        if (StringUtils.isNotEmpty((CharSequence)(finalName = ConvertUtil.collectSingleUrl(exportPictureMessageMap, pictureUrl, prefix)))) {
            result.setValue(finalName);
        }
    }
}

