/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportCsvWriter;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.mvc.export.dataconvert.AbstractExportDataConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.web.actions.export.ExportWriter;
import org.apache.commons.collections4.MapUtils;

class ExportToCsv
extends AbstractExportDataConvert {
    private static final int MAX_CELLCONTENT_LENGTH = Short.MAX_VALUE;
    private static final Log log = LogFactory.getLog(ExportToCsv.class);
    private int currBatchBeginRowIndex = 0;
    private int currBatchRowCount = 0;
    private RowMapper currBill;
    private int currBillBeginRowIndex = 0;
    private int lastCol;
    private RowMapper activeRow;
    private ExportWriterFormat headFormat = null;
    private Map<String, ExportWriterFormat> entryFormats = new HashMap<String, ExportWriterFormat>(16);
    private Map<String, Integer> entryLastCols = new HashMap<String, Integer>(16);
    private long mainOrgId;
    private Map<Integer, String[]> rowsData = new HashMap<Integer, String[]>(16);
    private ExportCsvWriter csvWriter;
    private Map<String, Integer> startEntryRowIndex = new HashMap<String, Integer>(4);
    private Map<String, String> headerMap = new HashMap<String, String>(16);
    private int headerOffset = 0;
    private boolean firstBatch = true;
    private List<String> headNames = new ArrayList<String>(16);
    private static final String REGEXATTACHMENT = "\n";

    ExportToCsv() {
    }

    @Override
    public void initialize(ExportDataContext context) {
        super.initialize(context);
        this.init(context, new HashMap<String, String>(16));
    }

    private void init(ExportDataContext context, Map<String, String> headerMap) {
        if (headerMap != null) {
            this.headerMap = headerMap;
        }
        List<ExportWriterFormat> formats = context.getFormats();
        for (ExportWriterFormat format : formats) {
            this.headerOffset = this.parseHeader(format, this.headNames, this.headerOffset);
        }
        this.csvWriter = new ExportCsvWriter(this.headNames.toArray(new String[0]), null, (MainEntityType)this.getContext().getMainEntityType(), context.getFileName(), context.getSaveDir());
    }

    private int parseHeader(ExportWriterFormat format, List<String> headNames, int preOffset) {
        int offset = preOffset;
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = format.fields.get(i);
            Map<String, Object> property = format.properties.get(fieldName);
            boolean mustInput = false;
            String caption = "";
            if (property != null) {
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                Object inputType = property.get("InputType");
                if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType) || "geoPointField".equals(inputType)) {
                    offset = this.splitColumn(format, property, fieldName, offset, headNames, mustInput);
                    continue;
                }
                String displayName = property.get("DisplayName").toString();
                if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((Object)property.get("EntityDescription"))) {
                    String description = property.get("EntityDescription").toString();
                    displayName = ExportWriter.getRealDescByInputType(description, property, null, fieldName);
                }
                if (this.headerMap.containsKey(fieldName)) {
                    displayName = this.headerMap.get(fieldName);
                }
                caption = (mustInput ? "*" : "") + displayName;
            }
            headNames.add(caption);
            ++offset;
        }
        for (ExportWriterFormat wr : format.next) {
            offset += this.parseHeader(wr, headNames, preOffset);
        }
        return offset;
    }

    private int splitColumn(ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, List<String> headNames, boolean mustInput) {
        List<String> splitCols = format.flexColumn.get(fieldName);
        List<String> splitColDisplayNames = format.flexColumnDisplay.get(fieldName);
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                String displayName = ExportWriter.dealDisplayName(j, format.getExchangeNameAndMark(), property, splitCols, splitColDisplayNames);
                String colsName = splitCols.get(j);
                if (this.headerMap.containsKey(colsName)) {
                    displayName = this.headerMap.get(colsName);
                }
                String caption = (j == 0 && mustInput ? "*" : "") + displayName;
                headNames.add(caption);
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public boolean beginBatch(DynamicObject[] billObjs, int rowIndex) {
        this.currBatchBeginRowIndex = rowIndex;
        this.currBillBeginRowIndex = rowIndex;
        this.currBatchRowCount = 0;
        if (this.firstBatch) {
            this.initCsvHeader();
        }
        return true;
    }

    @Override
    public int endBatch(DynamicObject[] billObjs) {
        return this.currBatchRowCount;
    }

    @Override
    public boolean beginBill(DynamicObject billObj) {
        MainOrgProp mainOrgProp = this.getContext().getMainEntityType().getMainOrgProperty();
        long mainOrgId = 0L;
        if (mainOrgProp != null) {
            DynamicObject mainOrgObj = (DynamicObject)mainOrgProp.getValue((Object)billObj);
            mainOrgId = mainOrgObj != null ? (Long)mainOrgObj.getPkValue() : 0L;
        }
        this.mainOrgId = mainOrgId;
        this.activeRow = this.currBill = new RowMapper(null, billObj, this.headFormat, this.currBillBeginRowIndex);
        return true;
    }

    @Override
    public void endBill(DynamicObject billObj) {
        int rowCount = this.currBill.getChildMaxRowCount();
        this.currBatchRowCount += rowCount;
        this.currBillBeginRowIndex += rowCount;
        this.fillParentCellValue(rowCount);
        for (Object[] objectArray : this.rowsData.values()) {
            try {
                this.csvWriter.list2csv(objectArray);
            }
            catch (IOException e) {
                log.error((Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("ERROR WRITE ROWS TO CSV", e.getMessage()), new Object[0]);
            }
        }
        this.activeRow = null;
        this.currBill = null;
        this.rowsData.clear();
    }

    @Override
    public boolean beginEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        if (entryType instanceof LinkEntryType || entryType instanceof NameVersionEntryType) {
            return false;
        }
        RowMapper parentRow = this.activeRow;
        int rowIndex = parentRow.genChildCurrRowIndex(entryType.getName());
        this.activeRow = new RowMapper(parentRow, entryRow, this.entryFormats.get(entryType.getName()), rowIndex);
        return true;
    }

    @Override
    public void endEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        Integer rowCount = this.activeRow.getChildMaxRowCount();
        this.activeRow.getParent().addChildRowCount(entryType.getName(), rowCount);
        this.fillParentCellValue(rowCount);
        this.activeRow = this.activeRow.getParent();
    }

    @Override
    public void convertValue(IDataEntityProperty prop, Object value) {
        IExportPropConvert propConvert = this.getPropConvert(prop);
        propConvert.exportValue(this.activeRow.getActiveRow(), value);
    }

    @Override
    public void writeColHeader(int col, String caption, Map<String, Object> cellPropertys) {
        if (col > this.lastCol) {
            this.lastCol = col;
        }
    }

    @Override
    public void writeValue(int col, Object value, Map<String, Object> cellPropertys) {
        if (value == null) {
            return;
        }
        if (cellPropertys == null) {
            this.getCSVData()[col] = value.toString();
            return;
        }
        Object inputType = cellPropertys.get("InputType");
        if ("time".equals(inputType) || "date".equals(inputType) || "datetime".equals(inputType)) {
            this.getCSVData()[col] = value.toString();
        } else if ("decimal".equals(inputType)) {
            Object dataObj = value;
            if (dataObj instanceof NumberPrecision || dataObj instanceof Map) {
                Map<String, String> dataMap = new HashMap<String, BigDecimal>();
                if (dataObj instanceof NumberPrecision) {
                    dataMap.put("result", (String)((Object)(((NumberPrecision)dataObj).getResult() == null ? new BigDecimal(0) : ((NumberPrecision)dataObj).getResult())));
                    dataMap.put("sign", ((NumberPrecision)dataObj).getSign());
                    dataMap.put("precision", (String)((Object)Integer.valueOf(((NumberPrecision)dataObj).getPrecision())));
                    dataMap.put("showSign", (String)((Object)Boolean.valueOf(((NumberPrecision)dataObj).isShowSign())));
                    dataMap.put("groupingUsed", (String)((Object)Boolean.valueOf(((NumberPrecision)dataObj).isGroupingUsed())));
                    dataMap.put("stripTrailingZeros", (String)((Object)Boolean.valueOf(((NumberPrecision)dataObj).isStripTrailingZeros())));
                } else if (dataObj instanceof Map) {
                    dataMap = (Map)dataObj;
                }
                BigDecimal decimal = new BigDecimal(((Object)dataMap.getOrDefault("result", (String)((Object)Integer.valueOf(0)))).toString());
                if (!ListDataExporter.isDecimalTooBig(decimal.toString())) {
                    this.getCSVData()[col] = String.valueOf(decimal.doubleValue());
                    dataObj = null;
                } else if (dataObj instanceof Map) {
                    dataObj = decimal;
                }
            } else if (dataObj instanceof Number && !ListDataExporter.isDecimalTooBig(dataObj.toString())) {
                this.getCSVData()[col] = String.valueOf(Double.parseDouble(dataObj.toString()));
                dataObj = null;
            }
            if (dataObj != null) {
                this.getCSVData()[col] = String.valueOf(dataObj.toString());
            }
        } else {
            String val;
            if (value instanceof BigDecimal) {
                value = new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString());
            }
            if ((val = value.toString()) != null && val.length() >= Short.MAX_VALUE) {
                val = String.format(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u5355\u5143\u683c\u652f\u6301\u7684\u6700\u5927\u957f\u5ea6%s\u3002", (String)"ExportToExcel_1", (String)"bos-export", (Object[])new Object[0]), Short.MAX_VALUE);
            }
            this.getCSVData()[col] = val;
        }
    }

    @Override
    public void writeAttachPanelMessage(Object pkValue) {
        List<Map<String, Object>> attachmentPanelAttS = this.getContext().getAttachArr().get(pkValue.toString());
        if (attachmentPanelAttS == null) {
            return;
        }
        this.writeAttachmentPanelAttNames(attachmentPanelAttS, this.entryFormats);
    }

    private void writeAttachmentPanelAttNames(List<Map<String, Object>> attachmentPanelAttS, Map<String, ExportWriterFormat> entryFormats) {
        List attachmentPanelFormatList = entryFormats.values().stream().filter(ExportWriterFormat::isAttachPanel).collect(Collectors.toList());
        for (ExportWriterFormat attachmentPanelFormat : attachmentPanelFormatList) {
            if (MapUtils.isEmpty(attachmentPanelFormat.properties) || attachmentPanelFormat.properties.size() > 1) continue;
            String attachmentPanelName = attachmentPanelFormat.name;
            LinkedHashSet<String> attachmentPanelNameSet = new LinkedHashSet<String>();
            for (Map<String, Object> attachmentPanelAtt : attachmentPanelAttS) {
                if (attachmentPanelName == null || attachmentPanelAtt.get("fattachmentpanel") == null || !StringUtils.equals((CharSequence)attachmentPanelAtt.get("fattachmentpanel").toString(), (CharSequence)attachmentPanelName)) continue;
                String attUrl = (String)attachmentPanelAtt.get("url");
                String attName = (String)this.getContext().getExportAttMessageMap().get((Object)attUrl);
                if (!StringUtils.isNotEmpty((CharSequence)attName)) continue;
                attachmentPanelNameSet.add(attName);
            }
            String attachmentPanelValue = String.join((CharSequence)REGEXATTACHMENT, attachmentPanelNameSet);
            int attachmentPanelCol = attachmentPanelFormat.col;
            this.getCSVData()[attachmentPanelCol] = attachmentPanelValue;
        }
    }

    private String[] getCSVData() {
        return this.rowsData.computeIfAbsent(this.activeRow.rowIndex, k -> new String[this.headNames.size()]);
    }

    @Override
    public boolean isCanExport(String field) {
        DynamicProperty property = this.getDynamicProperty(field);
        if (property instanceof TextProp && ((TextProp)property).isPassword()) {
            return false;
        }
        FieldControlRule fieldControlRule = this.getFieldControlRule(this.mainOrgId);
        if (fieldControlRule == null) {
            return true;
        }
        return !fieldControlRule.getCanNotReadFields().contains(field);
    }

    private DynamicProperty getDynamicProperty(String fieldName) {
        BillEntityType mainEntityType = this.getContext().getMainEntityType();
        Map entities = mainEntityType.getAllEntities();
        for (Map.Entry entry : entities.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            DynamicProperty property = entityType.getProperty(fieldName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public void finished() {
        super.finished();
    }

    @Override
    public Object getExportResult() {
        return null;
    }

    @Override
    public String flushAndUpload(String fileName) throws IOException {
        this.csvWriter.flush();
        this.csvWriter.close();
        return this.csvWriter.upload(fileName);
    }

    @Override
    public String flushToLocal() throws IOException {
        this.csvWriter.flush();
        this.csvWriter.close();
        return this.csvWriter.getCsvFile().getAbsolutePath();
    }

    @Override
    public Integer getStartEntryRowIndex(String prop) {
        this.startEntryRowIndex.putIfAbsent(prop, 0);
        return this.startEntryRowIndex.get(prop);
    }

    @Override
    public void setStartEntryRowIndex(String prop, Integer startEntryRowIndex) {
        this.startEntryRowIndex.put(prop, startEntryRowIndex);
    }

    private void initCsvHeader() {
        this.headFormat = this.getContext().getFormats().get(0);
        int lastCol = this.initColHeader(this.headFormat);
        this.entryLastCols.put(this.headFormat.name, lastCol);
        this.initEntryFormats(this.headFormat.next);
    }

    private void initEntryFormats(List<ExportWriterFormat> nextEntryFormats) {
        if (nextEntryFormats == null || nextEntryFormats.isEmpty()) {
            return;
        }
        for (ExportWriterFormat entryFormat : nextEntryFormats) {
            int lastCol = this.initColHeader(entryFormat);
            this.entryFormats.put(entryFormat.name, entryFormat);
            this.entryLastCols.put(entryFormat.name, lastCol);
            this.initEntryFormats(entryFormat.next);
        }
    }

    private int initColHeader(ExportWriterFormat entryFormat) {
        int col = entryFormat.col;
        if (entryFormat.isAttachPanel()) {
            if (col > this.lastCol) {
                this.lastCol = col;
            }
            return col;
        }
        EntityType entityType = (EntityType)this.getContext().getSubMainType().getAllEntities().get(entryFormat.name);
        for (String propName : entryFormat.fields) {
            IExportPropConvert propConvert;
            IDataEntityProperty prop = (IDataEntityProperty)entityType.getProperties().get((Object)propName);
            if (prop == null) {
                String[] keys = propName.split("\\.");
                if (keys.length > 1) {
                    prop = (IDataEntityProperty)entityType.getProperties().get((Object)keys[keys.length - 1]);
                }
                if (prop == null) continue;
            }
            if ((propConvert = this.getPropConvert(prop)) == null) continue;
            col = propConvert.initColHeader(entryFormat, col);
        }
        return col > entryFormat.col ? col - 1 : entryFormat.col;
    }

    private void fillParentCellValue(int rowCount) {
        if (!this.getContext().isFillParent()) {
            return;
        }
        if (rowCount <= 1) {
            return;
        }
        int lastCol = this.entryLastCols.get(this.activeRow.getColFormats().name);
        for (int i = 1; i < rowCount; ++i) {
            int toRowIndex = this.activeRow.getRowIndex() + i;
            String[] toRow = this.rowsData.get(toRowIndex);
            for (int col = this.activeRow.getColFormats().col; col <= lastCol; ++col) {
                if (null != toRow) {
                    this.copyCol(toRow, col, this.rowsData.get(this.activeRow.getRowIndex())[col]);
                    continue;
                }
                log.error("get toRow is nul and rowsData is:" + SerializationUtils.toJsonString(this.rowsData));
            }
        }
    }

    private void copyCol(String[] toRow, int col, String value) {
        toRow[col] = value;
    }

    private FieldControlRule getFieldControlRule(long orgId) {
        FieldControlRules fieldControlRules = this.getContext().getFieldControlRules();
        if (fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    class RowMapper {
        private RowMapper parent;
        private DynamicObject activeRow;
        private ExportWriterFormat colFormats;
        private int lastCol;
        private int rowIndex;
        private Map<String, Integer> childRowCounts = new HashMap<String, Integer>();

        public RowMapper(RowMapper parent, DynamicObject activeRow, ExportWriterFormat colFormats, int rowIndex) {
            this.parent = parent;
            this.activeRow = activeRow;
            this.colFormats = colFormats;
            this.rowIndex = rowIndex;
        }

        public RowMapper getParent() {
            return this.parent;
        }

        public DynamicObject getActiveRow() {
            return this.activeRow;
        }

        public ExportWriterFormat getColFormats() {
            return this.colFormats;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public int getLastCol() {
            return this.lastCol;
        }

        public void setLastCol(int lastCol) {
            this.lastCol = lastCol;
        }

        public int genChildCurrRowIndex(String childEntryKey) {
            Integer rowCount = this.childRowCounts.get(childEntryKey);
            if (rowCount == null) {
                rowCount = 0;
            }
            return this.rowIndex + rowCount;
        }

        public int getChildMaxRowCount() {
            if (this.childRowCounts.isEmpty()) {
                return 1;
            }
            Integer rowCount = 1;
            for (Map.Entry<String, Integer> childEntry : this.childRowCounts.entrySet()) {
                if (Integer.compare(rowCount, childEntry.getValue()) >= 0) continue;
                rowCount = childEntry.getValue();
            }
            return rowCount;
        }

        public void addChildRowCount(String childEntryKey, Integer rowCount) {
            Integer oldRowCount = this.childRowCounts.get(childEntryKey);
            if (oldRowCount == null) {
                this.childRowCounts.put(childEntryKey, rowCount);
            } else {
                this.childRowCounts.put(childEntryKey, oldRowCount + rowCount);
            }
        }
    }
}

