/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.ca.CASerializeUtils;
import kd.bos.ca.CAServerFactory;
import kd.bos.ca.CaConfigService;
import kd.bos.ca.ICAService;
import kd.bos.ca.KSign;
import kd.bos.ca.TopESAService;
import kd.bos.ca.bean.VerifySignResult;
import kd.bos.cfca.CFCAServcice;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertInfo;
import kd.bos.entity.ca.SignField;
import kd.bos.entity.ca.SignInfo;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.ca.VerifySignInfo;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.ca.CAModule;
import kd.bos.util.CollectionUtils;

public class SignService {
    private static Log log = LogFactory.getLog(SignService.class);
    private static final String SCHEMEENTITY = "sign_scheme";
    private static final String ORGENTRY = "orgentry";
    private static final String FILTERENTRY = "filterentry";
    private static final String FILTERCONDITION = "filtercondition";
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    static final String TABLE_ORG = "t_bd_signschemeorg";
    static final String SIGNENTITY_ORG = "bos_signscheme_orgentity";
    private static final String DEFAULT_ORGFUNCID = "15";
    private static final String FUSERID = "FuserId";
    private static final String FCLEARTEXT = "FClearText";
    private static final String FSIGNTEXT = "FSignText";
    private static final String FORGID = "FOrgID";
    private static final String FSIGNFIELD = "fsignfield";
    private static final String BOS_BUSINESS_DAO = "bos-business-dao";
    private static final String CAPROVIDER = "caProvider";
    private static final String ENABLE = "enable";
    private static final String FORMNUMBER = "formnumber";
    private static final String SIGNFIELD = "Signfield";
    private static final String SIGNOPERATE = "Signoperate";
    private static final String VERIFYOPETATE = "Verifyoperate";
    private static final String OPKEY = ", opkey:";
    private static final String FORMIDPRE = ", formId:";
    private static final String OPSIGNRESULT = "opSignResult:";
    private static final String ORGID = "orgid";
    private static final String ISINCLUDESUBORG = "isincludesuborg";
    private static final String LONGNUMBER = "longnumber";
    public static final String SIGN_OPCODE_KEY = "OpCode";
    public static final String SIGN_CLEARPIN_KEY = "ClearPin";
    public static final String CA_VERIFY_KEY = "verifySign";
    public static final String CA_CLEARPIN_KEY = "clearPin";
    public static final String CA_SIGN_KEY = "sign";

    public static String getCaLicneseCode(String formId, String productVersion) {
        String licenseCode = "CP_IDA";
        if (StringUtils.isEmpty((Object)productVersion)) {
            return licenseCode;
        }
        float productV = Float.parseFloat(productVersion);
        if ((double)productV < 4.0) {
            return licenseCode;
        }
        QFilter[] qFilters = new QFilter[1];
        QFilter qFilter = new QFilter("number", "=", (Object)formId);
        qFilter.and(ENABLE, "=", (Object)"1");
        qFilters[0] = qFilter;
        Map configMap = BusinessDataReader.loadFromCache((String)"bd_caconfig_license", (QFilter[])qFilters);
        if (configMap == null || configMap.isEmpty()) {
            return licenseCode;
        }
        DynamicObject dynamicObject = (DynamicObject)configMap.values().stream().findFirst().get();
        licenseCode = dynamicObject.getString("licensecode");
        if (StringUtils.isEmpty((Object)licenseCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8bb8\u53ef\u7f16\u7801", (String)"SignService_7", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        }
        return licenseCode;
    }

    public static void writeLog(String formId, Map<Object, Object> signtexts, Map<Object, Object> cleartexts) {
        ORM orm = ORM.create();
        DynamicObject dynamicObject = null;
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Object, Object> entry : signtexts.entrySet()) {
            dynamicObject = orm.newDynamicObject("bd_signmessagelog");
            Object pkId = entry.getKey();
            String signtext = entry.getValue().toString();
            String cleartext = cleartexts.get(pkId).toString();
            dynamicObject.set("formid", (Object)formId);
            dynamicObject.set("businessid", (Object)String.valueOf(pkId));
            dynamicObject.set("signtime", (Object)new Date());
            dynamicObject.set("signer", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("cleartext", (Object)cleartext);
            dynamicObject.set("signtext", (Object)signtext);
            objs.add(dynamicObject);
        }
        orm.insert(objs);
    }

    public static void saveSignMessage(String formId, Map<Object, Object> signtexts, Map<Object, Object> cleartexts) {
        Object signField;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ISimpleProperty pkProp = type.getPrimaryKey();
        String primaryKey = pkProp.getAlias();
        String tableName = type.getAlias() + "_SN";
        DBRoute route = new DBRoute(type.getDBRouteKey());
        ArrayList<SqlParameter> params = null;
        Map<String, Long> pkOrgMap = SignService.collectOrgId(signtexts.keySet(), formId);
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        String signFieldScheme = "";
        if (schemes.size() > 0 && (signField = ((DynamicObject)schemes.get(0)).get("signfield")) != null) {
            signFieldScheme = signField.toString();
        }
        String inserSql = "INSERT INTO " + tableName + "(" + primaryKey + ",FuserId,FClearText,FSignText,FOrgID,fsignfield) VALUES (?,?,?,?,?,?)";
        ArrayList<SqlParameter[]> saveParams = new ArrayList<SqlParameter[]>();
        String updateSql = "UPDATE " + tableName + " SET FClearText = ? , FSignText = ? ,FuserId = ? , FOrgID = ? , fsignfield = ? WHERE " + primaryKey + " = ?";
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>();
        boolean isStringPk = SignService.isStringPk(type);
        Map<Object, SignInfo> signTextMap = SignService.getSignTextMap(signtexts.keySet(), type.getDBRouteKey(), tableName, primaryKey, isStringPk);
        for (Map.Entry<Object, Object> entry : signtexts.entrySet()) {
            Object pkId = entry.getKey();
            String signtext = entry.getValue().toString();
            String cleartext = cleartexts.get(pkId).toString();
            long orgId = pkOrgMap.get(pkId.toString()) == null ? 0L : pkOrgMap.get(pkId.toString());
            SqlParameter pkSqlParam = null;
            if (isStringPk) {
                pkId = pkId.toString();
                pkSqlParam = new SqlParameter(primaryKey, 12, pkId);
            } else {
                pkId = Long.valueOf(pkId.toString());
                pkSqlParam = new SqlParameter(primaryKey, -5, pkId);
            }
            SignInfo signText = signTextMap.get(pkId);
            if (signText == null) {
                params = new ArrayList<SqlParameter>();
                params.add(pkSqlParam);
                params.add(new SqlParameter(FUSERID, 12, (Object)RequestContext.get().getUserId()));
                params.add(new SqlParameter(FCLEARTEXT, 12, (Object)cleartext));
                params.add(new SqlParameter(FSIGNTEXT, 12, (Object)signtext));
                params.add(new SqlParameter(FORGID, -5, (Object)orgId));
                params.add(new SqlParameter(FSIGNFIELD, 12, (Object)signFieldScheme));
                saveParams.add(params.toArray(new SqlParameter[params.size()]));
                continue;
            }
            params = new ArrayList();
            params.add(new SqlParameter(FCLEARTEXT, 12, (Object)cleartext));
            params.add(new SqlParameter(FSIGNTEXT, 12, (Object)signtext));
            params.add(new SqlParameter(FUSERID, 12, (Object)RequestContext.get().getUserId()));
            params.add(new SqlParameter(FORGID, -5, (Object)orgId));
            params.add(new SqlParameter(FSIGNFIELD, 12, (Object)(StringUtils.isEmpty((Object)signText.getSignField()) ? signFieldScheme : signText.getSignField())));
            params.add(pkSqlParam);
            updateParams.add(params.toArray(new SqlParameter[params.size()]));
        }
        try (TXHandle tx = TX.required();){
            if (!saveParams.isEmpty()) {
                DB.executeBatch((DBRoute)route, (String)inserSql, saveParams);
            }
            if (!updateParams.isEmpty()) {
                DB.executeBatch((DBRoute)route, (String)updateSql, updateParams);
            }
        }
    }

    private static Map<String, Long> collectOrgId(Set<Object> pks, String formId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        int dbType = type.getPrimaryKey().getDbType();
        if (dbType == -5) {
            pks = pks.stream().map(pk -> Long.parseLong(pk.toString())).collect(Collectors.toSet());
        }
        HashMap<String, Long> pkOrgMap = new HashMap<String, Long>(16);
        Map entities = BusinessDataReader.loadFromCache((Object[])pks.toArray(), (DynamicObjectType)type);
        for (Map.Entry entry : entities.entrySet()) {
            long orgid = SignService.getOrg(formId, (DynamicObject)entry.getValue());
            pkOrgMap.put(entry.getKey().toString(), orgid);
        }
        return pkOrgMap;
    }

    private static Map<Object, SignInfo> getSignTextMap(Collection<Object> pkIds, String routeKey, String tableName, String primaryKey, boolean isStringPk) {
        if (pkIds.size() <= 0) {
            return new HashMap<Object, SignInfo>(0);
        }
        Object[] pkIdArr = pkIds.stream().map(m -> {
            if (isStringPk) {
                return m.toString();
            }
            return Long.valueOf(m.toString());
        }).toArray();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(primaryKey, new Object[0]).append(",FuserId,FSignText,FClearText,FOrgID,fsignfield  from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(primaryKey, pkIdArr);
        return (Map)DB.query((DBRoute)new DBRoute(routeKey), (SqlBuilder)sqlBuilder, rs -> {
            HashMap<Object, SignInfo> signInfoMap = new HashMap<Object, SignInfo>(pkIds.size());
            while (rs.next()) {
                SignInfo info = new SignInfo();
                Object keyObj = rs.getObject(primaryKey);
                if (keyObj instanceof BigDecimal) {
                    keyObj = ((BigDecimal)keyObj).longValue();
                }
                info.setPkId(keyObj);
                info.setUserId(rs.getString(FUSERID));
                info.setSignText(rs.getString(FSIGNTEXT));
                info.setClearText(rs.getString(FCLEARTEXT));
                info.setOrgId(rs.getObject(FORGID));
                info.setSignField(rs.getString(FSIGNFIELD));
                signInfoMap.put(info.getPkId(), info);
            }
            return signInfoMap;
        });
    }

    public static SignInfo getSignText(String formId, Object pkId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ISimpleProperty primaryKeyProp = type.getPrimaryKey();
        String primaryKey = primaryKeyProp.getAlias();
        String tableName = type.getAlias() + "_SN";
        DBRoute route = new DBRoute(type.getDBRouteKey());
        boolean stringPk = SignService.isStringPk(type);
        pkId = stringPk ? pkId.toString() : Long.valueOf(pkId.toString());
        Map<Object, SignInfo> signTextMap = SignService.getSignTextMap(Stream.of(pkId).collect(Collectors.toList()), route.getRouteKey(), tableName, primaryKey, stringPk);
        return signTextMap.get(pkId);
    }

    public static Map<Object, VerifySignInfo> verifySignByIds(String formId, List<Object> ids) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ORM orm = ORM.create();
        ids = SignService.isStringPk(type) ? ids.stream().map(id -> String.valueOf(id)).collect(Collectors.toList()) : ids.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
        DynamicObjectCollection objs = orm.getByIds(formId, ids);
        Map<Object, VerifySignInfo> verifyInfos = SignService.verifySign(formId, objs);
        log.debug("verifySignByIds:" + CASerializeUtils.toJsonString(verifyInfos) + ", formId :" + formId + ", ids:" + CASerializeUtils.toJsonString(ids));
        return verifyInfos;
    }

    public static Map<Object, VerifySignInfo> verifySign(String formId, DynamicObjectCollection docs) {
        HashMap<Object, VerifySignInfo> verifySignInfos = new HashMap<Object, VerifySignInfo>();
        SignInfo info = null;
        VerifySignInfo verifyInfo = null;
        Map<Object, Object> Texts = SignService.computeDigests(formId, docs);
        Map<Object, Object> clearTexts = null;
        try {
            clearTexts = KSign.calculateSignTexts(Texts);
        }
        catch (Exception e) {
            verifyInfo = new VerifySignInfo();
            verifyInfo.setSuccess(false);
            verifyInfo.setMessage(ResManager.loadKDString((String)"\u9a8c\u7b7e\u65f6\u52a0\u5bc6\u7b7e\u540d\u4fe1\u606f\u5931\u8d25\u3002", (String)"SignService_0", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
            log.error("\u9a8c\u7b7e\u65f6\u52a0\u5bc6\u7b7e\u540d\u4fe1\u606f\u5931\u8d25\u3002Texts:" + CASerializeUtils.toJsonString(Texts), (Throwable)e);
        }
        HashSet<Object> verifyIds = clearTexts == null ? new HashSet() : clearTexts.keySet();
        Map<String, Object> caConfigs = CaConfigService.getCaParameter();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ISimpleProperty pkProp = type.getPrimaryKey();
        String primaryKey = pkProp.getAlias();
        String tableName = type.getAlias() + "_SN";
        boolean stringPk = SignService.isStringPk(type);
        Map<Object, SignInfo> signTextMap = SignService.getSignTextMap(verifyIds, type.getDBRouteKey(), tableName, primaryKey, stringPk);
        for (DynamicObject obj : docs) {
            Object pkId = obj.getPkValue();
            if (verifyIds.contains(pkId)) {
                String cleartext;
                info = signTextMap.get(pkId);
                if (info != null) {
                    verifyInfo = SignService.getPublicKey(info.getUserId());
                    log.debug("getPublicKey:" + CASerializeUtils.toJsonString(verifyInfo) + "info.orgId:" + info.getOrgId());
                } else {
                    verifyInfo = new VerifySignInfo(false, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u8fd8\u672a\u8fdb\u884c\u7b7e\u540d\u3002", (String)"SignService_1", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
                    log.debug("\u8be5\u5355\u636e\u8fd8\u672a\u8fdb\u884c\u7b7e\u540d,formId:" + formId + " ,obj.pk:" + pkId);
                }
                String string = cleartext = clearTexts == null ? "" : (String)clearTexts.get(pkId);
                if (verifyInfo.isSuccess() && info != null) {
                    String serviceClassName = (String)caConfigs.get("CAServiceName");
                    if (StringUtils.isEmpty((Object)serviceClassName)) {
                        Object caProvider = caConfigs.get(CAPROVIDER);
                        int provider = caProvider == null ? 0 : (Integer)caProvider;
                        serviceClassName = provider == 1 ? CFCAServcice.class.getName() : TopESAService.class.getName();
                    }
                    ICAService service = CAServerFactory.getService(serviceClassName);
                    VerifySignResult result = service.verifySign(info.getSignText(), cleartext, verifyInfo.getMessage(), caConfigs);
                    verifyInfo.setSuccess(result.isSuccess());
                    String message = result.getMessage();
                    if (!result.isSuccess() && StringUtils.isEmpty((Object)message)) {
                        message = ResManager.loadKDString((String)"\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d\u5b57\u7b26\u4e32\u662f\u5426\u88ab\u7be1\u6539\u3002", (String)"SignService_6", (String)CAModule.getModuleName(), (Object[])new Object[0]);
                    }
                    verifyInfo.setMessage(message);
                }
                verifySignInfos.put(pkId, verifyInfo);
                continue;
            }
            verifyInfo = new VerifySignInfo(false, ResManager.loadKDString((String)"\u6240\u5728\u7ec4\u7ec7\u4e0d\u5728\u53d7\u63a7\u8303\u56f4\u3002", (String)"SignService_2", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
            verifySignInfos.put(pkId, verifyInfo);
        }
        return verifySignInfos;
    }

    private static boolean isEnableSignOrg(String formId) {
        BillParam billParam = ParameterHelper.getBillParam((String)formId);
        return billParam != null && billParam.getOverallParam() != null && billParam.getOverallParam().isEnableSignOrg();
    }

    public static VerifySignInfo getPublicKey(String userid) {
        VerifySignInfo info = new VerifySignInfo(true);
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("userid", "=", (Object)Long.parseLong(userid))};
        DynamicObjectCollection dynColl = orm.getByFilter("bd_userandcertrelation", filters);
        String publicKey = null;
        if (dynColl != null && !dynColl.isEmpty()) {
            String certid = ((DynamicObject)dynColl.get(0)).getString("certid");
            DynamicObject obj = orm.getById("bd_usercredentials", (Object)Long.parseLong(certid));
            if (obj.get(ENABLE).equals("1")) {
                publicKey = obj.getString("publickey");
                info.setMessage(publicKey);
            } else {
                info.setSuccess(false);
                info.setMessage(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\u3002\u8bc1\u4e66\u5df2\u7981\u7528\u3002", (String)"SignService_3", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
            }
        } else {
            info.setSuccess(false);
            info.setMessage(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\u3002\u672a\u627e\u5230\u8be5\u7528\u6237\u8bc1\u4e66\u3002", (String)"SignService_4", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        }
        return info;
    }

    public static CertInfo getCertInfo(String userid) {
        QFilter[] filters;
        CertInfo info = new CertInfo();
        ORM orm = ORM.create();
        DynamicObjectCollection dynColl = orm.getByFilter("bd_userandcertrelation", filters = new QFilter[]{new QFilter("userid", "=", (Object)Long.parseLong(userid))});
        if (dynColl != null && !dynColl.isEmpty()) {
            String certid = ((DynamicObject)dynColl.get(0)).getString("certid");
            DynamicObject obj = orm.getById("bd_usercredentials", (Object)Long.parseLong(certid));
            info.setPublicKey(obj.getString("publickey"));
            info.setSerialNumber(obj.getString("number"));
            String issue = obj.getString("issue");
            if (StringUtils.isEmpty((Object)issue)) {
                int provider;
                Map<String, Object> caConfigs = CaConfigService.getCaParameter();
                Object caProvider = caConfigs.get(CAPROVIDER);
                int n = provider = caProvider == null ? 0 : (Integer)caProvider;
                if (provider == 2) {
                    info.setCertIssuer("C=CN, O=Tobacco, CN=\u4e91\u5357\u4e2d\u70dfCA");
                }
            } else {
                info.setCertIssuer(issue);
            }
            info.setEnable(obj.getInt(ENABLE));
        }
        return info;
    }

    public static Map<Object, Object> computeDigests(String formId, DynamicObjectCollection docs) {
        DynamicObject scheme;
        HashMap<Object, Object> resultClearTexts = new HashMap<Object, Object>();
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        DynamicObject dynamicObject = scheme = schemes == null || schemes.isEmpty() ? null : (DynamicObject)schemes.get(0);
        if (scheme == null) {
            log.debug("\u8ba1\u7b97\u6570\u636e\u5305\u660e\u6587\u65f6\u52a0\u8f7d\u7b7e\u540d\u65b9\u6848\u4e3a\u7a7a\uff0c\u9000\u51fa\u8ba1\u7b97");
            return resultClearTexts;
        }
        if (SignService.isEnableSignOrg(formId)) {
            return SignService.computeDigestsByGroup(formId, docs, scheme);
        }
        List<SignField> signFieldIds = SignService.getSignField(scheme, null, formId, 0L);
        Map<Object, Map<String, Object>> resultMaps = SignService.getResultMaps(formId, docs, signFieldIds);
        resultClearTexts.putAll(SignService.getClearTextsFromResultMaps(resultMaps));
        return resultClearTexts;
    }

    private static Map<Object, Object> computeDigestsByGroup(String formId, DynamicObjectCollection docs, DynamicObject scheme) {
        HashMap<Object, Object> resultClearTexts = new HashMap<Object, Object>();
        Map<Long, DynamicObjectCollection> docMap = SignService.groupDataEntities(formId, docs);
        Set<Long> subordinateOrgIds = SignService.getSchemeAllSubordinates(scheme, formId);
        for (Map.Entry<Long, DynamicObjectCollection> entry : docMap.entrySet()) {
            long orgId = entry.getKey();
            DynamicObjectCollection orgDocs = entry.getValue();
            List<SignField> signFieldIds = SignService.getSignField(scheme, subordinateOrgIds, formId, orgId);
            if (signFieldIds.isEmpty()) {
                String dataDocs = entry.getValue() == null ? "" : CASerializeUtils.toJsonString(entry.getValue());
                log.warn("form formId\uff1a" + formId + " orgid:" + orgId + " signFields is empty! selected dataEntities[" + dataDocs + "] will skip verifySign.");
                continue;
            }
            Map<Object, Map<String, Object>> resultMaps = SignService.getResultMaps(formId, orgDocs, signFieldIds);
            resultClearTexts.putAll(SignService.getClearTextsFromResultMaps(resultMaps));
        }
        return resultClearTexts;
    }

    private static Map<Object, Object> getClearTextsFromResultMaps(Map<Object, Map<String, Object>> resultMaps) {
        HashMap<Object, Object> clearTexts = new HashMap<Object, Object>(16);
        for (Map.Entry<Object, Map<String, Object>> map : resultMaps.entrySet()) {
            Object id = map.getKey();
            Map<String, Object> value = map.getValue();
            clearTexts.put(id, CASerializeUtils.toJsonString(value));
        }
        return clearTexts;
    }

    private static Map<Object, Map<String, Object>> getResultMaps(DynamicObjectCollection objs, List<SignField> signFieldIds) {
        return SignService.getResultMaps(null, objs, signFieldIds);
    }

    private static Map<Object, Map<String, Object>> getResultMaps(String formId, DynamicObjectCollection objs, List<SignField> signFieldIds) {
        HashMap<Object, Map<String, Object>> resultMaps = new HashMap<Object, Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        List resultEntryMaps = null;
        HashMap<String, Object> resultEntryMap = null;
        List resultSubEntryMaps = null;
        HashMap<String, Object> resultSubEntryMap = null;
        DynamicObjectCollection entrys = null;
        DynamicObjectCollection subEntrys = null;
        String id = null;
        String parentId = null;
        String entryentityId = null;
        String subEntryentityId = null;
        List<Object> pkIds = objs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        Map<Object, List<SignField>> pk2SignFieldMap = SignService.querySignFieldFromSignTable(formId, pkIds);
        List<SignField> currentScheme = signFieldIds;
        try {
            for (DynamicObject obj : objs) {
                resultMap = new HashMap<String, Object>();
                List<SignField> fieldList = pk2SignFieldMap.get(obj.getPkValue());
                signFieldIds = fieldList != null ? fieldList : currentScheme;
                for (SignField signFieldId : signFieldIds) {
                    int j;
                    int i;
                    id = signFieldId.getId();
                    if (id.equals(parentId = signFieldId.getParentId())) {
                        resultMap.put(id, SignService.getFormat(obj.get(id)));
                        continue;
                    }
                    if (id.contains(".")) {
                        parentId = parentId.substring(0, parentId.length() - id.length());
                    }
                    int startIndex = parentId.indexOf(46, 0);
                    int endIndex = parentId.lastIndexOf(46);
                    entryentityId = parentId.substring(0, startIndex);
                    entrys = obj.getDynamicObjectCollection(entryentityId);
                    if (resultMap.get(entryentityId) != null) {
                        resultEntryMaps = (List)resultMap.get(entryentityId);
                    } else {
                        resultEntryMaps = new ArrayList();
                        resultMap.put(entryentityId, resultEntryMaps);
                    }
                    if (startIndex == endIndex) {
                        if (resultEntryMaps.size() == 0) {
                            for (i = 0; i < entrys.size(); ++i) {
                                resultEntryMap = new HashMap<String, Object>();
                                resultEntryMap.put(id, SignService.getFormat(((DynamicObject)entrys.get(i)).get(id)));
                                resultEntryMaps.add(resultEntryMap);
                            }
                            continue;
                        }
                        for (i = 0; i < entrys.size(); ++i) {
                            ((Map)resultEntryMaps.get(i)).put(id, SignService.getFormat(((DynamicObject)entrys.get(i)).get(id)));
                        }
                        continue;
                    }
                    subEntryentityId = parentId.substring(startIndex + 1, endIndex);
                    if (resultEntryMaps.size() == 0) {
                        for (i = 0; i < entrys.size(); ++i) {
                            resultEntryMap = new HashMap(16);
                            resultEntryMaps.add(resultEntryMap);
                            resultSubEntryMaps = new ArrayList(16);
                            resultEntryMap.put(subEntryentityId, resultSubEntryMaps);
                            subEntrys = ((DynamicObject)entrys.get(i)).getDynamicObjectCollection(subEntryentityId);
                            for (j = 0; j < subEntrys.size(); ++j) {
                                resultSubEntryMap = new HashMap(4);
                                resultSubEntryMap.put(id, SignService.getFormat(((DynamicObject)subEntrys.get(j)).get(id)));
                                resultSubEntryMaps.add(resultSubEntryMap);
                            }
                        }
                        continue;
                    }
                    for (i = 0; i < entrys.size(); ++i) {
                        if (((Map)resultEntryMaps.get(i)).get(subEntryentityId) != null) {
                            resultSubEntryMaps = (List)((Map)resultEntryMaps.get(i)).get(subEntryentityId);
                        } else {
                            resultSubEntryMaps = new ArrayList();
                            ((Map)resultEntryMaps.get(i)).put(subEntryentityId, resultSubEntryMaps);
                        }
                        subEntrys = ((DynamicObject)entrys.get(i)).getDynamicObjectCollection(subEntryentityId);
                        if (resultSubEntryMaps.size() == 0) {
                            for (j = 0; j < subEntrys.size(); ++j) {
                                resultSubEntryMap = new HashMap<String, Object>();
                                resultSubEntryMap.put(id, SignService.getFormat(((DynamicObject)subEntrys.get(j)).get(id)));
                                resultSubEntryMaps.add(resultSubEntryMap);
                            }
                            continue;
                        }
                        for (j = 0; j < subEntrys.size(); ++j) {
                            ((Map)resultSubEntryMaps.get(j)).put(id, SignService.getFormat(((DynamicObject)subEntrys.get(j)).get(id)));
                        }
                    }
                }
                resultMaps.put(obj.getPkValue(), resultMap);
            }
        }
        catch (Exception e) {
            SignService.clearSignFieldFromSignTable(formId, objs);
            throw e;
        }
        return resultMaps;
    }

    private static void clearSignFieldFromSignTable(String formId, DynamicObjectCollection objs) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ISimpleProperty pkProp = type.getPrimaryKey();
        String primaryKey = pkProp.getAlias();
        String tableName = type.getAlias() + "_SN";
        DBRoute route = new DBRoute(type.getDBRouteKey());
        String updateSql = "UPDATE " + tableName + " SET fsignfield = '' WHERE " + primaryKey + " = ?";
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(objs.size());
        boolean isStringPk = SignService.isStringPk(type);
        for (DynamicObject obj : objs) {
            Object pkId = obj.getPkValue();
            SqlParameter pkSqlParam = isStringPk ? new SqlParameter(primaryKey, 12, (Object)pkId.toString()) : new SqlParameter(primaryKey, -5, (Object)Long.parseLong(pkId.toString()));
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(1);
            params.add(pkSqlParam);
            updateParams.add(params.toArray(new SqlParameter[0]));
        }
        DB.executeBatch((DBRoute)route, (String)updateSql, updateParams);
    }

    public static Map<Object, List<SignField>> querySignFieldFromSignTable(String formId, List<Object> pkIds) {
        CustomParam customParam = new CustomParam();
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String signFieldScheme = (String)customParameter.get("CA_SIGN_FIELD_SCHEME");
        if ("true".equals(signFieldScheme)) {
            return new HashMap<Object, List<SignField>>(0);
        }
        Map<Object, List<Object>> pk2SignFieldMap = new HashMap<Object, List<SignField>>(pkIds.size());
        if (formId != null) {
            try {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
                ISimpleProperty pkProp = type.getPrimaryKey();
                String primaryKey = pkProp.getAlias();
                String tableName = type.getAlias() + "_SN";
                DBRoute route = new DBRoute(type.getDBRouteKey());
                DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)type.getDBRouteKey(), (String)tableName);
                if (tableSchema == null || tableSchema.getColumns().stream().map(DbMetadataColumn::getName).noneMatch("fsigntext"::equals)) {
                    return pk2SignFieldMap;
                }
                SqlBuilder sql = new SqlBuilder();
                sql.append("select ", new Object[0]).append(primaryKey, new Object[0]).append(" , fsignfield from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(primaryKey, pkIds);
                pk2SignFieldMap = (Map)DB.query((DBRoute)route, (SqlBuilder)sql, resultSet -> {
                    HashMap pk2SignField = new HashMap(pkIds.size());
                    while (resultSet.next()) {
                        List fields;
                        String fSignField = resultSet.getString(FSIGNFIELD);
                        if (StringUtils.isEmpty((Object)fSignField) || com.bes.mq.util.CollectionUtils.isEmpty((Collection)(fields = (List)CASerializeUtils.fromJsonString(fSignField, List.class)))) continue;
                        ArrayList<SignField> fieldList = new ArrayList<SignField>(fields.size());
                        for (Map field : fields) {
                            String fId = field.get("Id") == null ? "" : field.get("Id").toString();
                            String fParentId = field.get("ParentId") == null ? "" : field.get("ParentId").toString();
                            fieldList.add(new SignField(fId, fParentId));
                        }
                        pk2SignField.put(resultSet.getObject(primaryKey), fieldList);
                    }
                    return pk2SignField;
                });
            }
            catch (Throwable b) {
                log.warn("signTable getSignField exception, formId={}", (Object)formId);
            }
        }
        return pk2SignFieldMap;
    }

    private static Object getFormat(Object oldValue) {
        if (oldValue instanceof BigDecimal) {
            oldValue = new BigDecimal(((BigDecimal)oldValue).stripTrailingZeros().toPlainString());
        } else if (oldValue instanceof String) {
            oldValue = oldValue.toString().trim();
        }
        return oldValue;
    }

    public static List<SignField> getSignField(String formId, long orgId) {
        DynamicObject scheme;
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        DynamicObject dynamicObject = scheme = schemes == null || schemes.isEmpty() ? null : (DynamicObject)schemes.get(0);
        if (scheme == null) {
            log.debug(formId + "\u83b7\u53d6\u7b7e\u540d\u5b57\u6bb5\u65f6\u52a0\u8f7d\u7b7e\u540d\u65b9\u6848\u4e3a\u7a7a\uff0c\u9000\u51fa\u8ba1\u7b97");
            return new ArrayList<SignField>();
        }
        return SignService.getSignField(scheme, null, formId, orgId);
    }

    private static List<SignField> getSignField(DynamicObject scheme, Set<Long> subordinateOrgIds, String formId, long orgId) {
        if (StringUtils.isEmpty((Object)formId)) {
            throw new KDException(String.format(ResManager.loadKDString((String)"formId \u4e0d\u80fd\u4e3a\u7a7a\uff0c formId:%s", (String)"SignService_0", (String)"bos-ca", (Object[])new Object[0]), formId));
        }
        ArrayList<SignField> signFieldIds = new ArrayList<SignField>();
        List<Map<String, Object>> signs = null;
        signs = orgId == 0L ? SignService.getSignsNew(scheme, formId) : SignService.getSignsByOrg(scheme, subordinateOrgIds, orgId, formId);
        if (signs == null || signs.isEmpty()) {
            return signFieldIds;
        }
        Map<String, Object> sign = signs.get(0);
        List fields = (List)sign.get(SIGNFIELD);
        if (fields != null && !fields.isEmpty()) {
            for (Map field : fields) {
                String id = field.get("Id") == null ? "" : field.get("Id").toString();
                String parentId = field.get("ParentId") == null ? "" : field.get("ParentId").toString();
                SignField signField = new SignField(id, parentId);
                signFieldIds.add(signField);
            }
        }
        return signFieldIds;
    }

    private static Map<Long, DynamicObjectCollection> groupDataEntities(String formId, DynamicObjectCollection dataEntities) {
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject entity : dataEntities) {
            long orgid = SignService.getOrg(formId, entity);
            if (orgid == 0L) continue;
            DynamicObjectCollection entities = (DynamicObjectCollection)map.get(orgid);
            if (entities == null) {
                entities = new DynamicObjectCollection(entity.getDynamicObjectType(), null);
            }
            entities.add((Object)entity);
            map.put(orgid, entities);
        }
        return map;
    }

    public static SignScheme getSignScheme(String orgId, String formId) {
        if (StringUtils.isEmpty((Object)formId)) {
            throw new KDException(String.format(ResManager.loadKDString((String)"formId \u4e0d\u80fd\u4e3a\u7a7a\uff0c formId:%s", (String)"SignService_0", (String)"bos-ca", (Object[])new Object[0]), formId));
        }
        List<Map<String, Object>> signs = null;
        long orgid = 0L;
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        if (SignService.isEnableSignOrg(formId)) {
            DynamicObject scheme;
            DynamicObject dynamicObject = scheme = schemes == null || schemes.isEmpty() ? null : (DynamicObject)schemes.get(0);
            if (scheme == null) {
                return null;
            }
            orgid = StringUtils.isEmpty((Object)orgId) ? RequestContext.get().getOrgId() : Long.parseLong(orgId);
            Set<Long> subordinateOrgIds = SignService.getSchemeAllSubordinates(scheme, formId);
            signs = SignService.getSignsByOrg(scheme, subordinateOrgIds, orgid, formId);
            if (signs.isEmpty()) {
                return null;
            }
            Map<String, Object> sign = signs.get(0);
            SignScheme signScheme = SignService.getSignScheme(formId, orgid, sign);
            return signScheme;
        }
        SignScheme signScheme = SignService.getSignScheme(formId);
        if (signScheme != null) {
            signScheme.setOrg(orgid);
        }
        return signScheme;
    }

    public static SignScheme getSignScheme(String formId) {
        List<Map<String, Object>> signs = SignService.getSignsNew(formId);
        if (signs.isEmpty()) {
            return null;
        }
        Map<String, Object> sign = signs.get(0);
        SignScheme signScheme = SignService.getSignScheme(formId, 0L, sign);
        return signScheme;
    }

    private static SignScheme getSignScheme(String formId, long orgid, Map<String, Object> sign) {
        String signField = sign.get(SIGNFIELD) == null ? "" : CASerializeUtils.toJsonString(sign.get(SIGNFIELD));
        String signOperate = sign.get(SIGNOPERATE) == null ? "" : (String)sign.get(SIGNOPERATE);
        String verifyOperate = sign.get(VERIFYOPETATE) == null ? "" : (String)sign.get(VERIFYOPETATE);
        SignScheme signScheme = new SignScheme(formId, "", orgid, signField, SignService.getSignOperates(signOperate), verifyOperate);
        return signScheme;
    }

    public static Map<String, Boolean> getOpSignResult(String formId, String opKey, DynamicObjectCollection dataEntities) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(CA_SIGN_KEY, Boolean.FALSE);
        result.put(CA_CLEARPIN_KEY, Boolean.TRUE);
        result.put(CA_VERIFY_KEY, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return result;
        }
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        if (schemes == null || schemes.isEmpty()) {
            return result;
        }
        return SignService.getOpSignResult(formId, opKey, dataEntities, schemes);
    }

    private static Map<String, Boolean> getOpSignResult(String formId, String opKey, DynamicObjectCollection dataEntities, DynamicObjectCollection schemes) {
        if (dataEntities == null || dataEntities.isEmpty() || !SignService.isEnableSignOrg(formId)) {
            return SignService.getOpSignResultSingle(schemes, formId, opKey);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(CA_SIGN_KEY, Boolean.FALSE);
        result.put(CA_VERIFY_KEY, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return result;
        }
        Map<Long, DynamicObjectCollection> entityMap = SignService.groupDataEntities(formId, dataEntities);
        DynamicObject scheme = (DynamicObject)schemes.get(0);
        Set<Long> subordinateOrgIds = SignService.getSchemeAllSubordinates(scheme, formId);
        for (Map.Entry<Long, DynamicObjectCollection> entry : entityMap.entrySet()) {
            long orgid = entry.getKey();
            List<Map<String, Object>> signs = SignService.getSignsByOrg(scheme, subordinateOrgIds, orgid, formId);
            if (signs.isEmpty()) continue;
            Tuple<Boolean, Boolean> signTuple = SignService.parseSign(signs, opKey);
            result.put(CA_SIGN_KEY, (Boolean)signTuple.item1);
            result.put(CA_CLEARPIN_KEY, (Boolean)signTuple.item2);
            result.put(CA_VERIFY_KEY, SignService.parseVerify(signs, opKey));
            log.debug(OPSIGNRESULT + CASerializeUtils.toJsonString(result) + FORMIDPRE + formId + OPKEY + opKey);
            return result;
        }
        return result;
    }

    public static Map<String, Boolean> getOpSignResultSingle(String formId, String opKey) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(CA_SIGN_KEY, Boolean.FALSE);
        result.put(CA_VERIFY_KEY, Boolean.FALSE);
        if (StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return result;
        }
        List<Map<String, Object>> signs = SignService.getSignsNew(formId);
        Tuple<Boolean, Boolean> signTuple = SignService.parseSign(signs, opKey);
        result.put(CA_SIGN_KEY, (Boolean)signTuple.item1);
        result.put(CA_CLEARPIN_KEY, (Boolean)signTuple.item2);
        result.put(CA_VERIFY_KEY, SignService.parseVerify(signs, opKey));
        return result;
    }

    private static Map<String, Boolean> getOpSignResultSingle(DynamicObjectCollection schemes, String formId, String opKey) {
        DynamicObject scheme;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(CA_SIGN_KEY, Boolean.FALSE);
        result.put(CA_VERIFY_KEY, Boolean.FALSE);
        DynamicObject dynamicObject = scheme = schemes == null || schemes.isEmpty() ? null : (DynamicObject)schemes.get(0);
        if (scheme == null || StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return result;
        }
        List<Map<String, Object>> signs = SignService.getSignsNew(scheme, formId);
        Tuple<Boolean, Boolean> signTuple = SignService.parseSign(signs, opKey);
        result.put(CA_SIGN_KEY, (Boolean)signTuple.item1);
        result.put(CA_CLEARPIN_KEY, (Boolean)signTuple.item2);
        result.put(CA_VERIFY_KEY, SignService.parseVerify(signs, opKey));
        return result;
    }

    private static boolean parseVerify(List<Map<String, Object>> signs, String opKey) {
        Map<String, Object> sign;
        String operations;
        if (signs.size() > 0 && !StringUtils.isEmpty((Object)(operations = (String)(sign = signs.get(0)).get(VERIFYOPETATE)))) {
            for (String operation : operations.split(",")) {
                if (!opKey.equals(operation)) continue;
                return true;
            }
        }
        return false;
    }

    private static Tuple<Boolean, Boolean> parseSign(List<Map<String, Object>> signs, String opKey) {
        if (signs.size() > 0) {
            Map<String, Object> sign = signs.get(0);
            String operations = (String)sign.get(SIGNOPERATE);
            List<Map<String, Object>> signOperates = SignService.getSignOperates(operations);
            if (CollectionUtils.isEmpty(signOperates)) {
                return new Tuple((Object)false, (Object)true);
            }
            for (Map<String, Object> opMap : signOperates) {
                String signOpCode = String.valueOf(opMap.get(SIGN_OPCODE_KEY));
                Object clearPin = opMap.getOrDefault(SIGN_CLEARPIN_KEY, false);
                if (!opKey.equals(signOpCode)) continue;
                return new Tuple((Object)true, (Object)Boolean.parseBoolean(String.valueOf(clearPin)));
            }
        }
        return new Tuple((Object)false, (Object)true);
    }

    public static List<Map<String, Object>> getSignOperates(String signOperate) {
        ArrayList<Map<String, Object>> signOperateList;
        if (signOperate.startsWith("[{") && signOperate.endsWith("}]")) {
            signOperateList = (ArrayList<Map<String, Object>>)SerializationUtils.fromJsonString((String)signOperate, List.class);
        } else {
            String[] split = signOperate.split(",");
            signOperateList = new ArrayList<Map<String, Object>>(4);
            for (String op : split) {
                HashMap<String, Object> opMap = new HashMap<String, Object>();
                opMap.put(SIGN_OPCODE_KEY, op);
                opMap.put(SIGN_CLEARPIN_KEY, true);
                signOperateList.add(opMap);
            }
        }
        return signOperateList;
    }

    public static List<Map<String, Object>> getSignsNew(String formId) {
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        if (schemes == null || schemes.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject scheme = (DynamicObject)schemes.get(0);
        return SignService.getSignsNew(scheme, formId);
    }

    private static List<Map<String, Object>> getSignsNew(DynamicObject scheme, String formId) {
        if (scheme == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return SignService.getSignFromScheme(scheme);
    }

    private static List<Map<String, Object>> getSignsByOrg(DynamicObject scheme, Set<Long> subordinateOrgIds, long orgid, String formId) {
        if (SignService.isEnableSignOrg(formId)) {
            Set<Long> orgList = SignService.getOrgIdsFromScheme(scheme);
            if (SignService.isMatchOrg(orgList, subordinateOrgIds, orgid, formId)) {
                return SignService.getSignFromScheme(scheme);
            }
            return new ArrayList<Map<String, Object>>();
        }
        return SignService.getSignFromScheme(scheme);
    }

    private static boolean isMatchOrg(Set<Long> orgList, Set<Long> subordinateOrgIds, long orgid, String formId) {
        if (orgList == null || orgList.isEmpty()) {
            return false;
        }
        if (orgList.contains(orgid)) {
            return true;
        }
        return subordinateOrgIds.contains(orgid);
    }

    private static Set<Long> getSchemeAllSubordinates(DynamicObject scheme, String formId) {
        HashSet<Long> schemeSubordinates = new HashSet<Long>();
        if (scheme == null) {
            return schemeSubordinates;
        }
        DynamicObjectCollection orgEntry = scheme.getDynamicObjectCollection(ORGENTRY);
        if (orgEntry == null || orgEntry.isEmpty()) {
            return schemeSubordinates;
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (DynamicObject entry : orgEntry) {
            boolean isincludesuborg;
            DynamicObject org;
            if (entry == null || (org = entry.getDynamicObject(ORGID)) == null || !(isincludesuborg = entry.getBoolean(ISINCLUDESUBORG))) continue;
            orgList.add((Long)org.getPkValue());
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List subordinateIds = orgService.getAllSubordinateOrgs(Long.valueOf(Long.parseLong(SignService.getOrgFuncId(formId))), orgList, false);
        schemeSubordinates.addAll(subordinateIds);
        return schemeSubordinates;
    }

    private static Set<Long> getOrgIdsFromScheme(DynamicObject scheme) {
        HashSet<Long> orgList = new HashSet<Long>();
        if (scheme == null) {
            return orgList;
        }
        DynamicObjectCollection orgEntry = scheme.getDynamicObjectCollection(ORGENTRY);
        if (orgEntry == null || orgEntry.isEmpty()) {
            return orgList;
        }
        for (DynamicObject entry : orgEntry) {
            DynamicObject org;
            if (entry == null || (org = entry.getDynamicObject(ORGID)) == null) continue;
            orgList.add((Long)org.getPkValue());
        }
        return orgList;
    }

    private static DynamicObjectCollection queryScheme(String entityName, QFilter[] filters) {
        Map schemeMaps = new HashMap();
        try {
            schemeMaps = BusinessDataReader.loadFromCache((String)entityName, (QFilter[])filters);
        }
        catch (Exception e) {
            SignService.syncOrgEntry(entityName, filters);
            schemeMaps = BusinessDataReader.loadFromCache((String)entityName, (QFilter[])filters);
        }
        DynamicObjectCollection schemes = new DynamicObjectCollection();
        if (schemeMaps != null && !schemeMaps.isEmpty()) {
            schemes.addAll(schemeMaps.values());
        }
        return schemes;
    }

    private static List<Map<String, Object>> getSignFromScheme(DynamicObject scheme) {
        ArrayList<Map<String, Object>> signs = new ArrayList<Map<String, Object>>();
        if (scheme == null) {
            log.warn("\u672a\u627e\u5230\u5339\u914d\u7684\u5f53\u524d\u7ec4\u7ec7\u7684\u65b9\u6848\u3002");
            return signs;
        }
        String signFieldStr = scheme.getString(SIGNFIELD);
        List signField = new ArrayList();
        if (!StringUtils.isEmpty((Object)signFieldStr)) {
            signField = (List)CASerializeUtils.fromJsonString(signFieldStr, List.class);
        }
        String signOperateStr = scheme.getString(SIGNOPERATE);
        String verifyOperateStr = scheme.getString(VERIFYOPETATE);
        HashMap<String, Object> signFieldMap = new HashMap<String, Object>();
        signFieldMap.put(SIGNFIELD, signField);
        signFieldMap.put(SIGNOPERATE, signOperateStr);
        signFieldMap.put(VERIFYOPETATE, verifyOperateStr);
        signs.add(signFieldMap);
        return signs;
    }

    private static long getOrg(String formId, DynamicObject dataEntity) {
        BillEntityType dt;
        MainEntityType idt;
        Long userOrgId = 0L;
        if (dataEntity != null && (idt = EntityMetadataCache.getDataEntityType((String)formId)) instanceof BillEntityType && (dt = (BillEntityType)idt).getMainOrgProperty() != null && dataEntity.getDynamicObject(dt.getMainOrgProperty().getName()) != null) {
            userOrgId = (Long)dataEntity.getDynamicObject(dt.getMainOrgProperty().getName()).getPkValue();
        }
        if (userOrgId == 0L) {
            log.warn("\u5355\u636e\u4e3b\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u5c06\u4f7f\u7528\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u7ec4\uff1a" + RequestContext.get().getOrgId());
            userOrgId = RequestContext.get().getOrgId();
        }
        return userOrgId;
    }

    private static String getOrgFuncId(String formId) {
        if (StringUtils.isEmpty((Object)formId)) {
            return DEFAULT_ORGFUNCID;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        if (dataEntityType == null) {
            return DEFAULT_ORGFUNCID;
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isEmpty((Object)mainOrg)) {
            return DEFAULT_ORGFUNCID;
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return DEFAULT_ORGFUNCID;
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isEmpty((Object)orgfuncid) ? DEFAULT_ORGFUNCID : orgfuncid;
    }

    public static FilterBuilder getSignSchemeFilter(String formId) {
        QFilter[] qFilter = new QFilter[]{new QFilter(FORMNUMBER, "=", (Object)formId)};
        DynamicObjectCollection schemes = SignService.queryScheme(SCHEMEENTITY, qFilter);
        if (schemes == null || schemes.isEmpty()) {
            return null;
        }
        DynamicObject scheme = (DynamicObject)schemes.get(0);
        if (scheme == null) {
            return null;
        }
        DynamicObjectCollection filterEntry = scheme.getDynamicObjectCollection(FILTERENTRY);
        for (DynamicObject filter : filterEntry) {
            boolean enable;
            if (filter == null) continue;
            boolean bl = enable = filter.get(ENABLE) == null ? false : filter.getBoolean(ENABLE);
            if (!enable) continue;
            String filterStr = filter.getString(FILTERCONDITION);
            String filterType = filter.getString("filtertype");
            if (StringUtils.isEmpty((Object)filterStr) || StringUtils.isEmpty((Object)filterType) || !"1".equals(filterType)) continue;
            FilterCondition filterCondition = (FilterCondition)CASerializeUtils.fromJsonString(filterStr, FilterCondition.class);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            return filterBuilder;
        }
        return null;
    }

    private static List<Object> getFilterData(DynamicObjectType type, QFilter[] filters) {
        ArrayList<Object> idList = new ArrayList<Object>();
        try (DataSet ds = ORM.create().queryDataSet("SignService", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return idList;
    }

    private static void syncOrgEntry(String entityName, QFilter[] filters) {
        String selectFileds;
        ORM orm = ORM.create();
        DynamicObjectCollection cols = orm.query(SCHEMEENTITY, selectFileds = "id, formnumber, signfield, signoperate, verifyoperate, orgentry.orgid orgid, orgentry.isincludesuborg isincludesuborg", filters);
        if (cols == null || cols.isEmpty()) {
            return;
        }
        String id = ((DynamicObject)cols.get(0)).getString("id");
        Object[] orgs = new DynamicObject[cols.size()];
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)SIGNENTITY_ORG);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject col = (DynamicObject)cols.get(i);
            DynamicObject org = new DynamicObject((DynamicObjectType)dt);
            org.set("id", (Object)id);
            org.set(ORGID, col.get(ORGID));
            org.set(ISINCLUDESUBORG, col.get(ISINCLUDESUBORG));
            orgs[i] = org;
        }
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", 1, (Object)id)};
                String SQL = String.format("delete from %s where Fid = ?;", TABLE_ORG);
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])orgs);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    @Deprecated
    public static Map<String, Boolean> getOpSignResultSingle(String formId, String opKey, DynamicObject dataEntity) {
        return SignService.getOpSignResultSingle(formId, opKey);
    }

    @Deprecated
    public static DynamicObject[] buildDataEntityByFilter(String formId, String opKey, DynamicObject[] successObjs) {
        if (successObjs == null || successObjs.length <= 0 || "save".equals(opKey)) {
            return successObjs;
        }
        DynamicObjectCollection cols = new DynamicObjectCollection();
        cols.addAll(Arrays.asList(successObjs));
        Map<String, Boolean> signResult = SignService.getOpSignResult(formId, opKey, cols);
        boolean sign = signResult.get(CA_SIGN_KEY);
        boolean verifySign = signResult.get(CA_VERIFY_KEY);
        if (sign || verifySign) {
            FilterBuilder filterBuilder = SignService.getSignSchemeFilter(formId);
            if (filterBuilder == null) {
                return successObjs;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            String pk = dt.getPrimaryKey().getName();
            ArrayList<Object> pkIds = new ArrayList<Object>();
            for (DynamicObject col : cols) {
                pkIds.add(col.getPkValue());
            }
            ArrayList<Object> filterIds = new ArrayList<Object>();
            filterBuilder.buildFilter(true);
            QFilter[] qFilters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pk, "in", pkIds)};
            filterIds.addAll(SignService.getFilterData((DynamicObjectType)dt, qFilters));
            ArrayList<DynamicObject> newCols = new ArrayList<DynamicObject>();
            for (DynamicObject col : cols) {
                Object pkId = col.getPkValue();
                if (!filterIds.contains(pkId)) continue;
                newCols.add(col);
            }
            DynamicObject[] filterObjs = new DynamicObject[newCols.size()];
            filterObjs = newCols.toArray(filterObjs);
            return filterObjs;
        }
        return successObjs;
    }

    @Deprecated
    public static boolean isSign(String formId, String opKey) {
        if (StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return false;
        }
        List<Map<String, Object>> signs = SignService.getSignsNew(formId);
        Tuple<Boolean, Boolean> signTuple = SignService.parseSign(signs, opKey);
        return (Boolean)signTuple.item1;
    }

    @Deprecated
    public static boolean isVerify(String formId, String opKey) {
        if (StringUtils.isEmpty((Object)formId) || StringUtils.isEmpty((Object)opKey)) {
            return false;
        }
        List<Map<String, Object>> signs = SignService.getSignsNew(formId);
        return SignService.parseVerify(signs, opKey);
    }

    @Deprecated
    public static List<Map<String, Object>> getSigns(String formId) {
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("FFORMNUMBER", 12, (Object)formId), new SqlParameter(FORGID, 12, (Object)RequestContext.get().getOrgId())};
        String sql = "select FSIGNFIELD, FSIGNOPERATE, FVERIFYOPERATE, FORGID from T_BD_SIGNSCHEME where FFORMNUMBER = ? and FORGID = ?";
        List signs = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParams, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){
            private List<Map<String, Object>> signs = new ArrayList<Map<String, Object>>();

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String signFieldStr = rs.getString(1);
                    List signField = (List)CASerializeUtils.fromJsonString(signFieldStr, List.class);
                    String signOperateStr = rs.getString(2);
                    String verifyOperateStr = rs.getString(3);
                    HashMap<String, Object> signFieldMap = new HashMap<String, Object>();
                    signFieldMap.put(SignService.SIGNFIELD, signField);
                    signFieldMap.put(SignService.SIGNOPERATE, signOperateStr);
                    signFieldMap.put(SignService.VERIFYOPETATE, verifyOperateStr);
                    this.signs.add(signFieldMap);
                }
                return this.signs;
            }
        });
        return signs;
    }

    @Deprecated
    public static List<Map<String, Object>> getSignsNew(String formId, DynamicObject dataEntity) {
        return SignService.getSignsNew(formId);
    }

    @Deprecated
    public static boolean isSubOrg(String orgFunction, Long subOrgID, Long superiorOrgID) {
        boolean isSubOrg = false;
        String subOrgLongNumber = null;
        String superiorOrgLongNumber = null;
        String selectFields = "id, org.id orgId, longnumber";
        QFilter viewFilter = new QFilter("view.treetype", "=", (Object)orgFunction);
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)"1");
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(subOrgID);
        orgIdList.add(superiorOrgID);
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter[] filters = new QFilter[]{viewFilter, isDefaultViewFilter, orgFilter};
        DynamicObjectCollection orgCollection = ORM.create().query(ENTITYID_ORG_STRUCTURE, selectFields, filters);
        if (orgCollection == null || orgCollection.size() != 2) {
            return isSubOrg;
        }
        if (subOrgID.equals(((DynamicObject)orgCollection.get(0)).getLong(ORGID))) {
            subOrgLongNumber = ((DynamicObject)orgCollection.get(0)).getString(LONGNUMBER);
            superiorOrgLongNumber = ((DynamicObject)orgCollection.get(1)).getString(LONGNUMBER);
        } else {
            subOrgLongNumber = ((DynamicObject)orgCollection.get(1)).getString(LONGNUMBER);
            superiorOrgLongNumber = ((DynamicObject)orgCollection.get(0)).getString(LONGNUMBER);
        }
        if (StringUtils.isEmpty((Object)subOrgLongNumber) || StringUtils.isEmpty((Object)superiorOrgLongNumber)) {
            return isSubOrg;
        }
        if (subOrgLongNumber.startsWith(superiorOrgLongNumber + '!')) {
            isSubOrg = true;
        }
        return isSubOrg;
    }

    private static boolean isStringPk(MainEntityType type) {
        ISimpleProperty pkProp = type.getPrimaryKey();
        return pkProp instanceof VarcharProp;
    }
}

