/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca.operate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.ca.operate.SignOperateService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.SignField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.service.operation.EntityOperateService;

public class SignEntityOperateFacade
implements IEntityLifecycleFacade {
    private final SignOperateService signOperateService = new SignOperateService();
    private static final String SIGN_CALLBACK_FLAG = "signCallbackFlag";
    private MainEntityType billEntityType;
    private boolean existScheme;

    public FacadeResult doExecute(Map<String, Object> params) {
        FacadeResult result = new FacadeResult();
        String operationKey = (String)params.get("operationKey");
        MainEntityType mainEntityType = (MainEntityType)params.get("mainEntityType");
        OperationResult operationResult = (OperationResult)params.get("operationResult");
        OperateOption option = (OperateOption)params.get("option");
        DynamicObject[] dataEntities = (DynamicObject[])params.get("dataEntities");
        result.setSuccess(true);
        boolean signVerify = this.signOperateService.signVerify(operationKey, mainEntityType, operationResult, option, dataEntities);
        result.setCode(signVerify ? 3 : 6);
        return result;
    }

    public FacadeResult callOperation(Map<String, Object> params) {
        FacadeResult facadeResult = new FacadeResult();
        OperateOption option = (OperateOption)params.get("option");
        if (Boolean.parseBoolean(option.getVariableValue("sign")) && Boolean.parseBoolean((String)option.getVariables().get(SIGN_CALLBACK_FLAG))) {
            MainEntityType billEntityType = (MainEntityType)params.get("billEntityType");
            DynamicObject[] objs = (DynamicObject[])params.get("objs");
            this.signOperateService.saveSignInfo(billEntityType, option, objs);
        }
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        return facadeResult;
    }

    public FacadeResult afterPreparePropertysFirst(Map<String, Object> params) {
        FacadeResult facadeResult = new FacadeResult();
        String formId = (String)params.get("formId");
        long orgId = params.get("orgId") == null ? 0L : (Long)params.get("orgId");
        OperateOption option = (OperateOption)params.get("option");
        this.billEntityType = (MainEntityType)params.get("billEntityType");
        List fieldKeys = (List)params.get("fieldKeys");
        List<SignField> fields = this.signOperateService.getSignField(formId, orgId);
        if (!fields.isEmpty()) {
            this.existScheme = true;
        }
        if (!fields.isEmpty() && !Boolean.parseBoolean((String)option.getVariables().get(SIGN_CALLBACK_FLAG)) && this.billEntityType instanceof BillEntityType) {
            for (SignField field : fields) {
                fieldKeys.add(field.getId());
            }
        }
        if (!fields.isEmpty()) {
            fieldKeys.addAll(this.signOperateService.getFilterFields(this.billEntityType));
        }
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        return facadeResult;
    }

    public FacadeResult afterPreparePropertys(Map<String, Object> params) {
        FacadeResult facadeResult = new FacadeResult();
        if (!this.existScheme) {
            facadeResult.setSuccess(true);
            facadeResult.setCode(3);
            return facadeResult;
        }
        Object[] ids = (Object[])params.get("ids");
        List fieldKeys = (List)params.get("fieldKeys");
        EntityOperateService owner = (EntityOperateService)params.get("owner");
        Map variables = owner.getOption().getVariables();
        List<SignField> fields = this.signOperateService.getSignFieldFromSignTable(this.billEntityType.getName(), Arrays.asList(ids));
        if (!fields.isEmpty() && !Boolean.parseBoolean((String)variables.get(SIGN_CALLBACK_FLAG)) && this.billEntityType instanceof BillEntityType) {
            for (SignField field : fields) {
                if (fieldKeys.contains(field.getId())) continue;
                fieldKeys.add(field.getId());
            }
        }
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        return facadeResult;
    }
}

