/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca.operate;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.ca.CaConfigService;
import kd.bos.ca.ISignFormOperateService;
import kd.bos.ca.KSign;
import kd.bos.ca.SignService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.LoadingType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertInfo;
import kd.bos.entity.ca.SignField;
import kd.bos.entity.ca.VerifySignInfo;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientCallbackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.service.filter.SignSchemeFilterService;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class SignOperateService
implements ISignFormOperateService {
    private static Log log = LogFactory.getLog(SignOperateService.class);
    private static final String SIGN_VERIFY = "signVerify()";
    private static final String SIGN_CALLBACK_FLAG = "signCallbackFlag";
    private static final String BILL_PARAM_OP_EXECUTE_LOG = "opexecutelog";
    private OperateLog operateLog;

    private OperateLog getOperateLog(String formId) {
        if (this.operateLog == null) {
            DynamicObject billParamObj = ParameterReader.getBillParameter((String)formId);
            boolean opExecuteLog = false;
            if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BILL_PARAM_OP_EXECUTE_LOG)) {
                opExecuteLog = billParamObj.getBoolean(BILL_PARAM_OP_EXECUTE_LOG);
            }
            this.operateLog = OperateLog.get((boolean)opExecuteLog);
        }
        return this.operateLog;
    }

    public List<String> getFilterFields(MainEntityType mainEntityType) {
        return SignSchemeFilterService.getFilterFields(mainEntityType);
    }

    public List<SignField> getSignField(String formId, long orgId) {
        return SignService.getSignField(formId, orgId);
    }

    public List<SignField> getSignFieldFromSignTable(String formId, List<Object> pkIds) {
        Map<Object, List<SignField>> pk2SignFields = SignService.querySignFieldFromSignTable(formId, pkIds);
        return pk2SignFields.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean afterSignOperation(IFormView view, String opKey, OperationResult opResult, OperateOption operateOption) {
        boolean signCallbackFlag = Boolean.parseBoolean((String)operateOption.getVariables().get(SIGN_CALLBACK_FLAG));
        if (opResult != null && !opResult.isSuccess() && opResult.isNeedSign() && !signCallbackFlag) {
            this.sign(view, opKey, opResult, operateOption);
            return false;
        }
        return true;
    }

    @Override
    public void sign(IFormView view, String opKey, OperationResult opResult, OperateOption operateOption) {
        Map clearTexts = (Map)SerializationUtils.fromJsonString((String)opResult.getClearText(), Map.class);
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(clearTexts.get("hasUnSignData"))) {
            opResult.setSuccess(false);
            view.showErrorNotification((String)clearTexts.get("hasUnSignData"));
            return;
        }
        Map<Object, Object> signText = null;
        try {
            signText = KSign.calculateSignTexts(clearTexts);
        }
        catch (Exception e) {
            opResult.setSuccess(false);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u6570\u636e\u8ba1\u7b97\u52a0\u5bc6\u5931\u8d25%s", (String)"SignOperateService_3", (String)"bos-ca", (Object[])new Object[0]), e.getMessage()));
        }
        CertInfo info = SignService.getCertInfo(RequestContext.get().getUserId());
        if (info.getSerialNumber() == null) {
            opResult.setSuccess(false);
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u8bc1\u4e66\u3002", (String)"SignOperateService_4", (String)"bos-ca", (Object[])new Object[0]));
            return;
        }
        if (info.getEnable() == 0) {
            opResult.setSuccess(false);
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8bc1\u4e66\u5df2\u88ab\u7981\u7528\u3002", (String)"SignOperateService_6", (String)"bos-ca", (Object[])new Object[0]));
            return;
        }
        args.put("signText", signText);
        args.put("serialNumber", info.getSerialNumber());
        args.put("issue", info.getCertIssuer());
        String clearPin = operateOption.getVariableValue("clearPin", "true");
        args.put("clearPin", Boolean.parseBoolean(clearPin));
        cache.put("clearText", opResult.getClearText());
        ClientCallbackListener listener = new ClientCallbackListener();
        ArrayList<ClientCallback> list = new ArrayList<ClientCallback>();
        list.add(new ClientCallback(opKey));
        Map variables = operateOption.getVariables();
        HashMap newVariables = new HashMap(variables);
        newVariables.remove("bos_skip_op_batch");
        listener.setOptionVariables(newVariables);
        listener.setListCallBack(list);
        if (this.needShowLoading()) {
            String msg = ResManager.loadKDString((String)"%s\u64cd\u4f5c\u6267\u884c\u4e2d", (String)"SignOperateService_0", (String)"bos-ca", (Object[])new Object[0]);
            msg = String.format(msg, operateOption.getVariableValue("operateName"));
            this.showLoading(view, msg, true);
        }
        view.executeClientMethodCallback("sign", args, listener);
        opResult.setShowMessage(false);
    }

    @Override
    public Map<String, Object> getCaConfig() {
        return CaConfigService.getCaConfig();
    }

    private boolean needShowLoading() {
        return true;
    }

    private void showLoading(IFormView view, String msg, boolean visible) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("text", msg);
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", visible);
        paraMap.put("pageId", view.getPageId());
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setPageLoading", paraMap);
    }

    public boolean signVerify(String operationKey, MainEntityType mainEntityType, OperationResult operationResult, OperateOption operateOption, DynamicObject[] outSuccessObjs) {
        OperateLog operateLog = this.getOperateLog(mainEntityType.getName());
        operateLog.beginMothed(SIGN_VERIFY, null);
        boolean cancleCaSign = Boolean.parseBoolean((String)operateOption.getVariables().get("cancle_standard_caSign"));
        boolean cancleCaVerify = Boolean.parseBoolean((String)operateOption.getVariables().get("cancle_standard_caVerify"));
        if (cancleCaSign && cancleCaVerify) {
            operateOption.setVariableValue("sign", "false");
            return true;
        }
        int length = outSuccessObjs == null ? 0 : outSuccessObjs.length;
        DynamicObject[] successObjs = SignSchemeFilterService.getDataBySignFilter(mainEntityType, operationKey, outSuccessObjs);
        if (successObjs == null || successObjs.length <= 0) {
            operateOption.setVariableValue("sign", "false");
            operateLog.endMothed(SIGN_VERIFY, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53:%1$s\uff0c\u64cd\u4f5ckey:%2$s\uff0c\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u5305\uff1a%3$s\u6761\uff0c\u7b26\u5408\u7b7e\u540d\u6761\u4ef6\u7684\u64cd\u4f5c\u5b9e\u4f53\u6570\u636e\u5305\u4e3a\u7a7a\u4e0d\u7b7e\u540d\u9a8c\u7b7e", (String)"SignOperateService_1", (String)"bos-ca", (Object[])new Object[0]), mainEntityType.getName(), operationKey, length));
            return true;
        }
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.addAll(Arrays.asList(successObjs));
        ArrayList<Object> ids = new ArrayList<Object>(successObjs.length);
        for (DynamicObject successObj : successObjs) {
            ids.add(successObj.getPkValue());
        }
        Map<String, Boolean> signFlag = SignService.getOpSignResult(mainEntityType.getName(), operationKey, col);
        boolean sign = signFlag.get("sign");
        boolean clearPin = signFlag.getOrDefault("clearPin", true);
        boolean verifySign = signFlag.get("verifySign");
        operateOption.setVariableValue("sign", String.valueOf(sign));
        operateOption.setVariableValue("clearPin", String.valueOf(clearPin));
        if (!cancleCaVerify && verifySign && !this.verifySign(mainEntityType, ids, operationResult, operateLog)) {
            return false;
        }
        if (!cancleCaSign && sign && !Boolean.parseBoolean((String)operateOption.getVariables().get(SIGN_CALLBACK_FLAG))) {
            String productVersion;
            String formId = mainEntityType.getName();
            String licenseCode = SignService.getCaLicneseCode(formId, productVersion = LicenseServiceHelper.getProductVersion());
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)licenseCode);
            if (!result.getHasLicense().booleanValue()) {
                operationResult.setSuccess(false);
                operationResult.setShowMessage(true);
                operationResult.setMessage(result.getMsg());
                operateLog.endMothed(SIGN_VERIFY, null);
                return false;
            }
            try {
                this.signBillData(mainEntityType, operationResult, successObjs, operateLog);
            }
            catch (Exception e2) {
                operationResult.setSuccess(false);
                operationResult.setShowMessage(true);
                operationResult.setMessage(e2.getMessage());
            }
            operateLog.endMothed(SIGN_VERIFY, null);
            return false;
        }
        operateLog.endMothed(SIGN_VERIFY, null);
        return true;
    }

    public void saveSignInfo(MainEntityType entityType, OperateOption operateOption, DynamicObject[] successObjs) {
        OperateLog operateLog = this.getOperateLog(entityType.getName());
        operateLog.beginMothed("saveSignInfo()", null);
        HashMap<Object, Object> signTexts = new HashMap();
        Map<Object, Object> clearTexts = new HashMap<Object, Object>();
        Map signResult = (Map)SerializationUtils.fromJsonString((String)operateOption.getVariableValue("signResult"), Map.class);
        Map clearResult = (Map)SerializationUtils.fromJsonString((String)operateOption.getVariableValue("clearResult"), Map.class);
        String formId = entityType.getName();
        boolean firstSave = Boolean.parseBoolean(operateOption.getVariableValue("signFirstSave"));
        if (firstSave) {
            String entryKey = "0";
            ISimpleProperty pkProp = entityType.getPrimaryKey();
            if (pkProp instanceof VarcharProp) {
                entryKey = "";
            }
            entityType.getPrimaryKey().getDbType();
            Object pkId = successObjs[0].getPkValue();
            signTexts.put(pkId, signResult.get(entryKey));
            clearTexts.put(pkId, clearResult.get(entryKey));
        } else {
            signTexts.putAll(signResult);
            clearTexts.putAll(clearResult);
            List pkIdList = Stream.of(successObjs).map(m -> String.valueOf(m.getPkValue())).collect(Collectors.toList());
            signTexts = signTexts.entrySet().stream().filter(f -> f != null && f.getKey() instanceof String && pkIdList.contains(f.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            clearTexts = clearTexts.entrySet().stream().filter(f -> f != null && f.getKey() instanceof String && pkIdList.contains(f.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SignService.saveSignMessage(formId, signTexts, clearTexts);
        try (TXHandle h = TX.notSupported();){
            SignService.writeLog(formId, signTexts, clearTexts);
        }
        operateLog.endMothed("saveSignInfo()", null);
    }

    private void signBillData(MainEntityType mainEntityType, OperationResult operationResult, DynamicObject[] successObjs, OperateLog operateLog) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        operateLog.beginMothed("signBillData", null);
        String entityId = mainEntityType.getName();
        DynamicObjectCollection successdocs = new DynamicObjectCollection(successObjs[0].getDynamicObjectType(), null);
        for (int i = 0; i < successObjs.length; ++i) {
            successdocs.add((Object)successObjs[i]);
        }
        Map<Object, Object> clearTexts = SignService.computeDigests(entityId, successdocs);
        operationResult.setSuccess(false);
        operationResult.setNeedSign(true);
        operationResult.setShowMessage(true);
        operationResult.setClearText(SerializationUtils.toJsonString(clearTexts));
        operationResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u5728\u5ba2\u6237\u7aef\u7b7e\u540d\u8ba4\u8bc1", (String)"SignOperateService_5", (String)"bos-ca", (Object[])new Object[0]));
        operateLog.endMothed("signBillData", null);
    }

    private boolean verifySign(MainEntityType mainEntityType, List<Object> ids, OperationResult result, OperateLog operateLog) {
        operateLog.beginMothed("verifySign(ids, result)", null);
        String formId = mainEntityType.getName();
        Map<Object, VerifySignInfo> VerifySignInfos = SignService.verifySignByIds(formId, ids);
        boolean success = true;
        StringBuilder message = new StringBuilder();
        for (Map.Entry<Object, VerifySignInfo> info : VerifySignInfos.entrySet()) {
            if (info.getValue().isSuccess()) continue;
            success = false;
            Object pkId = info.getKey();
            String billNo = result.getBillNos().get(pkId) == null ? (String)pkId : (String)result.getBillNos().get(pkId);
            message.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011 ", (String)"SignOperateService_2", (String)"bos-ca", (Object[])new Object[0]), billNo)).append(info.getValue().getMessage()).append("   ");
        }
        result.setSuccess(success);
        if (!success) {
            result.setShowMessage(true);
        }
        result.setMessage(message.toString());
        operateLog.endMothed("verifySign(ids, result)", null);
        return success;
    }
}

