/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SignSchemeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SignSchemeUpgradeServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            this.upgrate(result);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u7b7e\u540d\u8868\u540c\u6b65\u914d\u7f6e\u65b9\u6848\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private void upgrate(UpgradeResult result) {
        result.setLog(ResManager.loadKDString((String)"\u7b7e\u540d\u8868\u540c\u6b65\u914d\u7f6e\u65b9\u6848\u5f00\u59cb\u6267\u884c", (String)"SignSchemeUpgradeServiceImpl_0", (String)"bos-ca", (Object[])new Object[0]));
        String schemeSql = "select fformnumber from t_bd_signscheme";
        ArrayList signTableInfos = new ArrayList(10);
        ArrayList<String> formNumbers = new ArrayList<String>(10);
        DB.query((DBRoute)DBRoute.basedata, (String)schemeSql, r -> {
            while (r.next()) {
                String formNumber = r.getString("fformnumber");
                formNumbers.add(formNumber);
                SignTableInfo tableInfo = this.getTableInfo(formNumber);
                if (tableInfo == null) continue;
                signTableInfos.add(tableInfo);
            }
            return signTableInfos;
        });
        for (SignTableInfo signTableInfo : signTableInfos) {
            try {
                DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)signTableInfo.roueKey, (String)signTableInfo.tableName);
                if (SignSchemeUpgradeServiceImpl.existsFieldInTableSchema(tableSchema, "fsignfield")) continue;
                DB.execute((DBRoute)new DBRoute(signTableInfo.roueKey), (String)String.format("ALTER TABLE %s ADD %s varchar(2000);", signTableInfo.tableName, "fsignfield"), (Object[])new SqlParameter[0]);
            }
            catch (Exception e) {
                logger.warn("signScheme error", (Throwable)e);
            }
        }
        this.updateSchemeBizAppIds(formNumbers);
        result.setLog(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u8868\u540c\u6b65\u914d\u7f6e\u65b9\u6848\u6267\u884c\u5b8c\u6210\uff0c\u6210\u529f=%s\u4e2a", (String)"SignSchemeUpgradeServiceImpl_1", (String)"bos-ca", (Object[])new Object[0]), signTableInfos.size()));
    }

    private void updateSchemeBizAppIds(List<String> formNumbers) {
        if (formNumbers.size() <= 0) {
            return;
        }
        SqlBuilder selectAppIdSql = new SqlBuilder();
        selectAppIdSql.append("select fbizappid,fnumber from t_meta_formdesign where ", new Object[0]);
        selectAppIdSql.appendIn("fnumber", formNumbers.toArray());
        ResultSetHandler action = rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String fnumber = rs.getString("fnumber");
                String fbizappid = rs.getString("fbizappid");
                map.put(fnumber, fbizappid);
            }
            return map;
        };
        Map formNumber2AppId = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)selectAppIdSql, (ResultSetHandler)action);
        String updateAppIdSql = "update t_bd_signscheme set fbizappid = ? where fformnumber = ?";
        ArrayList<kd.bos.db.SqlParameter[]> paramsList = new ArrayList<kd.bos.db.SqlParameter[]>(10);
        for (String number : formNumbers) {
            String appId = (String)formNumber2AppId.get(number);
            if (appId == null) continue;
            kd.bos.db.SqlParameter[] params = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter("fbizappid", 12, (Object)appId), new kd.bos.db.SqlParameter("fformnumber", 12, (Object)number)};
            paramsList.add(params);
        }
        try (TXHandle tx = TX.required();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateAppIdSql, paramsList);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
            }
        }
    }

    private SignTableInfo getTableInfo(String formId) {
        if (formId == null) {
            return null;
        }
        try {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            String dbRoueKey = entityMetadata.getDBRouteKey();
            List entityList = entityMetadata.getEntitys();
            for (Entity entity : entityList) {
                if (!(entity instanceof BillEntity)) continue;
                SignTableInfo tableInfo = new SignTableInfo();
                tableInfo.roueKey = dbRoueKey;
                tableInfo.tableName = entity.getTableName() + "_sn";
                return tableInfo;
            }
        }
        catch (Exception e) {
            logger.warn("getTableInfo exception", (Throwable)e);
        }
        return null;
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }

    static class SignTableInfo {
        private String roueKey;
        private String tableName;

        SignTableInfo() {
        }
    }
}

