/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cfca;

import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.svs.api.SVBusiness;
import cfca.svs.api.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cfca.CFCAConfig;
import kd.bos.cfca.CFCAConfigFactory;
import kd.bos.cfca.SessionFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CFCAVerifySign {
    private static final Log log = LogFactory.getLog(CFCAVerifySign.class);
    private static final String VERIFY_SUCCESS = "success";
    private static final String VERIFY_MESSAGE = "message";
    private static final String UTF_8 = "UTF-8";
    private static final String SIGNALG = "signAlg";
    private static final String SIGNALG_SM2 = "sm3WithSM2Encryption";
    private static final String SIGNALG_RSA = "sha256WithRSAEncryption";
    private static final String CFCA_SADK = "SADK";
    private static final String CFCA_HARD = "HARD";

    public static Map<String, Object> verifySign(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        Map<String, Object> result = CFCAVerifySign.verifyMessageRawCFCA(signData, plainData, publicKey, caConfig);
        return result;
    }

    private static Map<String, Object> verifyMessageRawCFCA(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        String signType;
        String string = signType = caConfig == null || !caConfig.containsKey("signType") ? CFCA_HARD : (String)caConfig.get("signType");
        if (CFCA_SADK.equals(signType)) {
            return CFCAVerifySign.verifyMessageRawSADK(signData, plainData, publicKey, caConfig);
        }
        return CFCAVerifySign.verifyMessageRawHard(signData, plainData, publicKey, caConfig);
    }

    private static Map<String, Object> verifyMessageRawSADK(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        HashMap<String, Object> result;
        block9: {
            result = new HashMap<String, Object>();
            if (publicKey != null) {
                try {
                    Session session = SessionFactory.getInstance().getSession();
                    ByteArrayInputStream ins = new ByteArrayInputStream(publicKey.getBytes(UTF_8));
                    X509Cert cert = new X509Cert((InputStream)ins);
                    PublicKey pubKey = cert.getPublicKey();
                    String signAlg = caConfig == null || !caConfig.containsKey(SIGNALG) ? SIGNALG_SM2 : (String)caConfig.get(SIGNALG);
                    Signature util = new Signature();
                    boolean verifyResult = false;
                    if ("RSA".equals(signAlg)) {
                        verifyResult = util.p1VerifyMessage(SIGNALG_RSA, plainData.getBytes(UTF_8), signData.getBytes(UTF_8), pubKey, session);
                        if (!verifyResult) {
                            log.info("CFCA:SHA-256\u7b97\u6cd5\uff1a\u9a8c\u7b7e\u5931\u8d25\uff0c\u5c06\u4f7f\u7528SHA-1\u7b97\u6cd5\u91cd\u65b0\u9a8c\u7b7e");
                            verifyResult = util.p1VerifyMessage("sha1WithRSAEncryption", plainData.getBytes(UTF_8), signData.getBytes(UTF_8), pubKey, session);
                        }
                    } else {
                        verifyResult = util.p1VerifyMessage(SIGNALG_SM2, plainData.getBytes(UTF_8), signData.getBytes(UTF_8), (PublicKey)((SM2PublicKey)pubKey), session);
                    }
                    if (verifyResult) {
                        result.put(VERIFY_SUCCESS, Boolean.TRUE);
                        result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u7b7e\u540d\u503c\u9a8c\u8bc1\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u6210\u529f\u3002", (String)"CFCAVerifySign_0", (String)"bos-ca", (Object[])new Object[0]));
                        break block9;
                    }
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u7b7e\u540d\u503c\u9a8c\u8bc1\u5931\u8d25\u3002", (String)"CFCAVerifySign_1", (String)"bos-ca", (Object[])new Object[0]));
                }
                catch (IOException ioe) {
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u516c\u94a5\uff0c%s\u3002", (String)"CFCAVerifySign_2", (String)"bos-ca", (Object[])new Object[0]), ioe.getMessage()));
                }
                catch (Exception e) {
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e2d\u5fc3\uff0c%s\u3002", (String)"CFCAVerifySign_3", (String)"bos-ca", (Object[])new Object[0]), e.getMessage()));
                }
            } else {
                result.put(VERIFY_SUCCESS, Boolean.FALSE);
                result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u7528\u6237\u5bf9\u5e94\u7684\u8bc1\u4e66\u3002", (String)"CFCAVerifySign_4", (String)"bos-ca", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private static Map<String, Object> verifyMessageRawHard(String signData, String plainData, String publicKey, Map<String, Object> caConfig) {
        HashMap<String, Object> result;
        block14: {
            result = new HashMap<String, Object>();
            if (publicKey != null) {
                try {
                    CFCAConfig config = null;
                    config = caConfig != null && !caConfig.isEmpty() ? new CFCAConfig(caConfig) : new CFCAConfig();
                    String signAlg = caConfig == null || !caConfig.containsKey(SIGNALG) ? SIGNALG_SM2 : (String)caConfig.get(SIGNALG);
                    CFCAConfigFactory.getInstance().setConfig(config);
                    CFCAConfigFactory.getInstance().init();
                    SVBusiness svBusiness = new SVBusiness();
                    String response = "";
                    boolean verifyResult = false;
                    String typeInfo = ResManager.loadKDString((String)"\u786c\u4ef6\u670d\u52a1\u5668SM2\u9a8c\u8bc1\u8bc1\u4e66\u6709\u6548\u6027\u3002", (String)"CFCAVerifySign_5", (String)"bos-ca", (Object[])new Object[0]);
                    if ("RSA".equals(signAlg)) {
                        typeInfo = ResManager.loadKDString((String)"\u786c\u4ef6\u670d\u52a1\u5668RSA\u9a8c\u8bc1\u8bc1\u4e66\u6709\u6548\u6027\u3002", (String)"CFCAVerifySign_6", (String)"bos-ca", (Object[])new Object[0]);
                        response = svBusiness.rsaP1VerifySignWithCert(publicKey, plainData.getBytes(UTF_8), signData, SIGNALG_RSA, "-1");
                    } else {
                        response = svBusiness.sm2P1VerifySignWithCert(publicKey, plainData.getBytes(UTF_8), signData, "-1");
                    }
                    Map<String, Object> verifyCertRes = CFCAVerifySign.dealResponse(response, typeInfo);
                    boolean isCertAvalible = (Boolean)verifyCertRes.get(VERIFY_SUCCESS);
                    if (isCertAvalible) {
                        if ("RSA".equals(signAlg)) {
                            typeInfo = ResManager.loadKDString((String)"\u786c\u4ef6\u670d\u52a1\u5668RSA\u9a8c\u7b7e\u3002", (String)"CFCAVerifySign_7", (String)"bos-ca", (Object[])new Object[0]);
                            response = svBusiness.rsaP1VerifySignWithCert(publicKey, plainData.getBytes(UTF_8), signData, SIGNALG_RSA, "-1");
                        } else {
                            typeInfo = ResManager.loadKDString((String)"\u786c\u4ef6\u670d\u52a1\u5668SM2\u9a8c\u7b7e\u3002", (String)"CFCAVerifySign_8", (String)"bos-ca", (Object[])new Object[0]);
                            response = svBusiness.sm2P1VerifySignWithCert(publicKey, plainData.getBytes(UTF_8), signData, "-1");
                        }
                        Map<String, Object> verifySignRes = CFCAVerifySign.dealResponse(response, typeInfo);
                        verifyResult = (Boolean)verifySignRes.get(VERIFY_SUCCESS);
                        if (verifyResult) {
                            result.put(VERIFY_SUCCESS, Boolean.TRUE);
                            result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u7b7e\u540d\u503c\u9a8c\u8bc1\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u6210\u529f\u3002", (String)"CFCAVerifySign_9", (String)"bos-ca", (Object[])new Object[0]));
                        } else {
                            result.put(VERIFY_SUCCESS, Boolean.FALSE);
                            if (StringUtils.isBlank((Object)verifySignRes.get(VERIFY_MESSAGE))) {
                                result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u7b7e\u540d\u503c\u9a8c\u8bc1\u5931\u8d25\u3002", (String)"CFCAVerifySign_10", (String)"bos-ca", (Object[])new Object[0]));
                            } else {
                                result.put(VERIFY_MESSAGE, verifySignRes.get(VERIFY_MESSAGE));
                            }
                        }
                        break block14;
                    }
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c%s", (String)"CFCAVerifySign_11", (String)"bos-ca", (Object[])new Object[0]), verifyCertRes.get(VERIFY_MESSAGE)));
                }
                catch (IOException ioe) {
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u516c\u94a5\uff0c%s\u3002", (String)"CFCAVerifySign_12", (String)"bos-ca", (Object[])new Object[0]), ioe.getMessage()));
                }
                catch (Exception e) {
                    result.put(VERIFY_SUCCESS, Boolean.FALSE);
                    result.put(VERIFY_MESSAGE, String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e2d\u5fc3\uff0c%s\u3002", (String)"CFCAVerifySign_13", (String)"bos-ca", (Object[])new Object[0]), e.getMessage()));
                }
            } else {
                result.put(VERIFY_SUCCESS, Boolean.FALSE);
                result.put(VERIFY_MESSAGE, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u7528\u6237\u5bf9\u5e94\u7684\u8bc1\u4e66\u3002", (String)"CFCAVerifySign_14", (String)"bos-ca", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private static Map<String, Object> dealResponse(String response, String typeInfo) {
        String errorCode;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String message = "";
        boolean success = false;
        if ("".equals(response)) {
            message = String.format(ResManager.loadKDString((String)"%s Socket \u53ef\u80fd\u53d1\u751f \u901a\u8baf\u5f02\u5e38", (String)"CFCAVerifySign_15", (String)"bos-ca", (Object[])new Object[0]), typeInfo);
        }
        if ("0".equals(errorCode = XmlUtil.getNodeText((String)response, (String)"ErrorCode"))) {
            message = String.format(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"CFCAVerifySign_16", (String)"bos-ca", (Object[])new Object[0]), typeInfo);
            success = true;
        } else {
            message = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:%2$s \u9519\u8bef\u4fe1\u606f\u4e3a:%3$s", (String)"CFCAVerifySign_17", (String)"bos-ca", (Object[])new Object[0]), typeInfo, errorCode, XmlUtil.getNodeText((String)response, (String)"ErrorDesc"));
            success = false;
        }
        result.put(VERIFY_SUCCESS, success);
        result.put(VERIFY_MESSAGE, message);
        return result;
    }
}

