/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SignConfigProviderPlugin
extends AbstractFormPlugin
implements IDataModelChangeListener {
    private static final int LENGTH = 20;

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String newValue;
        super.propertyChanged(e);
        IDataEntityProperty obj = e.getProperty();
        if (obj != null && "config_tag".equals(obj.getName()) && StringUtils.isNotBlank((CharSequence)(newValue = (String)(changeSet = e.getChangeSet())[0].getNewValue()))) {
            if (newValue.length() > 20) {
                newValue = newValue.substring(0, 20) + "...";
            }
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("config");
            String field = largeTextEdit.getFieldKey();
            this.getModel().setValue(field, (Object)newValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            String value = (String)this.getModel().getValue("provider");
            LocaleString name = this.getItemName(value);
            this.getModel().setValue("providername", (Object)name);
        }
    }

    private LocaleString getItemName(String value) {
        LocaleString localeString = new LocaleString(value);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return localeString;
        }
        ComboProp comboProp = (ComboProp)this.getModel().getDataEntityType().findProperty("provider");
        List items = comboProp.getComboItems();
        if (items != null) {
            for (ValueMapItem item : items) {
                if (!value.equals(item.getValue())) continue;
                return item.getName();
            }
        }
        return localeString;
    }
}

