/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.ca.SignSchemeListPlugin;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.metadata.form.rule.FieldId;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SignFieldEditPlugin
extends AbstractFormPlugin
implements IDataModelChangeListener,
BeforeF7SelectListener {
    private String number = null;
    private static final int SIGNFIELD_LENGTH = 1800;
    private static final int OPERATE_LENGTH = 500;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FORM_OBJECT = "formobject";
    private static final String SIGN_FIELD = "signfield";
    private static final String SIGN_OPERATE = "signoperate";
    private static final String VERIFY_OPERATE = "verifyoperate";
    private static final String IS_ENABLE_SIGNORG = "isenablesignorg";
    private static final String FORM_NUMBER = "formNumber";
    private static final String VALUE = "value";
    private static final String SIGN_FIELD_1 = "Signfield";
    private static final String SIGN_OPERATE_1 = "Signoperate";
    private static final String SIGN_OPERATE_Desc = "SignoperateDesc";
    private static final String VERIFY_OPERATE_1 = "Verifyoperate";
    private static final String CONTEXT = "context";
    private static final String META_CONTEXT = "MetaContext";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BasedataEdit formobject = (BasedataEdit)this.getView().getControl(FORM_OBJECT);
        formobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit signfield = (TextEdit)this.getView().getControl(SIGN_FIELD);
        signfield.addButtonClickListener((ClickListener)this);
        TextEdit signoperate = (TextEdit)this.getView().getControl(SIGN_OPERATE);
        signoperate.addButtonClickListener((ClickListener)this);
        TextEdit verifyoperate = (TextEdit)this.getView().getControl(VERIFY_OPERATE);
        verifyoperate.addButtonClickListener((ClickListener)this);
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = service.getModeType();
        if (modelType == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_ENABLE_SIGNORG});
        }
    }

    public void afterCreateNewData(EventObject e) {
        List values;
        super.afterCreateNewData(e);
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam(FORM_NUMBER);
        boolean isenablesignorg = this.getView().getFormShowParameter().getCustomParam(IS_ENABLE_SIGNORG) != null && (Boolean)this.getView().getFormShowParameter().getCustomParam(IS_ENABLE_SIGNORG) != false;
        this.getModel().setValue(IS_ENABLE_SIGNORG, (Object)isenablesignorg);
        this.getModel().setValue(FORM_OBJECT, (Object)formNumber);
        this.getPageCache().put(FORM_NUMBER, formNumber);
        if (StringUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("orgid"))) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParam("orgid"));
        }
        List result = (List)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List list = values = result != null ? result : new ArrayList();
        if (values.size() > 0) {
            String verifyOperateStr;
            String signOperateStr;
            Map value = (Map)values.get(0);
            List fields = (List)value.get(SIGN_FIELD_1);
            if (!StringUtils.isEmpty((Object)fields)) {
                String signfields = this.getListString(fields);
                this.getModel().setValue(SIGN_FIELD, (Object)signfields);
            }
            if (!StringUtils.isEmpty((Object)(signOperateStr = (String)value.get(SIGN_OPERATE_1)))) {
                List signOperates = (List)SerializationUtils.fromJsonString((String)signOperateStr, List.class);
                Object signOperateDesc = value.get(SIGN_OPERATE_Desc);
                if (signOperates != null && signOperateDesc != null) {
                    String[] arr = signOperateDesc.toString().split(",");
                    for (int i = 0; i < signOperates.size(); ++i) {
                        Map operate = (Map)signOperates.get(i);
                        operate.put("OpName", arr.length > i ? arr[i] : operate.get("OpCode"));
                    }
                }
                value.put(SIGN_OPERATE_1, signOperates);
                this.getModel().setValue(SIGN_OPERATE, (Object)this.getOperationsString(signOperates));
            }
            if (!StringUtils.isEmpty((Object)(verifyOperateStr = (String)value.get(VERIFY_OPERATE_1)))) {
                this.getModel().setValue(VERIFY_OPERATE, (Object)verifyOperateStr);
            }
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)values));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String treeNodeId = (String)this.getView().getFormShowParameter().getCustomParam("treeNodeId");
        if (!StringUtils.isEmpty((Object)treeNodeId)) {
            arg0.getFormShowParameter().setCustomParam("treeRootNodeId", (Object)treeNodeId);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "signfield": {
                this.getSignField();
                break;
            }
            case "signoperate": {
                this.getSignOperate();
                break;
            }
            case "verifyoperate": {
                this.getVerifyOperate();
                break;
            }
            case "btnok": {
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"", (String)"ca_schemes", (String)"4715a0df000000ac");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignFieldEditPlugin_15", (String)"bos-ca", (Object[])new Object[0]));
                    return;
                }
                String formNumber = this.getPageCache().get(FORM_NUMBER);
                if (!StringUtils.isEmpty((Object)formNumber)) {
                    BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formNumber);
                    if (dt.getBillParameter() == null) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u672a\u5f00\u542f\u5355\u636e\u53c2\u6570\uff0c\u786e\u8ba4\u4fdd\u5b58?", (String)"SignFieldEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("continue_save", (IFormPlugin)this));
                        break;
                    }
                    this.returnDataAndClose();
                    break;
                }
                this.returnDataAndClose();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if ("continue_save".equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.returnDataAndClose();
        }
    }

    private void returnDataAndClose() {
        long fid;
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        this.appendSign("Id", this.getView().getFormShowParameter().getParentFormId());
        this.appendSign("_Type_", "CertRule");
        List<Map<String, Object>> signs = this.getSigns();
        para.put(VALUE, signs);
        para.put(IS_ENABLE_SIGNORG, this.getModel().getValue(IS_ENABLE_SIGNORG));
        para.put(FORM_OBJECT, this.getModel().getValue(FORM_OBJECT));
        if (this.getModel().getValue(FORM_OBJECT) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61", (String)"SignFieldEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        para.put("fid", this.getView().getFormShowParameter().getCustomParam("fid"));
        para.put("FOrgID", this.getView().getModel().getValue("org"));
        DynamicObject formObject = (DynamicObject)para.get(FORM_OBJECT);
        String formNumber = formObject.getString("number");
        long l = fid = para.get("fid") == null ? 0L : Long.parseLong(para.get("fid").toString());
        if (SignSchemeListPlugin.existScheme(formNumber, fid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u5df2\u5b58\u5728", (String)"SignFieldEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String message = this.checkData();
        if (!StringUtils.isEmpty((Object)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private String checkData() {
        String signField = (String)this.getView().getModel().getValue(SIGN_FIELD);
        String signOperate = (String)this.getView().getModel().getValue(SIGN_OPERATE);
        String verifyOperate = (String)this.getView().getModel().getValue(VERIFY_OPERATE);
        if (StringUtils.isEmpty((Object)signField)) {
            return ResManager.loadKDString((String)"\u52a0\u7b7e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SignFieldEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((Object)signOperate.trim())) {
            return ResManager.loadKDString((String)"\u7b7e\u540d\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SignFieldEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((Object)verifyOperate.trim())) {
            return ResManager.loadKDString((String)"\u9a8c\u7b7e\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SignFieldEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        return "";
    }

    private void getVerifyOperate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bd_signoperateselect");
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        parameter.setCustomParam(META_CONTEXT, (Object)context);
        String formNumber = this.getPageCache().get(FORM_NUMBER);
        parameter.setCustomParam(FORM_NUMBER, (Object)formNumber);
        parameter.setCustomParam("operates", this.getModel().getValue(VERIFY_OPERATE));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, VERIFY_OPERATE));
        this.getView().showForm(parameter);
    }

    private void getSignOperate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bd_signoperate_edit");
        String formNumber = this.getPageCache().get(FORM_NUMBER);
        parameter.setCustomParam(FORM_NUMBER, (Object)formNumber);
        List<Map<String, Object>> signs = this.getSigns();
        if (signs != null && !signs.isEmpty()) {
            Object signOperates = signs.get(0).get(SIGN_OPERATE_1);
            parameter.setCustomParam(SIGN_OPERATE, signOperates);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SIGN_OPERATE));
        this.getView().showForm(parameter);
    }

    private void getSignField() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bd_signfieldselect");
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        parameter.setCustomParam(META_CONTEXT, (Object)context);
        String formNumber = this.getPageCache().get(FORM_NUMBER);
        if (StringUtils.isEmpty((Object)formNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"SignFieldEditPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam(FORM_NUMBER, (Object)formNumber);
        String fields = (String)this.getModel().getValue(SIGN_FIELD);
        if (!StringUtils.isEmpty((Object)fields) && !" ".equals(fields)) {
            String[] ids = fields.split(",");
            List<String> fieldIds = Arrays.asList(ids);
            ArrayList<FieldId> selFields = new ArrayList<FieldId>(16);
            for (String id : fieldIds) {
                selFields.add(new FieldId(id));
            }
            parameter.setCustomParam("signfields", selFields);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SIGN_FIELD));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        Map data = (Map)closedCallBackEvent.getReturnData();
        if (SIGN_FIELD.equalsIgnoreCase(actionId)) {
            String fieldsString;
            List fields = (List)data.get("SignFields");
            String signfields = this.getListString(fields);
            String string = fieldsString = fields == null ? "" : SerializationUtils.toJsonString((Object)fields);
            if (fieldsString != null && fieldsString.length() > 1800) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u5b57\u6bb5\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SignFieldEditPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(SIGN_FIELD, (Object)signfields);
            this.appendSign(SIGN_FIELD_1, fields);
        } else if (SIGN_OPERATE.equalsIgnoreCase(actionId)) {
            if (!StringUtils.isEmpty((Object)data)) {
                List operations = (List)data.get("Operations");
                int length = 0;
                if (operations != null) {
                    length = SerializationUtils.toJsonString((Object)operations).length();
                }
                if (length > 500) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u7b7e\u64cd\u4f5c\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SignFieldEditPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String operationsString = this.getOperationsString(operations);
                this.getModel().setValue(SIGN_OPERATE, (Object)operationsString);
                this.appendSign(SIGN_OPERATE_1, operations);
            }
        } else if (VERIFY_OPERATE.equalsIgnoreCase(actionId) && !StringUtils.isEmpty((Object)data)) {
            List operations = (List)data.get("Operations");
            String operationsString = this.getOperationsString(operations);
            if (operationsString != null && operationsString.length() > 500) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u7b7e\u64cd\u4f5c\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SignFieldEditPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(VERIFY_OPERATE, (Object)operationsString);
            this.appendSign(VERIFY_OPERATE_1, operationsString);
        }
    }

    public String getListString(List<Map<String, Object>> fields) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map<String, Object> field : fields) {
            builder.append(field.get("Id"));
            if (++i >= fields.size()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private String getOperationsString(List<Map<String, Object>> operations) {
        if (operations == null || operations.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map<String, Object> operation : operations) {
            builder.append(operation.get("OpCode"));
            if (++i >= operations.size()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private List<Map<String, Object>> getSigns() {
        List signs = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(VALUE), Map.class);
        return signs;
    }

    private void appendSign(String key, Object value) {
        List<Map<String, Object>> signs = this.getSigns();
        if (signs.size() == 0) {
            signs.add(new HashMap());
        }
        signs.get(0).put(key, value);
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString(signs));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty obj = e.getProperty();
        if (obj instanceof BasedataProp && FORM_OBJECT.equalsIgnoreCase(obj.getName())) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            String number = newValue == null ? "" : newValue.getString("number");
            boolean isEnableSignOrg = !StringUtils.isEmpty((Object)number) && SignFieldEditPlugin.isEnableSignOrg(number);
            this.getModel().setValue(IS_ENABLE_SIGNORG, (Object)isEnableSignOrg);
            this.getModel().setValue(FORM_OBJECT, (Object)number);
            this.getPageCache().put(FORM_NUMBER, number);
            this.getModel().setValue(SIGN_FIELD, (Object)"");
            this.getModel().setValue(SIGN_OPERATE, (Object)"");
            this.getModel().setValue(VERIFY_OPERATE, (Object)"");
        } else if (obj instanceof TextProp) {
            String name = obj.getName();
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = (String)changeSet[0].getNewValue();
            if (StringUtils.isEmpty((Object)newValue)) {
                if (SIGN_FIELD.equalsIgnoreCase(name)) {
                    this.appendSign(SIGN_FIELD_1, new ArrayList());
                } else if (SIGN_OPERATE.equalsIgnoreCase(name)) {
                    this.appendSign(SIGN_OPERATE_1, "");
                } else if (VERIFY_OPERATE.equalsIgnoreCase(name)) {
                    this.appendSign(VERIFY_OPERATE_1, "");
                }
            }
        }
    }

    protected static boolean isEnableSignOrg(String formNumber) {
        BillParam billParam = ParameterHelper.getBillParam((String)formNumber);
        return billParam != null && billParam.getOverallParam() != null && billParam.getOverallParam().isEnableSignOrg();
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}

