/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.rule.FieldId;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;

public class SignFieldSelectPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    private static final String FIELD_TREE = "FieldTree";
    private static final String SIGN_FIELDS = "signfields";
    private ProductSettingService productSettingService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
    private ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove"});
        TreeView fieldtree = (TreeView)this.getControl(FIELD_TREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List fieldIds = (List)this.getView().getFormShowParameter().getCustomParam(SIGN_FIELDS);
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
        Map fieldTree = null;
        if (context != null) {
            List billContext = (List)context.get(0);
            fieldTree = EntityMetadataUtil.getBillFieldTreeByKey((List)billContext);
        } else {
            String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                return;
            }
            String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
            if (entityMetadata == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801%s\u5143\u6570\u636e\u52a0\u8f7d\u4e3a\u7a7a", (String)"SignFieldSelectPlugin_1", (String)"bos-ca", (Object[])new Object[0]), formNumber));
                return;
            }
            MainEntityType dt = entityMetadata.buildDataEntityType();
            DataEntityPropertyCollection properties = dt.getProperties();
            List items = entityMetadata.getRootEntity().getItems();
            List fields = this.productSettingService.getFormDisVisitField(formNumber);
            this.removeDynamicFields(items, properties, fields, 1 == this.licenseService.getModeType());
            fieldTree = entityMetadata.getRootEntity().createFieldsTreeByKey("billFields", false);
            Map<String, EntityItem<?>> entityItemMap = entityMetadata.getItems().stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity(), (m1, m2) -> m1));
            List itemList = (List)fieldTree.get("Items");
            this.baseDataExtendNode(entityItemMap, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formNumber), entityMetadata, itemList);
        }
        TreeNode root = TreeNode.Parse((String)"", (Map)fieldTree, (String)"Id", (String)"Name", (String)"Items");
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.addNode(root);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(10);
        if (fieldIds != null) {
            IDataModel model = this.getModel();
            model.deleteEntryData(SIGN_FIELDS);
            List fieldIdss = SerializationUtils.fromJsonStringToList((String)fieldIds.toString(), FieldId.class);
            for (FieldId fieldId : fieldIdss) {
                TreeNode parentNode;
                String nodeId = fieldId.getId();
                TreeNode node = root.getTreeNode(nodeId, 16);
                if (node == null) continue;
                checkNodes.add(node);
                List childNodes = node.getChildren();
                if (!CollectionUtils.isEmpty((Collection)childNodes)) {
                    for (TreeNode childNode : childNodes) {
                        int rowindex = model.createNewEntryRow(SIGN_FIELDS);
                        String id = childNode.getId();
                        model.setValue("fname", (Object)(node.getText() + "." + childNode.getText()), rowindex);
                        model.setValue("fkey", (Object)id, rowindex);
                        String parentId = this.getChildPath(root, id, id);
                        model.setValue("fparentid", (Object)parentId, rowindex);
                        this.getPageCache().put(fieldId.getId(), parentId);
                    }
                    continue;
                }
                int rowindex = model.createNewEntryRow(SIGN_FIELDS);
                model.setValue("fkey", (Object)node.getId(), rowindex);
                if (node.getParentid() != null && (parentNode = root.getTreeNode(node.getParentid())) != null && parentNode != root) {
                    model.setValue("fname", (Object)(parentNode.getText() + "." + node.getText()), rowindex);
                } else {
                    model.setValue("fname", (Object)node.getText(), rowindex);
                }
                String parentId = this.getChildPath(root, nodeId, nodeId);
                model.setValue("fparentid", (Object)parentId, rowindex);
                this.getPageCache().put(fieldId.getId(), parentId);
            }
            tree.checkNodes(checkNodes);
        }
    }

    private void baseDataExtendNode(Map<String, EntityItem<?>> entityItemMap, DynamicObjectType dataEntityType, EntityMetadata entityMetadata, List<Map<String, Object>> itemList) {
        for (Map<String, Object> item : itemList) {
            DynamicProperty property;
            DynamicObjectType subObjectType;
            EntityItem itemById;
            String id = String.valueOf(item.get("Id"));
            EntityItem<?> entityItem = entityItemMap.get(id);
            if (entityItem instanceof EntryEntity) {
                this.baseDataExtendNode(entityItemMap, dataEntityType, entityMetadata, (List)item.get("Items"));
                continue;
            }
            if (!(entityItem instanceof AbstractBasedataField) || entityItem instanceof ItemClassField) continue;
            AbstractBasedataField field = (AbstractBasedataField)entityItem;
            ArrayList<Map<String, Object>> extendItems = new ArrayList<Map<String, Object>>(10);
            DynamicObjectType currentType = dataEntityType;
            if (dataEntityType instanceof MainEntityType && (itemById = entityMetadata.getItemById(field.getParentId())) != null && (subObjectType = (DynamicObjectType)((MainEntityType)dataEntityType).getAllEntities().get(itemById.getKey())) != null) {
                currentType = subObjectType;
            }
            if ((property = currentType.getProperty(field.getKey())) instanceof IComplexProperty) {
                IDataEntityType complexType = ((IComplexProperty)property).getComplexType();
                this.createComplexProperty(id, extendItems, complexType);
            }
            if (extendItems.size() <= 0) continue;
            item.put("Items", extendItems);
        }
    }

    private void createComplexProperty(String id, List<Map<String, Object>> extendItems, IDataEntityType complexType) {
        if (complexType == null) {
            return;
        }
        for (IDataEntityProperty complexTypeProperty : complexType.getProperties()) {
            if (this.isPropertyIgnore(complexType, complexTypeProperty)) continue;
            if (complexTypeProperty instanceof FieldProp || complexTypeProperty instanceof FlexProp) {
                extendItems.add(this.createFieldNode(id + "." + complexTypeProperty.getName(), this.getDisplayName(complexTypeProperty)));
                continue;
            }
            if (!(complexTypeProperty instanceof IComplexProperty)) continue;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
            Map<String, Object> complexNode = this.createFieldNode(id + "." + complexTypeProperty.getName(), this.getDisplayName(complexTypeProperty));
            complexNode.put("Items", items);
            extendItems.add(complexNode);
            this.createComplexProperty(id + "." + complexTypeProperty.getName(), items, ((IComplexProperty)complexTypeProperty).getComplexType());
        }
    }

    private String getDisplayName(IDataEntityProperty complexTypeProperty) {
        String name = complexTypeProperty.getName();
        LocaleString displayName = complexTypeProperty.getDisplayName();
        if (displayName != null) {
            name = displayName.getLocaleValue();
        }
        return name;
    }

    private boolean isPropertyIgnore(IDataEntityType complexType, IDataEntityProperty complexTypeProperty) {
        if (complexTypeProperty instanceof PKFieldProp || complexTypeProperty instanceof GeoPointProp || kd.bos.orm.util.StringUtils.isEmpty((Object)complexTypeProperty.getAlias())) {
            return true;
        }
        if (complexTypeProperty instanceof BooleanProp && complexTypeProperty.isDbIgnore()) {
            return true;
        }
        if (complexType instanceof RefEntityType) {
            String masterIdPropName = ((RefEntityType)complexType).getMasteridPropName();
            return StringUtils.equals((CharSequence)masterIdPropName, (CharSequence)complexTypeProperty.getName()) && !(complexTypeProperty instanceof MasterBasedataProp);
        }
        return false;
    }

    private Map<String, Object> createFieldNode(String id, String name) {
        HashMap<String, Object> refMap = new HashMap<String, Object>(3);
        refMap.put("Id", id);
        refMap.put("Type", "Text");
        refMap.put("Name", name);
        return refMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParentAndClose();
        } else if ("btnremove".equalsIgnoreCase(key)) {
            this.removeRefreshFields();
        }
    }

    private void returnDataToParentAndClose() {
        HashMap data = new HashMap(1);
        ArrayList selFields = new ArrayList();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SIGN_FIELDS);
        for (DynamicObject entity : entryEntity) {
            if (entity == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("Id", entity.get("fkey"));
            map.put("ParentId", entity.get("fparentid"));
            selFields.add(map);
        }
        data.put("SignFields", selFields);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        List checkedNodes = tree.getTreeState().getCheckedNodes();
        IDataModel model = this.getModel();
        model.deleteEntryData(SIGN_FIELDS);
        for (Map checkedNode : checkedNodes) {
            TreeNode treeNode;
            String id = String.valueOf(checkedNode.get("id"));
            if (Boolean.parseBoolean(checkedNode.get("isParent").toString())) continue;
            int rowIndex = model.createNewEntryRow(SIGN_FIELDS);
            model.setValue("fkey", (Object)id, rowIndex);
            String parentId = id;
            String name = checkedNode.get("text").toString();
            parentId = this.getChildPath(root, id, parentId);
            if (id.contains(".") && (treeNode = root.getTreeNode(String.valueOf(checkedNode.get("parentid")), 16)) != null) {
                name = treeNode.getText() + "." + name;
            }
            model.setValue("fname", (Object)name, rowIndex);
            model.setValue("fparentid", (Object)parentId, rowIndex);
        }
    }

    private String getChildPath(TreeNode root, String id, String parentId) {
        List childPath = root.getChildPath(id);
        if (!CollectionUtils.isEmpty((Collection)childPath)) {
            parentId = childPath.stream().filter(f -> !f.equals(root.getId())).flatMap(fMap -> Stream.of(fMap.split("\\."))).distinct().collect(Collectors.joining("."));
        }
        return parentId;
    }

    private void removeRefreshFields() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SIGN_FIELDS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u9664\u7684\u884c", (String)"SignFieldSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue("fparentid", row));
        }
        model.deleteEntryRows(SIGN_FIELDS, rows);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.uncheckNodes(nodeIds);
    }

    private void removeDynamicFields(List<EntityItem<?>> items, DataEntityPropertyCollection properties, List<String> blackList, Boolean isSingleOrg) {
        Iterator<EntityItem<?>> iter = items.iterator();
        while (iter.hasNext()) {
            DataEntityPropertyCollection entryProperties;
            EntryType entryDt;
            List entryItems;
            SubEntryEntity entity;
            EntityItem<?> item = iter.next();
            if (this.itemNeedRemove(blackList, isSingleOrg, item)) {
                iter.remove();
                continue;
            }
            if (item instanceof MuliLangTextField) continue;
            if (item instanceof Field) {
                String key = item.getKey();
                DynamicProperty property = (DynamicProperty)properties.get((Object)key);
                if (property != null && !StringUtils.isBlank((CharSequence)property.getAlias())) continue;
                iter.remove();
                continue;
            }
            if (item instanceof SubEntryEntity) {
                entity = (SubEntryEntity)item;
                entryItems = entity.getItems();
                entryDt = (EntryType)entity.buildDataEntityType();
                entryProperties = entryDt.getProperties();
                this.removeDynamicFields(entryItems, entryProperties, blackList, isSingleOrg);
                continue;
            }
            if (!(item instanceof EntryEntity)) continue;
            entity = (EntryEntity)item;
            entryItems = entity.getItems();
            entryDt = (EntryType)entity.buildDataEntityType();
            entryProperties = entryDt.getProperties();
            this.removeDynamicFields(entryItems, entryProperties, blackList, isSingleOrg);
        }
    }

    private boolean itemNeedRemove(List<String> blackList, Boolean isSingleOrg, EntityItem<?> item) {
        String fieldKey = item.getKey().split("\\.")[0];
        if (!blackList.isEmpty() && blackList.contains(fieldKey)) {
            return true;
        }
        if (!isSingleOrg.booleanValue()) {
            return false;
        }
        if (item instanceof OrgField && !"01".equals(((OrgField)item).getOrgFuncs())) {
            return true;
        }
        if (item instanceof MulBasedataField && "bos_org".equals(((MulBasedataField)item).getBaseEntityId()) && !"01".equals(((MulBasedataField)item).getOrgFuncs())) {
            return true;
        }
        return item instanceof BasedataField && !(item instanceof ItemClassField) && "bos_org".equals(((BasedataField)item).getBaseEntityId());
    }
}

