/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.EventObject;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SignSchemeFilterEditPlugin
extends AbstractFormPlugin {
    private static final String TABLE_SIGNSCHEME = "t_bd_signscheme";
    private static final String ENTRY_SIGNSCHEME = "sign_scheme";
    private static final String TABLE_FILTER = "t_bd_signschemefilter";
    private static final String SIGNENTITY_FILTER = "bos_sign_filter_entry";
    private static final String FILTER_EDIT = "bos_signfilteredit";
    private static final String FILTER_EDIT1 = "bos_printfilterediter";
    private static final String FILTER_ENTRY = "filterentity";
    private static final String BIZOBJECTID = "bizobjectid";
    private static final String ENABLE = "enable";
    private static final String FILTERTYPE = "filtertype";
    private static final String FILTERNAME = "filtername";
    private static final String FILTERCONDITION = "filtercondition";
    private static final String SEQ = "sseq";
    private static final String ID = "id";
    private static final String TOOL_BAR = "toolbar";
    private static final String BTN_ADD_LINE = "btnaddline";
    private static final String BTN_DELETE_LINE = "btndeleteline";
    private static final String BTN_SAVE = "btnsave";
    private static final String SIGN_SCHEME_ID = "signSchemeId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_SAVE});
        this.addClickListeners(new String[]{FILTERNAME});
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                if (!this.checkData()) {
                    return;
                }
                String signSchemeIdStr = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEME_ID);
                Long signSchemeId = Long.parseLong(signSchemeIdStr);
                this.deleteEntry(signSchemeId);
                this.saveData();
                break;
            }
            case "filtername": {
                this.showFilterEditer();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map retData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(FILTERNAME) && (retData = (Map)closedCallBackEvent.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(FILTER_ENTRY);
            this.getModel().setValue(FILTERNAME, retData.get("name"), currentRowIndex);
            this.getModel().setValue(FILTERCONDITION, retData.get("condition"), currentRowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        String signSchemeId = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEME_ID);
        signSchemeId = signSchemeId == null ? "" : signSchemeId;
        Long signSchemePkId = StringUtils.isBlank((CharSequence)signSchemeId) ? 0L : Long.parseLong(signSchemeId);
        QFilter schemeFilter = new QFilter(ID, "=", (Object)signSchemePkId);
        QFilter[] filters = new QFilter[]{schemeFilter};
        DynamicObjectCollection signSchemeFilterEntry = QueryServiceHelper.query((String)ENTRY_SIGNSCHEME, (String)"id,formnumber,filterentry.enable enable,filterentry.filtertype filtertype,filterentry.filtername filtername,filterentry.filtercondition filtercondition", (QFilter[])filters);
        if (signSchemeFilterEntry != null && signSchemeFilterEntry.size() > 0) {
            this.getModel().setValue(BIZOBJECTID, (Object)((DynamicObject)signSchemeFilterEntry.get(0)).getString("formnumber"));
            for (int i = 0; i < signSchemeFilterEntry.size(); ++i) {
                DynamicObject filterObj = (DynamicObject)signSchemeFilterEntry.get(i);
                if (StringUtils.isBlank((Object)filterObj.get(FILTERCONDITION))) continue;
                model.createNewEntryRow(FILTER_ENTRY);
                model.setValue(ENABLE, filterObj.get(ENABLE), i);
                model.setValue(FILTERTYPE, filterObj.get(FILTERTYPE), i);
                model.setValue(FILTERNAME, filterObj.get(FILTERNAME), i);
                model.setValue(FILTERCONDITION, filterObj.get(FILTERCONDITION), i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty obj = e.getProperty();
        if (ENABLE.equalsIgnoreCase(obj.getName())) {
            this.setEnable();
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        String signSchemeId = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEME_ID);
        DynamicObjectCollection list = model.getEntryEntity(FILTER_ENTRY);
        DynamicObject[] filterArr = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)SIGNENTITY_FILTER);
            DynamicObject schemeFilter = new DynamicObject((DynamicObjectType)dt);
            schemeFilter.set(ID, (Object)signSchemeId);
            schemeFilter.set(ENABLE, model.getValue(ENABLE, i));
            schemeFilter.set(FILTERTYPE, model.getValue(FILTERTYPE, i));
            schemeFilter.set(FILTERNAME, model.getValue(FILTERNAME, i));
            schemeFilter.set(FILTERCONDITION, model.getValue(FILTERCONDITION, i));
            filterArr[i] = schemeFilter;
        }
        SaveServiceHelper.save((DynamicObject[])filterArr);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTRY_SIGNSCHEME);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{signSchemeId}, (DynamicObjectType)type);
        DynamicObject obj = (DynamicObject)objs.get(Long.parseLong(signSchemeId));
        BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{obj});
        cacheManager.removeByFilterDt();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SignSchemeFilterEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.getView().close();
    }

    private void deleteEntry(Long id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", -5, (Object)id)};
                String SQL = String.format("delete from %s where Fid = ?;", TABLE_FILTER);
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void clearAllEntryRow() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(FILTER_ENTRY);
        for (int i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow(FILTER_ENTRY, i);
        }
    }

    private void showFilterEditer() {
        FormMetadata formMeta;
        String entityId;
        Object bizEntity;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(FILTER_ENTRY);
        Object name = this.getModel().getValue(FILTERNAME, currentRowIndex);
        Object condition = this.getModel().getValue(FILTERCONDITION, currentRowIndex);
        Object type = this.getModel().getValue(FILTERTYPE, currentRowIndex);
        if (!"1".equals(type)) {
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)configInfo.get("billformid");
        if (StringUtils.isBlank((CharSequence)formId) && (bizEntity = this.getModel().getValue(BIZOBJECTID)) != null) {
            formId = (String)bizEntity;
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"SignSchemeFilterEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (!id.equals(entityId = (formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form)).getEntityId())) {
            formId = MetadataDao.getNumberById((String)entityId);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FILTER_EDIT);
        showParameter.setCustomParam("formid", (Object)formId);
        showParameter.setCustomParam("name", name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FILTERNAME);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setEnable() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(FILTER_ENTRY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        int curIdx = this.getModel().getEntryCurrentRowIndex(FILTER_ENTRY);
        if (curIdx < 0) {
            return;
        }
        for (int i = 0; i < doc.size(); ++i) {
            if (i == curIdx) continue;
            this.getModel().setValue(ENABLE, (Object)false, i);
        }
    }

    private boolean checkData() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(FILTER_ENTRY);
        if (doc == null || doc.isEmpty()) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < doc.size(); ++i) {
            boolean enable;
            DynamicObject obj = (DynamicObject)doc.get(i);
            boolean bl = enable = obj.get(ENABLE) == null ? false : obj.getBoolean(ENABLE);
            if (!enable) continue;
            ++count;
        }
        if (count > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u6301\u5f00\u542f\u4e00\u4e2a\u8fc7\u6ee4\u6761\u4ef6", (String)"SignSchemeFilterEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

