/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ca.SignService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.designer.tree.BizAppTreeBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterWriter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class SignSchemeListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String KEY_NEW = "new";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_BTN_ORG = "btn_org";
    private static final String KEY_BTN_FILTER = "btn_filter";
    protected static final String Key_FormNumber = "formnumber";
    private static final String KEY_FORM_NAME = "formname";
    protected static final String Key_FID = "fid";
    protected static final String Key_Signs = "signs";
    protected static final String Key_SignField = "signfield";
    protected static final String Key_SignOperate = "signoperate";
    protected static final String Key_VerifyOperate = "verifyoperate";
    protected static final String Key_SignFieldDesc = "signfielddesc";
    protected static final String Key_SignOperateDesc = "signoperatedesc";
    protected static final String Key_VerifyOperateDesc = "verifyoperatedesc";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_SCHEME = "searchscheme";
    protected static final String Key_ORG = "FOrgID";
    protected static final String FSIGN_FIELD = "fsignfield";
    protected static final String Key_ORGID = "orgid";
    private static final String SCHEME_ENTITY = "sign_scheme";
    private static final String FORM_ID_NEW_SCHEME = "bd_signfieldedit";
    private static final String FORM_ID_ORG = "bos_signscheme_org";
    private static final String FORM_ID_FILTER = "bos_signscheme_filter";
    private static final String CACHE_ID_SIGN_SCHEME = "SignSchemes";
    private static final String CACHE_ID_TREE_NODES = "nodes";
    private static final String CACHE_ID_CURR_NODE = "currnode";
    public static final String ParamKey_FormObject = "formobject";
    private static final String PARAM_KEY_IS_ENABLE_SIGN_ORG = "isenablesignorg";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String PROJECT_NAME = "bos-ca";
    private static final String FCLEAR_TEXT = "FClearText";
    private static final String FSIGN_TEXT = "FSignText";
    private static final String FUSER_ID = "FuserId";
    private static Log log = LogFactory.getLog(SignSchemeListPlugin.class);
    private List<SignScheme> _allScheme;

    public void initialize() {
        super.initialize();
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = service.getModeType();
        if (modelType == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BTN_ORG});
        }
        TreeView tView = (TreeView)this.getControl(KEY_TREE_VIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_SCHEME);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHE_ID_SIGN_SCHEME);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<SignScheme> allSchemes = this.loadAllScheme();
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(KEY_TREE_VIEW);
        tView.addNode(rootNode);
        List<SignScheme> signSchemes = this.doSearchByNodeId(allSchemes, "");
        this.putSchemeCache(signSchemes);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = e.getOperateKey();
        if (KEY_NEW.equalsIgnoreCase(opKey)) {
            this.doNew();
        } else if (KEY_MODIFY.equalsIgnoreCase(opKey)) {
            this.doModify();
        } else if (KEY_DELETE.equalsIgnoreCase(opKey)) {
            this.doBeforeDelete();
        } else if ("donothing_ctorg".equalsIgnoreCase(opKey)) {
            this.showOrg();
        } else if ("donothing_filter".equalsIgnoreCase(opKey)) {
            this.showFilter();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(KEY_NEW)) {
            this.afterShowNewForm(closedCallBackEvent, KEY_NEW);
        } else if (actionId.equalsIgnoreCase(KEY_MODIFY)) {
            this.afterShowNewForm(closedCallBackEvent, KEY_MODIFY);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doDelete();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CACHE_ID_CURR_NODE))) {
            return;
        }
        List<SignScheme> allSchemes = this.getSchemeCache();
        this.doSearchByNodeId(allSchemes, newNodeId);
        this.getPageCache().put(CACHE_ID_CURR_NODE, newNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.doModify();
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_SCHEME, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_SCHEME, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        }
    }

    private void doNew() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_NEW_SCHEME);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("treeNodeId", (Object)this.getPageCache().get(CACHE_ID_CURR_NODE));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_NEW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doModify() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"SignSchemeListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        String formNumber = (String)this.getModel().getValue(Key_FormNumber, rowIndex);
        long fid = (Long)this.getModel().getValue(Key_FID, rowIndex);
        String orgId = StringUtils.isBlank((Object)this.getModel().getValue(Key_ORGID, rowIndex)) ? "" : (String)this.getModel().getValue(Key_ORGID, rowIndex);
        List<Map<String, Object>> signs = this.getSigns(rowIndex);
        String signOperateDesc = (String)this.getModel().getValue(Key_SignOperateDesc, rowIndex);
        signs.get(0).put("SignoperateDesc", signOperateDesc);
        boolean isEnableSignOrg = SignSchemeListPlugin.isEnableSignOrg(formNumber);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_NEW_SCHEME);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("value", signs);
        showParameter.setCustomParam("value", signs);
        showParameter.setCustomParam("formNumber", (Object)formNumber);
        showParameter.setCustomParam(Key_FID, (Object)fid);
        showParameter.setCustomParam(Key_ORGID, (Object)orgId);
        showParameter.setCustomParam("treeNodeId", (Object)this.getPageCache().get(CACHE_ID_CURR_NODE));
        showParameter.setCustomParam(PARAM_KEY_IS_ENABLE_SIGN_ORG, (Object)isEnableSignOrg);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_MODIFY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private List<Map<String, Object>> getSigns(int selectRow) {
        ArrayList<Map<String, Object>> signs = new ArrayList<Map<String, Object>>();
        String signFieldStr = (String)this.getModel().getValue(Key_SignField, selectRow);
        String signOperateStr = (String)this.getModel().getValue(Key_SignOperate, selectRow);
        String verifyOperateStr = (String)this.getModel().getValue(Key_VerifyOperate, selectRow);
        List signField = StringUtils.isBlank((CharSequence)signFieldStr) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)signFieldStr, List.class);
        HashMap<String, Object> signFieldMap = new HashMap<String, Object>();
        signFieldMap.put("Signfield", signField);
        signFieldMap.put("Signoperate", signOperateStr);
        signFieldMap.put("Verifyoperate", verifyOperateStr);
        signs.add(signFieldMap);
        return signs;
    }

    private void doBeforeDelete() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"SignSchemeListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u7b7e\u540d\u914d\u7f6e\u65b9\u6848\u5417\uff1f", (String)"SignSchemeListPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
    }

    private void doDelete() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (int idx : selRows) {
            long fid = (Long)this.getModel().getValue(Key_FID, idx);
            schemeIds.add(fid);
        }
        this.delete(schemeIds);
        this.getModel().deleteEntryRows(KEY_ENTRY_ENTITY, selRows);
        grid.clearEntryState();
        List<SignScheme> allSchemes = this.getSchemeCache();
        Iterator<SignScheme> iterator = allSchemes.iterator();
        while (iterator.hasNext()) {
            SignScheme signScheme = iterator.next();
            if (!schemeIds.contains(signScheme.getId())) continue;
            iterator.remove();
        }
        this.putSchemeCache(allSchemes);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SignSchemeListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private void showOrg() {
        SignScheme myScheme = this.getSelectScheme();
        if (myScheme == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_ORG);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("signSchemeId", (Object)String.valueOf(myScheme.getId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_BTN_ORG);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d7\u63a7\u7ec4\u7ec7", (String)"SignSchemeListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void showFilter() {
        SignScheme myScheme = this.getSelectScheme();
        if (myScheme == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_FILTER);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("signSchemeId", (Object)String.valueOf(myScheme.getId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_BTN_FILTER);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u8303\u56f4", (String)"SignSchemeListPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private SignScheme getSelectScheme() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"SignSchemeListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        long fid = (Long)this.getModel().getValue(Key_FID, rowIndex);
        List<SignScheme> allSchemes = this.getSchemeCache();
        SignScheme myScheme = null;
        for (SignScheme scheme : allSchemes) {
            if (fid != scheme.getId()) continue;
            myScheme = scheme;
            break;
        }
        return myScheme;
    }

    private List<String> doSearchList(String searchText) {
        HashSet<String> searchList = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<String>();
        }
        List<SignScheme> allSchemes = this.getSchemeCache();
        for (SignScheme scheme : allSchemes) {
            if (StringUtils.isNotBlank((CharSequence)scheme.getFormName()) && scheme.getFormName().indexOf(searchText) == 0) {
                searchList.add(scheme.getFormName());
            } else if (StringUtils.isNotBlank((CharSequence)scheme.getFormNumber()) && scheme.getFormNumber().indexOf(searchText) == 0) {
                searchList.add(scheme.getFormNumber());
            }
            if (searchList.size() < 10) continue;
            break;
        }
        return new ArrayList<String>(searchList);
    }

    private void doSearchByBill(String searchText) {
        List<SignScheme> allSchemes = this.getSchemeCache();
        ArrayList<SignScheme> mySchemes = new ArrayList<SignScheme>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            mySchemes.addAll(allSchemes);
        } else {
            for (SignScheme scheme : allSchemes) {
                if ((!StringUtils.isNotBlank((CharSequence)scheme.getFormName()) || scheme.getFormName().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)scheme.getFormNumber()) || scheme.getFormNumber().indexOf(searchText) < 0)) continue;
                mySchemes.add(scheme);
            }
        }
        this.refreshEntryGrid(mySchemes);
    }

    private List<SignScheme> doSearchByNodeId(List<SignScheme> allSchemes, String nodedId) {
        ArrayList<SignScheme> mySchemes = new ArrayList<SignScheme>();
        String rootNodeJson = this.getPageCache().get(CACHE_ID_TREE_NODES);
        BizAppTreeBuilder bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)rootNodeJson, BizAppTreeBuilder.class);
        TreeNode rootNode = bizAppTreeBuilder.getRootNode();
        HashSet<String> bizAppIds = new HashSet<String>();
        if (rootNode.getId().equals(nodedId) || "".equals(nodedId)) {
            if (rootNode.getChildren() != null) {
                for (TreeNode cloudNode : rootNode.getChildren()) {
                    bizAppIds.add(nodedId);
                    if (cloudNode.getChildren() == null) continue;
                    for (TreeNode bizAppNode : cloudNode.getChildren()) {
                        bizAppIds.add(bizAppNode.getId());
                        bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                    }
                }
            }
            for (SignScheme scheme : allSchemes) {
                if (!bizAppIds.contains(scheme.getBizAppId()) && !"".equals(scheme.getBizAppId())) continue;
                mySchemes.add(scheme);
            }
        } else {
            TreeNode cloudNode = null;
            if (rootNode.getChildren() != null) {
                for (TreeNode node : rootNode.getChildren()) {
                    if (!node.getId().equals(nodedId)) continue;
                    cloudNode = node;
                    break;
                }
            }
            if (cloudNode != null) {
                bizAppIds.add(nodedId);
                if (cloudNode.getChildren() != null) {
                    for (TreeNode bizAppNode : cloudNode.getChildren()) {
                        bizAppIds.add(bizAppNode.getId());
                        bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                    }
                }
            } else {
                bizAppIds.add(nodedId);
                bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
            }
            for (SignScheme scheme : allSchemes) {
                if (!bizAppIds.contains(scheme.getBizAppId())) continue;
                mySchemes.add(scheme);
            }
        }
        this.refreshEntryGrid(mySchemes);
        return mySchemes;
    }

    private void refreshEntryGrid(List<SignScheme> schemes) {
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        if (schemes.size() > 0) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, schemes.size());
            for (int index = 0; index < schemes.size(); ++index) {
                SignScheme scheme = schemes.get(index);
                this.renderRow(scheme, index);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void afterShowNewForm(ClosedCallBackEvent closedCallBackEvent, String actionId) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params == null) {
            return;
        }
        DynamicObject formObject = (DynamicObject)params.get(ParamKey_FormObject);
        if (StringUtils.isBlank((Object)formObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61", (String)"SignSchemeListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String formNumber = formObject.getString("number");
        String formName = formObject.getLocaleString("name").toString();
        long fid = params.get(Key_FID) == null ? 0L : Long.parseLong(params.get(Key_FID).toString());
        DynamicObject orgObject = (DynamicObject)params.get(Key_ORG);
        long org = orgObject == null ? 0L : orgObject.getLong("masterid");
        List signs = (List)params.get("value");
        String bizAppId = this.getBizAppId(formObject);
        boolean isEnableSignOrg = params.get(PARAM_KEY_IS_ENABLE_SIGN_ORG) != null && (Boolean)params.get(PARAM_KEY_IS_ENABLE_SIGN_ORG) != false;
        String signField = "";
        String verifyOperate = "";
        String signFieldDesc = "";
        String signOperateDesc = "";
        String verifyOperateDesc = "";
        List<Map<String, Object>> signOperates = new ArrayList<Map<String, Object>>();
        if (signs != null && signs.size() > 0) {
            Map sign = (Map)signs.get(0);
            List fields = (List)sign.get("Signfield");
            signField = SerializationUtils.toJsonString((Object)fields);
            signFieldDesc = this.getListString(fields);
            signOperates = (List)sign.get("Signoperate");
            verifyOperate = (String)sign.get("Verifyoperate");
            Tuple<String, String> operateDescTuple = this.getOperationsString(signOperates, verifyOperate, formNumber);
            signOperateDesc = (String)operateDescTuple.item1;
            verifyOperateDesc = (String)operateDescTuple.item2;
        }
        List<SignScheme> allSchemes = this.getSchemeCache();
        SignScheme scheme = new SignScheme(formNumber, formName, org, signField, signOperates, verifyOperate);
        if (fid != 0L) {
            scheme.setId(fid);
        }
        scheme.setBizAppId(bizAppId);
        scheme.setSignFieldDesc(signFieldDesc);
        scheme.setSignOperateDesc(signOperateDesc);
        scheme.setVerifyOperateDesc(verifyOperateDesc);
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        String formAppId = MetadataDao.getAppIdByFormId((String)formId);
        scheme.setFormBizAppId(formAppId);
        this.save(scheme);
        this.createSignTable(formNumber);
        SignSchemeListPlugin.updateBillParam(formNumber, isEnableSignOrg);
        if (actionId.equalsIgnoreCase(KEY_MODIFY)) {
            allSchemes.remove(this.getSelectScheme());
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
            allSchemes.add(scheme);
            this.putSchemeCache(allSchemes);
            this.renderRow(scheme, rowIndex);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SignSchemeListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        allSchemes.add(scheme);
        this.putSchemeCache(allSchemes);
        this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
        int rowIndex = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY) - 1;
        this.renderRow(scheme, rowIndex);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SignSchemeListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private String getBizAppId(DynamicObject formObject) {
        if (formObject == null) {
            return " ";
        }
        String nodeId = this.getPageCache().get(CACHE_ID_CURR_NODE);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ID_TREE_NODES), TreeNode.class);
        TreeNode node = rootNode.getTreeNode(nodeId);
        if (node != null && "app".equals(node.getData())) {
            return node.getId();
        }
        String bizAppId = " ";
        try {
            bizAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)formObject.getPkValue(), (String)formObject.getDynamicObjectType().getName()).getString("bizappid_id");
            if (StringUtils.isBlank((CharSequence)bizAppId)) {
                bizAppId = " ";
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return bizAppId;
    }

    private void renderRow(SignScheme scheme, int rowIndex) {
        this.getModel().setValue(Key_FormNumber, (Object)scheme.getFormNumber(), rowIndex);
        this.getModel().setValue(KEY_FORM_NAME, (Object)scheme.getFormName(), rowIndex);
        this.getModel().setValue(Key_SignField, (Object)scheme.getSignField(), rowIndex);
        this.getModel().setValue(Key_SignOperate, (Object)scheme.getSignOperate(), rowIndex);
        this.getModel().setValue(Key_VerifyOperate, (Object)scheme.getVerifyOperate(), rowIndex);
        this.getModel().setValue(Key_SignFieldDesc, (Object)scheme.getSignFieldDesc(), rowIndex);
        this.getModel().setValue(Key_SignOperateDesc, (Object)scheme.getSignOperateDesc(), rowIndex);
        this.getModel().setValue(Key_VerifyOperateDesc, (Object)scheme.getVerifyOperateDesc(), rowIndex);
        this.getModel().setValue(Key_FID, (Object)scheme.getId(), rowIndex);
        this.getModel().setValue(Key_ORGID, (Object)scheme.getOrg(), rowIndex);
        this.getModel().setValue(Key_ORG, (Object)scheme.getOrg(), rowIndex);
    }

    protected static boolean existScheme(String formNumber, long fid) {
        String sql = "select FID, FFORMNUMBER, FOrgID, FSIGNFIELD, FSIGNOPERATE, FVERIFYOPERATE,FBIZAPPID from T_BD_SIGNSCHEME where FFORMNUMBER = ?";
        Object[] sqlParams = new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter("FFORMNUMBER", 12, (Object)formNumber)};
        Set ids = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParams, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> ids = new HashSet<Long>(16);
                while (rs.next()) {
                    ids.add(rs.getLong(1));
                }
                return ids;
            }
        });
        int count = (int)ids.stream().filter(id -> id != fid).count();
        return count > 0;
    }

    private TreeNode buildTreeNodes() {
        BizAppTreeBuilder bizAppTreeBuilder = new BizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"SignSchemeListPlugin_5", (String)PROJECT_NAME, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        this.filterCloudAndAppNodes(root);
        String json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
        this.getPageCache().put(CACHE_ID_TREE_NODES, json);
        return root;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
        this.removeEmptyCloudNode(cloudNodes);
    }

    private void removeEmptyCloudNode(List<TreeNode> cloudNodes) {
        if (CollectionUtils.isEmpty(cloudNodes)) {
            return;
        }
        Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = cloudIterator.next();
            List appNodes = cloud.getChildren();
            if (!CollectionUtils.isEmpty((Collection)appNodes)) continue;
            cloudIterator.remove();
        }
    }

    private void putSchemeCache(List<SignScheme> schemes) {
        String schemesJsonString = SerializationUtils.toJsonString(schemes);
        this.getPageCache().put(CACHE_ID_SIGN_SCHEME, schemesJsonString);
        this._allScheme = schemes;
    }

    private List<SignScheme> getSchemeCache() {
        if (this._allScheme != null) {
            return this._allScheme;
        }
        String schemesJsonString = this.getPageCache().get(CACHE_ID_SIGN_SCHEME);
        this._allScheme = StringUtils.isBlank((CharSequence)schemesJsonString) ? new ArrayList<SignScheme>() : SerializationUtils.fromJsonStringToList((String)schemesJsonString, SignScheme.class);
        return this._allScheme;
    }

    public String getListString(List<Map<String, Object>> fields) {
        if (fields == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map<String, Object> field : fields) {
            builder.append(field.get("Id"));
            if (++i >= fields.size()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private Tuple<String, String> getOperationsString(List<Map<String, Object>> signOperates, String verifyOperate, String formNumber) {
        if (CollectionUtils.isEmpty(signOperates) && StringUtils.isBlank((CharSequence)verifyOperate)) {
            return new Tuple((Object)"", (Object)"");
        }
        List ops = null;
        if (!StringUtils.isBlank((CharSequence)formNumber)) {
            ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        }
        String signOperate = this.getOperationsOpCodeString(signOperates);
        return new Tuple((Object)this.getOperationName(signOperate, ops), (Object)this.getOperationName(verifyOperate, ops));
    }

    private String getOperationName(String signOperate, List<Map<String, Object>> ops) {
        String[] operations;
        if (StringUtils.isBlank((CharSequence)signOperate)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String name : operations = signOperate.split(",")) {
            if (ops != null && !ops.isEmpty()) {
                name = this.getOpName(name, ops);
            }
            builder.append(name);
            if (++i >= operations.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private String getOperationsOpCodeString(List<Map<String, Object>> operations) {
        if (operations == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map<String, Object> operation : operations) {
            String opCode = operation.get("OpCode").toString();
            builder.append(opCode);
            if (++i >= operations.size()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private String getOpName(String opKey, List<Map<String, Object>> ops) {
        String opName = "";
        for (Map<String, Object> op : ops) {
            if (!StringUtils.equals((CharSequence)opKey, (CharSequence)String.valueOf(op.get("key")))) continue;
            opName = op.get("name") == null ? "" : (String)((Map)op.get("name")).get(Lang.get().toString());
            break;
        }
        if (StringUtils.isBlank((CharSequence)opName)) {
            opName = opKey;
        }
        return opName;
    }

    private List<SignScheme> loadAllScheme() {
        String sql = "select FID, FFORMNUMBER, FOrgID, FSIGNFIELD, FSIGNOPERATE, FVERIFYOPERATE,FBIZAPPID from T_BD_SIGNSCHEME";
        StringBuilder formNumParam = new StringBuilder();
        List allScheme = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            ArrayList<SignScheme> allScheme1 = new ArrayList<SignScheme>(10);
            while (rs.next()) {
                SignScheme scheme = new SignScheme();
                long id = rs.getLong(1);
                scheme.setId(id);
                scheme.setFormNumber(rs.getString(2));
                formNumParam.append("'").append(scheme.getFormNumber()).append("',");
                scheme.setOrg(rs.getLong(3));
                scheme.setSignField(rs.getString(4));
                String signOperate = rs.getString(5);
                List<Map<String, Object>> signOperateList = SignService.getSignOperates(signOperate);
                scheme.setSignOperate(SerializationUtils.toJsonString(signOperateList));
                scheme.setVerifyOperate(rs.getString(6));
                scheme.setBizAppId(rs.getString(7));
                Tuple<String, String> operationsDescTuple = this.getOperationsString(signOperateList, scheme.getVerifyOperate(), scheme.getFormNumber());
                scheme.setSignOperateDesc((String)operationsDescTuple.item1);
                scheme.setVerifyOperateDesc((String)operationsDescTuple.item2);
                allScheme1.add(scheme);
            }
            return allScheme1;
        });
        sql = "select fnumber,fname from t_meta_entitydesign_l where fnumber in (%s) and flocaleid = '%s'";
        if (formNumParam.length() > 0) {
            sql = String.format(sql, formNumParam.substring(0, formNumParam.length() - 1), RequestContext.get().getLang().toString());
            Map formMapping = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getString(2));
                }
                return map;
            });
            allScheme.stream().forEach(item -> {
                String formName = (String)formMapping.get(item.getFormNumber());
                item.setFormName(formName == null ? item.getFormNumber() : formName);
            });
        }
        return allScheme;
    }

    private boolean save(SignScheme scheme) {
        IDataEntityType signSchemeType = OrmUtils.getDataEntityType(SignScheme.class);
        Object[] result = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        if (scheme.getId() > 0L) {
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])new Object[]{scheme.getId()}, (DynamicObjectType)type);
            if (objs == null || objs.length == 0) {
                return false;
            }
            DynamicObject obj = objs[0];
            obj = this.setDynamicObject(obj, scheme);
            BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{obj});
            cacheManager.removeByDt();
            return true;
        }
        result = SaveServiceHelper.save((IDataEntityType)signSchemeType, (Object[])new Object[]{scheme});
        cacheManager.removeByDt();
        return result != null && result.length > 0;
    }

    private DynamicObject setDynamicObject(DynamicObject obj, SignScheme scheme) {
        if (scheme == null) {
            return obj;
        }
        obj.set(Key_FormNumber, (Object)scheme.getFormNumber());
        obj.set(Key_SignField, (Object)scheme.getSignField());
        obj.set(Key_SignOperate, (Object)scheme.getSignOperate());
        obj.set(Key_VerifyOperate, (Object)scheme.getVerifyOperate());
        obj.set("bizappid", (Object)(scheme.getBizAppId() == null ? "" : scheme.getBizAppId()));
        return obj;
    }

    private void delete(List schemeIds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])schemeIds.toArray());
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByDt();
    }

    private void createSignTable(String number) {
        ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>();
        String formId = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        String dbRoueKey = entityMetadata.getDBRouteKey();
        List entityList = entityMetadata.getEntitys();
        for (Entity entity : entityList) {
            if (!(entity instanceof BillEntity)) continue;
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (sqlList != null && sqlList.size() > 0) {
            for (SqlObject list : sqlList) {
                DBRoute dbRoute = new DBRoute(dbRoueKey);
                DB.execute((DBRoute)dbRoute, (String)list.getSql(), (Object[])list.getParams());
            }
        }
    }

    private void genAlertSignTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
        StringBuilder sb = new StringBuilder();
        String sql = "";
        String pkFieldName = null;
        String pkFieldType = null;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        String signTableName = entity.getTableName() + "_SN";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)signTableName);
        if (null == tableSchema) {
            sb.append(String.format("CREATE TABLE %s (", signTableName));
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(" NOT NULL,");
            sb.append("CONSTRAINT ");
            String pkName = "pk_" + (signTableName.length() > 2 ? signTableName.substring(2) : signTableName);
            sb.append(pkName);
            sb.append(String.format(" PRIMARY KEY(%s));", pkFieldName));
            sql = sb.toString();
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FSIGN_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s bigint NOT NULL;", signTableName, Key_ORG);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(2000);", signTableName, FSIGN_FIELD);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        } else {
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                sql = String.format("ALTER TABLE %s ADD %s " + pkFieldType + " NOT NULL;", signTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, FCLEAR_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, FSIGN_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(4000) NOT NULL;", signTableName, FSIGN_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, FUSER_ID)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, Key_ORG)) {
                sql = String.format("ALTER TABLE %s ADD %s bigint NOT NULL;", signTableName, Key_ORG);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!SignSchemeListPlugin.existsFieldInTableSchema(tableSchema, FSIGN_FIELD)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(2000);", signTableName, FSIGN_FIELD);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }

    private String getPkFieldType(int pkInt) {
        String pkFieldType = null;
        switch (pkInt) {
            case 12: {
                pkFieldType = "VARCHAR(18)";
                break;
            }
            case -9: {
                pkFieldType = "NVARCHAR(18)";
                break;
            }
            case 4: {
                pkFieldType = "INTEGER";
                break;
            }
            case -5: {
                pkFieldType = "BIGINT";
                break;
            }
            default: {
                pkFieldType = "NVARCHAR";
            }
        }
        return pkFieldType;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.doModify();
    }

    private static void updateBillParam(String formNumber, boolean isEnableSignOrg) {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put(PARAM_KEY_IS_ENABLE_SIGN_ORG, isEnableSignOrg);
        ParameterWriter.saveBillParameter((String)formNumber, param);
    }

    private static boolean isEnableSignOrg(String formNumber) {
        BillParam billParam = ParameterHelper.getBillParam((String)formNumber);
        return billParam != null && billParam.getOverallParam() != null && billParam.getOverallParam().isEnableSignOrg();
    }
}

