/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SignSchemeOrgEditPlugin
extends AbstractFormPlugin {
    private static final String TABLE_SIGNSCHEME = "t_bd_signscheme";
    private static final String ENTRY_SIGNSCHEME = "sign_scheme";
    private static final String TABLE_ORG = "t_bd_signschemeorg";
    private static final String SIGNENTITY_ORG = "bos_signscheme_orgentity";
    private static final String SEQ = "sseq";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TOOL_BAR = "toolbar";
    private static final String BTN_ADD_LINE = "btnaddline";
    private static final String BTN_DELETE_LINE = "btndeleteline";
    private static final String BTN_SAVE = "btnsave";
    private static final String ORG = "org";
    private static final String ORG_ID = "orgid";
    private static final String ORG_F7 = "orgf7";
    private static final String ENTITY_ORG = "orgentity";
    private static final String IS_INCLUDE_SUB_ORG = "isincludesuborg";
    private static final String BASE_DATA_ID = "fbasedataId";
    private static final String PROPERTY = "property";
    private static final String PROPERTY_VALUE = "propertyvalue";
    private static final String ENABLE = "enable";
    private static final String BIZOBJECTID = "bizobjectid";
    private static final String BTN_ADD = "btn_add";
    private static final String REFRESH = "refresh";
    private static final String SIGN_SCHEMEID = "signSchemeId";
    private static final String FORM_NUMBER = "formnumber";
    private static final String DEFAULT_ORGFUNCID = "15";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_SAVE});
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "btnaddline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgf7();
                break;
            }
        }
    }

    private void refreshOrgf7() {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity(ENTITY_ORG);
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject obj : curOrgList) {
            ids.add(Long.parseLong(String.valueOf(obj.getDynamicObject(ORG_ID).getPkValue())));
        }
        this.getModel().setValue(ORG_F7, (Object)ids.toArray());
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.getControl(ORG_F7);
        base.setOrgFuncId(this.getOrgFuncId(this.getModel().getValue(BIZOBJECTID)));
        base.click();
    }

    private String getOrgFuncId(Object bizObject) {
        if (StringUtils.isBlank((Object)bizObject)) {
            return DEFAULT_ORGFUNCID;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return DEFAULT_ORGFUNCID;
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return DEFAULT_ORGFUNCID;
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return DEFAULT_ORGFUNCID;
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? DEFAULT_ORGFUNCID : orgfuncid;
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                String signSchemeId = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEMEID);
                if (!this.checkData(signSchemeId)) {
                    return;
                }
                this.deleteEntry(Long.parseLong(signSchemeId));
                this.saveData();
                break;
            }
        }
    }

    private boolean checkData(String signSchemeId) {
        String bizObjectId = this.queryBizObjectById(signSchemeId);
        DynamicObjectCollection list = this.getModel().getEntryEntity(ENTITY_ORG);
        if (!list.isEmpty()) {
            HashSet<String> newOrgSet = new HashSet<String>();
            for (int i = 0; i < list.size(); ++i) {
                Object org = this.getModel().getValue(ORG_ID, i);
                if (!(org instanceof DynamicObject)) continue;
                Object pkValue = ((DynamicObject)org).getPkValue();
                newOrgSet.add(String.valueOf(pkValue));
            }
            String msg = this.isDuplicateScheme(bizObjectId, signSchemeId, newOrgSet);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showErrorNotification(msg);
                return false;
            }
        }
        return true;
    }

    private String queryBizObjectById(String signSchemeId) {
        if (StringUtils.isBlank((CharSequence)signSchemeId)) {
            return "";
        }
        ORM orm = ORM.create();
        QFilter filer = new QFilter(ID, "=", (Object)Long.parseLong(signSchemeId));
        QFilter[] filters = new QFilter[]{filer};
        DynamicObject bizObj = orm.queryOne(ENTRY_SIGNSCHEME, "id, formnumber", filters);
        return bizObj.getString(FORM_NUMBER);
    }

    private String isDuplicateScheme(String bizObjectId, String signSchemeId, Set<String> orgSet) {
        if (StringUtils.isBlank((CharSequence)bizObjectId) || StringUtils.isBlank((CharSequence)signSchemeId)) {
            return null;
        }
        QFilter[] qFilter = new QFilter[]{new QFilter(FORM_NUMBER, "=", (Object)bizObjectId), new QFilter(ID, "!=", (Object)Long.parseLong(signSchemeId))};
        StringBuilder selectFileds = new StringBuilder();
        selectFileds.append(" id");
        selectFileds.append(", formnumber");
        selectFileds.append(", orgentry.orgid org");
        selectFileds.append(", orgentry.orgid.number number");
        DynamicObjectCollection col = QueryServiceHelper.query((String)ENTRY_SIGNSCHEME, (String)selectFileds.toString(), (QFilter[])qFilter, null);
        if (col == null || col.size() == 0) {
            return null;
        }
        ArrayList<String> allSchemeOrgList = new ArrayList<String>();
        String name = "";
        for (Object obj : col) {
            name = obj.getString(FORM_NUMBER);
            String orgId = obj.getString(ORG);
            if (!StringUtils.isNotBlank((CharSequence)orgId)) continue;
            allSchemeOrgList.add(orgId);
        }
        ArrayList<String> duplicateOrgList = new ArrayList<String>();
        for (String orgId : orgSet) {
            if (StringUtils.isBlank((CharSequence)orgId) || !allSchemeOrgList.contains(orgId)) continue;
            duplicateOrgList.add(orgId);
        }
        String msg = null;
        if (!duplicateOrgList.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61[%1$s]\u4e2d\u4e0b\u5217\u7ec4\u7ec7\u5df2\u5b58\u5728\u76f8\u540c\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u9002\u7528\u7ec4\u7ec7\uff1a[%2$s]", (String)"SignSchemeOrgEditPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]), name, String.join((CharSequence)"\uff0c", duplicateOrgList));
        }
        return msg;
    }

    public void afterCreateNewData(EventObject e) {
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        String signSchemeId = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEMEID);
        signSchemeId = signSchemeId == null ? "" : signSchemeId;
        Long signSchemePkId = StringUtils.isBlank((CharSequence)signSchemeId) ? 0L : Long.parseLong(signSchemeId);
        QFilter schemeFilter = new QFilter(ID, "=", (Object)signSchemePkId);
        QFilter[] filters = new QFilter[]{schemeFilter};
        DynamicObjectCollection signSchemeOrgEntry = QueryServiceHelper.query((String)ENTRY_SIGNSCHEME, (String)"id,formnumber,orgentry.orgid orgid,orgentry.isincludesuborg isincludesuborg,orgentry.orgid.number number,orgentry.orgid.name name", (QFilter[])filters);
        HashSet<Long> orgSet = new HashSet<Long>();
        if (signSchemeOrgEntry != null && signSchemeOrgEntry.size() > 0) {
            this.getModel().setValue(BIZOBJECTID, (Object)((DynamicObject)signSchemeOrgEntry.get(0)).getString(FORM_NUMBER));
            for (int i = 0; i < signSchemeOrgEntry.size(); ++i) {
                DynamicObject orgObj = (DynamicObject)signSchemeOrgEntry.get(i);
                String orgid = orgObj.getString(ORG_ID);
                if (StringUtils.isBlank((Object)orgObj.get(NUMBER))) break;
                model.createNewEntryRow(ENTITY_ORG);
                model.setValue(ORG_ID, orgObj.get(ORG_ID), i);
                model.setValue(IS_INCLUDE_SUB_ORG, orgObj.get(IS_INCLUDE_SUB_ORG), i);
                orgSet.add(Long.parseLong(orgid));
            }
        }
        this.getModel().setValue(ORG_F7, (Object)orgSet.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (ORG_F7.equals(proName)) {
            this.refreshOrgEntity(e);
        }
    }

    private void refreshOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity(ENTITY_ORG);
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>();
        for (DynamicObject curOrgObj : curOrgList) {
            subOrgMap.put(curOrgObj.getDynamicObject(ORG_ID).getLong(ID), curOrgObj.get(IS_INCLUDE_SUB_ORG));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        int m = orgCol.size();
        for (int i = 0; i < m; ++i) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(i);
            DynamicObject org = orgObj.getDynamicObject(BASE_DATA_ID);
            if (org == null) continue;
            this.getModel().createNewEntryRow(ENTITY_ORG);
            this.getModel().setValue(ORG_ID, (Object)org, i);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong(ID));
            if (isIncludeSubOrg == null) continue;
            this.getModel().setValue(IS_INCLUDE_SUB_ORG, isIncludeSubOrg, i);
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        String signSchemeId = (String)this.getView().getFormShowParameter().getCustomParam(SIGN_SCHEMEID);
        DynamicObjectCollection list = model.getEntryEntity(ENTITY_ORG);
        DynamicObject[] orgArr = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)SIGNENTITY_ORG);
            DynamicObject schemeOrg = new DynamicObject((DynamicObjectType)dt);
            schemeOrg.set(ID, (Object)signSchemeId);
            schemeOrg.set(ORG_ID, model.getValue(ORG_ID, i));
            schemeOrg.set(IS_INCLUDE_SUB_ORG, model.getValue(IS_INCLUDE_SUB_ORG, i));
            orgArr[i] = schemeOrg;
        }
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])orgArr);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTRY_SIGNSCHEME);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{signSchemeId}, (DynamicObjectType)type);
        DynamicObject obj = (DynamicObject)objs.get(Long.parseLong(signSchemeId));
        BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{obj});
        cacheManager.removeByFilterDt();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SignSchemeOrgEditPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void deleteEntry(Long id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", -5, (Object)id)};
                String SQL = String.format("delete from %s where Fid = ?;", TABLE_ORG);
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void clearAllEntryRow() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(ENTITY_ORG);
        for (int i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow(ENTITY_ORG, i);
        }
    }
}

