/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertInfo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.svc.ca.CAModule;

public class UserCredentialsListPlugin
extends AbstractListPlugin {
    private static final String BAR_IMPORT = "bar_import";
    private static final String BAR_RELATION = "bar_relation";
    private static final String BAR_SHOW_USER = "bar_showuser";
    private static final String BAR_UNRELATION = "bar_unrelation";
    private static final String BAR_DELETE = "bar_delete";
    private static final String BILL_LIST_STAP = "billlistap";
    private static final String BOS_USER = "bos_user";
    private static final String USER_ID = "userid";
    private static final String CERT_ID = "certid";
    private static final String PUBLICKEY = "publickey";
    private static final String NUMBER = "number";
    private static final String BEGIN = "begin";
    private static final String END = "end";
    private static final String NAME = "name";
    private static final String ISSUER = "issue";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String CERT_NAME = "certname";
    private static final String UNAME = "uname";
    private static final String CREATE_TIME = "CREATETIME";
    private static final String BD_USER_CREDENTIALS = "bd_usercredentials";
    private static final String BD_USERANDCERT_RELATION = "bd_userandcertrelation";
    private static final String BD_RELATION_USER = "bd_relationuser";
    private static final String USERNAME_DESC = "uname desc";
    private static final String USERNAME_ASC = "uname asc";

    public void initialize() {
        super.initialize();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        if (CollectionUtils.isEmpty((Collection)filters)) {
            return;
        }
        ArrayList<QFilter> inFilterList = new ArrayList<QFilter>(5);
        for (QFilter filter : filters) {
            this.dealUserNameEmpty(filter);
            QFilter inFilter = this.transFilter(filter.__copy(false));
            inFilterList.add(inFilter);
            List nests = filter.getNests(true);
            if (nests == null) continue;
            for (QFilter.QFilterNest best : nests) {
                this.transFilterNest(inFilter, best);
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(inFilterList);
    }

    private void dealUserNameEmpty(QFilter rootFilter) {
        if (rootFilter != null && UNAME.equals(rootFilter.getProperty()) && ("not like".equals(rootFilter.getCP()) || "!=".equals(rootFilter.getCP()))) {
            rootFilter.or(new QFilter("id", "not in", this.getAllCertIdInRelation()));
        }
    }

    private QFilter transFilter(QFilter filter) {
        String value;
        if (UNAME.equals(filter.getProperty())) {
            return this.relationTransfer(this.normalSearchReplace(filter));
        }
        if ("1".equals(filter.getProperty()) && filter.getValue() != null && (value = filter.getValue().toString()).contains("#")) {
            return this.ftLikeProcess(filter, value);
        }
        return filter;
    }

    private void transFilterNest(QFilter root, QFilter.QFilterNest nest) {
        String value;
        QFilter filter = nest.getFilter();
        String op = nest.getOp();
        if (UNAME.equals(filter.getProperty())) {
            this.nestWithRoot(root, this.relationTransfer(this.normalSearchReplace(filter)), op);
        } else if ("1".equals(filter.getProperty()) && filter.getValue() != null && (value = filter.getValue().toString()).contains("#")) {
            this.nestWithRoot(root, this.ftLikeProcess(filter, value), op);
        } else {
            this.nestWithRoot(root, filter, op);
        }
    }

    private QFilter ftLikeProcess(QFilter filter, String value) {
        String[] filterValues = value.split("#");
        String[] filterFields = filterValues[0].split(",");
        QFilter firstFilter = null;
        for (String filterField : filterFields) {
            QFilter processFilter;
            String newValue = filterField + "#" + filterValues[filterValues.length - 1];
            if (UNAME.equals(filterField)) {
                processFilter = this.relationTransfer(this.fastSearchReplace(filter, newValue));
            } else {
                processFilter = filter.__copy(true);
                processFilter.__setValue((Object)newValue);
            }
            if (firstFilter == null) {
                firstFilter = processFilter;
                continue;
            }
            firstFilter.or(processFilter);
        }
        return firstFilter;
    }

    private void nestWithRoot(QFilter root, QFilter filter, String op) {
        if (root.getNests(true).stream().map(QFilter.QFilterNest::getFilter).anyMatch(a -> this.qfEquals(filter, (QFilter)a)) || this.qfEquals(root, filter)) {
            return;
        }
        if ("or".equalsIgnoreCase(op)) {
            root.or(filter);
        } else if ("and".equalsIgnoreCase(op)) {
            root.and(filter);
        }
    }

    private boolean qfEquals(QFilter filter, QFilter a) {
        return StringUtils.equals((CharSequence)a.getCP(), (CharSequence)filter.getCP()) && StringUtils.equals((CharSequence)a.getProperty(), (CharSequence)filter.getProperty()) && Objects.equals(a.getValue(), filter.getValue());
    }

    private QFilter normalSearchReplace(QFilter filter) {
        return filter.trans(qf -> {
            qf.__setProperty(NAME);
            return qf;
        });
    }

    private QFilter fastSearchReplace(QFilter filter, String value) {
        return filter.trans(qf -> {
            String[] split = value.split("#");
            qf.__setValue((Object)(split[0].replace(UNAME, NAME) + "#" + split[split.length - 1]));
            return qf;
        });
    }

    private QFilter relationTransfer(QFilter userFilter) {
        if (userFilter.getValue() instanceof QEmptyValue) {
            return new QFilter("id", "not in", this.getAllCertIdInRelation());
        }
        List userIds = BusinessDataServiceHelper.loadFromCache((String)BOS_USER, (String)"id", (QFilter[])userFilter.toArray()).values().stream().map(m -> m.get("id")).collect(Collectors.toList());
        List certIds = BusinessDataServiceHelper.loadFromCache((String)BD_USERANDCERT_RELATION, (String)CERT_ID, (QFilter[])new QFilter(USER_ID, "in", userIds).toArray()).values().stream().map(m -> m.get(CERT_ID)).collect(Collectors.toList());
        return new QFilter("id", "in", certIds);
    }

    private List<Object> getAllCertIdInRelation() {
        return BusinessDataServiceHelper.loadFromCache((String)BD_USERANDCERT_RELATION, (String)CERT_ID, (QFilter[])new QFilter(CERT_ID, "is not null", null).toArray()).values().stream().map(m -> m.get(CERT_ID)).collect(Collectors.toList());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new RelationUserListProvider());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && "donothing_delete".equals(operateKey)) {
            this.doBeforeDelete();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_import": {
                this.importCert(evt);
                break;
            }
            case "bar_relation": {
                this.relateUser();
                break;
            }
            case "bar_unrelation": {
                this.unrelateUser();
                break;
            }
            case "bar_showuser": {
                this.showUser();
                break;
            }
        }
    }

    private void unrelateUser() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        if (selectRows != null && selectRows.size() != 0) {
            if (selectRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u89e3\u7ed1\u591a\u5f20\u8bc1\u4e66\u3002", (String)"UserCredentialsListPlugin_17", (String)CAModule.getModuleName(), (Object[])new Object[0]));
            } else {
                DynamicObject certMessage = BusinessDataServiceHelper.loadSingle((Object)selectRows.get(0).getPrimaryKeyValue(), (String)BD_USER_CREDENTIALS);
                DynamicObject userObj = BusinessDataServiceHelper.loadSingle((String)BD_USERANDCERT_RELATION, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(CERT_ID, "=", selectRows.get(0).getPrimaryKeyValue())});
                if (userObj != null) {
                    long userId = userObj.getLong(USER_ID);
                    Object certId = certMessage.getPkValue();
                    DeleteServiceHelper.delete((String)BD_USERANDCERT_RELATION, (QFilter[])new QFilter[]{new QFilter(CERT_ID, "=", certId), new QFilter(USER_ID, "=", (Object)userId)});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u7ed1\u6210\u529f\u3002", (String)"UserCredentialsListPlugin_19", (String)CAModule.getModuleName(), (Object[])new Object[0]));
                    this.getView().updateView();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u7528\u6237\uff0c\u65e0\u9700\u89e3\u7ed1\u3002", (String)"UserCredentialsListPlugin_18", (String)CAModule.getModuleName(), (Object[])new Object[0]));
                }
            }
        }
    }

    private void doBeforeDelete() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        if (selectRows == null || selectRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e\u3002", (String)"UserCredentialsListPlugin_3", (String)CAModule.getModuleName(), (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BAR_DELETE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u5220\u9664\u8bc1\u4e66\u5417\uff1f", (String)"UserCredentialsListPlugin_12", (String)CAModule.getModuleName(), (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)BAR_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteCert();
        }
    }

    private void importCert(ItemClickEvent evt) {
        Toolbar bar = (Toolbar)evt.getSource();
        CertInfo certInfo = bar.getCertInfo();
        DynamicObject usercert = BusinessDataServiceHelper.loadSingle((String)BD_USER_CREDENTIALS, (String)PUBLICKEY, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)certInfo.getSerialNumber())});
        if (usercert != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u8bc1\u4e66\u3002", (String)"UserCredentialsListPlugin_0", (String)CAModule.getModuleName(), (Object[])new Object[0]));
        } else {
            usercert = BusinessDataServiceHelper.newDynamicObject((String)BD_USER_CREDENTIALS);
            usercert.set(NUMBER, (Object)certInfo.getSerialNumber());
            usercert.set(PUBLICKEY, (Object)certInfo.getPublicKey());
            usercert.set(CERT_NAME, (Object)certInfo.getCertName());
            usercert.set(BEGIN, (Object)certInfo.getBegin().getTime());
            usercert.set(END, (Object)certInfo.getEnd().getTime());
            usercert.set(NAME, (Object)certInfo.getIssuer());
            usercert.set(ISSUER, (Object)certInfo.getCertIssuer());
            usercert.set(ENABLE, (Object)"1");
            usercert.set(STATUS, (Object)"A");
            usercert.set(CREATE_TIME, (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{usercert});
            String msg = String.format(ResManager.loadKDString((String)"\u8bc1\u4e66\uff1a%s\u5df2\u5bfc\u5165\u3002", (String)"UserCredentialsListPlugin_1", (String)CAModule.getModuleName(), (Object[])new Object[0]), certInfo.getSerialNumber());
            this.getView().updateView();
            this.getView().showSuccessNotification(msg);
            this.writeLogInfo("donothing_import", new MultiLangEnumBridge("\u5bfc\u5165", "UserCredentialsListPlugin_14", CAModule.getModuleName()).getDescription(), msg);
        }
    }

    private void relateUser() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        if (selectRows != null && selectRows.size() != 0) {
            if (selectRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5173\u8054\u591a\u5f20\u8bc1\u4e66\u3002", (String)"UserCredentialsListPlugin_4", (String)CAModule.getModuleName(), (Object[])new Object[0]));
            } else {
                ListShowParameter para = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)false);
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAR_RELATION));
                para.setCustomParam("externalUserType", (Object)"all");
                this.getView().showForm((FormShowParameter)para);
            }
        }
    }

    private void showUser() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        if (selectRows == null || selectRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e\u3002", (String)"UserCredentialsListPlugin_3", (String)CAModule.getModuleName(), (Object[])new Object[0]));
        } else if (selectRows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u663e\u793a\u591a\u6761\u6570\u636e\u7684\u5173\u8054\u7528\u6237\u3002", (String)"UserCredentialsListPlugin_5", (String)CAModule.getModuleName(), (Object[])new Object[0]));
        } else {
            DynamicObject certMessage = BusinessDataServiceHelper.loadSingle((Object)selectRows.get(0).getPrimaryKeyValue(), (String)BD_USER_CREDENTIALS);
            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((String)BD_USERANDCERT_RELATION, (String)USER_ID, (QFilter[])new QFilter[]{new QFilter(CERT_ID, "=", selectRows.get(0).getPrimaryKeyValue())});
            if (userObj != null) {
                String name = (String)UserServiceHelper.getUserInfoByID((long)userObj.getLong(USER_ID)).get(NAME);
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId(BD_RELATION_USER);
                parameter.setCustomParam(CERT_NAME, certMessage.get(CERT_NAME));
                parameter.setCustomParam(NAME, (Object)name);
                this.getView().showForm(parameter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8bc1\u4e66\u672a\u5173\u8054\u7528\u6237\u3002", (String)"UserCredentialsListPlugin_6", (String)CAModule.getModuleName(), (Object[])new Object[0]));
            }
        }
    }

    private void deleteCert() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        Object[] pks = selectRows.getPrimaryKeyValues();
        DeleteServiceHelper.delete((String)BD_USERANDCERT_RELATION, (QFilter[])new QFilter[]{new QFilter(CERT_ID, "in", (Object)selectRows.getPrimaryKeyValues())});
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)BD_USER_CREDENTIALS);
        DeleteServiceHelper.delete((IDataEntityType)met, (Object[])pks);
        this.getView().updateView();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_STAP);
        billList.clearSelection();
        String msg = ResManager.loadKDString((String)"\u8bc1\u4e66\u53ca\u5176\u5173\u8054\u4fe1\u606f\u5220\u9664\u6210\u529f\u3002", (String)"UserCredentialsListPlugin_7", (String)CAModule.getModuleName(), (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
        this.writeLogInfo("donothing_delete", new MultiLangEnumBridge("\u5220\u9664", "UserCredentialsListPlugin_16", CAModule.getModuleName()).getDescription(), msg);
    }

    private ListSelectedRowCollection getSelectRows() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_STAP);
        return billList.getSelectedRows();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnDatas;
        super.closedCallBack(closedCallBackEvent);
        if (BAR_RELATION.equals(closedCallBackEvent.getActionId()) && (returnDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection selectRows = this.getSelectRows();
            String primaryKey = returnDatas.get(0).getPrimaryKeyValue().toString();
            Long userId = Long.parseLong(primaryKey);
            String name = returnDatas.get(0).getName();
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)BD_USERANDCERT_RELATION);
            DynamicObject usercert = BusinessDataServiceHelper.loadSingle((String)BD_USERANDCERT_RELATION, (String)(met.getPrimaryKey().getAlias() + "," + USER_ID + "," + CERT_ID), (QFilter[])new QFilter[]{new QFilter(CERT_ID, "=", selectRows.get(0).getPrimaryKeyValue())});
            DynamicObject certForUser = BusinessDataServiceHelper.loadSingle((String)BD_USERANDCERT_RELATION, (String)met.getPrimaryKey().getAlias(), (QFilter[])new QFilter[]{new QFilter(USER_ID, "=", (Object)userId)});
            if (usercert == null && certForUser == null) {
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)BD_USERANDCERT_RELATION);
                user.set(USER_ID, (Object)userId);
                String certIdStr = String.valueOf(selectRows.get(0).getPrimaryKeyValue());
                Long certId = Long.parseLong(certIdStr);
                user.set(CERT_ID, (Object)certId);
                this.certExist(certId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{user});
                this.getView().updateView();
                String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f\uff0c\u8be5\u8bc1\u4e66\u5df2\u5173\u8054\uff1a%s\u3002", (String)"UserCredentialsListPlugin_8", (String)CAModule.getModuleName(), (Object[])new Object[0]), name);
                this.getView().showSuccessNotification(msg);
                this.writeLogInfo("donothing_relateuser", new MultiLangEnumBridge("\u5173\u8054", "UserCredentialsListPlugin_15", CAModule.getModuleName()).getDescription(), msg);
            } else if (usercert != null && primaryKey.equals(usercert.get(USER_ID))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u8fc7\u8be5\u7528\u6237\uff1a%s", (String)"UserCredentialsListPlugin_9", (String)CAModule.getModuleName(), (Object[])new Object[0]), name));
            } else if (certForUser != null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u7ecf\u5173\u8054\u8bc1\u4e66\uff0c\u4e00\u4e2a\u7528\u6237\u53ea\u80fd\u62e5\u6709\u4e00\u5f20\u8bc1\u4e66\uff1a%s\u3002", (String)"UserCredentialsListPlugin_10", (String)CAModule.getModuleName(), (Object[])new Object[0]), name));
            } else {
                usercert.set(USER_ID, (Object)userId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{usercert});
                this.getView().updateView();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u5173\u8054\u7528\u6237\u6210\u529f\uff0c\u8be5\u8bc1\u4e66\u5df2\u5173\u8054\uff1a%s\u3002", (String)"UserCredentialsListPlugin_11", (String)CAModule.getModuleName(), (Object[])new Object[0]), name));
            }
        }
    }

    private void certExist(Long certId) {
        MainEntityType userCredentialType = EntityMetadataCache.getDataEntityType((String)BD_USER_CREDENTIALS);
        String msg = ResManager.loadKDString((String)"\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"UserCredentialsListPlugin_13", (String)CAModule.getModuleName(), (Object[])new Object[0]);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)certId, (String)BD_USER_CREDENTIALS, (String)userCredentialType.getPrimaryKey().getAlias());
        if (obj == null) {
            throw new KDBizException(msg);
        }
    }

    private void writeLogInfo(String opKey, String opName, String opDesc) {
        DynamicObject bizObj;
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setOpTime(new Date());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setOpDescription(opDesc);
        appLogInfo.setOpName(opKey, opName);
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId())});
        if (bizApp != null) {
            appLogInfo.setBizAppID(String.valueOf(bizApp.getPkValue()));
        }
        if ((bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)BD_USER_CREDENTIALS)})) != null) {
            appLogInfo.setBizObjID(String.valueOf(bizObj.getPkValue()));
        }
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    static class RelationUserListProvider
    extends ListDataProvider {
        RelationUserListProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            List ids = rows.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            Map<Long, Long> relationMap = BusinessDataServiceHelper.loadFromCache((String)UserCredentialsListPlugin.BD_USERANDCERT_RELATION, (QFilter[])new QFilter[]{new QFilter(UserCredentialsListPlugin.CERT_ID, "in", ids)}).values().stream().filter(f -> f.get(UserCredentialsListPlugin.CERT_ID) != null && f.get(UserCredentialsListPlugin.USER_ID) != null).collect(Collectors.toMap(m -> (Long)m.get(UserCredentialsListPlugin.CERT_ID), m -> (Long)m.get(UserCredentialsListPlugin.USER_ID)));
            Map<Long, String> userMap = BusinessDataServiceHelper.loadFromCache((Object[])relationMap.values().toArray(), (String)UserCredentialsListPlugin.BOS_USER).values().stream().filter(f -> f.get("id") != null && f.get(UserCredentialsListPlugin.NAME) != null).collect(Collectors.toMap(m -> (Long)m.get("id"), m -> m.get(UserCredentialsListPlugin.NAME).toString()));
            rows.forEach(row -> {
                Long userId = (Long)relationMap.get(row.getLong("id"));
                if (userId != null) {
                    row.set(UserCredentialsListPlugin.UNAME, userMap.get(userId));
                }
            });
            if (this.getOrderByExpr() == null) {
                return rows;
            }
            Comparator nameComparator = (o1, o2) -> {
                String s1 = o1.getString(UserCredentialsListPlugin.UNAME);
                String s2 = o2.getString(UserCredentialsListPlugin.UNAME);
                if (s1 == null || s2 == null) {
                    return 0;
                }
                return s2.compareTo(s1);
            };
            if (this.getOrderByExpr().contains(UserCredentialsListPlugin.USERNAME_DESC)) {
                nameComparator = Comparator.nullsLast(nameComparator);
            } else if (this.getOrderByExpr().contains(UserCredentialsListPlugin.USERNAME_ASC)) {
                nameComparator = Comparator.nullsLast(nameComparator).reversed();
            }
            List filteredRows = rows.stream().sorted(nameComparator).collect(Collectors.toList());
            rows.clear();
            rows.addAll(filteredRows);
            return rows;
        }
    }
}

