/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.ca;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ca.SignService;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.ca.VerifySignInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.filter.SignSchemeFilterService;
import kd.bos.servicehelper.ca.SignCommandParam;
import kd.bos.servicehelper.ca.SignCommandResult;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
@KSObject
public class SignServiceHelper {
    public static Map<Object, VerifySignInfo> verifySignByIds(String entityNumber, List<Object> ids) {
        Map<Object, VerifySignInfo> verifyInfos = SignService.verifySignByIds(entityNumber, ids);
        return verifyInfos;
    }

    public static VerifySignInfo verifySignById(String entityNumber, Object id) {
        ArrayList<Object> ids = new ArrayList<Object>();
        ids.add(id);
        Map<Object, VerifySignInfo> verifyInfos = SignService.verifySignByIds(entityNumber, ids);
        Object firstKey = null;
        firstKey = verifyInfos.keySet().stream().findFirst().orElse(null);
        if (firstKey != null) {
            if (firstKey instanceof Long) {
                return verifyInfos.get(Long.parseLong(id.toString()));
            }
            return verifyInfos.get(String.valueOf(id));
        }
        return null;
    }

    public static SignCommandResult sendClientSignCommand(SignCommandParam signParam) {
        Map<Object, Object> clearTextMap;
        OperationResult opResult = new OperationResult();
        SignCommandResult result = new SignCommandResult();
        result.setOperationResult(opResult);
        String entityNumber = signParam.getEntityNumber();
        DynamicObjectCollection docs = signParam.getDocs();
        List<Object> pkIds = docs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (signParam.isSchemeFilter()) {
            docs = SignSchemeFilterService.getDataBySignFilter(EntityMetadataCache.getDataEntityType((String)entityNumber), docs, entityNumber);
        }
        if ((clearTextMap = SignService.computeDigests(entityNumber, docs)).isEmpty()) {
            result.setNotNeedPkIds(pkIds);
            return result;
        }
        ArrayList<Object> needSignPkIds = new ArrayList<Object>(clearTextMap.keySet());
        result.setNeedPkIds(needSignPkIds);
        List<Object> notNeedSignPkIds = pkIds.stream().filter(f -> f != null && !needSignPkIds.contains(f)).collect(Collectors.toList());
        result.setNotNeedPkIds(notNeedSignPkIds);
        String clearText = SerializationUtils.toJsonString(clearTextMap);
        opResult.setClearText(clearText);
        SignOperateCallback signOperateCallback = signParam.getSignOperateCallback();
        signOperateCallback.sign(opResult, signParam.isClearPin());
        return result;
    }

    public static void saveSignMessage(String entityNumber, Map<Object, Object> signTextsMap, Map<Object, Object> clearTextsMap) {
        SignService.saveSignMessage(entityNumber, signTextsMap, clearTextsMap);
        SignService.writeLog(entityNumber, signTextsMap, clearTextsMap);
    }

    public static SignScheme getSignSCheme(String orgId, String formId) {
        return SignService.getSignScheme(orgId, formId);
    }

    public static boolean needSign(String orgId, String formId, String operateKey) {
        String signOperate;
        if (orgId == null || formId == null || operateKey == null) {
            return false;
        }
        SignScheme signScheme = SignService.getSignScheme(orgId, formId);
        if (signScheme != null && StringUtils.isNotEmpty((CharSequence)(signOperate = signScheme.getSignOperate()))) {
            List signOperateList = (List)SerializationUtils.fromJsonString((String)signOperate, List.class);
            for (Map map : signOperateList) {
                if (!StringUtils.equals((CharSequence)String.valueOf(map.get("OpCode")), (CharSequence)operateKey)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

