/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin.mode;

import kd.bos.business.plugin.mode.CodeRuleNumberMode;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.opplugin.pagecache.SerialNumberCache;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.coderule.util.CodeRuleNumberDTO;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.GeneratorWithNumException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CodeRuleOperateOptionMode
implements CodeRuleNumberMode {
    private static final Log logger = LogFactory.getLog(CodeRuleOperateOptionMode.class);
    private OperateOption operateOption;
    private SerialNumberCache serialNumberCache;
    private String className;
    private String billNoField;
    private CodeRuleNumberMode nextNumberMode;

    public CodeRuleOperateOptionMode(OperateOption operateOption, String className, String billNoField) {
        this.operateOption = operateOption;
        this.className = className;
        this.billNoField = billNoField;
        this.serialNumberCache = new SerialNumberCache(className);
    }

    @Override
    public void setAbleExecute(boolean isAbleExecute) {
    }

    @Override
    public void nextHandlerMode(CodeRuleNumberMode numberMode) {
        this.nextNumberMode = numberMode;
    }

    @Override
    public String getNumber(DynamicObject dynamicObject, CodeRuleInfo codeRuleInfo) {
        if (!this.serialNumberCache.isOpenBillNoParam(this.operateOption)) {
            return null;
        }
        if (null == codeRuleInfo || null == dynamicObject) {
            return null;
        }
        String number = dynamicObject.getString(this.billNoField);
        if (!CodeRuleInfoUtil.validateCodeRuleContainSerialNum(codeRuleInfo)) {
            return null;
        }
        String sortItemValue = CodeRuleSerialNumUtil.getSortItemValue(codeRuleInfo, dynamicObject, number);
        if (null == sortItemValue) {
            return null;
        }
        String codeRuleKey = codeRuleInfo.getId() + sortItemValue;
        String serialNumber = this.serialNumberCache.getAndRemoveSerialNumber(this.operateOption, codeRuleKey);
        String assembleNumber = this.assembleNumber(dynamicObject, codeRuleInfo, serialNumber);
        this.nextNumberMode.setAbleExecute(StringUtils.isBlank((CharSequence)assembleNumber));
        return assembleNumber;
    }

    @Override
    public boolean recycleNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        if (!this.serialNumberCache.isOpenBillNoParam(this.operateOption)) {
            return false;
        }
        if (null == codeRuleInfo || null == dataInfo || StringUtils.isBlank((CharSequence)number)) {
            return false;
        }
        if (codeRuleInfo.getIsNonBreak().booleanValue()) {
            return false;
        }
        if (!CodeRuleInfoUtil.validateCodeRuleContainSerialNum(codeRuleInfo)) {
            return false;
        }
        CodeRuleNumberDTO codeRuleNumberDTO = CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, dataInfo, number);
        if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
            return false;
        }
        String codeRuleKey = codeRuleInfo.getId() + codeRuleNumberDTO.getSortItemValue();
        this.serialNumberCache.saveSerialNumberToOperation(codeRuleKey, Long.parseLong(codeRuleNumberDTO.getSerialNumber()), this.operateOption);
        this.nextNumberMode.setAbleExecute(codeRuleInfo.getIsNonBreak());
        return true;
    }

    private String assembleNumber(DynamicObject dataInfo, CodeRuleInfo codeRuleInfo, String serialNumber) {
        if (StringUtils.isBlank((CharSequence)serialNumber)) {
            return null;
        }
        StringBuilder beforeSeqNumber = new StringBuilder();
        StringBuilder afterSeqNumber = new StringBuilder();
        StringBuilder number = beforeSeqNumber;
        boolean isFirst = true;
        String entryValue = "";
        CodeRuleEntryInfo seqInfo = null;
        boolean hasCheckCode = false;
        boolean seqVisableFlag = true;
        try {
            for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
                entryValue = "";
                boolean isVisable = codeRuleEntry.getVisable();
                if (isFirst) {
                    isFirst = false;
                } else if (StringUtils.isNotBlank((CharSequence)codeRuleEntry.getSplitSign()) && isVisable) {
                    number.append(codeRuleEntry.getSplitSign());
                }
                CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType());
                switch (enums) {
                    case TYPE_FIX_TEXT: {
                        entryValue = codeRuleEntry.getFormat();
                        break;
                    }
                    case TYPE_SEQ: {
                        seqVisableFlag = isVisable;
                        number = afterSeqNumber;
                        seqInfo = codeRuleEntry;
                        break;
                    }
                    case TYPE_RANDOM_NUMBER: {
                        entryValue = CodeRuleSerialNumUtil.getRandomNumber(8);
                        break;
                    }
                    case TYPE_SYSTEM_TIME_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                        break;
                    }
                    case TYPE_DATE_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_ITEM_FIELD: {
                        entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                        break;
                    }
                    case TYPE_LIST_FIELD: {
                        break;
                    }
                    case CHECK_CODE: {
                        hasCheckCode = true;
                        break;
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue))) || !isVisable) continue;
                number.append(entryValue);
            }
            String seqValue = "";
            if (seqInfo != null) {
                seqValue = this.buildSerialNumber(codeRuleInfo, seqInfo, Long.parseLong(serialNumber));
            }
            StringBuilder finalNumber = new StringBuilder();
            finalNumber.append((CharSequence)beforeSeqNumber);
            if (seqVisableFlag) {
                finalNumber.append(seqValue);
            }
            finalNumber.append((CharSequence)afterSeqNumber);
            if (hasCheckCode) {
                if (CommonUtil.validateNumLen(finalNumber.toString())) {
                    finalNumber.append(CommonUtil.getCheckNumber(finalNumber.toString()));
                } else {
                    throw new KDBizException(new ErrorCode("ERRCODE_CODERULE_VALIDATE_NUMBER", CodeRuleConstant.getCODELENGTHERROR()), new Object[0]);
                }
            }
            String billNumber = finalNumber.toString();
            codeRuleInfo.setNumber(billNumber);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return null;
        }
        return codeRuleInfo.getNumber();
    }

    private String buildSerialNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, long number) {
        try {
            return CodeRuleSerialNumUtil.addChar(codeRuleEntry, "" + number, codeRuleInfo.getName(), codeRuleInfo.isFillWithZero(), codeRuleInfo.isAutoIncrLength());
        }
        catch (Exception e) {
            throw new GeneratorWithNumException(GeneratorException.ErrorCode.ERRCODE_CODERULE_VALIDATE_NUMBER.getCode(), e.getMessage(), e, new int[]{(int)number});
        }
    }

    private String getClassName() {
        return this.className;
    }
}

