/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.CodeRuleSysBizObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleAttrTreeEditPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
SearchEnterListener {
    public static final String ATTRTREE = "attrtree";
    public static final String CURRENT_ROW = "currentRow";
    private static final String ATTRIBUTETYPE = "attributetype";
    private static final String DISPLAYNAME = "displayname";
    private static final String ALIAS = "alias";
    private static final String DT_NAME = "dtName";
    private static final String TEXT = "text";
    private static final String SEARCH_AP = "searchap";
    private static final String BOS_CODERULE = "bos-coderule";

    public void initialize() {
        this.addClickListeners(new String[]{"btnreturndata"});
        TreeView tree = (TreeView)this.getControl(ATTRTREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(SEARCH_AP);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnreturndata".equalsIgnoreCase(btn.getKey())) {
            this.returnRowDataToParent();
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
    }

    public void treeNodeDoubleClick(TreeNodeEvent arg0) {
        this.returnRowDataToParent();
    }

    public void afterBindData(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getControl(ATTRTREE);
        String dtName = (String)this.getView().getFormShowParameter().getCustomParam("dynamicObjectType");
        int attributetype = (Integer)this.getView().getFormShowParameter().getCustomParam(ATTRIBUTETYPE);
        this.getPageCache().put(ATTRIBUTETYPE, "" + attributetype);
        boolean fromSeqSegmen = this.getView().getFormShowParameter().getCustomParam("fromSeqSegmen") != null;
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CodeRuleAttrTreeEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        if (64 == attributetype) {
            this.buildSysTree(children);
        } else {
            TreeNode node;
            List<Map<String, Object>> propList = this.getPropsList(4, dtName);
            Iterator<Map<String, Object>> iter = null;
            if (CollectionUtils.isNotEmpty(propList)) {
                iter = propList.iterator();
                if (!fromSeqSegmen) {
                    while (iter.hasNext()) {
                        Map<String, Object> map = iter.next();
                        node = new TreeNode();
                        node.setText(map.get(DISPLAYNAME) + " (" + map.get(ALIAS) + ")");
                        node.setId((String)map.get(ALIAS));
                        if (map.get(DT_NAME) != null && !fromSeqSegmen) {
                            this.intiSecTree(node, (String)map.get(DT_NAME));
                        }
                        node.setParentid("0");
                        children.add(node);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(propList = this.getPropsList(8, dtName))) {
                for (Map<String, Object> map : propList) {
                    node = new TreeNode();
                    node.setText(map.get(DISPLAYNAME) + " (" + map.get(ALIAS) + ")");
                    node.setId((String)map.get(ALIAS));
                    if (map.get(DT_NAME) != null && !fromSeqSegmen) {
                        this.intiSecTree(node, (String)map.get(DT_NAME));
                    }
                    node.setParentid("0");
                    children.add(node);
                }
            }
        }
        root.setChildren(children);
        root.setIsOpened(true);
        this.getPageCache().put(dtName, SerializationUtils.toJsonString((Object)root));
        tree.addNode(root);
    }

    private void intiSecTree(TreeNode parent, String dtName) {
        List<Map<String, Object>> propList = this.getPropsList(4, dtName);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(8);
        if (CollectionUtils.isNotEmpty(propList)) {
            for (Map<String, Object> map : propList) {
                TreeNode node = new TreeNode();
                node.setText(map.get(DISPLAYNAME) + " (" + map.get(ALIAS) + ")");
                node.setId(parent.getId() + "." + map.get(ALIAS));
                node.setParentid(parent.getId());
                children.add(node);
            }
        }
        parent.setChildren(children);
    }

    private void buildSysTree(List<TreeNode> children) {
        String operator = CodeRuleSysBizObject.OPERATOR.getKey();
        String orgcity = CodeRuleSysBizObject.ORGCITY.getKey();
        TreeNode nodeOperator = new TreeNode("0", operator, CodeRuleSysBizObject.OPERATOR.getValue());
        TreeNode nodeOrgCity = new TreeNode("0", orgcity, CodeRuleSysBizObject.ORGCITY.getValue());
        String operatorKey = operator + ".";
        String orgcityKey = orgcity + ".";
        for (CodeRuleSysBizObject node : CodeRuleSysBizObject.values()) {
            if (node.getKey().startsWith(operatorKey)) {
                nodeOperator.addChild(new TreeNode(operator, node.getKey(), node.getValue()));
                continue;
            }
            if (!node.getKey().startsWith(orgcityKey)) continue;
            nodeOrgCity.addChild(new TreeNode(orgcity, node.getKey(), node.getValue()));
        }
        children.add(nodeOrgCity);
        children.add(nodeOperator);
    }

    private List<Map<String, Object>> getPropsList(int type, String dtName) {
        String langName = RequestContext.get().getLang().name();
        List<DynamicSimpleProperty> propsList = null;
        switch (type) {
            case 4: {
                propsList = this.getTextProperties(dtName);
                break;
            }
            case 8: {
                propsList = this.getBasedataProperties(dtName);
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(8);
        for (DynamicProperty dynamicProperty : propsList) {
            if (type == 4 && this.getPageCache().get(ATTRIBUTETYPE).equals(String.valueOf(2)) && !(dynamicProperty instanceof DateTimeProp) || dynamicProperty.getDisplayName() == null) continue;
            HashMap<String, Object> propValue = new HashMap<String, Object>();
            propValue.put(ALIAS, dynamicProperty.getName());
            propValue.put(DISPLAYNAME, dynamicProperty.getDisplayName().get((Object)langName));
            if (dynamicProperty instanceof BasedataProp) {
                propValue.put(DT_NAME, ((BasedataProp)dynamicProperty).getBaseEntityId());
            }
            returnList.add(propValue);
        }
        return returnList;
    }

    private List<DynamicSimpleProperty> getTextProperties(String dtName) {
        DataEntityPropertyCollection entitySet = this.getProperties(dtName);
        List simpleFileds = entitySet.getSimpleProperties(false);
        ArrayList<DynamicSimpleProperty> textProList = new ArrayList<DynamicSimpleProperty>(simpleFileds.size());
        for (ISimpleProperty sproperty : simpleFileds) {
            textProList.add((DynamicSimpleProperty)sproperty);
        }
        return textProList;
    }

    private List<BasedataProp> getBasedataProperties(String dtName) {
        ArrayList<BasedataProp> basedataProList = new ArrayList<BasedataProp>();
        DataEntityPropertyCollection entitySet = this.getProperties(dtName);
        List complexFileds = entitySet.getComplexProperties(false);
        for (IComplexProperty cproperty : complexFileds) {
            if (!(cproperty instanceof BasedataProp)) continue;
            basedataProList.add((BasedataProp)cproperty);
        }
        return basedataProList;
    }

    private DataEntityPropertyCollection getProperties(String dtName) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)dtName);
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        return dynaObj.getDataEntityType().getProperties();
    }

    private void returnRowDataToParent() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        TreeView tree = (TreeView)this.getControl(ATTRTREE);
        Map map = tree.getTreeState().getFocusNode();
        if (map == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u3002", (String)"CodeRuleAttrTreeEditPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        Object isParent = map.get("isParent");
        if (isParent == null || Boolean.parseBoolean(isParent.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"CodeRuleAttrTreeEditPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String dtName = (String)this.getView().getFormShowParameter().getCustomParam("dynamicObjectType");
        String number = (String)map.get("id");
        returnData.put("valueatribute", number);
        if (this.getView().getFormShowParameter().getCustomParam(CURRENT_ROW) != null) {
            returnData.put(CURRENT_ROW, this.getView().getFormShowParameter().getCustomParam(CURRENT_ROW));
        }
        if (!"0".equals((String)map.get("parentid"))) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(dtName), TreeNode.class);
            TreeNode node = root.getTreeNode((String)map.get("parentid"), 2);
            returnData.put("valueatributeshow", node.getText() + "." + map.get(TEXT));
        } else {
            returnData.put("valueatributeshow", map.get(TEXT));
        }
        if (this.isBillNo(number, dtName)) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u9009\u62e9\u4e86\u201c%s\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"CodeRuleAttrTreeEditPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]), map.get(TEXT)), ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u7f16\u7801\u6bb5\u4e2d\u5305\u542b\u5355\u636e\u7f16\u53f7\uff0c\u5728\u751f\u6210\u7f16\u53f7\u65f6\u53ef\u80fd\u4f1a\u51fa\u73b0\u6b7b\u5faa\u73af\uff0c\u8bf7\u614e\u91cd\u9009\u62e9\u3002", (String)"CodeRuleAttrTreeEditPlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("choose_billno", (IFormPlugin)this));
            this.getPageCache().put("choose_billno_data", SerializationUtils.toJsonString(returnData));
            return;
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private boolean isBillNo(String number, String dtName) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dtName);
        if (mainEntityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)mainEntityType;
            return StringUtils.equals((CharSequence)number, (CharSequence)billEntityType.getBillNo());
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        if (StringUtils.equals((CharSequence)"choose_billno", (CharSequence)closedEvent.getCallBackId()) && closedEvent.getResult() == MessageBoxResult.Yes) {
            String billNoData = this.getPageCache().get("choose_billno_data");
            this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)billNoData, Map.class));
            this.getView().close();
        }
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        String dtName = (String)this.getView().getFormShowParameter().getCustomParam("dynamicObjectType");
        if (StringUtils.isBlank((CharSequence)dtName)) {
            return;
        }
        String tree = this.getPageCache().get(dtName);
        if (StringUtils.isBlank((CharSequence)tree)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)tree, TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CodeRuleAttrTreeEditPlugin_5", (String)BOS_CODERULE, (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getControl(ATTRTREE);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        TreeNode p;
        String parentId = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentId) && (p = rootNode.getTreeNode(parentId)) != null) {
            this.expandParents(treeView, rootNode, p);
            treeView.expand(parentId);
            if (p == rootNode) {
                treeView.updateNode(node);
            }
            return;
        }
        treeView.updateNode(node);
    }
}

