/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.ext.BeforeInitFilterConditionArgs;
import kd.bos.coderule.ext.ICodeRuleEditPlugin;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleConditionEditPlugin
extends AbstractFormPlugin
implements ICodeRuleEditPlugin {
    private static final Log log = LogFactory.getLog(CodeRuleConditionEditPlugin.class);
    private static final String CONTROL_CONDITION = "filtercondition";
    private static final String CONDITION_DESC = "conditiondesc";
    private static final String BTN_OK = "btnok";
    private static final String BOS_CODERULE = "bos-coderule";

    public void registerListener(EventObject e) {
        Button button = (Button)this.getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String objectNumber = (String)formShowParameter.getCustomParam("bizObjectNumber");
        if (StringUtils.isBlank((CharSequence)objectNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"CodeRuleConditionEditPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        this.initFilterFieldKey(objectNumber);
    }

    private void initFilterFieldKey(String objectNumber) {
        if (StringUtils.isBlank((CharSequence)objectNumber)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)objectNumber);
        if (!(dataEntityType instanceof BillEntityType)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_CONDITION);
        filterGrid.setEntityNumber(objectNumber);
        GetFilterFieldsParameter parameterObject = new GetFilterFieldsParameter((IDataEntityType)dataEntityType);
        parameterObject.setbCompatibleProductMode(false);
        parameterObject.setNeedFieldCompareType(true);
        parameterObject.setNeedAliasEmptyFieldProp(true);
        List<Map<String, Object>> filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)parameterObject);
        String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
        BeforeInitFilterConditionArgs beforeInitFilterCondition = this.fireBeforeInitFilterCondition(filterColumns, objectNumber);
        if (beforeInitFilterCondition != null && beforeInitFilterCondition.getFilterColumns() != null) {
            filterColumns = beforeInitFilterCondition.getFilterColumns();
        }
        boolean isNeedFilter = beforeInitFilterCondition != null && CollectionUtils.isNotEmpty(beforeInitFilterCondition.getFieldKeys());
        filterColumns.removeIf(filterColumn -> {
            String fieldName = (String)filterColumn.get("fieldName");
            return StringUtils.equals((CharSequence)billNoKey, (CharSequence)fieldName) || isNeedFilter && !beforeInitFilterCondition.getFieldKeys().contains(fieldName);
        });
        filterGrid.setFilterColumns(filterColumns);
    }

    private BeforeInitFilterConditionArgs fireBeforeInitFilterCondition(List<Map<String, Object>> filterColumns, String objectNumber) {
        ArrayList<String> fieldKeys = new ArrayList<String>(filterColumns.size());
        filterColumns.forEach(filterColumn -> fieldKeys.add((String)filterColumn.get("fieldName")));
        try {
            PluginProxy pluginProxy = PluginProxy.create((Object)this, ICodeRuleEditPlugin.class, (String)"BOS_SVC_CODERULE_CONFIG");
            List plugins = pluginProxy.getPlugins();
            if (CollectionUtils.isNotEmpty((Collection)plugins)) {
                for (ICodeRuleEditPlugin plugin : plugins) {
                    String bizObjectNumber = plugin.getBizObjectNumber();
                    if (!StringUtils.equals((CharSequence)bizObjectNumber, (CharSequence)objectNumber)) continue;
                    BeforeInitFilterConditionArgs args = new BeforeInitFilterConditionArgs(filterColumns, fieldKeys);
                    plugin.beforeInitFilterCondition(args);
                    return args;
                }
            }
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u6761\u4ef6\u6267\u884c\u4e1a\u52a1\u6269\u5c55\u63d2\u4ef6\u62a5\u9519", (Throwable)e);
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String codeRuleId = (String)formShowParameter.getCustomParam("codeRuleId");
        if (StringUtils.isBlank((CharSequence)codeRuleId)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)codeRuleId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_coderule", (String)"id, filtercondition, conditiondesc", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        this.getModel().setValue(CONDITION_DESC, (Object)((DynamicObject)dynamicObjects.get(0)).getString(CONDITION_DESC));
        this.getView().updateView(CONDITION_DESC);
        String condition = ((DynamicObject)dynamicObjects.get(0)).getString(CONTROL_CONDITION);
        if (StringUtils.isBlank((CharSequence)condition)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_CONDITION);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)control.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String codeRuleId = (String)formShowParameter.getCustomParam("codeRuleId");
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_CONDITION);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            String conditionString = SerializationUtils.toJsonString((Object)filterCondition);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)codeRuleId, (String)"bos_coderule");
            if (dynamicObject.getBoolean("enable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u4e2d\u7684\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\u76f8\u5173\u64cd\u4f5c\uff0c\u8bf7\u7981\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"CodeRuleConditionEditPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
                return;
            }
            dynamicObject.set(CONDITION_DESC, this.getModel().getValue(CONDITION_DESC));
            dynamicObject.set(CONTROL_CONDITION, (Object)conditionString);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CodeRuleConditionEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            AppLogUtil.insertAppLog(this.getView(), dynamicObject, new MultiLangEnumBridge("\u8bbe\u7f6e\u542f\u52a8\u6761\u4ef6", "CodeRuleConditionEditPlugin_3", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\u3002", "BOS_CODERULE_10", BOS_CODERULE), true, codeRuleId, CommonUtil.getDynamicObjProperties(dynamicObject, "name").toString());
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    @Override
    public String getBizObjectNumber() {
        return null;
    }
}

