/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

@Deprecated
public class CodeRuleEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ruleEntryKey = "ruleentry";
    public static final int TYPE_FIX_TEXT = 1;
    public static final int TYPE_DATE_FIELD = 2;
    public static final int TYPE_STRING_FIELD = 4;
    public static final int TYPE_ITEM_FIELD = 8;
    public static final int TYPE_SEQ = 16;
    public static final int SYSTEM_FIELD = 64;
    public static final String ATTRIBUTETYPE = "attributetype";
    public static final String VALUEATRIBUTESHOW = "valueatributeshow";
    public static final String FORMAT = "format";
    public static final String ADDCHAR = "addchar";
    private static final String BIZOBJECTID = "bizobjectid";
    private static final String LENGTH = "length";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(ruleEntryKey);
        entrygrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String langName = RequestContext.get().getLang().name();
        String itemkey = evt.getItemKey();
        IDataModel model = this.getModel();
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject bizobject = (DynamicObject)this.getModel().getValue(BIZOBJECTID);
        switch (itemkey) {
            case "bar_condition": {
                ILocaleString name = (ILocaleString)bizobject.get("name");
                params.put("dtname", name.get((Object)langName));
                params.put("dtval", bizobject.get(1));
                params.put("coderuleid", model.getDataEntity().getPkValue());
                this.showForm("bos_coderulepropertydy", params, null, ShowType.Modal);
                break;
            }
            case "btn_seqsegment": {
                params.put("dynamicObjectType", bizobject.get("number"));
                this.showForm("bos_coderuleseqsegment", params, null, ShowType.Modal);
                break;
            }
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public void entryRowClick(RowClickEvent arg0) {
        int currentRowNum = this.getModel().getEntryRowCount(ruleEntryKey);
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ruleEntryKey);
        if (currentRowIndex < 0 || currentRowNum <= 0) {
            return;
        }
        String currentFieldKey = this.getModel().getEntryCurrentFieldKey(ruleEntryKey);
        if (this.getModel().getValue(ATTRIBUTETYPE, currentRowIndex) != null) {
            int type = Integer.parseInt((String)this.getModel().getValue(ATTRIBUTETYPE, currentRowIndex));
            if (VALUEATRIBUTESHOW.equalsIgnoreCase(currentFieldKey) && this.isHavingProjectId(type)) {
                if (this.getModel().getValue(BIZOBJECTID) == null) {
                    this.getView().showErrMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61", (String)"CodeRuleEditPlugin_0", (String)"bos-coderule", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61", (String)"CodeRuleEditPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
                    return;
                }
                DynamicObject bizobject = (DynamicObject)this.getModel().getValue(BIZOBJECTID);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("dynamicObjectType", bizobject.get(1));
                params.put(ATTRIBUTETYPE, type);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectValueatribute");
                this.showForm("bos_coderule_attr", params, closeCallBack, ShowType.Modal);
            } else if (FORMAT.equalsIgnoreCase(currentFieldKey) && (type == 2 || type == 1) && type == 2) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectDateFormat");
                this.showForm("bos_coderule_dateformat", null, closeCallBack, ShowType.Modal);
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("selectValueatribute".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData != null && !returnData.isEmpty()) {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ruleEntryKey);
                for (Map.Entry entry : returnData.entrySet()) {
                    this.getModel().setValue((String)entry.getKey(), entry.getValue(), currentRowIndex);
                }
            }
        } else if ("selectDateFormat".equals(e.getActionId())) {
            String format = (String)e.getReturnData();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ruleEntryKey);
            this.getModel().setValue(FORMAT, (Object)format, currentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ruleEntryKey);
        if (ATTRIBUTETYPE.equals(proName)) {
            this.initInput(Integer.parseInt((String)e.getChangeSet()[0].getNewValue()), currentRowIndex);
        }
        if ("name".equals(proName) || BIZOBJECTID.equals(proName) || "bizobjectid_Id".equals(proName) || "appmode".equals(proName) || "apporgid".equals(proName) || "example".equals(proName) || "examplelength".equals(proName) || "orgid_Id".equals(proName)) {
            return;
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.simulateCode();
    }

    private boolean isHavingProjectId(int type) {
        boolean isHaving = false;
        if (4 == type || 8 == type || 64 == type) {
            isHaving = true;
        }
        return isHaving;
    }

    private void simulateCode() {
        IDataModel model = this.getModel();
        DynamicObject codeRule = model.getDataEntity();
        DynamicObjectCollection list = model.getEntryEntity(ruleEntryKey);
        boolean isFirst = true;
        StringBuilder number = new StringBuilder();
        for (DynamicObject codeRuleEntry : list) {
            int attributeType = codeRuleEntry.get(ATTRIBUTETYPE) == null ? 0 : Integer.parseInt(String.valueOf(codeRuleEntry.get(ATTRIBUTETYPE)));
            if (attributeType == 0) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                number.append(codeRule.get("splitsign"));
            }
            switch (attributeType) {
                case 1: {
                    if (codeRuleEntry.get(FORMAT) == null) break;
                    number.append(codeRuleEntry.get(FORMAT));
                    break;
                }
                case 16: {
                    int length = Integer.parseInt(String.valueOf(codeRuleEntry.get(LENGTH) == null ? "1" : codeRuleEntry.get(LENGTH)));
                    String addChar = (String)codeRuleEntry.get(ADDCHAR);
                    Boolean addStyle = (Boolean)codeRuleEntry.get("addstyle");
                    if (addStyle == null) {
                        addStyle = Boolean.TRUE;
                    }
                    String serialNumber = this.addChar("1", length, addChar, addStyle);
                    number.append(serialNumber);
                    break;
                }
                case 2: {
                    if (codeRuleEntry.get(FORMAT) == null) break;
                    String dateTimeFormat = (String)codeRuleEntry.get(FORMAT);
                    Date currentTime = new Date();
                    SimpleDateFormat formatter = new SimpleDateFormat(dateTimeFormat);
                    String dateString = formatter.format(currentTime);
                    number.append(dateString);
                    break;
                }
                case 4: 
                case 8: 
                case 64: {
                    if (codeRuleEntry.get(VALUEATRIBUTESHOW) == null) break;
                    number.append(codeRuleEntry.get(VALUEATRIBUTESHOW));
                    break;
                }
            }
        }
        this.getModel().setValue("example", (Object)number);
        this.getModel().setValue("examplelength", (Object)number.length());
    }

    private String addChar(String serialNumber, int length, String addChar, boolean addStyle) {
        String number = "";
        int addLength = length - serialNumber.length();
        if (addLength <= 0) {
            return serialNumber;
        }
        StringBuilder sb = new StringBuilder();
        if (addStyle) {
            for (int i = 0; i < addLength; ++i) {
                sb.append(addChar);
            }
            sb.append(serialNumber);
        } else {
            sb.append(serialNumber);
            for (int i = 0; i < addLength; ++i) {
                sb.append(addChar);
            }
        }
        number = sb.toString();
        return number;
    }

    private void initInput(int attributetype, int rowNum) {
        IDataModel model = this.getModel();
        model.setValue(LENGTH, (Object)"", rowNum);
        model.setValue("initial", (Object)"", rowNum);
        model.setValue("step", (Object)"", rowNum);
        model.setValue(ADDCHAR, (Object)"", rowNum);
        model.setValue(FORMAT, (Object)"", rowNum);
        model.setValue(VALUEATRIBUTESHOW, (Object)"", rowNum);
        FieldEdit length = (FieldEdit)this.getControl(LENGTH);
        FieldEdit initial = (FieldEdit)this.getControl("initial");
        FieldEdit step = (FieldEdit)this.getControl("step");
        FieldEdit addchar = (FieldEdit)this.getControl(ADDCHAR);
        FieldEdit format = (FieldEdit)this.getControl(FORMAT);
        FieldEdit valueatributeshow = (FieldEdit)this.getControl(VALUEATRIBUTESHOW);
        length.setEntryKey(ruleEntryKey);
        length.setEnable("", true, rowNum);
        initial.setEntryKey(ruleEntryKey);
        initial.setEnable("", true, rowNum);
        step.setEntryKey(ruleEntryKey);
        step.setEnable("", true, rowNum);
        addchar.setEntryKey(ruleEntryKey);
        addchar.setEnable("", true, rowNum);
        format.setEntryKey(ruleEntryKey);
        format.setEnable("", true, rowNum);
        valueatributeshow.setEntryKey(ruleEntryKey);
        valueatributeshow.setEnable("", true, rowNum);
        switch (attributetype) {
            case 1: 
            case 2: {
                format.setEnable("", false, rowNum);
                break;
            }
            case 4: 
            case 8: 
            case 64: {
                valueatributeshow.setEnable("", false, rowNum);
                break;
            }
            case 16: {
                length.setEnable("", false, rowNum);
                initial.setEnable("", false, rowNum);
                step.setEnable("", false, rowNum);
                addchar.setEnable("", false, rowNum);
                break;
            }
        }
    }
}

