/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleMaxSerialEditPlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(CodeRuleMaxSerialEditPlugin.class);
    public static final String SORTITEMVALUE = "sortitemvalue";
    private static final String SORTITEMVALUE_1 = "sortitemvalue1";
    private static final String CODERULEID = "coderuleid";
    private static final String MAXSERIAL = "maxserial";
    private static final String BOS_CODERULE = "bos-coderule";

    public void afterCreateNewData(EventObject e) {
        this.reloadNum();
        boolean isFromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!isFromDatabase) {
            FormShowParameter parentParameter = this.getView().getParentView().getFormShowParameter();
            Object codeRuleId = parentParameter.getCustomParam(CODERULEID);
            if (StringUtils.isBlank((Object)codeRuleId)) {
                return;
            }
            this.getModel().setValue(CODERULEID, codeRuleId);
            this.getView().setEnable(Boolean.FALSE, new String[]{CODERULEID});
        }
    }

    public void afterLoadData(EventObject e) {
        this.reloadNum();
    }

    protected void reloadNum() {
        Object codeRuleObj = this.getModel().getValue(CODERULEID);
        if (codeRuleObj == null) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)codeRuleObj;
        CodeRuleInfo codeRuleInfo = CodeRuleCache.reloadCodeRuleById(String.valueOf(dynamicObject.getPkValue()));
        CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance(codeRuleInfo);
        Object sortitemObj = this.getModel().getValue(SORTITEMVALUE);
        CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntryInfo(codeRuleInfo);
        if (codeRuleEntryInfo != null) {
            long num = codeRuleSigner.signerNumber(codeRuleInfo, codeRuleEntryInfo, "" + sortitemObj, true);
            this.getModel().setValue(MAXSERIAL, (Object)((num -= codeRuleEntryInfo.getStep()) < 0L ? 0L : num));
            this.getModel().setDataChanged(false);
            if (codeRuleInfo.isFast()) {
                this.getModel().setValue(CODERULEID, (Object)CodeRuleFastUtil.getCloneAndAddFastTag(dynamicObject));
            }
        }
    }

    private CodeRuleEntryInfo getCodeRuleEntryInfo(CodeRuleInfo codeRuleInfo) {
        CodeRuleEntryInfo codeRuleEntryInfo = null;
        for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
            if (CodeRuleEntryTypeEnum.TYPE_SEQ != CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType())) continue;
            codeRuleEntryInfo = codeRuleEntry;
        }
        return codeRuleEntryInfo;
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getValue(CODERULEID) != null) {
            CodeRuleUtils.bindSortItem(this.getModel());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op;
        String operateKey;
        if (e.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)e.getSource()).getOperateKey())) {
            boolean isSuccess;
            String newValue;
            String oldValue;
            DynamicObject dataEntity;
            String sortItemValue;
            DynamicObject codeRule;
            DynamicObject codeRuleObj;
            block10: {
                DynamicObject dynamicObject;
                boolean enable;
                DynamicObjectCollection query;
                codeRuleObj = (DynamicObject)this.getModel().getValue(CODERULEID);
                if (codeRuleObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleMaxSerialEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                codeRule = BusinessDataServiceHelper.loadSingle((Object)codeRuleObj.getPkValue(), (String)"bos_coderule", (String)"id,ruleentry,issortitem");
                DynamicObjectCollection ruleEntry = codeRule.getDynamicObjectCollection("ruleentry");
                if (!this.checkSortItemExist(ruleEntry)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6d41\u6c34\u53f7\u4f9d\u636e\u3002", (String)"CodeRuleMaxSerialEditPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                sortItemValue = this.getModel().getValue(SORTITEMVALUE).toString();
                if (this.checkSortItemValueDuplicate(sortItemValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4f9d\u636e\u91cd\u590d\u3002", (String)"CodeRuleMaxSerialEditPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                this.getModel().setValue(SORTITEMVALUE, (Object)sortItemValue);
                Object maxserialObj = this.getModel().getValue(MAXSERIAL);
                if (maxserialObj == null || StringUtils.isBlank((CharSequence)maxserialObj.toString()) || Long.parseLong(maxserialObj.toString()) <= 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u6700\u5927\u6d41\u6c34\u53f7\u201d\u586b\u5165\u6709\u6548\u503c, \u5982\u679c\u8981\u6062\u590d\u5230\u521d\u59cb\u503c, \u8bf7\u76f4\u63a5\u5220\u9664\u6700\u5927\u53f7\u3002", (String)"CodeRuleMaxSerialEditPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Object id = codeRuleObj.getPkValue();
                if (id != null && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"bos_coderule", (String)"enable", (QFilter[])new QFilter("id", "=", (Object)((String)id)).toArray()))) && (enable = (dynamicObject = (DynamicObject)query.get(0)).getBoolean("enable"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u4e2d\u7684\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\u76f8\u5173\u64cd\u4f5c\uff0c\u8bf7\u7981\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"CodeRuleMaxSerialEditPlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]));
                    this.getModel().setDataChanged(false);
                    e.setCancel(true);
                    return;
                }
                dataEntity = this.getModel().getDataEntity();
                oldValue = this.getPageCache().get("pagecache_coderule_oldValue");
                newValue = this.getPageCache().get("pagecache_coderule_newValue");
                if (StringUtils.isEmpty((CharSequence)oldValue)) {
                    oldValue = dataEntity.getString(MAXSERIAL);
                }
                if (StringUtils.isEmpty((CharSequence)newValue)) {
                    newValue = dataEntity.getString(MAXSERIAL);
                }
                isSuccess = true;
                try {
                    this.rebuildSigner(codeRuleObj, e);
                }
                catch (KDException exception) {
                    ErrorCode errorCode = exception.getErrorCode();
                    if (errorCode == null || !StringUtils.equals((CharSequence)"Signer error", (CharSequence)errorCode.getCode())) break block10;
                    isSuccess = false;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4f9d\u636e\uff1a%s\u672a\u4f7f\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u6700\u5927\u53f7\u8bb0\u5f55\u3002", (String)"CodeRuleMaxSerialEditPlugin_8", (String)BOS_CODERULE, (Object[])new Object[0]), sortItemValue));
                }
            }
            this.recordOperationLog(codeRuleObj, codeRule, sortItemValue, dataEntity, oldValue, newValue, isSuccess);
            e.setCancel(!isSuccess);
        }
    }

    private void recordOperationLog(DynamicObject codeRuleObj, DynamicObject codeRule, String sortItemValue, DynamicObject dataEntity, String oldValue, String newValue, boolean isSuccess) {
        boolean isFromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (isFromDatabase) {
            if (AppLogUtil.checkSortItemValue(sortItemValue)) {
                AppLogUtil.insertAppLog(this.getView(), dataEntity, new MultiLangEnumBridge("\u6700\u5927\u53f7\u7f16\u8f91", "CodeRuleMaxSerialEditPlugin_5", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4fee\u6539\u524d\u53f7\u7801:%3$s\uff0c\u4fee\u6539\u540e\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRule.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), oldValue, newValue);
            } else {
                AppLogUtil.insertAppLog(this.getView(), dataEntity, new MultiLangEnumBridge("\u6700\u5927\u53f7\u7f16\u8f91", "CodeRuleMaxSerialEditPlugin_5", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e\uff1a%3$s\uff0c\u4fee\u6539\u524d\u53f7\u7801\uff1a%4$s\uff0c\u4fee\u6539\u540e\u53f7\u7801%5$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRule.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), CommonUtil.convertSortItem(sortItemValue), oldValue, newValue);
            }
        } else if (AppLogUtil.checkSortItemValue(sortItemValue)) {
            AppLogUtil.insertAppLog(this.getView(), dataEntity, new MultiLangEnumBridge("\u65b0\u589e\u6700\u5927\u53f7", "CodeRuleMaxSerialEditPlugin_7", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%3$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRule.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), newValue);
        } else {
            AppLogUtil.insertAppLog(this.getView(), dataEntity, new MultiLangEnumBridge("\u65b0\u589e\u6700\u5927\u53f7", "CodeRuleMaxSerialEditPlugin_7", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%3$s\uff0c\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, "" + codeRule.getPkValue(), CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), CommonUtil.convertSortItem(sortItemValue), newValue);
        }
    }

    protected void rebuildSigner(DynamicObject codeRuleObj, BeforeDoOperationEventArgs e) {
        CodeRuleInfo codeRuleInfo;
        String maxserialStr;
        Object sortitemObj = this.getModel().getValue(SORTITEMVALUE);
        Object maxserialObj = this.getModel().getValue(MAXSERIAL);
        long maxserial = 0L;
        if (maxserialObj != null && StringUtils.isNotEmpty((CharSequence)(maxserialStr = maxserialObj.toString()))) {
            maxserial = Long.parseLong(maxserialStr);
        }
        if ((codeRuleInfo = CodeRuleCache.reloadCodeRuleById(String.valueOf(codeRuleObj.getPkValue()))) == null) {
            return;
        }
        CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance(codeRuleInfo);
        if (!codeRuleSigner.isUseDB()) {
            codeRuleSigner.reset(codeRuleInfo.getId(), "" + sortitemObj, maxserial);
            e.setCancel(true);
            this.getModel().setDataChanged(false);
            this.getView().returnDataToParent((Object)maxserial);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (proName.equalsIgnoreCase(MAXSERIAL)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (oldValue != null) {
                this.getPageCache().put("pagecache_coderule_oldValue", oldValue.toString());
            }
            if (newValue != null) {
                this.getPageCache().put("pagecache_coderule_newValue", newValue.toString());
            }
            return;
        }
        if (StringUtils.equals((CharSequence)SORTITEMVALUE_1, (CharSequence)proName) && !this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            this.getModel().setValue(SORTITEMVALUE, this.getModel().getValue(SORTITEMVALUE_1));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("save".equals(e.getOperateKey())) {
            DynamicObject codeRuleObj = (DynamicObject)this.getModel().getValue(CODERULEID);
            if (codeRuleObj != null) {
                CodeRuleUtils.clearCache(new String[]{(String)codeRuleObj.getPkValue()});
            }
            this.getView().close();
        }
    }

    private boolean checkSortItemExist(DynamicObjectCollection ruleentry) {
        boolean sortitemAtRule = this.isSortitemAtRule(ruleentry);
        return sortitemAtRule || !StringUtils.isNotEmpty((CharSequence)((String)this.getModel().getValue(SORTITEMVALUE_1)));
    }

    private boolean isSortitemAtRule(DynamicObjectCollection ruleentry) {
        for (DynamicObject rule : ruleentry) {
            if (!rule.getBoolean("issortitem")) continue;
            return true;
        }
        return false;
    }

    private boolean checkSortItemValueDuplicate(String sortItemValue) {
        QFilter qf = new QFilter(SORTITEMVALUE, "=", (Object)sortItemValue);
        qf.and(CODERULEID, "=", (Object)((String)((DynamicObject)this.getModel().getValue(CODERULEID)).getPkValue()));
        Object[] objs = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"id", (QFilter[])new QFilter[]{qf});
        if (ArrayUtils.isEmpty((Object[])objs)) {
            return false;
        }
        Object pkValue = objs[0].getPkValue();
        return !pkValue.equals(this.getModel().getValue("id"));
    }
}

