/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.atomicincr.AtomicIncrement;
import kd.bos.bill.BillShowParameter;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.domain.MaxserialApi;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.newedit.ShowFormUtil;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.generator.constants.TableConstants;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CodeRuleMaxSerialListPlugin
extends AbstractListPlugin
implements TableConstants {
    private static final Log log = LogFactory.getLog(CodeRuleMaxSerialListPlugin.class);
    private static final String SORTITEMVALUE = "sortitemvalue";
    private static final String CODERULEID = "coderuleid";
    private static final String MAXSERIAL = "maxserial";
    private static final String BTN_RESTORE = "btnrestore";
    private static final String BOS_CODERULE = "bos-coderule";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTN_RESTORE});
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject dynamicObject : pageData) {
            String sortitemvalue = dynamicObject.getString(SORTITEMVALUE);
            if (!StringUtils.isBlank((CharSequence)sortitemvalue.replaceAll("_split_", ""))) continue;
            dynamicObject.set(SORTITEMVALUE, (Object)"");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BTN_RESTORE)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object codeRuleId = formShowParameter.getCustomParam(CODERULEID);
            if (StringUtils.isBlank((Object)codeRuleId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219\u3002", (String)"CodeRuleMaxSerialListPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]));
                return;
            }
            DynamicObject[] segmentData = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"key", (QFilter[])new QFilter[]{QFilter.like((String)"key", (String)((String)codeRuleId))});
            if (segmentData == null || segmentData.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u672a\u5f00\u59cb\u4f7f\u7528\uff0c\u65e0\u9700\u6062\u590d\u6700\u5927\u53f7\u3002", (String)"CodeRuleMaxSerialListPlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]));
                return;
            }
            Set<String> sortItems = this.collectSortItems(segmentData, (String)codeRuleId);
            DynamicObject[] maxSerialData = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)SORTITEMVALUE, (QFilter[])new QFilter[]{new QFilter(CODERULEID, "=", codeRuleId)});
            if (maxSerialData != null && maxSerialData.length > 0) {
                for (DynamicObject maxSerial : maxSerialData) {
                    String sortItemValue = maxSerial.getString(SORTITEMVALUE);
                    if (StringUtils.isBlank((CharSequence)sortItemValue)) {
                        sortItemValue = null;
                    }
                    sortItems.remove(sortItemValue);
                }
            }
            if (sortItems.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u53f7\u8bb0\u5f55\u672a\u4e22\u5931\uff0c\u65e0\u9700\u4fee\u590d\u3002", (String)"CodeRuleMaxSerialListPlugin_5", (String)BOS_CODERULE, (Object[])new Object[0]));
                return;
            }
            this.createMaxSerial((String)codeRuleId, sortItems);
        }
    }

    private void createMaxSerial(String codeRuleId, Set<String> sortItems) {
        if (CollectionUtils.isEmpty(sortItems)) {
            return;
        }
        log.info("[\u6700\u5927\u53f7\u8bb0\u5f55\u4fee\u590d]\u7f16\u7801\u89c4\u5219\uff1a" + codeRuleId + "\uff0c\u4f9d\u636e\uff1a" + StringUtils.join(sortItems, (String)"\u3001"));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial");
        Object[] newMaxSerials = new DynamicObject[sortItems.size()];
        int index = 0;
        for (String sortItem : sortItems) {
            DynamicObject maxSerial = new DynamicObject((DynamicObjectType)dt);
            maxSerial.set("codeRuleID", (Object)codeRuleId);
            maxSerial.set("seqsegmententryid", (Object)"");
            maxSerial.set(SORTITEMVALUE, (Object)sortItem);
            maxSerial.set(MAXSERIAL, (Object)0);
            maxSerial.set("initserial", (Object)0);
            maxSerial.set("createdate", (Object)new Date());
            maxSerial.set("creater", (Object)RequestContext.get().getCurrUserId());
            newMaxSerials[index++] = maxSerial;
        }
        SaveServiceHelper.save((IDataEntityType)dt, (Object[])newMaxSerials);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6700\u5927\u53f7\u6210\u529f\u3002", (String)"CodeRuleMaxSerialListPlugin_6", (String)BOS_CODERULE, (Object[])new Object[0]));
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refreshData();
    }

    private Set<String> collectSortItems(DynamicObject[] segmentData, String codeRuleId) {
        HashSet<String> sortItems = new HashSet<String>();
        int fixedIndex = "bas/coderule/".length();
        for (DynamicObject dynamicObject : segmentData) {
            String key = dynamicObject.getString("key");
            if (StringUtils.isBlank((CharSequence)key)) continue;
            String sortItem = key.substring(fixedIndex + codeRuleId.length());
            if (StringUtils.isBlank((CharSequence)sortItem)) {
                sortItem = null;
            }
            sortItems.add(sortItem);
        }
        return sortItems;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)e.getSource();
            String operateKey = op.getOperateKey();
            if ("delete".equals(operateKey)) {
                Object[] primaryKeyValues = e.getListSelectedData().getPrimaryKeyValues();
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(primaryKeyValues.length);
                for (Object primaryKeyValue : primaryKeyValues) {
                    String id = String.valueOf(primaryKeyValue);
                    DynamicObject[] dynamicObjectArr = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"coderuleid, sortitemvalue, maxserial", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                    if (dynamicObjectArr == null || dynamicObjectArr.length <= 0) {
                        return;
                    }
                    DynamicObject dynamicObject = dynamicObjectArr[0];
                    if (this.isEnableCodeRule(dynamicObject)) {
                        e.setCancel(true);
                        return;
                    }
                    dynamicObjects.add(dynamicObject);
                }
                this.getPageCache().put("CODERULE_PRIMARYKEYVALUES", DynamicObjectSerializeUtil.serialize((Object[])dynamicObjects.toArray(), (DynamicObjectType)this.getModel().getDataEntityType()));
            }
            if ("reset_maxserial".equals(operateKey)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectSortitem");
                new ShowFormUtil((AbstractFormPlugin)this, this.getModel()).showForm("bos_coderule_sortitem", params, closeCallBack, ShowType.Modal);
            }
        }
    }

    private boolean isEnableCodeRule(DynamicObject dynamicObject) {
        DynamicObject codeRule;
        boolean enable;
        DynamicObject codeRuleDynamicObject = dynamicObject.getDynamicObject(CODERULEID);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_coderule", (String)"enable", (QFilter[])new QFilter("id", "=", codeRuleDynamicObject.getPkValue()).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query) && (enable = (codeRule = (DynamicObject)query.get(0)).getBoolean("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u4e2d\u7684\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u8bf7\u7981\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"CodeRuleMaxSerialListPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "delete".equals(operateKey)) {
            Object[] dynamicObjects;
            String dynamicsStr = this.getPageCache().get("CODERULE_PRIMARYKEYVALUES");
            for (Object dynamicObj : dynamicObjects = DynamicObjectSerializeUtil.deserialize((String)dynamicsStr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial"))) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObj;
                DynamicObject codeRuleObj = dynamicObject.getDynamicObject(CODERULEID);
                String coderuleid = "" + codeRuleObj.getPkValue();
                String sortItemValue = CommonUtil.convertSortItem(dynamicObject.getString(SORTITEMVALUE));
                String newValue = dynamicObject.getString(MAXSERIAL);
                boolean isSuccess = operationResult.isSuccess();
                if (AppLogUtil.checkSortItemValue(sortItemValue)) {
                    AppLogUtil.insertAppLog(this.getView(), dynamicObject, new MultiLangEnumBridge("\u6700\u5927\u53f7\u8868\u5220\u9664", "CodeRuleMaxSerialListPlugin_0", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u53f7\u7801:%3$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, coderuleid, CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), newValue);
                } else {
                    AppLogUtil.insertAppLog(this.getView(), dynamicObject, new MultiLangEnumBridge("\u6700\u5927\u53f7\u8868\u5220\u9664", "CodeRuleMaxSerialListPlugin_0", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%3$s\uff0c\u53f7\u7801:%4$s\u3002", "AppLogUtil_1", BOS_CODERULE), isSuccess, coderuleid, CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString(), CommonUtil.convertSortItem(sortItemValue), newValue);
                }
                CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance();
                codeRuleSigner.clean(coderuleid, dynamicObject.getString(SORTITEMVALUE));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        int rowIndex = args.getRowIndex();
        this.getPageCache().put("billListHyperLinkClickRowIndex", String.valueOf(rowIndex));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openBillMaxSerial"));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListShowParameter showParameter;
        List qFilters;
        Map returnData;
        if ("selectSortitem".equals(e.getActionId()) && (returnData = (Map)e.getReturnData()) != null && CollectionUtils.isNotEmpty((Collection)(qFilters = (showParameter = (ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters())) && qFilters.size() == 1 && ((QFilter)qFilters.get(0)).getProperty().equals(CODERULEID)) {
            Object coderuleId = ((QFilter)qFilters.get(0)).getValue();
            String sortitemvalue = returnData.get("sortitem") == null ? "" : returnData.get("sortitem").toString();
            MaxserialApi.createUnique(coderuleId.toString(), sortitemvalue);
        }
        if (StringUtils.equals((CharSequence)"openBillMaxSerial", (CharSequence)e.getActionId())) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String rowIndex = this.getPageCache().get("billListHyperLinkClickRowIndex");
            Object returnData2 = e.getReturnData();
            clientViewProxy.setEntryFieldValue((AbstractGrid)this.getControl("billlistap"), MAXSERIAL, Integer.parseInt(rowIndex), returnData2);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private static void batchGetNumber(Map<String, DynamicObject> dataKeyMap) {
        String useDbGenerator = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam()).getOrDefault("SVC_CODERULE_USE_DB_GENERATOR", "true");
        if (!Boolean.parseBoolean(useDbGenerator)) {
            return;
        }
        AtomicIncrement atomicIncrement = AtomicIncrement.getInstance((String)"coderule");
        Map batchNumber = atomicIncrement.batchGet(dataKeyMap.keySet());
        if (MapUtils.isNotEmpty((Map)batchNumber)) {
            for (Map.Entry entry : batchNumber.entrySet()) {
                String key = (String)entry.getKey();
                Long value = (Long)entry.getValue();
                if (value == null) continue;
                DynamicObject dynamicObject = dataKeyMap.remove(key);
                dynamicObject.set(MAXSERIAL, (Object)value);
            }
        }
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String codeRuleId;
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)CodeRuleMaxSerialListPlugin.MAXSERIAL)) {
                return rows;
            }
            List<String> codeRuleIds = rows.stream().filter(row -> row.get(CodeRuleMaxSerialListPlugin.CODERULEID) != null).map(row -> (String)((DynamicObject)row.get(CodeRuleMaxSerialListPlugin.CODERULEID)).getPkValue()).collect(Collectors.toList());
            String[] codeRuleIdArr = new String[codeRuleIds.size()];
            codeRuleIds.toArray(codeRuleIdArr);
            Map<String, CodeRuleInfo> codeRuleInfoMap = CodeRuleCache.reloadCodeRuleByIds(codeRuleIdArr);
            HashMap<String, DynamicObject> dataKeyMap = new HashMap<String, DynamicObject>();
            for (DynamicObject row2 : rows) {
                if (row2.get(CodeRuleMaxSerialListPlugin.CODERULEID) == null) continue;
                DynamicObject codeRule = (DynamicObject)row2.get(CodeRuleMaxSerialListPlugin.CODERULEID);
                codeRuleId = (String)codeRule.getPkValue();
                String sortItem = row2.getString(CodeRuleMaxSerialListPlugin.SORTITEMVALUE);
                String key = kd.bos.generator.common.CommonUtil.getGeneratorKey(codeRuleId, sortItem);
                CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(codeRuleId);
                if (codeRuleInfo.isFast()) {
                    row2.set(CodeRuleMaxSerialListPlugin.CODERULEID, (Object)CodeRuleFastUtil.getCloneAndAddFastTag(codeRule));
                }
                dataKeyMap.put(key, row2);
            }
            CodeRuleMaxSerialListPlugin.batchGetNumber(dataKeyMap);
            for (DynamicObject row2 : dataKeyMap.values()) {
                if (row2.get(CodeRuleMaxSerialListPlugin.CODERULEID) == null) continue;
                DynamicObject codeRuleObj = (DynamicObject)row2.get(CodeRuleMaxSerialListPlugin.CODERULEID);
                codeRuleId = (String)codeRuleObj.getPkValue();
                CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(codeRuleId);
                Object sortItemObj = row2.get(CodeRuleMaxSerialListPlugin.SORTITEMVALUE);
                CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntryInfo(codeRuleInfo);
                if (codeRuleEntryInfo == null) continue;
                CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance();
                long num = codeRuleSigner.signerNumber(codeRuleInfo, codeRuleEntryInfo, "" + sortItemObj, true);
                row2.set(CodeRuleMaxSerialListPlugin.MAXSERIAL, (Object)((num -= codeRuleEntryInfo.getStep()) < 0L ? 0L : num));
            }
            return rows;
        }

        private CodeRuleEntryInfo getCodeRuleEntryInfo(CodeRuleInfo codeRuleInfo) {
            CodeRuleEntryInfo codeRuleEntryInfo = null;
            for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
                if (CodeRuleEntryTypeEnum.TYPE_SEQ != CodeRuleEntryTypeEnum.getEnums(codeRuleEntry.getAttributeType())) continue;
                codeRuleEntryInfo = codeRuleEntry;
            }
            return codeRuleEntryInfo;
        }
    }
}

