/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CodeRulePropertyEditPlugin
extends AbstractFormPlugin {
    private static final String codeRuleAppCondPro = "bos_coderuleappcondpro";
    private static final String codeRuleAppCondProValue = "bos_crappcondprovalue";
    private static final String codeRuleAppCondition = "bos_coderuleappcondition";
    private static final String proValCacheName = "proVal";
    public static final String PROPERTY = "property";
    public static final String PROPERTYVALUE = "propertyvalue";
    public static final String ENTRYID = "entryid";

    public void initialize() {
        this.addClickListeners(new String[]{"save"});
        this.initProperty();
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam("coderuleid");
        String dtName = (String)this.getView().getFormShowParameter().getCustomParam("dtname");
        model.setValue("dtname", (Object)dtName);
        model.setValue("id", (Object)codeRuleId);
        if (!"".equals(codeRuleId)) {
            QFilter[] qf = new QFilter[]{new QFilter("id", "=", (Object)codeRuleId)};
            DynamicObjectCollection col = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bos_coderule", (String)"id, conditionentry.id entryid, conditionentry.property property, conditionentry.propertyvalue propertyvalue", (QFilter[])qf, null);
            if (col == null || col.size() == 0) {
                return;
            }
            for (DynamicObject obj : col) {
                model.setValue("id", (Object)codeRuleId);
                Object property = obj.get(PROPERTY);
                if (property == null || StringUtils.isBlank((CharSequence)property.toString())) continue;
                model.setValue(PROPERTY, property);
                this.initPropertyVal((String)property);
                model.setValue(PROPERTYVALUE, obj.get(PROPERTYVALUE));
                model.setValue(ENTRYID, obj.get(ENTRYID));
            }
        }
    }

    public void click(EventObject evt) {
        IDataModel model = this.getModel();
        Button btn = (Button)evt.getSource();
        if ("save".equalsIgnoreCase(btn.getKey())) {
            Object codeRuleId;
            if (model.getValue(PROPERTY) != null && StringUtils.isNotBlank((Object)model.getValue(PROPERTY)) && model.getValue(PROPERTYVALUE) != null && StringUtils.isNotBlank((Object)model.getValue(PROPERTYVALUE))) {
                codeRuleId = String.valueOf(this.getModel().getValue("id"));
                if (this.dataValidate((String)codeRuleId)) {
                    return;
                }
                DynamicObject dataInfo = BusinessDataServiceHelper.loadSingle((Object)codeRuleId, (String)"bos_coderule");
                DynamicObjectCollection conditionEntrys = dataInfo.getDynamicObjectCollection("conditionentry");
                conditionEntrys.clear();
                DynamicObject dynaObj = new DynamicObject(conditionEntrys.getDynamicObjectType());
                dynaObj.set(PROPERTY, model.getValue(PROPERTY));
                dynaObj.set(PROPERTYVALUE, model.getValue(PROPERTYVALUE));
                dynaObj.set("id", model.getValue("id"));
                dynaObj.set("seq", (Object)1);
                conditionEntrys.add((Object)dynaObj);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataInfo});
            } else {
                codeRuleId = model.getValue("id");
                if (codeRuleId != null) {
                    String strCodeRuleId = codeRuleId.toString();
                    String bizObjectId = CodeRuleUtils.queryBizObjectById(strCodeRuleId);
                    String str = null;
                    if (CodeRuleUtils.isEnable(strCodeRuleId)) {
                        str = CodeRuleUtils.isDuplicateCodeRule(bizObjectId, strCodeRuleId, null, new HashMap<String, Object>());
                    }
                    if (StringUtils.isBlank(str)) {
                        this.deleteEntry(strCodeRuleId);
                    } else {
                        this.getView().showTipNotification(str, Integer.valueOf(2000));
                        return;
                    }
                }
            }
            this.getView().close();
            String type = CodeRuleCacheMrg.getType4EntityCodeRules();
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("dtval");
            CodeRuleCacheMrg.clearCache(type, entityId);
        }
    }

    private boolean dataValidate(String codeRuleId) {
        String bizObjectId = CodeRuleUtils.queryBizObjectById(codeRuleId);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        conditionMap.put(PROPERTY, this.getModel().getValue(PROPERTY));
        conditionMap.put(PROPERTYVALUE, this.getModel().getValue(PROPERTYVALUE));
        String msg = null;
        if (CodeRuleUtils.isEnable(codeRuleId)) {
            msg = CodeRuleUtils.isDuplicateCodeRule(bizObjectId, codeRuleId, null, conditionMap);
        }
        if (StringUtils.isNotBlank(msg)) {
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private void deleteEntry(String id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", 1, (Object)id)};
                String SQL = "delete from T_CR_AppCondition where Fid = ?;";
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (PROPERTY.equals(proName)) {
            String property = (String)this.getModel().getValue(PROPERTY);
            if (StringUtils.isBlank((CharSequence)property)) {
                this.getModel().setValue(PROPERTYVALUE, null);
                return;
            }
            this.initPropertyVal(property);
        }
    }

    private void initProperty() {
        String selectFields = "id, appcondpro.id proid, appcondpro.name proname, name";
        String dtval = (String)this.getView().getFormShowParameter().getCustomParam("dtval");
        QFilter filter = new QFilter("appcondpro.bizobjectid", "=", (Object)dtval);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection proValues = QueryServiceHelper.query((String)codeRuleAppCondProValue, (String)selectFields, (QFilter[])filters);
        ComboEdit propertyField = (ComboEdit)this.getControl(PROPERTY);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>();
        HashMap<String, HashMap<String, String>> proValueMap = new HashMap<String, HashMap<String, String>>();
        String id = null;
        String proname = null;
        String proid = null;
        String name = null;
        HashMap<String, String> valueMap = null;
        String local = RequestContext.get().getLang().name();
        for (DynamicObject proValue : proValues) {
            id = proValue.getString("id");
            proname = proValue.getString("proname");
            proid = proValue.getString("proid");
            name = proValue.getString("name");
            valueMap = (HashMap<String, String>)proValueMap.get(proid);
            if (valueMap == null) {
                valueMap = new HashMap<String, String>();
                proValueMap.put(proid, valueMap);
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(local, proname));
                comboItem.setValue(proid);
                propertyItems.add(comboItem);
            }
            valueMap.put(id, name);
        }
        this.getPageCache().put(proValCacheName, SerializationUtils.toJsonString(proValueMap));
        propertyField.setComboItems(propertyItems);
        if (propertyItems.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PROPERTY, PROPERTYVALUE});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u8bbe\u8ba1\u5668\u4e2d\u914d\u7f6e\u76f8\u5173\u5c5e\u6027", (String)"CodeRulePropertyEditPlugin_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
    }

    private void initPropertyVal(String property) {
        ComboEdit propertyField = (ComboEdit)this.getControl(PROPERTYVALUE);
        Map proValueMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(proValCacheName), Map.class);
        Map valueMap = (Map)proValueMap.get(property);
        ArrayList<ComboItem> propertyValItems = new ArrayList<ComboItem>(valueMap.size());
        String local = RequestContext.get().getLang().name();
        for (Map.Entry entry : valueMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue((String)entry.getKey());
            comboItem.setCaption(new LocaleString(local, (String)entry.getValue()));
            propertyValItems.add(comboItem);
        }
        propertyField.setComboItems(propertyValItems);
    }

    private List<DynamicSimpleProperty> getTextProperties(String dtName) {
        DataEntityPropertyCollection entitySet = this.getProperties(dtName);
        List simpleFileds = entitySet.getSimpleProperties(false);
        ArrayList<DynamicSimpleProperty> textProList = new ArrayList<DynamicSimpleProperty>(simpleFileds.size());
        for (ISimpleProperty sproperty : simpleFileds) {
            textProList.add((DynamicSimpleProperty)sproperty);
        }
        return textProList;
    }

    private DataEntityPropertyCollection getProperties(String dtName) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)dtName);
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        return dynaObj.getDataEntityType().getProperties();
    }
}

